/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.antlr;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javafx.antlr.v4Lexer;
import com.sun.tools.javafx.antlr.v4Parser;
import com.sun.tools.javafx.tree.JFXScript;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class JavafxSyntacticAnalysis {
    protected static final Context.Key<JavafxSyntacticAnalysis> syntaxKey = new Context.Key();
    protected Context context;
    protected Options options;
    protected Name.Table names;
    public Log log;

    public static JavafxSyntacticAnalysis instance(Context context) {
        JavafxSyntacticAnalysis instance = context.get(syntaxKey);
        if (instance == null) {
            instance = new JavafxSyntacticAnalysis(context);
        }
        return instance;
    }

    protected JavafxSyntacticAnalysis(Context context) {
        this.context = context;
        context.put(syntaxKey, this);
        this.names = Name.Table.instance(context);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
    }

    public JFXScript parse(CharSequence content, String fileName) {
        JFXScript unit = null;
        String parserChoice = this.options.get("parser");
        if (parserChoice == null) {
            parserChoice = "v4";
        }
        try {
            if (parserChoice.startsWith("v4")) {
                ANTLRStringStream input = new ANTLRStringStream(((Object)content).toString());
                v4Lexer lexer = new v4Lexer(this.context, input);
                CommonTokenStream tokens = new CommonTokenStream(lexer);
                v4Parser parser = new v4Parser(tokens);
                parser.initialize(this.context);
                unit = parser.script();
            }
        }
        catch (Throwable thr) {
            System.err.println("Error in syntactic analysis in " + fileName + ":");
            thr.printStackTrace(System.err);
        }
        return unit;
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    private void printTree(Tree tree, String prefix) {
        CommonToken token = (CommonToken)((CommonTree)tree).getToken();
        System.out.println(prefix + tree + "  (" + token.getStartIndex() + ")" + token.getLine());
        int n = tree.getChildCount();
        String nextPrefix = prefix + "   ";
        for (int i = 0; i < n; ++i) {
            this.printTree(tree.getChild(i), nextPrefix);
        }
    }
}

