/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.api;

import com.sun.javafx.api.JavafxCompiler;
import com.sun.javafx.api.tree.ClassDeclarationTree;
import com.sun.javafx.api.tree.FunctionDefinitionTree;
import com.sun.javafx.api.tree.JavaFXTreePath;
import com.sun.javafx.api.tree.JavaFXTreePathScanner;
import com.sun.javafx.api.tree.Scope;
import com.sun.javafx.api.tree.SourcePositions;
import com.sun.javafx.api.tree.Tree;
import com.sun.javafx.api.tree.UnitTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javafx.api.JavafxcScope;
import com.sun.tools.javafx.api.JavafxcTaskImpl;
import com.sun.tools.javafx.comp.JavafxAttr;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxEnter;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.comp.JavafxMemberEnter;
import com.sun.tools.javafx.comp.JavafxResolve;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JavafxTreeCopier;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import java.io.IOException;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxcTrees {
    private final JavafxResolve resolve;
    private final JavafxEnter enter;
    private final Log log;
    private final JavafxMemberEnter memberEnter;
    private final JavafxAttr attr;
    private final JavafxTreeMaker fxmake;
    private final JavafxcTaskImpl javafxcTaskImpl;
    private final Context ctx;

    public static JavafxcTrees instance(JavafxCompiler.CompilationTask task) {
        if (!(task instanceof JavafxcTaskImpl)) {
            throw new IllegalArgumentException();
        }
        return JavafxcTrees.instance(((JavafxcTaskImpl)task).getContext());
    }

    public static JavafxcTrees instance(Context context) {
        JavafxcTrees instance = context.get(JavafxcTrees.class);
        if (instance == null) {
            instance = new JavafxcTrees(context);
        }
        return instance;
    }

    private JavafxcTrees(Context context) {
        context.put(JavafxcTrees.class, this);
        this.ctx = context;
        this.attr = JavafxAttr.instance(context);
        this.enter = JavafxEnter.instance(context);
        this.log = Log.instance(context);
        this.resolve = JavafxResolve.instance(context);
        this.fxmake = JavafxTreeMaker.instance(context);
        this.memberEnter = JavafxMemberEnter.instance(context);
        this.javafxcTaskImpl = context.get(JavafxcTaskImpl.class);
    }

    public SourcePositions getSourcePositions() {
        return new SourcePositions(){

            public long getStartPosition(UnitTree file, Tree tree) {
                return JavafxTreeInfo.getStartPos((JFXTree)tree);
            }

            public long getEndPosition(UnitTree file, Tree tree) {
                Map<JCTree, Integer> endPositions = ((JFXScript)file).endPositions;
                return JavafxTreeInfo.getEndPos((JFXTree)tree, endPositions);
            }
        };
    }

    public ClassDeclarationTree getTree(TypeElement element) {
        return (ClassDeclarationTree)this.getTree((Element)element);
    }

    public FunctionDefinitionTree getTree(ExecutableElement method) {
        return (FunctionDefinitionTree)this.getTree((Element)method);
    }

    public Tree getTree(Element element) {
        Symbol symbol = (Symbol)element;
        Symbol.ClassSymbol enclosing = symbol.enclClass();
        JavafxEnv<JavafxAttrContext> env = this.enter.getEnv(enclosing);
        if (env == null) {
            return null;
        }
        JFXClassDeclaration classNode = env.enclClass;
        if (classNode != null) {
            if (JavafxTreeInfo.symbolFor(classNode) == element) {
                return classNode;
            }
            for (JFXTree node : classNode.getMembers()) {
                if (JavafxTreeInfo.symbolFor(node) != element) continue;
                return node;
            }
        }
        return null;
    }

    public JavaFXTreePath getPath(UnitTree unit, Tree node) {
        return JavafxcTrees.getPath(new JavaFXTreePath(unit), node);
    }

    public JavaFXTreePath getPath(Element e) {
        Pair<JFXTree, JFXScript> treeTopLevel = this.getTreeAndTopLevel(e);
        if (treeTopLevel == null) {
            return null;
        }
        return this.getPath((UnitTree)treeTopLevel.snd, (Tree)treeTopLevel.fst);
    }

    public static JavaFXTreePath getPath(JavaFXTreePath path, Tree target) {
        class Result
        extends Error {
            static final long serialVersionUID = -5942088234594905625L;
            JavaFXTreePath path;

            Result(JavaFXTreePath path) {
                this.path = path;
            }
        }
        path.getClass();
        target.getClass();
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PathFinder
            extends JavaFXTreePathScanner<JavaFXTreePath, Tree> {
                PathFinder() {
                }

                @Override
                public JavaFXTreePath scan(Tree tree, Tree target) {
                    if (tree == target) {
                        throw new Result(new JavaFXTreePath(this.getCurrentPath(), target));
                    }
                    return (JavaFXTreePath)super.scan(tree, target);
                }
            }
            new PathFinder().scan(path, target);
        }
        catch (Result result) {
            return result.path;
        }
        return null;
    }

    public Element getElement(JavaFXTreePath path) {
        Tree t = path.getLeaf();
        return JavafxTreeInfo.symbolFor((JFXTree)t);
    }

    public TypeMirror getTypeMirror(JavaFXTreePath path) {
        Tree t = path.getLeaf();
        return ((JFXTree)t).type;
    }

    public JavafxcScope getScope(JavaFXTreePath path) {
        return new JavafxcScope(this.ctx, this.getAttrContext(path));
    }

    public boolean isAccessible(Scope scope, TypeElement type) {
        if (scope instanceof JavafxcScope && type instanceof Symbol.ClassSymbol) {
            JavafxEnv<JavafxAttrContext> env = ((JavafxcScope)scope).env;
            return this.resolve.isAccessible(env, (Symbol.ClassSymbol)type);
        }
        return false;
    }

    public boolean isAccessible(Scope scope, Element member, DeclaredType type) {
        if (scope instanceof JavafxcScope && member instanceof Symbol && type instanceof Type) {
            JavafxEnv<JavafxAttrContext> env = ((JavafxcScope)scope).env;
            return this.resolve.isAccessible(env, (Type)((Object)type), (Symbol)member);
        }
        return false;
    }

    private JavafxEnv<JavafxAttrContext> getAttrContext(JavaFXTreePath path) {
        if (!(path.getLeaf() instanceof JFXTree)) {
            throw new IllegalArgumentException();
        }
        if (this.javafxcTaskImpl != null) {
            try {
                this.javafxcTaskImpl.enter();
            }
            catch (IOException e) {
                throw new Error("unexpected error while entering symbols: " + e);
            }
        }
        JFXScript unit = (JFXScript)path.getCompilationUnit();
        Copier copier = new Copier(this.fxmake.forToplevel(unit));
        JavafxEnv<JavafxAttrContext> env = null;
        JFXFunctionDefinition function = null;
        JFXVar field = null;
        List<Tree> l = List.nil();
        for (JavaFXTreePath p = path; p != null; p = p.getParentPath()) {
            l = l.prepend(p.getLeaf());
        }
        while (l.nonEmpty()) {
            Tree tree = (Tree)l.head;
            if (tree instanceof JFXScript) {
                env = this.enter.getTopLevelEnv((JFXScript)tree);
            } else if (tree instanceof JFXClassDeclaration) {
                env = this.enter.getClassEnv(((JFXClassDeclaration)tree).sym);
            } else if (tree instanceof JFXFunctionDefinition) {
                function = (JFXFunctionDefinition)tree;
            } else if (tree instanceof JFXVar) {
                field = (JFXVar)tree;
            } else {
                if (tree instanceof JFXBlock) {
                    if (function != null) {
                        env = this.memberEnter.getMethodEnv(function, env);
                    }
                    JFXTree body = copier.copy((JFXTree)tree, (JFXTree)path.getLeaf());
                    env = this.attribStatToTree(body, env, copier.leafCopy);
                    return env;
                }
                if (field != null && field.getInitializer() == tree) {
                    env = this.memberEnter.getInitEnv(field, env);
                    JFXExpression expr = copier.copy((JFXExpression)tree, (JFXTree)path.getLeaf());
                    env = this.attribExprToTree(expr, env, copier.leafCopy);
                    return env;
                }
            }
            l = l.tail;
        }
        return field != null ? this.memberEnter.getInitEnv(field, env) : env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavafxEnv<JavafxAttrContext> attribStatToTree(JFXTree stat, JavafxEnv<JavafxAttrContext> env, JFXTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            JavafxEnv<JavafxAttrContext> javafxEnv = this.attr.attribStatToTree(stat, env, tree);
            return javafxEnv;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavafxEnv<JavafxAttrContext> attribExprToTree(JFXExpression expr, JavafxEnv<JavafxAttrContext> env, JFXTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            JavafxEnv<JavafxAttrContext> javafxEnv = this.attr.attribExprToTree(expr, env, tree);
            return javafxEnv;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    private Pair<JFXTree, JFXScript> getTreeAndTopLevel(Element e) {
        JavafxEnv<JavafxAttrContext> enterEnv;
        if (e == null) {
            return null;
        }
        Symbol sym = (Symbol)e;
        Symbol.TypeSymbol ts = sym.kind != 1 ? sym.enclClass() : (Symbol.PackageSymbol)sym;
        JavafxEnv<JavafxAttrContext> javafxEnv = enterEnv = ts != null ? this.enter.getEnv(ts) : null;
        if (enterEnv == null) {
            return null;
        }
        JFXTree tree = JavafxTreeInfo.declarationFor(sym, enterEnv.tree);
        if (tree == null || enterEnv.toplevel == null) {
            return null;
        }
        return new Pair<JFXTree, JFXScript>(tree, enterEnv.toplevel);
    }

    public JavafxEnv<JavafxAttrContext> getFunctionEnv(JFXFunctionDefinition tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> mEnv = this.memberEnter.methodEnv(tree, env);
        ((JavafxAttrContext)mEnv.info).lint = ((JavafxAttrContext)mEnv.info).lint.augment(tree.sym.attributes_field, tree.sym.flags());
        List<JFXVar> l = tree.getParams();
        while (l.nonEmpty()) {
            ((JavafxAttrContext)mEnv.info).scope.enterIfAbsent(((JFXVar)l.head).sym);
            l = l.tail;
        }
        return mEnv;
    }

    public JavafxEnv<JavafxAttrContext> getInitEnv(JFXVar tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> iEnv = this.memberEnter.initEnv(tree, env);
        return iEnv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Copier
    extends JavafxTreeCopier {
        JFXTree leaf;
        JFXTree leafCopy = null;

        Copier(JavafxTreeMaker M) {
            super(M);
        }

        public <T extends JFXTree> T copy(T t, JFXTree leaf) {
            this.leaf = leaf;
            return this.copy(t);
        }

        @Override
        public <T extends JFXTree> T copy(T t) {
            T t2 = super.copy(t);
            if (t == this.leaf) {
                this.leafCopy = t2;
            }
            return t2;
        }
    }
}

