/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.code;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Warner;
import com.sun.tools.javafx.code.FunctionType;
import com.sun.tools.javafx.code.JavafxClassSymbol;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxTypes
extends Types {
    JavafxSymtab syms;
    private HashMap<Symbol.ClassSymbol, JFXClassDeclaration> fxClasses;

    public static void preRegister(final Context context) {
        context.put(typesKey, new Context.Factory<Types>(){

            @Override
            public Types make() {
                return new JavafxTypes(context);
            }
        });
    }

    public static JavafxTypes instance(Context context) {
        JavafxTypes instance = (JavafxTypes)context.get(typesKey);
        if (instance == null) {
            instance = new JavafxTypes(context);
        }
        return instance;
    }

    protected JavafxTypes(Context context) {
        super(context);
        this.syms = (JavafxSymtab)JavafxSymtab.instance(context);
    }

    public boolean isSequence(Type type) {
        return type != Type.noType && type != null && type.tag != 19 && type.tag != 12 && type.tag != 16 && this.erasure(type) == this.syms.javafx_SequenceTypeErasure;
    }

    public Type sequenceType(Type elemType) {
        return this.sequenceType(elemType, true);
    }

    public Type sequenceType(Type elemType, boolean withExtends) {
        if (elemType.isPrimitive()) {
            elemType = this.boxedClass((Type)elemType).type;
        }
        if (withExtends) {
            elemType = new Type.WildcardType(elemType, BoundKind.EXTENDS, this.syms.boundClass);
        }
        Type seqtype = this.syms.javafx_SequenceType;
        List<Type> actuals = List.of(elemType);
        Type clazzOuter = seqtype.getEnclosingType();
        return new Type.ClassType(clazzOuter, actuals, seqtype.tsym);
    }

    public Type elementType(Type seqType) {
        Type elemType = (Type)seqType.getTypeArguments().head;
        if (elemType instanceof Type.CapturedType) {
            elemType = ((Type.CapturedType)elemType).wildcard;
        }
        if (elemType instanceof Type.WildcardType) {
            elemType = ((Type.WildcardType)elemType).type;
        }
        if (elemType == null) {
            return this.syms.errType;
        }
        Type unboxed = this.unboxedType(elemType);
        if (unboxed.tag != 18) {
            elemType = unboxed;
        }
        return elemType;
    }

    public void getSupertypes(Symbol clazz, ListBuffer<Type> supertypes, Set<Type> dupSet) {
        if (clazz != null) {
            Type supType = this.supertype(clazz.type);
            if (supType != null && supType != Type.noType && !dupSet.contains(supType)) {
                supertypes.append(supType);
                dupSet.add(supType);
                this.getSupertypes(supType.tsym, supertypes, dupSet);
            }
            if (clazz instanceof JavafxClassSymbol) {
                for (Type superType : ((JavafxClassSymbol)clazz).getSuperTypes()) {
                    if (dupSet.contains(superType)) continue;
                    supertypes.append(superType);
                    dupSet.add(superType);
                    this.getSupertypes(superType.tsym, supertypes, dupSet);
                }
            }
        }
    }

    public boolean isSuperType(Type maybeSuper, Symbol.ClassSymbol sym) {
        ListBuffer<Type> supertypes = ListBuffer.lb();
        HashSet<Type> superSet = new HashSet<Type>();
        supertypes.append(sym.type);
        superSet.add(sym.type);
        this.getSupertypes(sym, supertypes, superSet);
        return superSet.contains(maybeSuper);
    }

    @Override
    public boolean isSubtype(Type t, Type s, boolean capture) {
        boolean b = super.isSubtype(t, s, capture);
        if (!b && s.isCompound()) {
            for (Type s2 : this.interfaces(s).prepend(this.supertype(s))) {
                if (this.isSubtype(t, s2, capture)) continue;
                return false;
            }
            return true;
        }
        return b;
    }

    @Override
    public Type asSuper(Type t, Symbol sym) {
        if (this.isCompoundClass(t.tsym)) {
            List<Type> supers;
            JavafxClassSymbol tsym = (JavafxClassSymbol)t.tsym;
            List<Type> l = supers = tsym.getSuperTypes();
            while (l.nonEmpty()) {
                Type x = this.asSuper((Type)l.head, sym);
                if (x != null) {
                    return x;
                }
                l = l.tail;
            }
        }
        return super.asSuper(t, sym);
    }

    public Type superType(JFXClassDeclaration cDecl) {
        Symbol sym1;
        if (!(cDecl.type instanceof Type.ClassType)) {
            return null;
        }
        Type.ClassType cType = (Type.ClassType)cDecl.type;
        Type superType = cType.supertype_field;
        if (superType != null && superType.tsym instanceof Symbol.ClassSymbol && (superType.tsym.flags_field & 0x800000000000L) == 0L) {
            if (superType == this.syms.objectType && (cType.tsym.flags_field & 0x800000000000L) != 0L) {
                for (Type iface : cType.interfaces_field) {
                    if ((iface.tsym.flags_field & 0x800000000000L) == 0L) continue;
                    return iface;
                }
            }
        } else if ((cDecl.mods.flags & 0x10L) != 0L && cDecl.getExtending().nonEmpty() && (sym1 = JavafxTreeInfo.symbol((JFXTree)cDecl.getExtending().head)) != null && (sym1.flags_field & 0x800000000000L) == 0L) {
            superType = ((JFXExpression)cDecl.getExtending().head).type;
        }
        return superType;
    }

    @Override
    public boolean isConvertible(Type t, Type s, Warner warn) {
        if (super.isConvertible(t, s, warn)) {
            return true;
        }
        if (this.isSequence(t) && this.isArray(s)) {
            return this.isConvertible(this.elementType(t), this.elemtype(s), warn);
        }
        if (this.isArray(t) && this.isSequence(s)) {
            return this.isConvertible(this.elemtype(t), this.elementType(s), warn);
        }
        if (t == this.syms.javafx_NumberType) {
            if (s == this.syms.floatType) {
                return true;
            }
            if (s == this.syms.javafx_IntegerType || s == this.syms.intType || s == this.syms.shortType || s == this.syms.charType || s == this.syms.byteType || s == this.syms.longType) {
                return true;
            }
        } else if (t == this.syms.javafx_IntegerType && (s == this.syms.javafx_NumberType || s == this.syms.intType || s == this.syms.floatType || s == this.syms.shortType || s == this.syms.charType || s == this.syms.byteType || s == this.syms.longType)) {
            return true;
        }
        return false;
    }

    public boolean isCompoundClass(Symbol sym) {
        if (!(sym instanceof JavafxClassSymbol)) {
            return false;
        }
        sym.complete();
        return (sym.flags_field & 0x800000000000L) != 0L;
    }

    public boolean isJFXClass(Symbol sym) {
        if (!(sym instanceof JavafxClassSymbol)) {
            return false;
        }
        sym.complete();
        return (sym.flags_field & 0x1000000000000L) != 0L;
    }

    public void addFxClass(Symbol.ClassSymbol csym, JFXClassDeclaration cdecl) {
        if (this.fxClasses == null) {
            this.fxClasses = new HashMap();
        }
        csym.flags_field |= 0x1000000000000L;
        this.fxClasses.put(csym, cdecl);
    }

    public JFXClassDeclaration getFxClass(Symbol.ClassSymbol csym) {
        return this.fxClasses.get(csym);
    }

    public Symbol.MethodSymbol implementation(Symbol.MethodSymbol msym, Symbol.TypeSymbol origin, boolean checkResult) {
        msym.complete();
        if (origin instanceof JavafxClassSymbol && this.isCompoundClass(origin)) {
            List<Type> supers;
            JavafxClassSymbol c = (JavafxClassSymbol)origin;
            Scope.Entry e = c.members().lookup(msym.name);
            while (e.scope != null) {
                if (e.sym.kind == 16) {
                    Symbol.MethodSymbol m = (Symbol.MethodSymbol)e.sym;
                    m.complete();
                    if (m.overrides(msym, origin, this, checkResult) && (m.flags() & 0x1000L) == 0L) {
                        return m;
                    }
                }
                e = e.next();
            }
            List<Type> l = supers = c.getSuperTypes();
            while (l.nonEmpty()) {
                Symbol.MethodSymbol m = this.implementation(msym, ((Type)l.head).tsym, checkResult);
                if (m != null) {
                    return m;
                }
                l = l.tail;
            }
            return null;
        }
        return msym.implementation(origin, this, checkResult);
    }

    public void clearCaches() {
        this.fxClasses = null;
    }

    public String toJavaFXString(Type type) {
        StringBuilder buffer = new StringBuilder();
        try {
            this.toJavaFXString(type, buffer);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toString();
    }

    public String toJavaFXString(List<Type> ts) {
        if (ts.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        try {
            this.toJavaFXString((Type)ts.head, buffer);
            List l = ts.tail;
            while (l.nonEmpty()) {
                buffer.append(",");
                this.toJavaFXString((Type)l.head, buffer);
                l = l.tail;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toString();
    }

    private boolean isJavaFXBoolean(Type type) {
        boolean result = false;
        if (type.tag == 8) {
            result = true;
        }
        return result;
    }

    private boolean isJavaLong(Type type) {
        boolean result = false;
        if (type.tag == 5) {
            result = true;
        }
        return result;
    }

    private boolean isJavaFXInteger(Type type) {
        boolean result = false;
        if (type.tag == 1) {
            result = true;
        } else if (type.tag == 3) {
            result = true;
        } else if (type.tag == 4) {
            result = true;
        }
        return result;
    }

    private boolean isJavaFXNumber(Type type) {
        boolean result = false;
        if (type.tag == 6) {
            result = true;
        } else if (type.tag == 7) {
            result = true;
        }
        return result;
    }

    private boolean isJavaFXString(Type type) {
        boolean result = false;
        if (type.tag == 10 && type.toString().equals("java.lang.String")) {
            result = true;
        }
        return result;
    }

    private boolean isJavaFXObject(Type type) {
        boolean result = false;
        if (type.tag == 10 && type.toString().equals("java.lang.Object")) {
            result = true;
        }
        return result;
    }

    private boolean isJavaFXUnknown(Type type) {
        boolean result = false;
        if (type.tag == 20) {
            result = true;
        }
        return result;
    }

    private boolean isJavaFXSequence(Type type) {
        boolean result = false;
        if (this.isSequence(type)) {
            result = true;
        }
        return result;
    }

    private boolean isJavaFXMethod(Type type) {
        boolean result = false;
        if (type instanceof Type.MethodType || type instanceof FunctionType) {
            result = true;
        }
        return result;
    }

    private void sequenceToJavaFXString(Type type, Appendable buffer) throws IOException {
        this.toJavaFXString(this.elementType(type), buffer);
        buffer.append("[]");
    }

    private void methodToJavaFXString(Type.MethodType type, Appendable buffer) throws IOException {
        List args;
        if (type.getReturnType() == null) {
            buffer.append("function(?):?");
            return;
        }
        buffer.append("function(");
        List l = args = type.getParameterTypes();
        while (l.nonEmpty()) {
            if (l != args) {
                buffer.append(",");
            }
            buffer.append(":");
            this.toJavaFXString((Type)l.head, buffer);
            l = l.tail;
        }
        buffer.append("):");
        this.toJavaFXString(type.getReturnType(), buffer);
    }

    private void toJavaFXString(Type type, Appendable buffer) throws IOException {
        if (this.isJavaFXBoolean(type)) {
            buffer.append("Boolean");
        } else if (this.isJavaLong(type)) {
            buffer.append("java.lang.Long");
        } else if (this.isJavaFXInteger(type)) {
            buffer.append("Integer");
        } else if (this.isJavaFXNumber(type)) {
            buffer.append("Number");
        } else if (this.isJavaFXString(type)) {
            buffer.append("String");
        } else if (this.isJavaFXObject(type)) {
            buffer.append("Object");
        } else if (this.isJavaFXUnknown(type)) {
            buffer.append("Object");
        } else if (this.isJavaFXSequence(type)) {
            this.sequenceToJavaFXString(type, buffer);
        } else if (this.isJavaFXMethod(type)) {
            Type.MethodType methodType = type.asMethodType();
            this.methodToJavaFXString(methodType, buffer);
        } else if (type.isCompound()) {
            this.toJavaFXString(this.supertype(type), buffer);
        } else {
            buffer.append(type.toString());
        }
    }

    public String toJavaFXString(Symbol.MethodSymbol sym, List<Symbol.VarSymbol> params) {
        StringBuilder builder = new StringBuilder();
        try {
            this.toJavaFXString(sym, params, builder);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return builder.toString();
    }

    public void toJavaFXString(Symbol.MethodSymbol sym, List<Symbol.VarSymbol> params, Appendable buffer) throws IOException {
        if ((sym.flags() & 0x100000L) != 0L) {
            buffer.append(sym.owner.name);
        } else {
            buffer.append(sym.name == sym.name.table.init ? sym.owner.name : sym.name);
            if (sym.type != null) {
                List<Type> args;
                buffer.append('(');
                List<Type> l = args = sym.type.getParameterTypes();
                while (l.nonEmpty()) {
                    if (l != args) {
                        buffer.append(",");
                    }
                    if (params != null && params.nonEmpty()) {
                        Symbol.VarSymbol param = (Symbol.VarSymbol)params.head;
                        if (param != null) {
                            buffer.append(param.name);
                        }
                        params = params.tail;
                    }
                    buffer.append(":");
                    this.toJavaFXString((Type)l.head, buffer);
                    l = l.tail;
                }
                buffer.append(')');
            }
        }
    }

    public String location(Symbol sym, Type site) {
        while ((sym.owner.flags() & 0x100000L) != 0L || this.syms.isRunMethod(sym.owner)) {
            sym = sym.owner;
        }
        return sym.location(site, this);
    }
}

