/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxVarSymbol;
import com.sun.tools.javafx.comp.JavafxAnalyzeClass;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.comp.JavafxOptimizationStatistics;
import com.sun.tools.javafx.comp.JavafxToJava;
import com.sun.tools.javafx.comp.JavafxTranslationSupport;
import com.sun.tools.javafx.comp.JavafxTypeMorpher;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JavafxTag;
import javax.lang.model.type.TypeMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxInitializationBuilder
extends JavafxTranslationSupport {
    protected static final Context.Key<JavafxInitializationBuilder> javafxInitializationBuilderKey = new Context.Key();
    private final JavafxToJava toJava;
    private final JavafxClassReader reader;
    private final JavafxOptimizationStatistics optStat;
    private final Name addChangeListenerName;
    private final Name locationInitializeName;
    private final Name[] changeListenerInterfaceName;
    private final Name sequenceChangeListenerInterfaceName;
    private static final String initHelperClassName = "com.sun.javafx.runtime.InitHelper";
    private final Name onChangeArgName1;
    private final Name onChangeArgName2;
    Name outerAccessorName;
    Name outerAccessorFieldName;
    final Type initHelperType;
    final Type abstractVariableType;

    public static JavafxInitializationBuilder instance(Context context) {
        JavafxInitializationBuilder instance = context.get(javafxInitializationBuilderKey);
        if (instance == null) {
            instance = new JavafxInitializationBuilder(context);
        }
        return instance;
    }

    protected JavafxInitializationBuilder(Context context) {
        super(context);
        context.put(javafxInitializationBuilderKey, this);
        this.toJava = JavafxToJava.instance(context);
        this.reader = JavafxClassReader.instance(context);
        this.optStat = JavafxOptimizationStatistics.instance(context);
        this.addChangeListenerName = this.names.fromString("addChangeListener");
        this.locationInitializeName = this.names.fromString("initialize");
        this.changeListenerInterfaceName = new Name[5];
        for (int i = 0; i < 5; ++i) {
            this.changeListenerInterfaceName[i] = this.names.fromString("com.sun.javafx.runtime.location." + JavafxVarSymbol.getTypePrefix(i) + "ChangeListener");
        }
        this.sequenceChangeListenerInterfaceName = this.names.fromString("com.sun.javafx.runtime.location.SequenceChangeListener");
        this.onChangeArgName1 = this.names.fromString("$oldValue");
        this.onChangeArgName2 = this.names.fromString("$newValue");
        this.outerAccessorName = this.names.fromString("accessOuter$");
        this.outerAccessorFieldName = this.names.fromString("accessOuterField$");
        Name name = Name.fromString(this.names, initHelperClassName);
        Symbol.ClassSymbol sym = this.reader.enterClass(name);
        this.initHelperType = sym.type;
        name = Name.fromString(this.names, "com.sun.javafx.runtime.location.AbstractVariable");
        sym = this.reader.enterClass(name);
        this.abstractVariableType = this.types.erasure(sym.type);
    }

    JavafxClassModel createJFXClassModel(JFXClassDeclaration cDecl, List<JavafxAnalyzeClass.TranslatedVarInfo> translatedAttrInfo, List<JavafxAnalyzeClass.TranslatedOverrideClassVarInfo> translatedOverrideAttrInfo) {
        boolean classOnly = cDecl.generateClassOnly();
        JCDiagnostic.DiagnosticPosition diagPos = cDecl.pos();
        Type superType = this.types.superType(cDecl);
        Symbol.ClassSymbol outerTypeSym = this.outerTypeSymbol(cDecl);
        JavafxAnalyzeClass analysis = new JavafxAnalyzeClass(diagPos, cDecl.sym, translatedAttrInfo, translatedOverrideAttrInfo, this.log, this.names, this.types, this.reader, this.typeMorpher);
        List<JavafxAnalyzeClass.VarInfo> instanceAttributeInfos = analysis.instanceAttributeInfos();
        List<Symbol.ClassSymbol> javaInterfaces = this.immediateJavaInterfaceNames(cDecl);
        List<Symbol.ClassSymbol> immediateFxSupertypeNames = this.immediateJavafxSupertypes(cDecl);
        ListBuffer cDefinitions = ListBuffer.lb();
        cDefinitions.appendList(this.makeAttributeFields(cDecl.sym, instanceAttributeInfos));
        cDefinitions.appendList(this.makeNeedsDefaultFields(instanceAttributeInfos));
        cDefinitions.appendList(this.makeAttributeFields(cDecl.sym, analysis.staticAttributeInfos()));
        cDefinitions.appendList(this.makeMemberVariableAccessorMethods(cDecl, instanceAttributeInfos));
        cDefinitions.appendList(this.makeApplyDefaultsMethods(diagPos, cDecl, instanceAttributeInfos));
        cDefinitions.append(this.makeInitStaticAttributesBlock(cDecl, translatedAttrInfo));
        cDefinitions.append(this.makeInitializeMethod(diagPos, instanceAttributeInfos, cDecl));
        if (outerTypeSym != null) {
            cDefinitions.append(this.makeOuterAccessorField(diagPos, cDecl, outerTypeSym));
            cDefinitions.append(this.makeOuterAccessorMethod(diagPos, cDecl, outerTypeSym));
        }
        cDefinitions.append(this.makeAddTriggersMethod(diagPos, cDecl, immediateFxSupertypeNames, translatedAttrInfo, translatedOverrideAttrInfo));
        cDefinitions.appendList(this.makeFunctionProxyMethods(cDecl, analysis.needDispatch()));
        if (outerTypeSym == null) {
            cDefinitions.append(this.makeJavaEntryConstructor(diagPos));
        }
        cDefinitions.append(this.makeFXEntryConstructor(diagPos, outerTypeSym, superType != null && this.types.isJFXClass(superType.tsym)));
        ListBuffer iDefinitions = ListBuffer.lb();
        if (!classOnly) {
            iDefinitions.appendList(this.makeMemberVariableAccessorInterfaceMethods(diagPos, translatedAttrInfo));
            iDefinitions.appendList(this.makeFunctionInterfaceMethods(cDecl));
            iDefinitions.appendList(this.makeOuterAccessorInterfaceMembers(cDecl));
        }
        Name interfaceName = classOnly ? null : this.interfaceName(cDecl);
        return new JavafxClassModel(interfaceName, this.makeImplementingInterfaces(diagPos, cDecl, javaInterfaces), iDefinitions.toList(), cDefinitions.toList(), this.makeAdditionalImports(diagPos, cDecl, javaInterfaces), superType);
    }

    private List<Symbol.ClassSymbol> immediateJavafxSupertypes(JFXClassDeclaration cDecl) {
        ListBuffer javafxClassNamesBuff = ListBuffer.lb();
        for (JFXExpression stype : cDecl.getSupertypes()) {
            Symbol sym = this.expressionSymbol(stype);
            if (!this.types.isJFXClass(sym)) continue;
            Symbol.ClassSymbol cSym = (Symbol.ClassSymbol)sym;
            javafxClassNamesBuff.append(cSym);
        }
        return javafxClassNamesBuff.toList();
    }

    private List<Symbol.ClassSymbol> immediateJavaInterfaceNames(JFXClassDeclaration cDecl) {
        ListBuffer javaInterfacesBuff = ListBuffer.lb();
        for (JFXExpression sup : cDecl.getSupertypes()) {
            String className;
            boolean isFXInterface;
            Symbol.ClassSymbol cSym = (Symbol.ClassSymbol)this.expressionSymbol(sup);
            if (cSym == null || (isFXInterface = (className = cSym.fullname.toString()).endsWith("$Intf")) || cSym.fullname == this.defs.fxObjectName || (cSym.flags_field & 0x800000000000L) == 0L || cSym.type == null) continue;
            javaInterfacesBuff.append(cSym);
        }
        return javaInterfacesBuff.toList();
    }

    private List<JCTree> makeFunctionInterfaceMethods(JFXClassDeclaration cDecl) {
        ListBuffer<JCTree> methods = ListBuffer.lb();
        for (JFXTree def : cDecl.getMembers()) {
            if (def.getFXTag() != JavafxTag.FUNCTION_DEF) continue;
            JFXFunctionDefinition func = (JFXFunctionDefinition)def;
            Symbol.MethodSymbol sym = func.sym;
            if ((sym.flags() & 0x100AL) != 0L) continue;
            this.appendMethodClones(methods, cDecl, sym, false);
        }
        return methods.toList();
    }

    private List<JCTree> makeFunctionProxyMethods(JFXClassDeclaration cDecl, List<Symbol.MethodSymbol> needDispatch) {
        ListBuffer<JCTree> methods = ListBuffer.lb();
        for (Symbol.MethodSymbol sym : needDispatch) {
            if ((sym.flags() & 2L) != 0L) continue;
            this.appendMethodClones(methods, cDecl, sym, true);
        }
        return methods.toList();
    }

    private void appendMethodClones(ListBuffer<JCTree> methods, JFXClassDeclaration cDecl, Symbol.MethodSymbol sym, boolean withDispatch) {
        boolean isBound;
        boolean bl = isBound = (sym.flags() & 0x8000000000L) != 0L;
        JCTree.JCBlock mthBody = withDispatch ? this.makeDispatchBody(cDecl, sym, isBound, sym.flags() == 8L) : null;
        JFXClassDeclaration diagPos = cDecl;
        ListBuffer params = ListBuffer.lb();
        for (Symbol.VarSymbol vsym : sym.getParameters()) {
            TypeMirror vtype = vsym.asType();
            if (isBound) {
                JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(vsym);
                vtype = vmi.getLocationType();
            }
            params.append(this.make.VarDef(this.make.Modifiers(0L), vsym.name, this.makeTypeTree(diagPos, (Type)vtype), null));
        }
        JCTree.JCModifiers mods = this.make.Modifiers(1L | (mthBody == null ? 1024L : 0L));
        mods = sym.owner == cDecl.sym ? this.addAccessAnnotationModifiers(diagPos, sym.flags(), mods) : this.addInheritedAnnotationModifiers(diagPos, sym.flags(), mods);
        methods.append(this.make.at(diagPos).MethodDef(mods, this.functionName(sym, false, isBound), this.makeReturnTypeTree(diagPos, sym, isBound), List.<JCTree.JCTypeParameter>nil(), params.toList(), List.<JCTree.JCExpression>nil(), mthBody, null));
        if (withDispatch) {
            this.optStat.recordProxyMethod();
        }
    }

    private List<JCTree.JCExpression> makeImplementingInterfaces(JCDiagnostic.DiagnosticPosition diagPos, JFXClassDeclaration cDecl, List<Symbol.ClassSymbol> baseInterfaces) {
        ListBuffer implementing = ListBuffer.lb();
        implementing.append(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.FXObject"));
        List<JFXExpression> l = cDecl.getImplementing();
        while (l.nonEmpty()) {
            implementing.append(this.makeTypeTree(null, ((JFXExpression)l.head).type));
            l = l.tail;
        }
        for (Symbol.ClassSymbol baseClass : baseInterfaces) {
            implementing.append(this.makeTypeTree(diagPos, baseClass.type, true));
        }
        return implementing.toList();
    }

    private List<JCTree.JCExpression> makeAdditionalImports(JCDiagnostic.DiagnosticPosition diagPos, JFXClassDeclaration cDecl, List<Symbol.ClassSymbol> baseInterfaces) {
        ListBuffer<JCTree.JCExpression> additionalImports = new ListBuffer<JCTree.JCExpression>();
        for (Symbol.ClassSymbol baseClass : baseInterfaces) {
            if (baseClass.type == null || baseClass.type.tsym == null || baseClass.type.tsym.packge() == cDecl.sym.packge() || baseClass.type.tsym.packge() == this.syms.unnamedPackage) continue;
            additionalImports.append(this.makeTypeTree(diagPos, baseClass.type, false));
            additionalImports.append(this.makeTypeTree(diagPos, baseClass.type, true));
        }
        return additionalImports.toList();
    }

    private JCTree.JCMethodDecl makeJavaEntryConstructor(JCDiagnostic.DiagnosticPosition diagPos) {
        JCTree.JCExpressionStatement thisCall = this.make.at(diagPos).Exec(this.make.at(diagPos).Apply(null, this.make.at(diagPos).Ident(this.names._this), List.of(this.make.at(diagPos).Literal(8, 0))));
        JCTree.JCExpressionStatement initCall = this.make.at(diagPos).Exec(this.make.at(diagPos).Apply(null, this.make.at(diagPos).Ident(this.defs.initializeName), List.<JCTree.JCExpression>nil()));
        return this.makeConstructor(diagPos, List.<JCTree.JCVariableDecl>nil(), List.of(thisCall, initCall));
    }

    private JCTree.JCMethodDecl makeFXEntryConstructor(JCDiagnostic.DiagnosticPosition diagPos, Symbol.ClassSymbol outerTypeSym, boolean superIsFX) {
        Name dummyParamName = this.names.fromString("dummy");
        this.make.at(diagPos);
        ListBuffer stmts = ListBuffer.lb();
        if (superIsFX) {
            stmts.append(this.make.Exec(this.make.Apply(null, this.make.Ident(this.names._super), List.of(this.make.Ident(dummyParamName)))));
        }
        ListBuffer params = ListBuffer.lb();
        if (outerTypeSym != null) {
            params.append(this.make.VarDef(this.make.Modifiers(0L), this.outerAccessorFieldName, this.make.Ident(outerTypeSym), null));
            JCTree.JCFieldAccess cSelect = this.make.Select((JCTree.JCExpression)this.make.Ident(this.names._this), this.outerAccessorFieldName);
            JCTree.JCAssign assignStat = this.make.Assign(cSelect, this.make.Ident(this.outerAccessorFieldName));
            stmts.append(this.make.Exec(assignStat));
        }
        params.append(this.make.at(diagPos).VarDef(this.make.Modifiers(0x200000000L), dummyParamName, this.makeTypeTree(diagPos, this.syms.booleanType), null));
        return this.makeConstructor(diagPos, params.toList(), stmts.toList());
    }

    private JCTree.JCMethodDecl makeConstructor(JCDiagnostic.DiagnosticPosition diagPos, List<JCTree.JCVariableDecl> params, List<JCTree.JCStatement> cStats) {
        return this.make.MethodDef(this.make.Modifiers(1L), this.names.init, this.make.TypeIdent(9), List.<JCTree.JCTypeParameter>nil(), params, List.<JCTree.JCExpression>nil(), this.make.Block(0L, cStats), null);
    }

    private Symbol.ClassSymbol outerTypeSymbol(JFXClassDeclaration cdecl) {
        if (cdecl.sym != null && this.toJava.hasOuters.contains(cdecl.sym)) {
            Symbol typeOwner = cdecl.sym.owner;
            while (typeOwner != null && typeOwner.kind != 2) {
                typeOwner = typeOwner.owner;
            }
            if (typeOwner != null) {
                return (typeOwner.flags_field & 0x10L) != 0L ? (Symbol.ClassSymbol)typeOwner.type.tsym : this.reader.jreader.enterClass(this.names.fromString(typeOwner.type.toString() + "$Intf"));
            }
        }
        return null;
    }

    private JCTree makeOuterAccessorField(JCDiagnostic.DiagnosticPosition diagPos, JFXClassDeclaration cdecl, Symbol.ClassSymbol outerTypeSym) {
        return this.make.at(diagPos).VarDef(this.make.at(diagPos).Modifiers(1L), this.outerAccessorFieldName, this.make.Ident(outerTypeSym), null);
    }

    private JCTree makeOuterAccessorMethod(JCDiagnostic.DiagnosticPosition diagPos, JFXClassDeclaration cdecl, Symbol.ClassSymbol outerTypeSym) {
        this.make.at(diagPos);
        Symbol.VarSymbol vs = new Symbol.VarSymbol(1L, this.outerAccessorFieldName, outerTypeSym.type, cdecl.sym);
        JCTree.JCIdent retIdent = this.make.Ident(vs);
        JCTree.JCReturn retRet = this.make.Return(retIdent);
        List<JCTree.JCStatement> mStats = List.of(retRet);
        return this.make.MethodDef(this.make.Modifiers(1L), this.outerAccessorName, this.make.Ident(outerTypeSym), List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), this.make.Block(0L, mStats), null);
    }

    private List<JCTree> makeOuterAccessorInterfaceMembers(JFXClassDeclaration cdecl) {
        ListBuffer members = ListBuffer.lb();
        if (cdecl.sym != null && this.toJava.hasOuters.contains(cdecl.sym)) {
            Symbol typeOwner = cdecl.sym.owner;
            while (typeOwner != null && typeOwner.kind != 2) {
                typeOwner = typeOwner.owner;
            }
            if (typeOwner != null) {
                Symbol.ClassSymbol returnSym = this.typeMorpher.reader.enterClass(this.names.fromString(typeOwner.type.toString() + "$Intf"));
                JCTree.JCMethodDecl accessorMethod = this.make.MethodDef(this.make.Modifiers(1L), this.outerAccessorName, this.make.Ident(returnSym), List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, null);
                members.append(accessorMethod);
                this.optStat.recordProxyMethod();
            }
        }
        return members.toList();
    }

    private Type morphedType(JavafxAnalyzeClass.VarInfo ai) {
        return this.requiresLocation(ai) ? ai.getVariableType() : ai.getRealType();
    }

    private JCTree.JCMethodDecl makeGetterMethod(JCDiagnostic.DiagnosticPosition diagPos, JavafxAnalyzeClass.VarInfo ai, JCTree.JCModifiers mods, JCTree.JCBlock statBlock) {
        Symbol.VarSymbol vsym = ai.getSymbol();
        return this.make.at(diagPos).MethodDef(mods, this.attributeGetterName(vsym), this.makeTypeTree(diagPos, this.morphedType(ai)), List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), statBlock, null);
    }

    private JCTree.JCMethodDecl makeSetterMethod(JCDiagnostic.DiagnosticPosition diagPos, JavafxAnalyzeClass.VarInfo ai, JCTree.JCModifiers mods, JCTree.JCBlock block) {
        Symbol.VarSymbol vsym = ai.getSymbol();
        return this.make.at(diagPos).MethodDef(mods, this.attributeSetterName(vsym), this.makeTypeTree(diagPos, ai.getRealType()), List.<JCTree.JCTypeParameter>nil(), List.of(this.makeParam(diagPos, ai.getRealType(), null, "value")), List.<JCTree.JCExpression>nil(), block, null);
    }

    private List<JCTree> makeMemberVariableAccessorInterfaceMethods(JCDiagnostic.DiagnosticPosition diagPos, List<? extends JavafxAnalyzeClass.VarInfo> attrInfos) {
        ListBuffer accessors = ListBuffer.lb();
        for (JavafxAnalyzeClass.VarInfo varInfo : attrInfos) {
            if (varInfo.isStatic()) continue;
            accessors.append(this.makeGetterMethod(diagPos, varInfo, this.make.Modifiers(1025L), null));
            if (this.requiresLocation(varInfo)) continue;
            accessors.append(this.makeSetterMethod(diagPos, varInfo, this.make.Modifiers(1025L), null));
        }
        return accessors.toList();
    }

    private JCTree.JCModifiers proxyModifiers(JavafxAnalyzeClass.VarInfo ai, JFXClassDeclaration cDecl) {
        long flags = ai.getFlags();
        JCTree.JCModifiers mods = this.make.Modifiers(1L);
        mods = ai.getSymbol().owner == cDecl.sym ? this.addAccessAnnotationModifiers(ai.pos(), flags, mods) : this.addInheritedAnnotationModifiers(ai.pos(), flags, mods);
        return mods;
    }

    private List<JCTree> makeMemberVariableAccessorMethods(JFXClassDeclaration cDecl, List<? extends JavafxAnalyzeClass.VarInfo> attrInfos) {
        ListBuffer accessors = ListBuffer.lb();
        for (JavafxAnalyzeClass.VarInfo varInfo : attrInfos) {
            if (!varInfo.needsCloning()) continue;
            JCDiagnostic.DiagnosticPosition diagPos = varInfo.pos();
            Symbol.VarSymbol vsym = varInfo.getSymbol();
            JCTree.JCIdent value = this.make.Ident(this.attributeFieldName(vsym));
            JCTree.JCReturn returnStat = this.make.at(diagPos).Return(value);
            JCTree.JCBlock block = this.make.at(diagPos).Block(0L, List.of(returnStat));
            accessors.append(this.makeGetterMethod(diagPos, varInfo, this.proxyModifiers(varInfo, cDecl), block));
            if (!this.requiresLocation(varInfo)) {
                ListBuffer stmts = ListBuffer.lb();
                if (!varInfo.isDef()) {
                    JCTree.JCIdent needsDefaultField = this.make.at(diagPos).Ident(this.attributeNeedsDefaultFieldName(vsym));
                    JCTree.JCAssign mark = this.make.at(diagPos).Assign(needsDefaultField, this.make.at(diagPos).Literal(8, 0));
                    stmts.append(this.make.at(diagPos).Exec(mark));
                }
                JCTree.JCIdent attr = this.make.at(diagPos).Ident(this.attributeFieldName(vsym));
                JCTree.JCIdent value2 = this.make.at(diagPos).Ident(this.defs.attributeSetMethodParamName);
                JCTree.JCAssign assign = this.make.at(diagPos).Assign(attr, value2);
                stmts.append(this.make.at(diagPos).Return(assign));
                JCTree.JCBlock block2 = this.make.at(diagPos).Block(0L, stmts.toList());
                accessors.append(this.makeSetterMethod(diagPos, varInfo, this.proxyModifiers(varInfo, cDecl), block2));
            }
            this.optStat.recordProxyMethod();
        }
        return accessors.toList();
    }

    private boolean isAttributeOriginClass(Symbol csym, Symbol attr) {
        if (this.types.isJFXClass(csym)) {
            Symbol.ClassSymbol supertypeSym = (Symbol.ClassSymbol)csym;
            Scope.Entry e = supertypeSym.members().elems;
            while (e != null && e.sym != null) {
                if (attr.owner == csym) {
                    return true;
                }
                if ((attr.flags() & 2L) != 0L) {
                    return false;
                }
                if (e.sym.kind == 4 && e.sym.name == attr.name) {
                    return true;
                }
                e = e.sibling;
            }
            for (Type supertype : supertypeSym.getInterfaces()) {
                if (!this.isAttributeOriginClass(supertype.tsym, attr)) continue;
                return true;
            }
        }
        return false;
    }

    private List<JCTree> makeApplyDefaultsMethods(JCDiagnostic.DiagnosticPosition diagPos, JFXClassDeclaration cDecl, List<? extends JavafxAnalyzeClass.VarInfo> attrInfos) {
        ListBuffer methods = ListBuffer.lb();
        for (JavafxAnalyzeClass.VarInfo varInfo : attrInfos) {
            if (!varInfo.needsCloning()) continue;
            Name methodName = this.attributeApplyDefaultsName(varInfo.getSymbol());
            ListBuffer stmts = ListBuffer.lb();
            if (varInfo.getDefaultInitStatement() != null) {
                stmts.append(varInfo.getDefaultInitStatement());
            } else {
                Symbol.ClassSymbol attrParent = null;
                for (JFXExpression supertype : cDecl.getSupertypes()) {
                    Symbol.TypeSymbol sym = supertype.type.tsym;
                    if (!this.isAttributeOriginClass(sym, varInfo.getSymbol())) continue;
                    attrParent = (Symbol.ClassSymbol)sym;
                    break;
                }
                assert (attrParent != null) : "Parent supertype for attribute " + varInfo.getNameString() + " not found";
                if (attrParent != null) {
                    stmts.append(this.makeSuperCall(diagPos, attrParent, methodName));
                }
            }
            JCTree.JCBlock statBlock = this.make.at(diagPos).Block(0L, stmts.toList());
            JCTree.JCModifiers mods = this.make.Modifiers(1L | (cDecl.generateClassOnly() ? 0L : 8L));
            methods.append(this.make.at(diagPos).MethodDef(mods, methodName, this.makeTypeTree(null, this.syms.voidType), List.<JCTree.JCTypeParameter>nil(), List.of(this.makeReceiverParam(cDecl)), List.<JCTree.JCExpression>nil(), statBlock, null));
            this.optStat.recordProxyMethod();
        }
        return methods.toList();
    }

    private JCTree.JCStatement makeSuperCall(JCDiagnostic.DiagnosticPosition diagPos, Symbol.ClassSymbol cSym, Name methodName) {
        List<JCTree.JCIdent> arg = List.of(this.make.at(diagPos).Ident(this.defs.receiverName));
        JCTree.JCExpression receiver = (cSym.flags() & 0x800000000000L) != 0L ? this.makeTypeTree(diagPos, cSym.type, false) : this.make.at(diagPos).Ident(this.names._super);
        return this.callStatement(diagPos, receiver, methodName, arg);
    }

    private List<JCTree.JCStatement> makeAllSuperCalls(JCDiagnostic.DiagnosticPosition diagPos, List<Symbol.ClassSymbol> javafxClasses, Name methodName) {
        ListBuffer stmts = ListBuffer.lb();
        for (Symbol.ClassSymbol cSym : javafxClasses) {
            stmts.append(this.makeSuperCall(diagPos, cSym, methodName));
        }
        return stmts.toList();
    }

    private JCTree.JCMethodDecl makeInitializeMethod(JCDiagnostic.DiagnosticPosition diagPos, List<JavafxAnalyzeClass.VarInfo> attrInfos, JFXClassDeclaration cDecl) {
        boolean classIsFinal = (cDecl.getModifiers().flags & 0x10L) != 0L;
        ListBuffer stmts = ListBuffer.lb();
        stmts.append(this.callStatement(diagPos, null, this.defs.addTriggersName, (Object)this.make.at(diagPos).Ident(this.names._this)));
        stmts.appendList(this.makeInitAttributesCode(attrInfos, cDecl));
        stmts.append(this.callStatement(diagPos, (JCTree.JCExpression)this.make.Ident(classIsFinal ? this.names._this : cDecl.getName()), this.defs.userInitName, (Object)this.make.TypeCast(this.make.Ident(this.interfaceName(cDecl)), (JCTree.JCExpression)this.make.Ident(this.names._this))));
        stmts.append(this.callStatement(diagPos, (JCTree.JCExpression)this.make.Ident(classIsFinal ? this.names._this : cDecl.getName()), this.defs.postInitName, (Object)this.make.TypeCast(this.make.Ident(this.interfaceName(cDecl)), (JCTree.JCExpression)this.make.Ident(this.names._this))));
        ListBuffer finishAttrs = ListBuffer.lb();
        for (JavafxAnalyzeClass.VarInfo ai : attrInfos) {
            Symbol.VarSymbol vsym = ai.getSymbol();
            if (!ai.needsCloning() || !this.requiresLocation(ai)) continue;
            finishAttrs.append(this.make.at(diagPos).Ident(this.attributeFieldName(vsym)));
        }
        stmts.append(this.callStatement(diagPos, this.makeTypeTree(diagPos, this.initHelperType), "finish", (Object)this.make.NewArray(this.makeTypeTree(diagPos, this.abstractVariableType), List.<JCTree.JCExpression>nil(), finishAttrs.toList())));
        JCTree.JCBlock initializeBlock = this.make.Block(0L, stmts.toList());
        return this.make.MethodDef(this.make.Modifiers(1L), this.defs.initializeName, this.makeTypeTree(null, this.syms.voidType), List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), initializeBlock, null);
    }

    private List<JCTree.JCStatement> makeInitAttributesCode(List<JavafxAnalyzeClass.VarInfo> attrInfos, JFXClassDeclaration cDecl) {
        ListBuffer stmts = ListBuffer.lb();
        for (JavafxAnalyzeClass.VarInfo ai : attrInfos) {
            if (ai.isStatic()) continue;
            JCDiagnostic.DiagnosticPosition diagPos = ai.pos();
            Symbol.VarSymbol vsym = ai.getSymbol();
            Name methodName = this.attributeApplyDefaultsName(vsym);
            List<JCTree.JCIdent> applyDefaultsArg = List.of(this.make.at(diagPos).Ident(this.names._this));
            JCTree.JCStatement applyDefaultsCall = this.callStatement(diagPos, null, methodName, applyDefaultsArg);
            if (!ai.isDef()) {
                JCTree.JCExpression cond;
                Name fieldName;
                if (this.requiresLocation(ai)) {
                    fieldName = this.attributeFieldName(vsym);
                    cond = this.callExpression(diagPos, (JCTree.JCExpression)this.make.at(diagPos).Ident(fieldName), this.defs.needDefaultsMethodName);
                } else {
                    fieldName = this.attributeNeedsDefaultFieldName(vsym);
                    cond = this.make.at(diagPos).Ident(fieldName);
                }
                applyDefaultsCall = this.make.If(cond, applyDefaultsCall, null);
            }
            stmts.append(applyDefaultsCall);
        }
        return stmts.toList();
    }

    private JCTree.JCBlock makeInitStaticAttributesBlock(JFXClassDeclaration cDecl, List<JavafxAnalyzeClass.TranslatedVarInfo> translatedAttrInfo) {
        ListBuffer stmts = ListBuffer.lb();
        boolean isLibrary = this.toJava.attrEnv.toplevel.isLibrary;
        for (JavafxAnalyzeClass.TranslatedVarInfo tai : translatedAttrInfo) {
            JCTree.JCStatement stat;
            assert (tai.var != null);
            assert (tai.var.getFXTag() == JavafxTag.VAR_DEF);
            assert (tai.var.pos != -1);
            if (!tai.isStatic()) continue;
            JCDiagnostic.DiagnosticPosition diagPos = tai.pos();
            if (tai.isDirectOwner() && (isLibrary || (tai.getFlags() | 0x400000000000L) == 0L)) {
                if (tai.getDefaultInitStatement() != null) {
                    stmts.append(tai.getDefaultInitStatement());
                }
                if (this.requiresLocation(tai)) {
                    stmts.append(this.callStatement(diagPos, (JCTree.JCExpression)this.make.at(diagPos).Ident(this.attributeFieldName(tai.getSymbol())), this.locationInitializeName));
                }
            }
            if ((stat = this.makeChangeListenerCall(tai)) == null) continue;
            stmts.append(stat);
        }
        return this.make.at(cDecl.pos()).Block(8L, stmts.toList());
    }

    private JCTree.JCMethodDecl makeAddTriggersMethod(JCDiagnostic.DiagnosticPosition diagPos, JFXClassDeclaration cDecl, List<Symbol.ClassSymbol> javafxSupers, List<JavafxAnalyzeClass.TranslatedVarInfo> translatedAttrInfo, List<JavafxAnalyzeClass.TranslatedOverrideClassVarInfo> translatedTriggerInfo) {
        JCTree.JCStatement stat;
        ListBuffer stmts = ListBuffer.lb();
        stmts.appendList(this.makeAllSuperCalls(diagPos, javafxSupers, this.defs.addTriggersName));
        for (JavafxAnalyzeClass.TranslatedVarInfo translatedVarInfo : translatedAttrInfo) {
            if (translatedVarInfo.isStatic() || (stat = this.makeChangeListenerCall(translatedVarInfo)) == null) continue;
            stmts.append(stat);
        }
        for (JavafxAnalyzeClass.TranslatedOverrideClassVarInfo translatedOverrideClassVarInfo : translatedTriggerInfo) {
            if (translatedOverrideClassVarInfo.isStatic() || (stat = this.makeChangeListenerCall(translatedOverrideClassVarInfo)) == null) continue;
            stmts.append(stat);
        }
        return this.make.at(diagPos).MethodDef(this.make.Modifiers(1L | (cDecl.generateClassOnly() ? 0L : 8L)), this.defs.addTriggersName, this.makeTypeTree(null, this.syms.voidType), List.<JCTree.JCTypeParameter>nil(), List.of(this.makeReceiverParam(cDecl)), List.<JCTree.JCExpression>nil(), this.make.Block(0L, stmts.toList()), null);
    }

    private List<JCTree> makeAttributeFields(Symbol csym, List<? extends JavafxAnalyzeClass.VarInfo> attrInfos) {
        ListBuffer fields = ListBuffer.lb();
        for (JavafxAnalyzeClass.VarInfo varInfo : attrInfos) {
            JCTree.JCExpression varInit;
            Type varType;
            if (!varInfo.needsCloning()) continue;
            JCDiagnostic.DiagnosticPosition diagPos = varInfo.pos();
            Symbol.VarSymbol sym = varInfo.getSymbol();
            boolean requiresLocation = this.requiresLocation(varInfo);
            long modFlags = 1L | (requiresLocation ? 16L : 0L) | varInfo.getFlags() & 8L;
            JCTree.JCModifiers mods = this.make.Modifiers(modFlags);
            if (sym.owner == csym) {
                List<JCTree.JCAnnotation> annotations = List.of(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.SourceName"), List.of(this.make.Literal(sym.name.toString()))));
                mods = this.addAccessAnnotationModifiers(diagPos, sym.flags(), mods, annotations);
            } else {
                mods = this.addInheritedAnnotationModifiers(diagPos, sym.flags(), mods);
            }
            JavafxTypeMorpher.VarMorphInfo vmi = varInfo.getVMI();
            if (requiresLocation) {
                varType = varInfo.getVariableType();
                varInit = this.makeLocationAttributeVariable(vmi, diagPos);
            } else {
                varType = varInfo.getRealType();
                varInit = this.makeDefaultValue(diagPos, vmi);
            }
            this.optStat.recordClassVar(sym, requiresLocation);
            JCTree.JCVariableDecl var = this.make.at(diagPos).VarDef(mods, this.attributeFieldName(sym), this.makeTypeTree(diagPos, varType), varInit);
            fields.append(var);
            this.optStat.recordConcreteField();
        }
        return fields.toList();
    }

    private Name attributeNeedsDefaultFieldName(Symbol.VarSymbol vsym) {
        Name aName = this.attributeFieldName(vsym);
        String nameStr = aName.toString() + "$needs_default$";
        return this.names.fromString(nameStr);
    }

    private List<JCTree> makeNeedsDefaultFields(List<? extends JavafxAnalyzeClass.VarInfo> attrInfos) {
        ListBuffer members = ListBuffer.lb();
        for (JavafxAnalyzeClass.VarInfo varInfo : attrInfos) {
            if (!varInfo.needsCloning() || varInfo.isStatic() || varInfo.isDef() || this.requiresLocation(varInfo)) continue;
            JCDiagnostic.DiagnosticPosition diagPos = varInfo.pos();
            Symbol.VarSymbol vsym = varInfo.getSymbol();
            JCTree.JCVariableDecl var = this.make.at(diagPos).VarDef(this.make.Modifiers(1L), this.attributeNeedsDefaultFieldName(vsym), this.makeTypeTree(diagPos, this.syms.booleanType), this.make.at(diagPos).Literal(8, 1));
            members.append(var);
            this.optStat.recordConcreteField();
        }
        return members.toList();
    }

    JCTree.JCStatement makeChangeListenerCall(JavafxAnalyzeClass.VarInfo info) {
        JCTree.JCExpression changeListener;
        JFXOnReplace onReplace = info.onReplace();
        if (onReplace == null) {
            return null;
        }
        JCDiagnostic.DiagnosticPosition diagPos = info.pos();
        ListBuffer members = ListBuffer.lb();
        List<JCTree.JCExpression> emptyTypeArgs = List.nil();
        int attributeKind = this.typeMorpher.varMorphInfo(info.getSymbol()).getTypeKind();
        if (this.types.isSequence(info.getRealType())) {
            ListBuffer<JCTree.JCStatement> setUpStmts = ListBuffer.lb();
            changeListener = this.makeIdentifier(diagPos, this.sequenceChangeListenerInterfaceName);
            changeListener = this.make.TypeApply(changeListener, List.of(this.makeTypeTree(diagPos, info.getElementType())));
            Type seqValType = this.types.sequenceType(info.getElementType(), false);
            List<JCTree.JCVariableDecl> onChangeArgs = List.of(this.makeIndexParam(diagPos, onReplace), this.makeParam(diagPos, this.syms.intType, onReplace.getLastIndex(), "$lastIndex$"), this.makeParam(diagPos, info.getRealType(), onReplace.getNewElements(), "$newElements$"), new JCTree.JCVariableDecl[]{this.makeParam(diagPos, seqValType, onReplace.getOldValue(), "$oldValue$"), this.makeParam(diagPos, seqValType, null, "$newValue$")});
            members.append(this.makeChangeListenerMethod(diagPos, onReplace, info.onReplaceTranslatedBody(), setUpStmts, "onChange", onChangeArgs, 9));
        } else {
            changeListener = this.makeIdentifier(diagPos, this.changeListenerInterfaceName[attributeKind]);
            members.append(this.makeOnReplaceChangeListenerMethod(diagPos, onReplace, info.onReplaceTranslatedBody(), info.getRealType()));
        }
        if (attributeKind == 0) {
            changeListener = this.make.at(diagPos).TypeApply(changeListener, List.of(this.makeTypeTree(diagPos, info.getRealType())));
        }
        JCTree.JCNewClass anonymousChangeListener = this.make.NewClass(null, emptyTypeArgs, changeListener, List.<JCTree.JCExpression>nil(), this.make.at(diagPos).AnonymousClassDef(this.make.Modifiers(0L), members.toList()));
        JCTree.JCExpression varRef = info.getSymbol().owner.kind == 2 ? this.makeAttributeAccess(diagPos, info.getSymbol(), info.getSymbol().isStatic() ? null : this.defs.receiverName) : this.make.at(diagPos).Ident(info.getName());
        JCTree.JCFieldAccess tmpSelect = this.make.at(diagPos).Select(varRef, this.addChangeListenerName);
        List<JCTree.JCExpression> args = List.of(anonymousChangeListener);
        return this.make.at(diagPos).Exec(this.make.at(diagPos).Apply(emptyTypeArgs, tmpSelect, args));
    }

    private JCTree.JCVariableDecl makeParam(JCDiagnostic.DiagnosticPosition diagPos, Type type, JFXVar var, String nameDefault) {
        Name name;
        if (var != null) {
            name = var.getName();
            diagPos = var.pos();
        } else {
            name = this.names.fromString(nameDefault);
        }
        long flags = 0x200000010L;
        if (var != null && var.mods != null) {
            flags |= var.mods.flags;
        }
        return this.make.at(diagPos).VarDef(this.make.Modifiers(flags), name, this.makeTypeTree(diagPos, type), null);
    }

    private JCTree.JCVariableDecl makeIndexParam(JCDiagnostic.DiagnosticPosition diagPos, JFXOnReplace onReplace) {
        return this.makeParam(diagPos, this.syms.intType, onReplace == null ? null : onReplace.getFirstIndex(), "$index$");
    }

    private JCTree.JCMethodDecl makeOnReplaceChangeListenerMethod(JCDiagnostic.DiagnosticPosition diagPos, JFXOnReplace onReplace, JCTree.JCBlock onReplaceTranslatedBody, Type attributeType) {
        JavafxTypeMorpher.VarMorphInfo vmi;
        List<JCTree.JCVariableDecl> onChangeArgs = List.nil().append(this.make.VarDef(this.make.Modifiers(0L), this.onChangeArgName1, this.makeTypeTree(diagPos, attributeType), null)).append(this.make.VarDef(this.make.Modifiers(0L), this.onChangeArgName2, this.makeTypeTree(diagPos, attributeType), null));
        ListBuffer<JCTree.JCStatement> setUpStmts = ListBuffer.lb();
        if (onReplace != null && onReplace.getOldValue() != null) {
            JFXVar oldValue = onReplace.getOldValue();
            vmi = this.typeMorpher.varMorphInfo(oldValue.sym);
            setUpStmts.append(this.make.at(diagPos).VarDef(this.make.Modifiers(0L), oldValue.getName(), this.makeTypeTree(diagPos, vmi.getRealType(), this.types.isJFXClass(vmi.getRealType().tsym)), this.makeIdentifier(diagPos, this.onChangeArgName1)));
        }
        if (onReplace != null && onReplace.getNewElements() != null) {
            JFXVar newValue = onReplace.getNewElements();
            vmi = this.typeMorpher.varMorphInfo(newValue.sym);
            setUpStmts.append(this.make.at(diagPos).VarDef(this.make.Modifiers(0L), newValue.getName(), this.makeTypeTree(diagPos, vmi.getRealType(), this.types.isJFXClass(vmi.getRealType().tsym)), this.makeIdentifier(diagPos, this.onChangeArgName2)));
        }
        return this.makeChangeListenerMethod(diagPos, onReplace, onReplaceTranslatedBody, setUpStmts, "onChange", onChangeArgs, 9);
    }

    private JCTree.JCMethodDecl makeChangeListenerMethod(JCDiagnostic.DiagnosticPosition diagPos, JFXOnReplace onReplace, JCTree.JCBlock onReplaceTranslatedBody, ListBuffer<JCTree.JCStatement> prefixStmts, String methodName, List<JCTree.JCVariableDecl> args, int returnTypeTag) {
        ListBuffer ocMethStmts = ListBuffer.lb();
        ocMethStmts.appendList(prefixStmts);
        if (onReplace != null) {
            diagPos = onReplace.pos();
            ocMethStmts.appendList(onReplaceTranslatedBody.getStatements());
        }
        if (returnTypeTag == 8) {
            ocMethStmts.append(this.make.at(diagPos).Return(this.make.at(diagPos).Literal(8, 1)));
        }
        return this.make.at(diagPos).MethodDef(this.make.at(diagPos).Modifiers(1L), this.names.fromString(methodName), this.make.at(diagPos).TypeIdent(returnTypeTag), List.<JCTree.JCTypeParameter>nil(), args, List.<JCTree.JCExpression>nil(), this.make.at(diagPos).Block(0L, ocMethStmts.toList()), null);
    }

    private JCTree.JCBlock makeDispatchBody(JCDiagnostic.DiagnosticPosition diagPos, Symbol.MethodSymbol mth, boolean isBound, boolean isStatic) {
        ListBuffer args = ListBuffer.lb();
        if (!isStatic) {
            args.append(this.make.Ident(this.names._this));
        }
        for (Symbol.VarSymbol var : mth.params) {
            args.append(this.make.Ident(var.name));
        }
        JCTree.JCExpression receiver = this.makeTypeTree(diagPos, mth.owner.type, false);
        JCTree.JCMethodInvocation expr = this.callExpression(diagPos, receiver, this.functionName(mth, !isStatic, isBound), args);
        JCTree.JCStatement statement = mth.getReturnType() == this.syms.voidType ? this.make.Exec(expr) : this.make.Return(expr);
        return this.make.at(diagPos).Block(0L, List.of(statement));
    }

    private boolean requiresLocation(JavafxAnalyzeClass.VarInfo ai) {
        return this.typeMorpher.requiresLocation(ai.getSymbol());
    }

    @Override
    protected String getSyntheticPrefix() {
        return "ifx$";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavafxClassModel {
        final Name interfaceName;
        final List<JCTree.JCExpression> interfaces;
        final List<JCTree> iDefinitions;
        final List<JCTree> additionalClassMembers;
        final List<JCTree.JCExpression> additionalImports;
        final Type superType;

        JavafxClassModel(Name interfaceName, List<JCTree.JCExpression> interfaces, List<JCTree> iDefinitions, List<JCTree> addedClassMembers, List<JCTree.JCExpression> additionalImports, Type superType) {
            this.interfaceName = interfaceName;
            this.interfaces = interfaces;
            this.iDefinitions = iDefinitions;
            this.additionalClassMembers = addedClassMembers;
            this.additionalImports = additionalImports;
            this.superType = superType;
        }
    }
}

