/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxClassSymbol;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxVarSymbol;
import com.sun.tools.javafx.comp.JavafxAnnotate;
import com.sun.tools.javafx.comp.JavafxAttr;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxAttrContextEnv;
import com.sun.tools.javafx.comp.JavafxCheck;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.comp.JavafxEnter;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.comp.JavafxResolve;
import com.sun.tools.javafx.comp.JavafxTodo;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXErroneous;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXImport;
import com.sun.tools.javafx.tree.JFXReturn;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import com.sun.tools.javafx.tree.JavafxTreeScanner;
import com.sun.tools.javafx.tree.JavafxVisitor;
import java.util.HashSet;
import java.util.Set;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxMemberEnter
extends JavafxTreeScanner
implements JavafxVisitor,
Symbol.Completer {
    protected static final Context.Key<JavafxMemberEnter> javafxMemberEnterKey = new Context.Key();
    protected static final boolean checkClash = true;
    private final Name.Table names;
    private final JavafxEnter enter;
    private final Log log;
    private final JavafxCheck chk;
    private final JavafxAttr attr;
    private final JavafxSymtab syms;
    private final JavafxTreeMaker fxmake;
    private final ClassReader reader;
    private final JavafxTodo todo;
    private final JavafxAnnotate annotate;
    private final Types types;
    private final Target target;
    ListBuffer<JavafxEnv<JavafxAttrContext>> halfcompleted = new ListBuffer();
    boolean isFirst = true;
    boolean completionEnabled = true;
    protected JavafxEnv<JavafxAttrContext> env;

    public static JavafxMemberEnter instance(Context context) {
        JavafxMemberEnter instance = context.get(javafxMemberEnterKey);
        if (instance == null) {
            instance = new JavafxMemberEnter(context);
        }
        return instance;
    }

    protected JavafxMemberEnter(Context context) {
        context.put(javafxMemberEnterKey, this);
        this.names = Name.Table.instance(context);
        this.enter = JavafxEnter.instance(context);
        this.log = Log.instance(context);
        this.chk = JavafxCheck.instance(context);
        this.attr = JavafxAttr.instance(context);
        this.syms = (JavafxSymtab)JavafxSymtab.instance(context);
        this.fxmake = JavafxTreeMaker.instance(context);
        this.reader = JavafxClassReader.instance(context);
        this.todo = JavafxTodo.instance(context);
        this.annotate = JavafxAnnotate.instance(context);
        this.types = Types.instance(context);
        this.target = Target.instance(context);
    }

    void importAll(int pos, Symbol.TypeSymbol tsym, JavafxEnv<JavafxAttrContext> env) {
        if (tsym.kind == 1 && tsym.members().elems == null && !tsym.exists()) {
            if (((Symbol.PackageSymbol)tsym).fullname.equals(this.names.java_lang)) {
                JCDiagnostic msg = JCDiagnostic.fragment("fatal.err.no.java.lang", new Object[0]);
                throw new FatalError(msg);
            }
            this.log.error(pos, "doesnt.exist", tsym);
        }
        Scope fromScope = tsym.members();
        Scope toScope = env.toplevel.starImportScope;
        Scope.Entry e = fromScope.elems;
        while (e != null) {
            if (e.sym.kind == 2 && !toScope.includes(e.sym)) {
                toScope.enter(e.sym, fromScope);
            }
            e = e.sibling;
        }
    }

    private void importStaticAll(int pos, final Symbol.TypeSymbol tsym, JavafxEnv<JavafxAttrContext> env) {
        final JavaFileObject sourcefile = env.toplevel.sourcefile;
        final Scope toScope = env.toplevel.starImportScope;
        final Symbol.PackageSymbol packge = env.toplevel.packge;
        final Symbol.TypeSymbol origin = tsym;
        new Object(){
            Set<Symbol> processed = new HashSet<Symbol>();

            void importFrom(Symbol.TypeSymbol tsym) {
                if (tsym == null || !this.processed.add(tsym)) {
                    return;
                }
                if (tsym instanceof Symbol.ClassSymbol) {
                    if (tsym instanceof JavafxClassSymbol) {
                        JavafxClassSymbol jfxTsym = (JavafxClassSymbol)tsym;
                        for (Type superType : jfxTsym.getSuperTypes()) {
                            this.importFrom(superType.tsym);
                        }
                    } else {
                        this.importFrom(((JavafxMemberEnter)JavafxMemberEnter.this).types.supertype((Type)tsym.type).tsym);
                    }
                    for (Type t : JavafxMemberEnter.this.types.interfaces(tsym.type)) {
                        this.importFrom(t.tsym);
                    }
                }
                Scope fromScope = tsym.members();
                Scope.Entry e = fromScope.elems;
                while (e != null) {
                    Symbol sym = e.sym;
                    if (sym.kind == 2 && (sym.flags() & 8L) != 0L && JavafxMemberEnter.this.staticImportAccessible(sym, packge) && sym.isMemberOf(origin, JavafxMemberEnter.this.types) && !toScope.includes(sym)) {
                        toScope.enter(sym, fromScope, origin.members());
                    }
                    e = e.sibling;
                }
            }
        }.importFrom(tsym);
        this.annotate.earlier(new JavafxAnnotate.Annotator(){
            Set<Symbol> processed = new HashSet<Symbol>();

            public String toString() {
                return "import static " + tsym + ".*" + " in " + sourcefile;
            }

            void importFrom(Symbol.TypeSymbol tsym2) {
                if (tsym2 == null || !this.processed.add(tsym2)) {
                    return;
                }
                if (tsym2 instanceof Symbol.ClassSymbol) {
                    if (tsym2 instanceof JavafxClassSymbol) {
                        JavafxClassSymbol jfxTsym = (JavafxClassSymbol)tsym2;
                        for (Type superType : jfxTsym.getSuperTypes()) {
                            this.importFrom(superType.tsym);
                        }
                    } else {
                        this.importFrom(((JavafxMemberEnter)JavafxMemberEnter.this).types.supertype((Type)tsym2.type).tsym);
                    }
                    for (Type t : JavafxMemberEnter.this.types.interfaces(tsym2.type)) {
                        this.importFrom(t.tsym);
                    }
                }
                Scope fromScope = tsym2.members();
                Scope.Entry e = fromScope.elems;
                while (e != null) {
                    Symbol sym = e.sym;
                    if (sym.isStatic() && sym.kind != 2 && JavafxMemberEnter.this.staticImportAccessible(sym, packge) && !toScope.includes(sym) && sym.isMemberOf(origin, JavafxMemberEnter.this.types)) {
                        toScope.enter(sym, fromScope, origin.members());
                    }
                    e = e.sibling;
                }
            }

            public void enterAnnotation() {
                this.importFrom(tsym);
            }
        });
    }

    boolean staticImportAccessible(Symbol sym, Symbol.PackageSymbol packge) {
        short flags = (short)(sym.flags() & 7L);
        switch (flags) {
            default: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: {
                return ((long)flags & 0x200000000000L) == 0L;
            }
            case 4: 
        }
        return sym.packge() == packge;
    }

    private void importNamedStatic(final JCDiagnostic.DiagnosticPosition pos, final Symbol.TypeSymbol tsym, final Name name, final JavafxEnv<JavafxAttrContext> env) {
        if (tsym.kind != 2) {
            this.log.error(pos, "static.imp.only.classes.and.interfaces", new Object[0]);
            return;
        }
        final Scope toScope = env.toplevel.namedImportScope;
        final Symbol.PackageSymbol packge = env.toplevel.packge;
        final Symbol.TypeSymbol origin = tsym;
        new Object(){
            Set<Symbol> processed = new HashSet<Symbol>();

            void importFrom(Symbol.TypeSymbol tsym) {
                if (tsym == null || !this.processed.add(tsym)) {
                    return;
                }
                if (tsym instanceof JavafxClassSymbol) {
                    JavafxClassSymbol jfxTsym = (JavafxClassSymbol)tsym;
                    for (Type superType : jfxTsym.getSuperTypes()) {
                        this.importFrom(superType.tsym);
                    }
                } else {
                    this.importFrom(((JavafxMemberEnter)JavafxMemberEnter.this).types.supertype((Type)tsym.type).tsym);
                }
                for (Type t : JavafxMemberEnter.this.types.interfaces(tsym.type)) {
                    this.importFrom(t.tsym);
                }
                Scope.Entry e = tsym.members().lookup(name);
                while (e.scope != null) {
                    Symbol sym = e.sym;
                    if (sym.isStatic() && sym.kind == 2 && JavafxMemberEnter.this.staticImportAccessible(sym, packge) && sym.isMemberOf(origin, JavafxMemberEnter.this.types) && JavafxMemberEnter.this.chk.checkUniqueStaticImport(pos, sym, toScope)) {
                        toScope.enter(sym, sym.owner.members(), origin.members());
                    }
                    e = e.next();
                }
            }
        }.importFrom(tsym);
        this.annotate.earlier(new JavafxAnnotate.Annotator(){
            Set<Symbol> processed = new HashSet<Symbol>();
            boolean found = false;

            public String toString() {
                return "import static " + tsym + "." + name;
            }

            void importFrom(Symbol.TypeSymbol tsym2) {
                if (tsym2 == null || !this.processed.add(tsym2)) {
                    return;
                }
                if (tsym2 instanceof JavafxClassSymbol) {
                    JavafxClassSymbol jfxTsym = (JavafxClassSymbol)tsym2;
                    for (Type superType : jfxTsym.getSuperTypes()) {
                        this.importFrom(superType.tsym);
                    }
                } else {
                    this.importFrom(((JavafxMemberEnter)JavafxMemberEnter.this).types.supertype((Type)tsym2.type).tsym);
                }
                for (Type t : JavafxMemberEnter.this.types.interfaces(tsym2.type)) {
                    this.importFrom(t.tsym);
                }
                Scope.Entry e = tsym2.members().lookup(name);
                while (e.scope != null) {
                    Symbol sym = e.sym;
                    if (sym.isStatic() && JavafxMemberEnter.this.staticImportAccessible(sym, packge) && sym.isMemberOf(origin, JavafxMemberEnter.this.types)) {
                        this.found = true;
                        if (sym.kind == 16 || sym.kind != 2 && JavafxMemberEnter.this.chk.checkUniqueStaticImport(pos, sym, toScope)) {
                            toScope.enter(sym, sym.owner.members(), origin.members());
                        }
                    }
                    e = e.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enterAnnotation() {
                JavaFileObject prev = JavafxMemberEnter.this.log.useSource(env.toplevel.sourcefile);
                try {
                    this.importFrom(tsym);
                    if (!this.found) {
                        JavafxMemberEnter.this.log.error(pos, "cant.resolve.location", JCDiagnostic.fragment("kindname.static", new Object[0]), name, "", "", JavafxResolve.typeKindName(tsym.type), tsym.type);
                    }
                }
                finally {
                    JavafxMemberEnter.this.log.useSource(prev);
                }
            }
        });
    }

    void importNamed(JCDiagnostic.DiagnosticPosition pos, Symbol tsym, JavafxEnv<JavafxAttrContext> env) {
        if (tsym.kind == 2 && this.chk.checkUniqueImport(pos, tsym, env.toplevel.namedImportScope)) {
            env.toplevel.namedImportScope.enter(tsym, tsym.owner.members());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void memberEnter(JFXTree tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> prevEnv = this.env;
        try {
            this.env = env;
            if (tree != null) {
                tree.accept(this);
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
        }
        finally {
            this.env = prevEnv;
        }
    }

    void memberEnter(List<? extends JFXTree> trees, JavafxEnv<JavafxAttrContext> env) {
        List<JFXTree> l = trees;
        while (l.nonEmpty()) {
            this.memberEnter((JFXTree)l.head, env);
            l = l.tail;
        }
    }

    @Override
    public void visitTree(JFXTree tree) {
        if (tree instanceof JFXBlock) {
            this.visitBlockExpression((JFXBlock)tree);
        } else {
            super.visitTree(tree);
        }
    }

    @Override
    public void visitErroneous(JFXErroneous tree) {
        this.memberEnter((List<? extends JFXTree>)tree.getErrorTrees(), this.env);
    }

    @Override
    public void visitScript(JFXScript tree) {
        if (tree.starImportScope.elems != null) {
            return;
        }
        if (tree.pid != null) {
            Symbol p = tree.packge;
            while (p.owner != this.syms.rootPackage) {
                p.owner.complete();
                if (this.syms.classes.get(((Symbol)p).getQualifiedName()) != null) {
                    this.log.error(tree.pos, "pkg.clashes.with.class.of.same.name", p);
                }
                p = p.owner;
            }
        }
        this.importNamed(tree.pos(), this.syms.javafx_StringType.tsym, this.env);
        this.importNamed(tree.pos(), this.syms.javafx_IntegerType.tsym, this.env);
        this.importNamed(tree.pos(), this.syms.javafx_BooleanType.tsym, this.env);
        this.importNamed(tree.pos(), this.syms.javafx_NumberType.tsym, this.env);
        this.importNamed(tree.pos(), this.syms.javafx_DurationType.tsym, this.env);
        this.importNamed(tree.pos(), this.syms.objectType.tsym, this.env);
        this.importNamed(tree.pos(), this.syms.javafx_FXRuntimeType.tsym, this.env);
        this.importStaticAll(tree.pos, this.syms.javafx_AutoImportRuntimeType.tsym, this.env);
        this.memberEnter(tree.defs, this.env);
    }

    @Override
    public void visitImport(JFXImport tree) {
        JFXExpression imp = tree.qualid;
        Name name = JavafxTreeInfo.name(imp);
        if (tree.qualid.getFXTag() == JavafxTag.SELECT) {
            if (name == this.names.fromString("Integer")) {
                this.log.error(tree.pos, "javafx.can.not.import.integer.primitive.type", new Object[0]);
            } else if (name == this.names.fromString("Number")) {
                this.log.error(tree.pos, "javafx.can.not.import.number.primitive.type", new Object[0]);
            } else if (name == this.names.fromString("Boolean")) {
                this.log.error(tree.pos, "javafx.can.not.import.boolean.primitive.type", new Object[0]);
            } else if (name == this.names.fromString("String")) {
                this.log.error(tree.pos, "javafx.can.not.import.string.primitive.type", new Object[0]);
            }
        }
        JavafxEnv<JavafxAttrContext> localEnv = this.env.dup(tree);
        boolean all = false;
        boolean allAndSundry = false;
        if (imp instanceof JFXSelect) {
            if (name == this.names.asterisk) {
                all = true;
                imp = ((JFXSelect)imp).getExpression();
            } else if (name.contentEquals("**")) {
                allAndSundry = true;
                assert (!allAndSundry);
            }
        }
        if (all) {
            Symbol.TypeSymbol p = this.attr.attribTree((JFXTree)imp, localEnv, (int)(imp instanceof JFXIdent ? 2 : 3), (Type)Type.noType).tsym;
            this.chk.checkCanonical(imp);
            if (p instanceof Symbol.ClassSymbol) {
                this.importStaticAll(tree.pos, p, this.env);
            } else {
                this.importAll(tree.pos, p, this.env);
            }
            return;
        }
        if (imp instanceof JFXSelect) {
            JFXSelect s = (JFXSelect)imp;
            Symbol.TypeSymbol p = this.attr.attribTree((JFXTree)s.selected, localEnv, (int)3, (Type)Type.noType).tsym;
            if (p instanceof Symbol.ClassSymbol) {
                this.chk.checkCanonical(s.selected);
                this.importNamedStatic(tree.pos(), p, name, localEnv);
                return;
            }
        }
        Symbol.TypeSymbol c = this.attribImportType((JFXTree)imp, localEnv).tsym;
        this.chk.checkCanonical(imp);
        this.importNamed(tree.pos(), c, this.env);
    }

    public JavafxEnv<JavafxAttrContext> methodEnv(JFXFunctionDefinition tree, JavafxEnv<JavafxAttrContext> env) {
        Scope localScope = new Scope(tree.sym);
        localScope.next = ((JavafxAttrContext)env.info).scope;
        JavafxEnv<JavafxAttrContext> localEnv = env.dup(tree, ((JavafxAttrContext)env.info).dup(localScope));
        localEnv.outer = env;
        localEnv.enclMethod = tree;
        if ((tree.mods.flags & 8L) != 0L) {
            ++((JavafxAttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    public JavafxEnv<JavafxAttrContext> getMethodEnv(JFXFunctionDefinition tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> mEnv = this.methodEnv(tree, env);
        ((JavafxAttrContext)mEnv.info).lint = ((JavafxAttrContext)mEnv.info).lint.augment(tree.sym.attributes_field, tree.sym.flags());
        List<JFXVar> l = tree.getParams();
        while (l.nonEmpty()) {
            ((JavafxAttrContext)mEnv.info).scope.enterIfAbsent(((JFXVar)l.head).sym);
            l = l.tail;
        }
        return mEnv;
    }

    public JavafxEnv<JavafxAttrContext> initEnv(JFXVar tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> localEnv = env.dupto(new JavafxAttrContextEnv((JFXTree)tree, ((JavafxAttrContext)env.info).dup()));
        if (tree.sym.owner.kind == 2) {
            ((JavafxAttrContext)localEnv.info).scope = new Scope.DelegatedScope(((JavafxAttrContext)env.info).scope);
            ((JavafxAttrContext)localEnv.info).scope.owner = tree.sym;
        }
        if ((tree.mods.flags & 8L) != 0L || (env.enclClass.sym.flags() & 0x200L) != 0L) {
            ++((JavafxAttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    public JavafxEnv<JavafxAttrContext> getInitEnv(JFXVar tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> iEnv = this.initEnv(tree, env);
        return iEnv;
    }

    @Override
    public void scan(JFXTree tree) {
    }

    @Override
    public void visitVar(JFXVar tree) {
        JavafxEnv<JavafxAttrContext> localEnv = this.env;
        if ((tree.mods.flags & 8L) != 0L || (((JavafxAttrContext)this.env.info).scope.owner.flags() & 0x200L) != 0L) {
            localEnv = this.env.dup(tree, ((JavafxAttrContext)this.env.info).dup());
            ++((JavafxAttrContext)localEnv.info).staticLevel;
        }
        Scope enclScope = JavafxEnter.enterScope(this.env);
        JavafxVarSymbol v = new JavafxVarSymbol(0L, tree.name, null, enclScope.owner);
        this.attr.varSymToTree.put(v, tree);
        tree.sym = v;
        SymbolCompleter completer = new SymbolCompleter();
        completer.env = this.env;
        completer.tree = tree;
        completer.attr = this.attr;
        v.completer = completer;
        v.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, v, tree);
        if (tree.init != null) {
            v.flags_field |= 0x40000L;
        }
        if (this.chk.checkUnique(tree.pos(), v, enclScope)) {
            this.chk.checkTransparentVar(tree.pos(), v, enclScope);
            enclScope.enter(v);
        }
        v.pos = tree.pos;
    }

    @Override
    public void visitFunctionDefinition(JFXFunctionDefinition tree) {
        try {
            Scope enclScope = JavafxEnter.enterScope(this.env);
            Symbol.MethodSymbol m = new Symbol.MethodSymbol(0L, tree.name, null, enclScope.owner);
            m.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, m, tree);
            tree.sym = m;
            enclScope.enter(m);
            SymbolCompleter completer = new SymbolCompleter();
            completer.env = this.env;
            completer.tree = tree;
            completer.attr = this.attr;
            m.completer = completer;
            this.attr.methodSymToTree.put(m, tree);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void visitReturn(JFXReturn tree) {
        super.visitReturn(tree);
    }

    @Override
    public void visitClassDeclaration(JFXClassDeclaration that) {
        for (JFXExpression superClass : that.getSupertypes()) {
            Type superType = this.attr.attribType(superClass, this.env);
            if (that.sym == null || !(that.sym instanceof JavafxClassSymbol) || superType == null || superType == Type.noType) continue;
            ((JavafxClassSymbol)that.sym).addSuperType(superType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type attribImportType(JFXTree tree, JavafxEnv<JavafxAttrContext> env) {
        assert (this.completionEnabled);
        try {
            this.completionEnabled = false;
            Type type = this.attr.attribType(tree, env);
            return type;
        }
        finally {
            this.completionEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (!this.completionEnabled) {
            assert ((sym.flags() & 0x1000000L) == 0L);
            sym.completer = this;
            return;
        }
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
        Type.ClassType ct = (Type.ClassType)c.type;
        JavafxEnv<JavafxAttrContext> localEnv = this.enter.typeEnvs.get(c);
        JFXClassDeclaration tree = (JFXClassDeclaration)localEnv.tree;
        boolean wasFirst = this.isFirst;
        this.isFirst = false;
        JavaFileObject prev = this.log.useSource(localEnv.toplevel.sourcefile);
        try {
            this.halfcompleted.append(localEnv);
            if (c.owner.kind == 1) {
                for (JFXTree def : localEnv.toplevel.defs) {
                    if (!(def instanceof JFXImport)) continue;
                    this.memberEnter(localEnv.toplevel, localEnv.enclosing(JavafxTag.TOPLEVEL));
                }
                this.todo.append(localEnv);
            }
            c.flags_field |= 0x10000000L;
            if (c.owner.kind == 2) {
                c.owner.complete();
            }
            JavafxEnv<JavafxAttrContext> baseEnv = this.baseEnv(tree, localEnv);
            Type supertype = null;
            Type solesupertype = null;
            ListBuffer<Type> interfaces = new ListBuffer<Type>();
            HashSet<Type> interfaceSet = new HashSet<Type>();
            ListBuffer extending = ListBuffer.lb();
            ListBuffer implementing = ListBuffer.lb();
            boolean compound = (tree.getModifiers().flags & 0x10L) == 0L;
            for (JFXExpression stype : tree.getSupertypes()) {
                Type st = this.attr.attribType(stype, localEnv);
                if (st.isInterface()) {
                    implementing.append(stype);
                    continue;
                }
                solesupertype = extending.isEmpty() ? st : null;
                extending.append(stype);
                if ((st.tsym.flags_field & 0x800000000000L) == 0L) {
                    compound = false;
                    supertype = st;
                    continue;
                }
                interfaces.append(st);
                this.chk.checkNotRepeated(stype.pos(), this.types.erasure(st), interfaceSet);
            }
            if (compound) {
                c.flags_field |= 0x800000000000L;
            }
            tree.setDifferentiatedExtendingImplementing(extending.toList(), implementing.toList());
            if (supertype == null) {
                supertype = c.fullname == this.names.java_lang_Object ? Type.noType : this.syms.objectType;
            }
            ct.supertype_field = supertype;
            List<JFXExpression> interfaceTrees = tree.getImplementing();
            if ((tree.mods.flags & 0x4000L) != 0L && this.target.compilerBootstrap(c)) {
                interfaceTrees = interfaceTrees.prepend(this.fxmake.Type(new Type.ClassType(this.syms.comparableType.getEnclosingType(), List.of(c.type), this.syms.comparableType.tsym)));
                interfaceTrees = interfaceTrees.prepend(this.fxmake.Type(this.syms.serializableType));
            }
            for (JFXExpression iface : interfaceTrees) {
                Type i = this.attr.attribBase(iface, baseEnv, false, true, true);
                if (i.tag != 10) continue;
                interfaces.append(i);
                this.chk.checkNotRepeated(iface.pos(), this.types.erasure(i), interfaceSet);
            }
            ct.interfaces_field = (c.flags_field & 0x2000L) != 0L ? List.of(this.syms.annotationType) : interfaces.toList();
            if (c.fullname == this.names.java_lang_Object) {
                if (tree.getExtending().head != null) {
                    this.chk.checkNonCyclic(((JFXExpression)tree.getExtending().head).pos(), supertype);
                    ct.supertype_field = Type.noType;
                } else if (tree.getImplementing().nonEmpty()) {
                    this.chk.checkNonCyclic(((JFXExpression)tree.getImplementing().head).pos(), (Type)ct.interfaces_field.head);
                    ct.interfaces_field = List.nil();
                }
            }
            this.chk.checkNonCyclic(tree.pos(), c.type);
            if ((c.flags_field & 0x200L) == 0L) {
                Symbol.VarSymbol thisSym = new Symbol.VarSymbol(262160L, this.names._this, c.type, c);
                thisSym.pos = 0;
                ((JavafxAttrContext)localEnv.info).scope.enter(thisSym);
                if (ct.supertype_field.tag == 10 && solesupertype != null) {
                    Symbol.VarSymbol superSym = new Symbol.VarSymbol(262160L, this.names._super, solesupertype, c);
                    superSym.pos = 0;
                    ((JavafxAttrContext)localEnv.info).scope.enter(superSym);
                }
            }
            if (c.owner.kind == 1 && c.owner != this.syms.unnamedPackage && this.reader.packageExists(c.fullname)) {
                this.log.error(tree.pos, "clash.with.pkg.of.same.name", c);
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
        }
        finally {
            this.log.useSource(prev);
        }
        if (wasFirst) {
            try {
                while (this.halfcompleted.nonEmpty()) {
                    this.finish(this.halfcompleted.next());
                }
            }
            finally {
                this.isFirst = true;
            }
            this.annotate.flush();
        }
    }

    private JavafxEnv<JavafxAttrContext> baseEnv(JFXClassDeclaration tree, JavafxEnv<JavafxAttrContext> env) {
        Scope typaramScope = new Scope(tree.sym);
        JavafxEnv<JavafxAttrContext> outer = env.outer;
        JavafxEnv<JavafxAttrContext> localEnv = outer.dup(tree, ((JavafxAttrContext)outer.info).dup(typaramScope));
        localEnv.baseClause = true;
        localEnv.outer = outer;
        ((JavafxAttrContext)localEnv.info).isSelfCall = false;
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(JavafxEnv<JavafxAttrContext> env) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            JFXClassDeclaration tree = (JFXClassDeclaration)env.tree;
            this.memberEnter(tree.getMembers(), env);
        }
        finally {
            this.log.useSource(prev);
        }
    }

    static class SymbolCompleter
    implements Symbol.Completer {
        JavafxEnv<JavafxAttrContext> env;
        JFXTree tree;
        JavafxAttr attr;

        SymbolCompleter() {
        }

        public void complete(Symbol m) throws Symbol.CompletionFailure {
            if (this.tree instanceof JFXVar) {
                this.attr.finishVar((JFXVar)this.tree, this.env);
            } else if (this.attr.pt != Type.noType) {
                m.completer = this;
                this.attr.attribExpr(this.tree, this.env);
            } else {
                this.attr.finishFunctionDefinition((JFXFunctionDefinition)this.tree, this.env);
            }
        }
    }
}

