/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;

public class JavafxOptimizationStatistics {
    private final Log log;
    private int instanceVarLocationCount;
    private int instanceVarDirectCount;
    private int instanceDefLocationCount;
    private int instanceDefDirectCount;
    private int scriptVarLocationCount;
    private int scriptVarDirectCount;
    private int scriptDefLocationCount;
    private int scriptDefDirectCount;
    private int localBoundVarLocationCount;
    private int localBoundVarDirectCount;
    private int localBoundDefLocationCount;
    private int localBoundDefDirectCount;
    private int localUnboundVarLocationCount;
    private int localUnboundVarDirectCount;
    private int localUnboundDefLocationCount;
    private int localUnboundDefDirectCount;
    private int proxyMethodCount;
    private int concreteFieldCount;
    protected static final Context.Key<JavafxOptimizationStatistics> jfxOptStatKey = new Context.Key();

    public static JavafxOptimizationStatistics instance(Context context) {
        JavafxOptimizationStatistics instance = context.get(jfxOptStatKey);
        if (instance == null) {
            instance = new JavafxOptimizationStatistics(context);
        }
        return instance;
    }

    protected JavafxOptimizationStatistics(Context context) {
        context.put(jfxOptStatKey, this);
        this.log = Log.instance(context);
        this.instanceVarLocationCount = 0;
        this.instanceVarDirectCount = 0;
        this.instanceDefLocationCount = 0;
        this.instanceDefDirectCount = 0;
        this.scriptVarLocationCount = 0;
        this.scriptVarDirectCount = 0;
        this.scriptDefLocationCount = 0;
        this.scriptDefDirectCount = 0;
        this.localBoundVarLocationCount = 0;
        this.localBoundVarDirectCount = 0;
        this.localBoundDefLocationCount = 0;
        this.localBoundDefDirectCount = 0;
        this.localUnboundVarLocationCount = 0;
        this.localUnboundVarDirectCount = 0;
        this.localUnboundDefLocationCount = 0;
        this.localUnboundDefDirectCount = 0;
        this.proxyMethodCount = 0;
        this.concreteFieldCount = 0;
    }

    public void recordClassVar(Symbol.VarSymbol vsym, boolean isLocation) {
        boolean isScript;
        long flags = vsym.flags();
        boolean isDef = (flags & 0x20000000000L) != 0L;
        boolean bl = isScript = (flags & 8L) != 0L;
        if (isLocation) {
            if (isScript) {
                if (isDef) {
                    ++this.scriptDefLocationCount;
                } else {
                    ++this.scriptVarLocationCount;
                }
            } else if (isDef) {
                ++this.instanceDefLocationCount;
            } else {
                ++this.instanceVarLocationCount;
            }
        } else if (isScript) {
            if (isDef) {
                ++this.scriptDefDirectCount;
            } else {
                ++this.scriptVarDirectCount;
            }
        } else if (isDef) {
            ++this.instanceDefDirectCount;
        } else {
            ++this.instanceVarDirectCount;
        }
    }

    public void recordLocalVar(Symbol.VarSymbol vsym, boolean isBound, boolean isLocation) {
        boolean isDef;
        long flags = vsym.flags();
        boolean bl = isDef = (flags & 0x20000000000L) != 0L;
        if (isBound) {
            if (isLocation) {
                if (isDef) {
                    ++this.localBoundDefLocationCount;
                } else {
                    ++this.localBoundVarLocationCount;
                }
            } else if (isDef) {
                ++this.localBoundDefDirectCount;
            } else {
                ++this.localBoundVarDirectCount;
            }
        } else if (isLocation) {
            if (isDef) {
                ++this.localUnboundDefLocationCount;
            } else {
                ++this.localUnboundVarLocationCount;
            }
        } else if (isDef) {
            ++this.localUnboundDefDirectCount;
        } else {
            ++this.localUnboundVarDirectCount;
        }
    }

    public void recordProxyMethod() {
        ++this.proxyMethodCount;
    }

    public void recordConcreteField() {
        ++this.concreteFieldCount;
    }

    private void show(String label, int value) {
        this.log.note("javafx.optimization.statistic", label, value);
    }

    private void printInstanceVariableData() {
        int instanceVariableLocationCount = this.instanceVarLocationCount + this.instanceDefLocationCount;
        int instanceVariableDirectCount = this.instanceVarDirectCount + this.instanceDefDirectCount;
        int instanceVariableCount = instanceVariableLocationCount + instanceVariableDirectCount;
        this.show("Instance variable count", instanceVariableCount);
        this.show("Instance variable Location count", instanceVariableLocationCount);
        this.show("Instance variable direct count", instanceVariableDirectCount);
        this.show("Instance 'var' count", this.instanceVarLocationCount + this.instanceVarDirectCount);
        this.show("Instance 'var' Location count", this.instanceVarLocationCount);
        this.show("Instance 'var' direct count", this.instanceVarDirectCount);
        this.show("Instance 'def' count", this.instanceDefLocationCount + this.instanceDefDirectCount);
        this.show("Instance 'def' Location count", this.instanceDefLocationCount);
        this.show("Instance 'def' direct count", this.instanceDefDirectCount);
    }

    private void printScriptVariableData() {
        int scriptVariableLocationCount = this.scriptVarLocationCount + this.scriptDefLocationCount;
        int scriptVariableDirectCount = this.scriptVarDirectCount + this.scriptDefDirectCount;
        int scriptVariableCount = scriptVariableLocationCount + scriptVariableDirectCount;
        this.show("Script variable count", scriptVariableCount);
        this.show("Script variable Location count", scriptVariableLocationCount);
        this.show("Script variable direct count", scriptVariableDirectCount);
        this.show("Script 'var' count", this.scriptVarLocationCount + this.scriptVarDirectCount);
        this.show("Script 'var' Location count", this.scriptVarLocationCount);
        this.show("Script 'var' direct count", this.scriptVarDirectCount);
        this.show("Script 'def' count", this.scriptDefLocationCount + this.scriptDefDirectCount);
        this.show("Script 'def' Location count", this.scriptDefLocationCount);
        this.show("Script 'def' direct count", this.scriptDefDirectCount);
    }

    private void printLocalVariableData() {
        int localBoundVariableLocationCount = this.localBoundVarLocationCount + this.localBoundDefLocationCount;
        int localBoundVariableDirectCount = this.localBoundVarDirectCount + this.localBoundDefDirectCount;
        int localBoundVariableCount = localBoundVariableLocationCount + localBoundVariableDirectCount;
        int localBoundVarCount = this.localBoundVarLocationCount + this.localBoundVarDirectCount;
        int localBoundDefCount = this.localBoundDefLocationCount + this.localBoundDefDirectCount;
        this.show("Local bound variable count", localBoundVariableCount);
        this.show("Local bound variable Location count", localBoundVariableLocationCount);
        this.show("Local bound variable direct count", localBoundVariableDirectCount);
        this.show("Local bound 'var' count", localBoundVarCount);
        this.show("Local bound 'var' Location count", this.localBoundVarLocationCount);
        this.show("Local bound 'var' direct count", this.localBoundVarDirectCount);
        this.show("Local bound 'def' count", localBoundDefCount);
        this.show("Local bound 'def' Location count", this.localBoundDefLocationCount);
        this.show("Local bound 'def' direct count", this.localBoundDefDirectCount);
        int localUnboundVariableLocationCount = this.localUnboundVarLocationCount + this.localUnboundDefLocationCount;
        int localUnboundVariableDirectCount = this.localUnboundVarDirectCount + this.localUnboundDefDirectCount;
        int localUnboundVariableCount = localUnboundVariableLocationCount + localUnboundVariableDirectCount;
        int localUnboundVarCount = this.localUnboundVarLocationCount + this.localUnboundVarDirectCount;
        int localUnboundDefCount = this.localUnboundDefLocationCount + this.localUnboundDefDirectCount;
        this.show("Local unbound variable count", localUnboundVariableCount);
        this.show("Local unbound variable Location count", localUnboundVariableLocationCount);
        this.show("Local unbound variable direct count", localUnboundVariableDirectCount);
        this.show("Local unbound 'var' count", localUnboundVarCount);
        this.show("Local unbound 'var' Location count", this.localUnboundVarLocationCount);
        this.show("Local unbound 'var' direct count", this.localUnboundVarDirectCount);
        this.show("Local unbound 'def' count", localUnboundDefCount);
        this.show("Local unbound 'def' Location count", this.localUnboundDefLocationCount);
        this.show("Local unbound 'def' direct count", this.localUnboundDefDirectCount);
        int localVariableLocationCount = localBoundVariableLocationCount + localUnboundVariableLocationCount;
        int localVariableDirectCount = localBoundVariableDirectCount + localUnboundVariableDirectCount;
        int localVariableCount = localVariableLocationCount + localVariableDirectCount;
        int localVarCount = localUnboundVarCount + localBoundVarCount;
        int localDefCount = localUnboundDefCount + localBoundDefCount;
        int localVarLocationCount = this.localBoundVarLocationCount + this.localUnboundVarLocationCount;
        int localVarDirectCount = this.localBoundVarDirectCount + this.localUnboundVarDirectCount;
        int localDefLocationCount = this.localBoundDefLocationCount + this.localUnboundDefLocationCount;
        int localDefDirectCount = this.localBoundDefDirectCount + this.localUnboundDefDirectCount;
        this.show("Local variable count", localVariableCount);
        this.show("Local variable Location count", localVariableLocationCount);
        this.show("Local variable direct count", localVariableDirectCount);
        this.show("Local 'var' count", localVarCount);
        this.show("Local 'var' Location count", localVarLocationCount);
        this.show("Local 'var' direct count", localVarDirectCount);
        this.show("Local 'def' count", localDefCount);
        this.show("Local 'def' Location count", localDefLocationCount);
        this.show("Local 'def' direct count", localDefDirectCount);
    }

    private void printProxyMethodData() {
        this.show("Proxy method count", this.proxyMethodCount);
    }

    private void printConcreteFieldData() {
        this.show("Concrete field count", this.concreteFieldCount);
    }

    public void printData(String which) {
        if (which.contains("i")) {
            this.printInstanceVariableData();
        }
        if (which.contains("s")) {
            this.printScriptVariableData();
        }
        if (which.contains("l")) {
            this.printLocalVariableData();
        }
        if (which.contains("m")) {
            this.printProxyMethodData();
        }
        if (which.contains("f")) {
            this.printConcreteFieldData();
        }
    }
}

