/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.javafx.api.JavafxBindStatus;
import com.sun.javafx.api.tree.SyntheticTree;
import com.sun.javafx.api.tree.TypeTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.comp.JavafxDefs;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXFunctionValue;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXModifiers;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXType;
import com.sun.tools.javafx.tree.JFXTypeClass;
import com.sun.tools.javafx.tree.JFXTypeUnknown;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import com.sun.tools.javafx.tree.JavafxTreeScanner;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxScriptClassBuilder {
    protected static final Context.Key<JavafxScriptClassBuilder> javafxModuleBuilderKey = new Context.Key();
    private final JavafxDefs defs;
    private Name.Table names;
    private JavafxTreeMaker fxmake;
    private Log log;
    private JavafxSymtab syms;
    private Set<Name> reservedTopLevelNamesSet;
    private Name pseudoFile;
    private Name pseudoDir;
    private Name defaultRunArgName;
    private static final boolean debugBadPositions = Boolean.getBoolean("JavafxModuleBuilder.debugBadPositions");

    public static JavafxScriptClassBuilder instance(Context context) {
        JavafxScriptClassBuilder instance = context.get(javafxModuleBuilderKey);
        if (instance == null) {
            instance = new JavafxScriptClassBuilder(context);
        }
        return instance;
    }

    protected JavafxScriptClassBuilder(Context context) {
        this.defs = JavafxDefs.instance(context);
        this.names = Name.Table.instance(context);
        this.fxmake = JavafxTreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = (JavafxSymtab)JavafxSymtab.instance(context);
        this.pseudoFile = this.names.fromString("__FILE__");
        this.pseudoDir = this.names.fromString("__DIR__");
        this.defaultRunArgName = this.names.fromString("_$UNUSED$_$ARGS$_");
    }

    public void convertAccessFlags(JFXScript script) {
        new JavafxTreeScanner(){

            void convertFlags(JFXModifiers mods) {
                long flags = mods.flags;
                long access = flags & 0x100000000007L;
                if (access == 0L) {
                    flags |= 0x200000000000L;
                }
                mods.flags = flags;
            }

            public void visitClassDeclaration(JFXClassDeclaration tree) {
                super.visitClassDeclaration(tree);
                this.convertFlags(tree.getModifiers());
            }

            public void visitFunctionDefinition(JFXFunctionDefinition tree) {
                super.visitFunctionDefinition(tree);
                this.convertFlags(tree.getModifiers());
            }

            public void visitVar(JFXVar tree) {
                super.visitVar(tree);
                this.convertFlags(tree.getModifiers());
            }
        }.scan(script);
    }

    private void checkAndNormalizeUserRunFunction(JFXFunctionDefinition runFunc) {
        JFXFunctionValue fval = runFunc.operation;
        List<JFXVar> params = fval.funParams;
        switch (params.size()) {
            case 0: {
                fval.funParams = this.makeRunFunctionArgs(this.defaultRunArgName);
                break;
            }
            case 1: {
                Name cName;
                JFXExpression cnExp;
                JFXType paramType = ((JFXVar)params.head).getJFXType();
                if (paramType.getCardinality() == TypeTree.Cardinality.ANY && paramType instanceof JFXTypeClass && (cnExp = ((JFXTypeClass)paramType).getClassName()) instanceof JFXIdent && (cName = ((JFXIdent)cnExp).getName()) == this.syms.stringTypeName) break;
            }
            default: {
                this.log.error(runFunc.pos(), "javafx.run.function.param", new Object[0]);
                fval.funParams = this.makeRunFunctionArgs(this.defaultRunArgName);
            }
        }
        fval.rettype = this.makeRunFunctionType();
    }

    public void preProcessJfxTopLevel(JFXScript module) {
        boolean isLibrary;
        Name moduleClassName = this.scriptName(module);
        if (debugBadPositions) {
            this.checkForBadPositions(module);
        }
        final boolean[] usesFile = new boolean[1];
        final boolean[] usesDir = new boolean[1];
        final JCDiagnostic.DiagnosticPosition[] diagPos = new JCDiagnostic.DiagnosticPosition[1];
        new JavafxTreeScanner(){

            public void visitIdent(JFXIdent id) {
                super.visitIdent(id);
                if (id.name.equals(JavafxScriptClassBuilder.this.pseudoFile)) {
                    usesFile[0] = true;
                    this.markPosition(id);
                }
                if (id.name.equals(JavafxScriptClassBuilder.this.pseudoDir)) {
                    usesDir[0] = true;
                    this.markPosition(id);
                }
            }

            void markPosition(JFXTree tree) {
                if (diagPos[0] == null) {
                    diagPos[0] = tree.pos();
                }
            }
        }.scan(module.defs);
        ListBuffer<JFXTree> scriptTops = ListBuffer.lb();
        scriptTops.appendList(this.pseudoVariables(diagPos[0], moduleClassName, module, usesFile[0], usesDir[0]));
        scriptTops.appendList(module.defs);
        boolean externalAccessFound = false;
        JFXExpression userRunFunction = null;
        long EXTERNALIZING_FLAGS = 30786325577733L;
        for (JFXTree tree : scriptTops) {
            switch (tree.getFXTag()) {
                case CLASS_DEF: {
                    JFXExpression decl = (JFXClassDeclaration)tree;
                    if ((((JFXClassDeclaration)decl).getModifiers().flags & 0x1C0000000005L) == 0L) break;
                    externalAccessFound = true;
                    break;
                }
                case FUNCTION_DEF: {
                    JFXExpression decl = (JFXFunctionDefinition)tree;
                    Name name = ((JFXFunctionDefinition)decl).name;
                    if (name == this.defs.userRunFunctionName) {
                        if (userRunFunction == null) {
                            this.checkAndNormalizeUserRunFunction((JFXFunctionDefinition)decl);
                            userRunFunction = decl;
                        } else {
                            this.log.error(decl.pos(), "javafx.run.function.single", new Object[0]);
                        }
                    }
                    if ((((JFXFunctionDefinition)decl).getModifiers().flags & 0x1C0000000005L) == 0L) break;
                    externalAccessFound = true;
                    break;
                }
                case VAR_DEF: {
                    JFXExpression decl = (JFXVar)tree;
                    if ((((JFXVar)decl).getModifiers().flags & 0x1C0000000005L) == 0L) break;
                    externalAccessFound = true;
                    break;
                }
            }
        }
        module.isLibrary = isLibrary = externalAccessFound || userRunFunction != null;
        ListBuffer<JFXTree> scriptClassDefs = new ListBuffer<JFXTree>();
        ListBuffer<JFXExpression> stats = new ListBuffer<JFXExpression>();
        JFXExpression value = null;
        ListBuffer<JFXTree> topLevelDefs = new ListBuffer<JFXTree>();
        JFXExpression moduleClass = null;
        boolean looseExpressionsSeen = false;
        block12: for (JFXTree tree : scriptTops) {
            if (value != null) {
                stats.append(value);
                value = null;
            }
            switch (tree.getFXTag()) {
                case IMPORT: {
                    topLevelDefs.append(tree);
                    continue block12;
                }
                case CLASS_DEF: {
                    JFXExpression decl = (JFXClassDeclaration)tree;
                    Name name = ((JFXClassDeclaration)decl).getName();
                    this.checkName(tree.pos, name);
                    if (name == moduleClassName) {
                        moduleClass = decl;
                        continue block12;
                    }
                    ((JFXClassDeclaration)decl).mods.flags |= 0x400000000008L;
                    scriptClassDefs.append(tree);
                    continue block12;
                }
                case FUNCTION_DEF: {
                    JFXExpression decl = (JFXFunctionDefinition)tree;
                    ((JFXFunctionDefinition)decl).mods.flags |= 0x400000000008L;
                    Name name = ((JFXFunctionDefinition)decl).name;
                    this.checkName(tree.pos, name);
                    if (name == this.defs.userRunFunctionName) continue block12;
                    scriptClassDefs.append(tree);
                    continue block12;
                }
                case VAR_DEF: {
                    JFXExpression decl = (JFXVar)tree;
                    if ((((JFXVar)decl).mods.flags & 0x400000000000L) == 0L) {
                        this.checkName(tree.pos, ((JFXVar)decl).getName());
                    }
                    ((JFXVar)decl).mods.flags |= 0x400000000008L;
                    scriptClassDefs.append(decl);
                    if (isLibrary) continue block12;
                    value = this.fxmake.VarScriptInit((JFXVar)decl);
                    continue block12;
                }
            }
            if (isLibrary && !looseExpressionsSeen) {
                this.log.error(tree.pos(), "javafx.loose.expressions", new Object[0]);
            }
            looseExpressionsSeen = true;
            value = (JFXExpression)tree;
        }
        Name commandLineArgs = this.defaultRunArgName;
        if (userRunFunction != null) {
            JFXBlock body;
            List<JFXVar> params = ((JFXFunctionDefinition)userRunFunction).operation.getParams();
            if (params.size() == 1) {
                commandLineArgs = ((JFXVar)params.head).getName();
            }
            if ((body = ((JFXFunctionDefinition)userRunFunction).getBodyExpression()).getStmts().size() > 0 || body.getValue() != null) {
                if (value != null) {
                    stats.append(value);
                }
                stats.appendList(body.getStmts());
                if (body.getValue() != null) {
                    value = body.getValue();
                }
            }
        }
        if (userRunFunction != null || !isLibrary || looseExpressionsSeen) {
            JFXFunctionDefinition internalRunFunction = this.makeInternalRunFunction(module, commandLineArgs, stats.toList(), value);
            internalRunFunction.setGenType(SyntheticTree.SynthType.SYNTHETIC);
            this.setEndPos(module, internalRunFunction, module);
            scriptClassDefs.prepend(internalRunFunction);
            module.isRunnable = true;
        }
        if (moduleClass == null) {
            JFXModifiers cMods = this.fxmake.Modifiers(1L);
            cMods.setGenType(SyntheticTree.SynthType.SYNTHETIC);
            moduleClass = this.fxmake.ClassDeclaration(cMods, moduleClassName, List.<JFXExpression>nil(), scriptClassDefs.toList());
            moduleClass.setGenType(SyntheticTree.SynthType.SYNTHETIC);
            moduleClass.setPos(module.getStartPosition());
            this.setEndPos(module, moduleClass, module);
        } else {
            ((JFXClassDeclaration)moduleClass).setMembers(scriptClassDefs.appendList(((JFXClassDeclaration)moduleClass).getMembers()).toList());
        }
        ((JFXClassDeclaration)moduleClass).isModuleClass = true;
        ((JFXClassDeclaration)moduleClass).runMethod = userRunFunction;
        topLevelDefs.append(moduleClass);
        module.defs = topLevelDefs.toList();
        this.convertAccessFlags(module);
        this.reservedTopLevelNamesSet = null;
    }

    protected void setEndPos(JFXScript module, JFXTree build, JFXTree copy) {
        if (module.endPositions != null) {
            module.endPositions.put(build, copy.getEndPosition(module.endPositions));
        }
    }

    private void debugPositions(final JFXScript module) {
        new JavafxTreeScanner(){

            public void scan(JFXTree tree) {
                super.scan(tree);
                if (tree != null) {
                    System.out.println("[" + tree.getStartPosition() + "," + tree.getEndPosition(module.endPositions) + "]  " + tree.toString());
                }
            }
        }.scan(module);
    }

    private List<JFXTree> pseudoVariables(JCDiagnostic.DiagnosticPosition diagPos, Name moduleClassName, JFXScript module, boolean usesFile, boolean usesDir) {
        ListBuffer pseudoDefs = ListBuffer.lb();
        if (usesFile || usesDir) {
            JFXIdent moduleClassFQN = module.pid != null ? this.fxmake.at(diagPos).Select(module.pid, moduleClassName) : this.fxmake.at(diagPos).Ident(moduleClassName);
            JFXExpression getFile = this.fxmake.at(diagPos).Identifier("com.sun.javafx.runtime.PseudoVariables.get__FILE__");
            JFXExpression forName = this.fxmake.at(diagPos).Identifier("java.lang.Class.forName");
            List<JFXExpression> args = List.of(this.fxmake.at(diagPos).Literal(moduleClassFQN.toString()));
            JFXFunctionInvocation loaderCall = this.fxmake.at(diagPos).Apply(List.<JFXExpression>nil(), forName, args);
            args = List.of(loaderCall);
            JFXFunctionInvocation getFileURL = this.fxmake.at(diagPos).Apply(List.<JFXExpression>nil(), getFile, args);
            JFXVar fileVar = this.fxmake.at(diagPos).Var(this.pseudoFile, this.getPseudoVarType(diagPos), this.fxmake.at(diagPos).Modifiers(70368744177688L), getFileURL, JavafxBindStatus.UNBOUND, null);
            pseudoDefs.append(fileVar);
            if (usesDir) {
                JFXExpression getDir = this.fxmake.at(diagPos).Identifier("com.sun.javafx.runtime.PseudoVariables.get__DIR__");
                args = List.of(this.fxmake.at(diagPos).Ident(this.pseudoFile));
                JFXFunctionInvocation getDirURL = this.fxmake.at(diagPos).Apply(List.<JFXExpression>nil(), getDir, args);
                pseudoDefs.append(this.fxmake.at(diagPos).Var(this.pseudoDir, this.getPseudoVarType(diagPos), this.fxmake.at(diagPos).Modifiers(70368744177688L), getDirURL, JavafxBindStatus.UNBOUND, null));
            }
        }
        return pseudoDefs.toList();
    }

    private JFXType getPseudoVarType(JCDiagnostic.DiagnosticPosition diagPos) {
        JFXExpression fqn = this.fxmake.at(diagPos).Identifier("java.lang.String");
        return this.fxmake.at(diagPos).TypeClass(fqn, TypeTree.Cardinality.SINGLETON);
    }

    private List<JFXVar> makeRunFunctionArgs(Name argName) {
        JFXVar mainArgs = this.fxmake.Param(argName, this.fxmake.TypeClass(this.fxmake.Ident(this.syms.stringTypeName), TypeTree.Cardinality.ANY));
        return List.of(mainArgs);
    }

    private JFXType makeRunFunctionType() {
        JFXExpression rettree = this.fxmake.Type(this.syms.objectType);
        rettree.type = this.syms.objectType;
        return this.fxmake.TypeClass(rettree, TypeTree.Cardinality.SINGLETON);
    }

    private JFXFunctionDefinition makeInternalRunFunction(JFXScript module, Name argName, List<JFXExpression> stats, JFXExpression value) {
        JFXBlock body = this.fxmake.Block(module.getStartPosition(), stats, value);
        this.setEndPos(module, body, module);
        body.setGenType(SyntheticTree.SynthType.SYNTHETIC);
        JFXFunctionDefinition func = this.fxmake.at(module.getStartPosition()).FunctionDefinition(this.fxmake.Modifiers(70368744181769L), this.defs.internalRunFunctionName, this.makeRunFunctionType(), this.makeRunFunctionArgs(argName), body);
        this.setEndPos(module, func, module);
        func.setGenType(SyntheticTree.SynthType.SYNTHETIC);
        this.setEndPos(module, func.operation, body);
        return func;
    }

    private Name scriptName(JFXScript tree) {
        int i;
        String fileObjName = null;
        JavaFileObject fo = tree.getSourceFile();
        URI uri = fo.toUri();
        String path = uri.toString();
        fileObjName = path.substring(i = path.lastIndexOf(47) + 1);
        int lastDotIdx = fileObjName.lastIndexOf(46);
        if (lastDotIdx != -1) {
            fileObjName = fileObjName.substring(0, lastDotIdx);
        }
        return Name.fromString(this.names, fileObjName);
    }

    private void checkName(int pos, Name name) {
        if (this.reservedTopLevelNamesSet == null) {
            this.reservedTopLevelNamesSet = new HashSet<Name>();
            this.reservedTopLevelNamesSet.add(this.pseudoFile);
            this.reservedTopLevelNamesSet.add(this.pseudoDir);
        }
        if (this.reservedTopLevelNamesSet.contains(name)) {
            this.log.error(pos, "javafx.reserved.top.level.script.member", name.toString());
        }
    }

    private void checkForBadPositions(JFXScript testTree) {
        final Map<JCTree, Integer> endPositions = testTree.endPositions;
        new JavafxTreeScanner(){

            public void scan(JFXTree tree) {
                JFXModifiers mods;
                super.scan(tree);
                if (tree instanceof JFXModifiers && ((mods = (JFXModifiers)tree).getFlags().isEmpty() || (mods.flags & 0x1000L) != 0L)) {
                    return;
                }
                if (tree instanceof JFXTypeUnknown) {
                    return;
                }
                if (tree != null) {
                    String where;
                    if (tree.pos <= 0) {
                        where = tree.getClass().getSimpleName();
                        try {
                            where = where + ": " + tree.toString();
                        }
                        catch (Throwable exc) {
                            // empty catch block
                        }
                        System.err.println("Position of " + tree.pos + " in ---" + where);
                    }
                    if (tree.getEndPosition(endPositions) <= 0) {
                        where = tree.getClass().getSimpleName();
                        try {
                            where = where + ": " + tree.toString();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        System.err.println("End position of " + tree.getEndPosition(endPositions) + " in ---" + where);
                    }
                }
            }
        }.scan(testTree);
    }
}

