/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.javafx.api.JavafxBindStatus;
import com.sun.javafx.api.tree.Tree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.FunctionType;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxAnalyzeClass;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxDefs;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.comp.JavafxInitializationBuilder;
import com.sun.tools.javafx.comp.JavafxOptimizationStatistics;
import com.sun.tools.javafx.comp.JavafxToBound;
import com.sun.tools.javafx.comp.JavafxTranslationSupport;
import com.sun.tools.javafx.comp.JavafxTypeMorpher;
import com.sun.tools.javafx.tree.BlockExprJCBlockExpression;
import com.sun.tools.javafx.tree.JFXAssign;
import com.sun.tools.javafx.tree.JFXAssignOp;
import com.sun.tools.javafx.tree.JFXBinary;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXBreak;
import com.sun.tools.javafx.tree.JFXCatch;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXContinue;
import com.sun.tools.javafx.tree.JFXErroneous;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXForExpression;
import com.sun.tools.javafx.tree.JFXForExpressionInClause;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXFunctionValue;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXIfExpression;
import com.sun.tools.javafx.tree.JFXImport;
import com.sun.tools.javafx.tree.JFXIndexof;
import com.sun.tools.javafx.tree.JFXInitDefinition;
import com.sun.tools.javafx.tree.JFXInstanceOf;
import com.sun.tools.javafx.tree.JFXInstanciate;
import com.sun.tools.javafx.tree.JFXInterpolateValue;
import com.sun.tools.javafx.tree.JFXKeyFrameLiteral;
import com.sun.tools.javafx.tree.JFXLiteral;
import com.sun.tools.javafx.tree.JFXModifiers;
import com.sun.tools.javafx.tree.JFXObjectLiteralPart;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXParens;
import com.sun.tools.javafx.tree.JFXPostInitDefinition;
import com.sun.tools.javafx.tree.JFXReturn;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXSequenceDelete;
import com.sun.tools.javafx.tree.JFXSequenceEmpty;
import com.sun.tools.javafx.tree.JFXSequenceExplicit;
import com.sun.tools.javafx.tree.JFXSequenceIndexed;
import com.sun.tools.javafx.tree.JFXSequenceInsert;
import com.sun.tools.javafx.tree.JFXSequenceRange;
import com.sun.tools.javafx.tree.JFXSequenceSlice;
import com.sun.tools.javafx.tree.JFXSkip;
import com.sun.tools.javafx.tree.JFXStringExpression;
import com.sun.tools.javafx.tree.JFXThrow;
import com.sun.tools.javafx.tree.JFXTimeLiteral;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXTry;
import com.sun.tools.javafx.tree.JFXTypeAny;
import com.sun.tools.javafx.tree.JFXTypeCast;
import com.sun.tools.javafx.tree.JFXTypeClass;
import com.sun.tools.javafx.tree.JFXTypeFunctional;
import com.sun.tools.javafx.tree.JFXTypeUnknown;
import com.sun.tools.javafx.tree.JFXUnary;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JFXVarScriptInit;
import com.sun.tools.javafx.tree.JFXWhileLoop;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import com.sun.tools.javafx.tree.JavafxTreeScanner;
import com.sun.tools.javafx.tree.JavafxVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxToJava
extends JavafxTranslationSupport
implements JavafxVisitor {
    protected static final Context.Key<JavafxToJava> jfxToJavaKey = new Context.Key();
    private final JavafxToBound toBound;
    private final JavafxInitializationBuilder initBuilder;
    private final JavafxOptimizationStatistics optStat;
    private ListBuffer<JCTree.JCStatement> prependToDefinitions = null;
    private ListBuffer<JCTree.JCStatement> prependToStatements = null;
    private ListBuffer<JCTree.JCExpression> additionalImports = null;
    private Map<Symbol, Name> substitutionMap = new HashMap<Symbol, Name>();
    Wrapped wrap = Wrapped.InNothing;
    Yield yield = Yield.ToExpression;
    protected JavafxEnv<JavafxAttrContext> attrEnv;
    private Target target;
    private static final String sequencesRangeString = "com.sun.javafx.runtime.sequence.Sequences.range";
    private static final String sequencesRangeExclusiveString = "com.sun.javafx.runtime.sequence.Sequences.rangeExclusive";
    private static final String sequenceBuilderString = "com.sun.javafx.runtime.sequence.SequenceBuilder";
    private static final String boundSequenceBuilderString = "com.sun.javafx.runtime.sequence.BoundSequenceBuilder";
    private static final String noMainExceptionString = "com.sun.javafx.runtime.NoMainException";
    private static final String toSequenceString = "toSequence";
    private static final String methodThrowsString = "java.lang.Throwable";
    private JFXClassDeclaration currentClass;
    Set<Symbol.ClassSymbol> hasOuters = new HashSet<Symbol.ClassSymbol>();
    private static final Pattern EXTENDED_FORMAT_PATTERN = Pattern.compile("%[<$0-9]*[tT][guwxGUVWXE]");

    public static JavafxToJava instance(Context context) {
        JavafxToJava instance = context.get(jfxToJavaKey);
        if (instance == null) {
            instance = new JavafxToJava(context);
        }
        return instance;
    }

    protected JavafxToJava(Context context) {
        super(context);
        context.put(jfxToJavaKey, this);
        this.toBound = JavafxToBound.instance(context);
        this.initBuilder = JavafxInitializationBuilder.instance(context);
        this.optStat = JavafxOptimizationStatistics.instance(context);
        this.target = Target.instance(context);
    }

    private <TFX extends JFXTree, TC extends JCTree> TC translateGeneric(TFX tree) {
        JCTree ret;
        Yield prevYield = this.yield;
        this.yield = Yield.ToExpression;
        if (tree == null) {
            ret = null;
        } else {
            JFXTree prevWhere = this.attrEnv.where;
            this.attrEnv.where = tree;
            tree.accept(this);
            this.attrEnv.where = prevWhere;
            ret = this.result;
            this.result = null;
        }
        this.yield = prevYield;
        return (TC)ret;
    }

    public JCTree.JCExpression translate(JFXExpression tree) {
        return (JCTree.JCExpression)this.translateGeneric(tree);
    }

    public JCTree.JCMethodDecl translate(JFXFunctionDefinition tree) {
        return (JCTree.JCMethodDecl)this.translateGeneric(tree);
    }

    public JCTree.JCVariableDecl translate(JFXVar tree) {
        return (JCTree.JCVariableDecl)this.translateGeneric(tree);
    }

    public JCTree.JCCompilationUnit translate(JFXScript tree) {
        return (JCTree.JCCompilationUnit)this.translateGeneric(tree);
    }

    public JCTree translate(JFXTree tree) {
        return this.translateGeneric(tree);
    }

    public JCTree.JCStatement translateClassDef(JFXClassDeclaration tree) {
        return (JCTree.JCStatement)this.translateGeneric(tree);
    }

    public JFXOnReplace translate(JFXOnReplace tree) {
        JFXOnReplace ret;
        Yield prevYield = this.yield;
        this.yield = Yield.ToExpression;
        if (tree == null) {
            ret = null;
        } else {
            JFXTree prevWhere = this.attrEnv.where;
            this.attrEnv.where = tree;
            tree.accept(this);
            this.attrEnv.where = prevWhere;
            ret = (JFXOnReplace)this.result;
            this.result = null;
        }
        this.yield = prevYield;
        return ret;
    }

    public JCTree.JCExpression translate(JFXExpression tree, Type type) {
        if (tree == null) {
            return null;
        }
        if (tree instanceof JFXBlock && this.yield == Yield.ToExpression) {
            this.visitBlockExpression((JFXBlock)tree, type);
            return (JCTree.JCExpression)this.result;
        }
        return this.convertTranslated(this.translate(tree), tree.pos(), tree.type, type);
    }

    public JCTree.JCExpression convertTranslated(JCTree.JCExpression translated, JCDiagnostic.DiagnosticPosition diagPos, Type sourceType, Type targetType) {
        boolean sourceIsSequence = this.types.isSequence(sourceType);
        boolean targetIsSequence = this.types.isSequence(targetType);
        if (sourceIsSequence && this.types.isArray(targetType)) {
            ListBuffer<JCTree.JCStatement> stats = ListBuffer.lb();
            Type elemType = this.types.elemtype(targetType);
            if (elemType.isPrimitive()) {
                String mname = "toArray";
                if (elemType == this.syms.floatType) {
                    mname = "toFloatArray";
                } else if (elemType == this.syms.doubleType) {
                    mname = "toDoubleArray";
                }
                return this.callExpression(diagPos, this.makeTypeTree(diagPos, this.syms.javafx_SequencesType, false), mname, (Object)translated);
            }
            JCTree.JCVariableDecl tmpVar = this.makeTmpVar(diagPos, sourceType, translated);
            stats.append(tmpVar);
            JCTree.JCVariableDecl sizeVar = this.makeTmpVar(diagPos, this.syms.intType, this.callExpression(diagPos, (JCTree.JCExpression)this.make.Ident(tmpVar.name), "size"));
            stats.append(sizeVar);
            JCTree.JCVariableDecl arrVar = this.makeTmpVar(diagPos, "arr", targetType, this.make.NewArray(this.makeTypeTree(diagPos, elemType, true), List.of(this.make.Ident(sizeVar.name)), null));
            stats.append(arrVar);
            stats.append(this.callStatement(diagPos, (JCTree.JCExpression)this.make.Ident(tmpVar.name), "toArray", List.of(this.make.Literal(4, 0), this.make.Ident(sizeVar.name), this.make.Ident(arrVar.name), new JCTree.JCExpression[]{this.make.Literal(4, 0)})));
            JCTree.JCIdent ident2 = this.make.Ident(arrVar.name);
            return this.makeBlockExpression(diagPos, stats, (JCTree.JCExpression)ident2);
        }
        if (this.types.isArray(sourceType) && targetIsSequence) {
            Type sourceElemType = this.types.elemtype(sourceType);
            List<JCTree.JCExpression> args = sourceElemType.isPrimitive() ? List.of(translated) : List.of(this.makeTypeInfo(diagPos, sourceElemType), translated);
            JCTree.JCExpression cSequences = this.makeTypeTree(diagPos, this.syms.javafx_SequencesType, false);
            return this.callExpression(diagPos, cSequences, "fromArray", args);
        }
        if (targetIsSequence && !sourceIsSequence) {
            Type targetElemType = this.types.elementType(targetType);
            JCTree.JCExpression cSequences = this.makeTypeTree(diagPos, this.syms.javafx_SequencesType, false);
            if (sourceType.isPrimitive()) {
                translated = this.convertTranslated(translated, diagPos, sourceType, targetElemType);
            }
            return this.callExpression(diagPos, cSequences, "singleton", List.of(this.makeTypeInfo(diagPos, targetElemType), translated));
        }
        if (targetIsSequence && sourceIsSequence) {
            Type sourceElemType = this.types.elementType(sourceType);
            Type targetElemType = this.types.elementType(targetType);
            if (this.types.isSameType(sourceElemType, this.syms.javafx_IntegerType) && this.types.isSameType(targetElemType, this.syms.javafx_NumberType)) {
                JCTree.JCExpression cSequences = this.makeTypeTree(diagPos, this.syms.javafx_SequencesType, false);
                return this.callExpression(diagPos, cSequences, "integerSequenceToNumberSequence", List.of(translated));
            }
        }
        if ((sourceType == this.syms.javafx_IntegerType || targetType == this.syms.javafx_IntegerType) && sourceType != targetType && sourceType != this.syms.unreachableType && targetType.isPrimitive()) {
            translated = this.make.at(diagPos).TypeCast(targetType, translated);
        }
        if (sourceType.isCompound()) {
            translated = this.make.at(diagPos).TypeCast(this.makeTypeTree(diagPos, this.types.erasure(targetType), true), translated);
        }
        return translated;
    }

    private <TFX extends JFXTree, TC extends JCTree> List<TC> translateGeneric(List<TFX> trees) {
        ListBuffer translated = ListBuffer.lb();
        if (trees == null) {
            return null;
        }
        List<Object> l = trees;
        while (l.nonEmpty()) {
            TC tree = this.translateGeneric((JFXTree)l.head);
            if (tree != null) {
                translated.append(tree);
            }
            l = l.tail;
        }
        return translated.toList();
    }

    public List<JCTree.JCExpression> translateExpressions(List<JFXExpression> trees) {
        return this.translateGeneric(trees);
    }

    public List<JCTree.JCCatch> translateCatchers(List<JFXCatch> trees) {
        return this.translateGeneric(trees);
    }

    public List<JCTree.JCExpression> translate(List<JFXExpression> trees, List<Type> types) {
        ListBuffer translated = ListBuffer.lb();
        if (trees == null) {
            return null;
        }
        List<Type> t = types;
        List<JFXExpression> l = trees;
        while (l.nonEmpty()) {
            JCTree.JCExpression tree = this.translate((JFXExpression)l.head, (Type)t.head);
            if (tree != null) {
                translated.append(tree);
            }
            l = l.tail;
            t = t.tail;
        }
        return translated.toList();
    }

    public JCTree.JCExpression translate(JFXExpression tree, Wrapped newState) {
        Wrapped prevWrap = this.wrap;
        this.wrap = newState;
        JCTree.JCExpression ret = this.translate(tree);
        this.wrap = prevWrap;
        return ret;
    }

    JCTree.JCBlock translateBlockExpressionToBlock(JFXBlock bexpr) {
        JCTree.JCStatement stmt = this.translateExpression(bexpr, Wrapped.InNothing, this.syms.voidType);
        return stmt == null ? null : this.asBlock(stmt);
    }

    JCTree.JCStatement translateExpressionToYield(JFXExpression expr) {
        assert (this.yield != Yield.ToExpression);
        if (expr == null) {
            return null;
        }
        JFXTree prevWhere = this.attrEnv.where;
        this.attrEnv.where = expr;
        expr.accept(this);
        this.attrEnv.where = prevWhere;
        JCTree ret = this.result;
        this.result = null;
        return ret instanceof JCTree.JCStatement ? (JCTree.JCStatement)ret : this.toCorrectReturn(expr, (JCTree.JCExpression)ret);
    }

    JCTree.JCStatement translateExpressionToReturn(JFXExpression expr) {
        Yield prevYield = this.yield;
        this.yield = Yield.ToReturnStatement;
        JCTree.JCStatement ret = this.translateExpressionToYield(expr);
        this.yield = prevYield;
        return ret;
    }

    JCTree.JCStatement translateExpressionToStatement(JFXExpression expr) {
        Yield prevYield = this.yield;
        this.yield = Yield.ToExecStatement;
        JCTree.JCStatement ret = this.translateExpressionToYield(expr);
        this.yield = prevYield;
        return ret;
    }

    JCTree.JCStatement translateExpression(JFXExpression expr, Wrapped newState, Type targetType) {
        JCTree.JCStatement ret;
        Wrapped prevWrap = this.wrap;
        Yield prevYield = this.yield;
        this.wrap = newState;
        if (targetType == this.syms.voidType || targetType == expr.type || targetType == null || expr.type == this.syms.unreachableType) {
            this.yield = targetType == this.syms.voidType ? Yield.ToExecStatement : Yield.ToReturnStatement;
            ret = this.translateExpressionToYield(expr);
        } else {
            this.yield = Yield.ToExpression;
            ret = this.make.at(expr).Return(this.translate(expr, targetType));
        }
        this.yield = prevYield;
        this.wrap = prevWrap;
        return ret;
    }

    JCTree.JCStatement translateExpression(JFXExpression expr, Type targetType) {
        return this.translateExpression(expr, this.wrap, targetType);
    }

    private JCTree.JCExpression straightConvert(JFXExpression tree) {
        if (tree == null) {
            return null;
        }
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        switch (tree.getFXTag()) {
            case IDENT: {
                JFXIdent id = (JFXIdent)tree;
                return this.make.at(diagPos).Ident(id.name);
            }
            case SELECT: {
                JFXSelect sel = (JFXSelect)tree;
                return this.make.at(diagPos).Select(this.straightConvert(sel.getExpression()), sel.getIdentifier());
            }
        }
        throw new RuntimeException("bad conversion");
    }

    JCTree.JCBlock asBlock(JCTree.JCStatement stmt) {
        if (stmt.getTag() == 7) {
            return (JCTree.JCBlock)stmt;
        }
        return this.make.at(stmt).Block(0L, List.of(stmt));
    }

    JCTree.JCStatement toCorrectReturn(JFXExpression expr, JCTree.JCExpression translated) {
        switch (this.yield) {
            case ToExecStatement: {
                return this.make.at(expr).Exec(translated);
            }
            case ToReturnStatement: {
                return this.make.at(expr).Return(translated);
            }
        }
        assert (false) : "this method should not be called";
        return null;
    }

    private boolean substitute(Symbol sym) {
        if (this.wrap == Wrapped.InLocation) {
            return false;
        }
        Name name = this.substitutionMap.get(sym);
        if (name == null) {
            return false;
        }
        this.result = this.make.Ident(name);
        return true;
    }

    private void setSubstitution(JFXTree target, Symbol sym) {
        if (target instanceof JFXInstanciate) {
            ((JFXInstanciate)target).varDefinedByThis = sym;
        }
    }

    public void toJava(JavafxEnv<JavafxAttrContext> attrEnv) {
        this.attrEnv = attrEnv;
        attrEnv.translatedToplevel = this.translate(attrEnv.toplevel);
        attrEnv.translatedToplevel.endPositions = attrEnv.toplevel.endPositions;
    }

    @Override
    public void visitScript(JFXScript tree) {
        this.fillClassesWithOuters(tree);
        ListBuffer translatedDefinitions = ListBuffer.lb();
        ListBuffer<JCTree.JCStatement> imports = ListBuffer.lb();
        this.additionalImports = ListBuffer.lb();
        this.prependToDefinitions = ListBuffer.lb();
        this.prependToStatements = this.prependToDefinitions;
        for (JFXTree jFXTree : tree.defs) {
            if (jFXTree.getFXTag() == JavafxTag.IMPORT) continue;
            translatedDefinitions.append(this.translate(jFXTree));
        }
        for (JCTree.JCStatement jCStatement : this.prependToDefinitions) {
            translatedDefinitions.prepend(jCStatement);
        }
        for (JCTree jCTree : imports) {
            translatedDefinitions.prepend(jCTree);
        }
        for (JCTree.JCExpression jCExpression : this.additionalImports) {
            translatedDefinitions.append(this.make.Import(jCExpression, false));
        }
        this.prependToDefinitions = null;
        this.prependToStatements = null;
        JCTree.JCExpression pid = this.straightConvert(tree.pid);
        JCTree.JCCompilationUnit jCCompilationUnit = this.make.at(tree.pos).TopLevel(List.<JCTree.JCAnnotation>nil(), pid, translatedDefinitions.toList());
        jCCompilationUnit.sourcefile = tree.sourcefile;
        jCCompilationUnit.docComments = null;
        jCCompilationUnit.lineMap = tree.lineMap;
        jCCompilationUnit.flags = tree.flags;
        this.result = jCCompilationUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDeclaration(JFXClassDeclaration tree) {
        JFXClassDeclaration prevClass = this.currentClass;
        JFXClassDeclaration prevEnclClass = this.attrEnv.enclClass;
        Wrapped prevWrap = this.wrap;
        this.wrap = Wrapped.InNothing;
        this.currentClass = tree;
        try {
            List<Object> args1;
            String className;
            Symbol.ClassSymbol cSym;
            Symbol symbol;
            boolean classIsFinal;
            JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
            this.attrEnv.enclClass = tree;
            ListBuffer<JCTree.JCStatement> translatedInitBlocks = ListBuffer.lb();
            ListBuffer<JCTree.JCStatement> translatedPostInitBlocks = ListBuffer.lb();
            ListBuffer translatedDefs = ListBuffer.lb();
            ListBuffer attrInfo = ListBuffer.lb();
            ListBuffer overrideInfo = ListBuffer.lb();
            ListBuffer<JCTree.JCStatement> prevPrependToDefinitions = this.prependToDefinitions;
            ListBuffer<JCTree.JCStatement> prevPrependToStatements = this.prependToStatements;
            this.prependToDefinitions = ListBuffer.lb();
            this.prependToStatements = this.prependToDefinitions;
            block10: for (JFXTree def : tree.getMembers()) {
                switch (def.getFXTag()) {
                    case INIT_DEF: {
                        this.translateAndAppendStaticBlock(((JFXInitDefinition)def).getBody(), translatedInitBlocks);
                        continue block10;
                    }
                    case POSTINIT_DEF: {
                        this.translateAndAppendStaticBlock(((JFXPostInitDefinition)def).getBody(), translatedPostInitBlocks);
                        continue block10;
                    }
                    case VAR_DEF: {
                        JFXVar attrDef = (JFXVar)def;
                        boolean isStatic = (attrDef.getModifiers().flags & 8L) != 0L;
                        JCTree.JCStatement init = this.translateDefinitionalAssignmentToSet(attrDef.pos(), attrDef.getInitializer(), attrDef.getBindStatus(), attrDef.sym, isStatic ? null : this.defs.receiverName, 0);
                        attrInfo.append(new JavafxAnalyzeClass.TranslatedVarInfo(attrDef, this.typeMorpher.varMorphInfo(attrDef.sym), init, attrDef.getOnReplace(), this.translatedOnReplaceBody(attrDef.getOnReplace())));
                        continue block10;
                    }
                    case OVERRIDE_ATTRIBUTE_DEF: {
                        boolean isStatic;
                        JFXOverrideClassVar override = (JFXOverrideClassVar)def;
                        boolean bl = isStatic = (override.sym.flags() & 8L) != 0L;
                        JCTree.JCStatement init = override.getInitializer() == null ? null : this.translateDefinitionalAssignmentToSet(override.pos(), override.getInitializer(), override.getBindStatus(), override.sym, isStatic ? null : this.defs.receiverName, 0);
                        overrideInfo.append(new JavafxAnalyzeClass.TranslatedOverrideClassVarInfo(override, this.typeMorpher.varMorphInfo(override.sym), init, override.getOnReplace(), this.translatedOnReplaceBody(override.getOnReplace())));
                        continue block10;
                    }
                    case FUNCTION_DEF: {
                        JFXFunctionDefinition funcDef = (JFXFunctionDefinition)def;
                        translatedDefs.append(this.translate(funcDef));
                        continue block10;
                    }
                }
                JCTree tdef = this.translate(def);
                if (tdef == null) continue;
                translatedDefs.append(tdef);
            }
            for (JCTree.JCStatement prepend : this.prependToDefinitions) {
                translatedDefs.prepend(prepend);
            }
            this.prependToDefinitions = prevPrependToDefinitions;
            this.prependToStatements = prevPrependToStatements;
            boolean classOnly = tree.generateClassOnly();
            JavafxInitializationBuilder.JavafxClassModel model = this.initBuilder.createJFXClassModel(tree, attrInfo.toList(), overrideInfo.toList());
            this.additionalImports.appendList(model.additionalImports);
            boolean bl = classIsFinal = (tree.getModifiers().flags & 0x10L) != 0L;
            if (!tree.hasBeenTranslated) {
                if (!classOnly) {
                    JCTree.JCModifiers mods = this.make.Modifiers(513L);
                    mods = this.addAccessAnnotationModifiers(diagPos, tree.mods.flags, mods);
                    JCTree.JCClassDecl cInterface = this.make.ClassDef(mods, model.interfaceName, List.<JCTree.JCTypeParameter>nil(), null, model.interfaces, model.iDefinitions);
                    this.prependToDefinitions.append(cInterface);
                }
                tree.hasBeenTranslated = true;
            }
            translatedDefs.appendList(model.additionalClassMembers);
            List<JCTree.JCVariableDecl> receiverVarDeclList = List.of(this.makeReceiverParam(tree));
            ListBuffer<Object> initStats = ListBuffer.lb();
            HashSet<String> dupSet = new HashSet<String>();
            for (JFXExpression parent : tree.getExtending()) {
                if (!(parent instanceof JFXIdent) || !this.types.isJFXClass(symbol = this.expressionSymbol(parent))) continue;
                cSym = (Symbol.ClassSymbol)symbol;
                className = cSym.fullname.toString();
                if (className.endsWith("$Intf")) {
                    className = className.substring(0, className.length() - "$Intf".length());
                }
                if (dupSet.contains(className)) continue;
                dupSet.add(className);
                args1 = List.nil();
                args1 = args1.append(this.make.TypeCast(this.makeTypeTree(diagPos, cSym.type, true), (JCTree.JCExpression)this.make.Ident(this.defs.receiverName)));
                initStats = initStats.append(this.callStatement(tree.pos(), this.makeIdentifier(diagPos, className), this.defs.userInitName, args1));
            }
            initStats.appendList(translatedInitBlocks);
            JCTree.JCBlock userInitBlock = this.make.Block(0L, initStats.toList());
            translatedDefs.append(this.make.MethodDef(this.make.Modifiers(classIsFinal ? 1L : 9L), this.defs.userInitName, this.makeTypeTree(null, this.syms.voidType), List.<JCTree.JCTypeParameter>nil(), receiverVarDeclList, List.<JCTree.JCExpression>nil(), userInitBlock, null));
            receiverVarDeclList = List.of(this.makeReceiverParam(tree));
            initStats = ListBuffer.lb();
            dupSet = new HashSet();
            for (JFXExpression parent : tree.getExtending()) {
                if (!(parent instanceof JFXIdent) || !this.types.isJFXClass(symbol = this.expressionSymbol(parent))) continue;
                cSym = (Symbol.ClassSymbol)symbol;
                className = cSym.fullname.toString();
                if (className.endsWith("$Intf")) {
                    className = className.substring(0, className.length() - "$Intf".length());
                }
                if (dupSet.contains(className)) continue;
                dupSet.add(className);
                args1 = List.nil();
                args1 = args1.append(this.make.TypeCast(this.makeTypeTree(diagPos, cSym.type, true), (JCTree.JCExpression)this.make.Ident(this.defs.receiverName)));
                initStats = initStats.append(this.callStatement(tree.pos(), this.makeIdentifier(diagPos, className), this.defs.postInitName, args1));
            }
            initStats.appendList(translatedPostInitBlocks);
            JCTree.JCBlock postInitBlock = this.make.Block(0L, initStats.toList());
            translatedDefs.append(this.make.MethodDef(this.make.Modifiers(classIsFinal ? 1L : 9L), this.defs.postInitName, this.makeTypeTree(null, this.syms.voidType), List.<JCTree.JCTypeParameter>nil(), receiverVarDeclList, List.<JCTree.JCExpression>nil(), postInitBlock, null));
            if (tree.isModuleClass) {
                translatedDefs.append(this.makeMainMethod(diagPos, tree.getName()));
            }
            List<JCTree.JCExpression> implementing = classOnly ? model.interfaces : List.of(this.make.Ident(model.interfaceName), this.makeIdentifier(diagPos, "com.sun.javafx.runtime.FXObject"));
            long flags = tree.mods.flags & 0x417L;
            if (tree.sym.owner.kind == 2) {
                flags |= 8L;
            }
            JCTree.JCModifiers classMods = this.make.at(diagPos).Modifiers(flags);
            classMods = this.addAccessAnnotationModifiers(diagPos, tree.mods.flags, classMods);
            JCTree.JCClassDecl res = this.make.at(diagPos).ClassDef(classMods, tree.getName(), List.<JCTree.JCTypeParameter>nil(), model.superType == null ? null : this.makeTypeTree(null, model.superType, false), implementing, translatedDefs.toList());
            res.sym = tree.sym;
            res.type = tree.type;
            this.result = res;
        }
        finally {
            this.attrEnv.enclClass = prevEnclClass;
            this.wrap = prevWrap;
            this.currentClass = prevClass;
        }
    }

    private void translateAndAppendStaticBlock(JFXBlock block, ListBuffer<JCTree.JCStatement> translatedBlocks) {
        JCTree.JCStatement stmt = this.translateExpressionToStatement(block);
        if (stmt != null) {
            translatedBlocks.append(stmt);
        }
    }

    @Override
    public void visitInitDefinition(JFXInitDefinition tree) {
        assert (false) : "should be processed by class tree";
    }

    @Override
    public void visitPostInitDefinition(JFXPostInitDefinition tree) {
        assert (false) : "should be processed by class tree";
    }

    @Override
    public void visitInstanciate(JFXInstanciate tree) {
        ListBuffer<JCTree.JCStatement> prevPrependToStatements = this.prependToStatements;
        this.prependToStatements = ListBuffer.lb();
        this.result = new InstanciateTranslator(tree, this){

            protected void processLocalVar(JFXVar var) {
                this.stats.append(JavafxToJava.this.translateExpressionToStatement(var));
            }

            protected JCTree.JCStatement translateAttributeSet(JFXExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName) {
                return this.toJava.translateDefinitionalAssignmentToSet(this.diagPos, init, bindStatus, vsym, instanceName, 1);
            }
        }.doit();
        if (this.result instanceof BlockExprJCBlockExpression) {
            BlockExprJCBlockExpression blockExpr = (BlockExprJCBlockExpression)this.result;
            blockExpr.stats = blockExpr.getStatements().prependList(this.prependToStatements.toList());
        }
        this.prependToStatements = prevPrependToStatements;
    }

    @Override
    public void visitStringExpression(JFXStringExpression tree) {
        this.result = new StringExpressionTranslator(tree, this){

            protected JCTree.JCExpression translateArg(JFXExpression arg) {
                return JavafxToJava.this.translate(arg);
            }
        }.doit();
    }

    private JCTree.JCExpression translateDefinitionalAssignmentToValueArg(JCDiagnostic.DiagnosticPosition diagPos, JFXExpression init, JavafxBindStatus bindStatus, JavafxTypeMorpher.VarMorphInfo vmi) {
        if (bindStatus.isUnidiBind()) {
            return this.toBound.translate(init, vmi.getRealType());
        }
        if (bindStatus.isBidiBind()) {
            assert (this.requiresLocation(vmi));
            return this.translate(init, Wrapped.InLocation);
        }
        if (init == null) {
            return this.makeDefaultValue(diagPos, vmi);
        }
        return this.translate(init, vmi.getSymbol().type);
    }

    private JCTree.JCExpression translateDefinitionalAssignmentToValue(JCDiagnostic.DiagnosticPosition diagPos, JFXExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym) {
        JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(vsym);
        JCTree.JCExpression valueArg = this.translateDefinitionalAssignmentToValueArg(diagPos, init, bindStatus, vmi);
        if (bindStatus.isUnidiBind()) {
            return valueArg;
        }
        if (this.requiresLocation(vmi)) {
            Name makeName = this.defs.makeMethodName;
            if (bindStatus.isBidiBind()) {
                makeName = this.defs.makeBijectiveMethodName;
            }
            return this.makeLocationVariable(vmi, diagPos, List.of(valueArg), makeName);
        }
        return valueArg;
    }

    private JCTree.JCStatement translateDefinitionalAssignmentToSet(JCDiagnostic.DiagnosticPosition diagPos, JFXExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName, int milieu) {
        if (init == null && vsym.owner.kind == 2 && this.requiresLocation(vsym)) {
            assert (!bindStatus.isBound()) : "cannot be bound and have no init expression";
            JCTree.JCExpression localAttr = this.makeAttributeAccess(diagPos, vsym, instanceName);
            Name methName = this.defs.setDefaultMethodName;
            return this.callStatement(diagPos, localAttr, methName);
        }
        return this.make.at(diagPos).Exec(this.translateDefinitionalAssignmentToSetExpression(diagPos, init, bindStatus, vsym, instanceName, milieu));
    }

    private JCTree.JCExpression translateDefinitionalAssignmentToSetExpression(JCDiagnostic.DiagnosticPosition diagPos, JFXExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName, int milieu) {
        assert ((vsym.flags() & 0x200000000L) == 0L) : "Parameters are not initialized";
        this.setSubstitution(init, vsym);
        JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(vsym);
        JCTree.JCExpression valueArg = this.translateDefinitionalAssignmentToValueArg(diagPos, init, bindStatus, vmi);
        return this.definitionalAssignmentToSetExpression(diagPos, valueArg, bindStatus, vsym, instanceName, vmi.getTypeKind(), milieu);
    }

    /*
     * Enabled aggressive block sorting
     */
    JCTree.JCExpression definitionalAssignmentToSetExpression(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression valueArg, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName, int typeKind, int milieu) {
        Name methName;
        if (!this.requiresLocation(vsym)) {
            JCTree.JCIdent varRef;
            if (vsym.owner.kind == 2) {
                if (instanceName == null) {
                    varRef = this.make.at(diagPos).Ident(this.attributeFieldName(vsym));
                    return this.make.at(diagPos).Assign(varRef, valueArg);
                }
                JCTree.JCIdent tc = this.make.at(diagPos).Ident(instanceName);
                Name setter = this.attributeSetterName(vsym);
                JCTree.JCFieldAccess toApply = this.make.at(diagPos).Select((JCTree.JCExpression)tc, setter);
                return this.make.at(diagPos).Apply(null, toApply, List.of(valueArg));
            }
            assert (instanceName == null);
            varRef = this.make.at(diagPos).Ident(vsym);
            return this.make.at(diagPos).Assign(varRef, valueArg);
        }
        JCTree.JCExpression varRef = vsym.owner.kind == 2 ? this.makeAttributeAccess(diagPos, vsym, instanceName) : this.make.at(diagPos).Ident(vsym);
        if (bindStatus.isUnidiBind()) {
            methName = this.defs.locationBindMilieuMethodName[milieu];
            return this.callExpression(diagPos, varRef, methName, (Object)valueArg);
        }
        if (bindStatus.isBidiBind()) {
            methName = this.defs.locationBijectiveBindMilieuMethodName[milieu];
            return this.callExpression(diagPos, varRef, methName, (Object)valueArg);
        }
        methName = this.defs.locationSetMilieuMethodName[typeKind][milieu];
        return this.callExpression(diagPos, varRef, methName, (Object)valueArg);
    }

    @Override
    public void visitVarScriptInit(JFXVarScriptInit tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXModifiers mods = tree.getModifiers();
        long modFlags = mods.flags | 0x10L;
        Symbol.VarSymbol vsym = tree.getSymbol();
        JFXVar var = tree.getVar();
        assert (vsym.owner.kind == 2) : "this should just be for script-level variables";
        assert ((modFlags & 8L) != 0L);
        assert ((modFlags & 0x400000000000L) != 0L);
        assert (!this.attrEnv.toplevel.isLibrary);
        this.result = this.translateDefinitionalAssignmentToSetExpression(diagPos, var.init, var.getBindStatus(), vsym, null, 0);
    }

    @Override
    public void visitVar(JFXVar tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXModifiers mods = tree.getModifiers();
        Symbol.VarSymbol vsym = tree.getSymbol();
        JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(vsym);
        assert (vsym.owner.kind != 2) : "attributes are processed in the class and should never come here";
        long flags = vsym.flags();
        boolean requiresLocation = this.requiresLocation(vsym);
        boolean isParameter = (flags & 0x200000000L) != 0L;
        boolean hasInnerAccess = (flags & 0x40000000000000L) != 0L;
        long modFlags = mods.flags & 0xFFFFFFFFFFFFFFEFL | (hasInnerAccess | requiresLocation ? 16L : 0L);
        JCTree.JCModifiers tmods = this.make.at(diagPos).Modifiers(modFlags);
        Type type = requiresLocation ? (isParameter ? vmi.getLocationType() : vmi.getVariableType()) : tree.type;
        JCTree.JCExpression typeExpression = this.makeTypeTree(diagPos, type, true);
        if (isParameter) {
            JCTree.JCExpression init = null;
            this.result = this.make.at(diagPos).VarDef(tmods, tree.name, typeExpression, init);
        } else {
            JCTree.JCExpression init;
            if (requiresLocation) {
                this.optStat.recordLocalVar(vsym, tree.getBindStatus().isBound(), true);
                init = this.makeLocationAttributeVariable(vmi, diagPos);
            } else {
                this.optStat.recordLocalVar(vsym, tree.getBindStatus().isBound(), false);
                if ((modFlags & 0x10L) != 0L) {
                    JCTree.JCExpression init2 = this.translateDefinitionalAssignmentToValue(tree.pos(), tree.init, tree.getBindStatus(), vsym);
                    this.result = this.make.at(diagPos).VarDef(tmods, tree.name, typeExpression, init2);
                    return;
                }
                init = this.makeDefaultValue(diagPos, vmi);
            }
            this.prependToStatements.append(this.make.at(-1).VarDef(tmods, tree.name, typeExpression, init));
            JFXOnReplace onReplace = tree.getOnReplace();
            if (onReplace != null) {
                JavafxAnalyzeClass.TranslatedVarInfo varInfo = new JavafxAnalyzeClass.TranslatedVarInfo(tree, vmi, null, tree.getOnReplace(), this.translatedOnReplaceBody(tree.getOnReplace()));
                JCTree.JCStatement changeListener = this.initBuilder.makeChangeListenerCall(varInfo);
                this.prependToStatements.append(changeListener);
            }
            this.result = this.translateDefinitionalAssignmentToSetExpression(diagPos, tree.init, tree.getBindStatus(), tree.sym, null, 0);
        }
    }

    @Override
    public void visitOverrideClassVar(JFXOverrideClassVar tree) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitOnReplace(JFXOnReplace tree) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitFunctionValue(JFXFunctionValue tree) {
        JFXFunctionDefinition def = tree.definition;
        this.result = this.makeFunctionValue(this.make.Ident(this.defs.lambdaName), def, tree.pos(), (Type.MethodType)def.type);
    }

    JCTree.JCExpression makeFunctionValue(JCTree.JCExpression meth, JFXFunctionDefinition def, JCDiagnostic.DiagnosticPosition diagPos, Type.MethodType mtype) {
        List<JCTree.JCStatement> stats;
        ListBuffer<JCTree.JCMethodDecl> members = new ListBuffer<JCTree.JCMethodDecl>();
        if (def != null) {
            members.append(this.translate(def));
        }
        JCTree.JCExpression encl = null;
        int nargs = mtype.argtypes.size();
        Type ftype = this.syms.javafx_FunctionTypes[nargs];
        JCTree.JCExpression t = this.makeQualifiedTree(null, ftype.tsym.getQualifiedName().toString());
        ListBuffer<JCTree.JCExpression> typeargs = new ListBuffer<JCTree.JCExpression>();
        Type rtype = this.syms.boxIfNeeded(mtype.restype);
        typeargs.append(this.makeTypeTree(diagPos, rtype));
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        ListBuffer<JCTree.JCIdent> margs = new ListBuffer<JCTree.JCIdent>();
        int i = 0;
        List<Type> l = mtype.argtypes;
        while (l.nonEmpty()) {
            Name pname = this.make.paramName(i++);
            Type ptype = this.syms.boxIfNeeded((Type)l.head);
            JCTree.JCVariableDecl param = this.make.VarDef(this.make.Modifiers(0L), pname, this.makeTypeTree(diagPos, ptype), null);
            params.append(param);
            JCTree.JCIdent marg = this.make.Ident(pname);
            margs.append(marg);
            typeargs.append(this.makeTypeTree(diagPos, ptype));
            l = l.tail;
        }
        long flags = 0x80000001L;
        JCTree.JCExpression call = this.make.Apply(null, meth, margs.toList());
        if (mtype.restype == this.syms.voidType) {
            stats = List.of(this.make.Exec(call), this.make.Return(this.make.Literal(17, null)));
        } else {
            if (mtype.restype.isPrimitive()) {
                call = this.makeBox(diagPos, call, mtype.restype);
            }
            stats = List.of(this.make.Return(call));
        }
        JCTree.JCMethodDecl bridgeDef = this.make.at(diagPos).MethodDef(this.make.Modifiers(flags), this.defs.invokeName, this.makeTypeTree(diagPos, rtype), List.<JCTree.JCTypeParameter>nil(), params.toList(), this.make.at(diagPos).Types((List<Type>)mtype.getThrownTypes()), this.make.Block(0L, stats), null);
        members.append(bridgeDef);
        JCTree.JCClassDecl cl = this.make.AnonymousClassDef(this.make.Modifiers(0L), members.toList());
        List<JCTree.JCExpression> nilArgs = List.nil();
        return this.make.NewClass(encl, nilArgs, this.make.TypeApply(t, typeargs.toList()), nilArgs, cl);
    }

    boolean isInnerFunction(Symbol.MethodSymbol sym) {
        return sym.owner != null && sym.owner.kind != 2 && (sym.flags() & 0x1000L) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFunctionDefinition(JFXFunctionDefinition tree) {
        if (this.isInnerFunction(tree.sym)) {
            JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
            Type.MethodType mtype = (Type.MethodType)tree.type;
            JCTree.JCExpression typeExpression = this.makeTypeTree(diagPos, this.syms.makeFunctionType(mtype), true);
            JFXFunctionDefinition def = new JFXFunctionDefinition(this.fxmake.Modifiers(4096L), tree.name, tree.operation);
            def.type = mtype;
            def.sym = new Symbol.MethodSymbol(0L, def.name, mtype, tree.sym.owner.owner);
            JCTree.JCExpression init = this.makeFunctionValue(this.make.Ident(tree.name), def, tree.pos(), mtype);
            JCTree.JCModifiers mods = this.make.at(diagPos).Modifiers(16L);
            this.result = this.make.at(diagPos).VarDef(mods, tree.name, typeExpression, init);
            return;
        }
        boolean isBound = (tree.sym.flags() & 0x8000000000L) != 0L;
        Wrapped prevWrap = this.wrap;
        this.wrap = Wrapped.InNothing;
        try {
            JCTree.JCBlock body;
            long flags;
            boolean classOnly = this.currentClass.generateClassOnly();
            long originalFlags = flags = tree.mods.flags;
            flags &= 0xFFFFFFFFFFFFFFFBL;
            if ((tree.mods.flags & 2L) == 0L) {
                flags |= 1L;
            }
            if ((flags & 0x1400L) == 0L && !classOnly) {
                flags |= 8L;
            }
            JCTree.JCModifiers mods = this.make.Modifiers(flags &= 0xFFFFFFFFFFFFEFFFL);
            boolean isRunMethod = this.syms.isRunMethod(tree.sym);
            boolean isImplMethod = (originalFlags & 0x1408L) == 0L && !isRunMethod && !classOnly;
            JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
            Type.MethodType mtype = (Type.MethodType)tree.type;
            JFXBlock bexpr = tree.getBodyExpression();
            if (bexpr == null) {
                body = null;
            } else if (isBound) {
                JCTree.JCExpression expr = this.toBound.translate((JFXExpression)bexpr, this.typeMorpher.varMorphInfo(tree.sym));
                body = this.asBlock(this.make.at(diagPos).Return(expr));
            } else {
                body = isRunMethod ? this.makeRunMethodBody(bexpr) : this.asBlock(this.translateExpression(bexpr, mtype.getReturnType()));
            }
            ListBuffer params = ListBuffer.lb();
            if ((originalFlags & 0x1408L) == 0L) {
                if (classOnly) {
                    body.stats = body.stats.prepend(this.make.at(diagPos).VarDef(this.make.at(diagPos).Modifiers(16L), this.defs.receiverName, this.make.Ident(this.initBuilder.interfaceName(this.currentClass)), this.make.at(diagPos).Ident(this.names._this)));
                } else {
                    params.prepend(this.makeReceiverParam(this.currentClass));
                }
            }
            for (JFXVar fxVar : tree.getParams()) {
                JCTree.JCVariableDecl var = this.translate(fxVar);
                params.append(var);
            }
            mods = this.addAccessAnnotationModifiers(diagPos, tree.mods.flags, mods);
            this.result = this.make.at(diagPos).MethodDef(mods, this.functionName(tree.sym, isImplMethod, isBound), this.makeReturnTypeTree(diagPos, tree.sym, isBound), this.make.at(diagPos).TypeParams(mtype.getTypeArguments()), params.toList(), this.make.at(diagPos).Types((List<Type>)mtype.getThrownTypes()), body, null);
            ((JCTree.JCMethodDecl)this.result).sym = tree.sym;
            this.result.type = tree.type;
        }
        finally {
            this.wrap = prevWrap;
        }
    }

    @Override
    public void visitBlockExpression(JFXBlock tree) {
        this.visitBlockExpression(tree, tree.type);
    }

    public void visitBlockExpression(JFXBlock tree, Type pt) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        ListBuffer<JCTree.JCStatement> prevPrependToStatements = this.prependToStatements;
        this.prependToStatements = ListBuffer.lb();
        JFXExpression value = tree.value;
        ListBuffer translatedStmts = ListBuffer.lb();
        for (JFXExpression expr : tree.getStmts()) {
            JCTree.JCStatement stmt = this.translateExpressionToStatement(expr);
            if (stmt == null) continue;
            translatedStmts.append(stmt);
        }
        List<Object> localDefs = translatedStmts.toList();
        if (this.yield == Yield.ToExpression) {
            assert (tree.type != this.syms.voidType) : "void block expressions should be handled below";
            if (value.getFXTag() == JavafxTag.RETURN) {
                value = ((JFXReturn)value).getExpression();
            }
            JCTree.JCExpression tvalue = this.translate(value, pt);
            localDefs = this.prependToStatements.appendList(localDefs).toList();
            this.result = this.makeBlockExpression(tree.pos(), localDefs, tvalue);
        } else {
            JCTree.JCStatement stmt;
            this.prependToStatements.appendList(localDefs);
            if (value != null && (stmt = this.translateExpressionToYield(value)) != null) {
                this.prependToStatements.append(stmt);
            }
            this.result = (localDefs = this.prependToStatements.toList()).size() == 1 ? (JCTree.JCStatement)localDefs.head : this.make.at(diagPos).Block(0L, localDefs);
        }
        this.prependToStatements = prevPrependToStatements;
    }

    @Override
    public void visitAssign(JFXAssign tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        if (tree.lhs.getFXTag() == JavafxTag.SEQUENCE_SLICE) {
            JFXSequenceSlice si = (JFXSequenceSlice)tree.lhs;
            JCTree.JCExpression rhs = this.translate(tree.rhs, si.getSequence().type);
            JCTree.JCExpression seq = this.translate(si.getSequence(), Wrapped.InLocation);
            JCTree.JCExpression firstIndex = this.translate(si.getFirstIndex());
            JCTree.JCExpression lastIndex = this.makeSliceLastIndex(si);
            JCTree.JCFieldAccess select = this.make.Select(seq, this.defs.replaceSliceMethodName);
            List<JCTree.JCExpression> args = List.of(firstIndex, lastIndex, rhs);
            this.result = this.make.at(diagPos).Apply(null, select, args);
        } else {
            this.result = new AssignTranslator(diagPos, tree.lhs, tree.rhs){

                JCTree.JCExpression buildRHS(JCTree.JCExpression rhsTranslated) {
                    return rhsTranslated;
                }

                JCTree.JCExpression defaultFullExpression(JCTree.JCExpression lhsTranslated, JCTree.JCExpression rhsTranslated) {
                    return this.m().Assign(lhsTranslated, rhsTranslated);
                }
            }.doit();
        }
    }

    @Override
    public void visitAssignop(final JFXAssignOp tree) {
        this.result = new AssignTranslator(tree.pos(), tree.lhs, tree.rhs){
            boolean useDurationOperations;
            {
                super(x0, x1, x2);
                this.useDurationOperations = this.types.isSameType(this.lhs.type, this.syms.javafx_DurationType) || this.types.isSameType(tree.rhs.type, this.syms.javafx_DurationType);
            }

            JCTree.JCExpression buildRHS(JCTree.JCExpression rhsTranslated) {
                JCTree.JCExpression lhsTranslated = JavafxToJava.this.translate(tree.lhs);
                if (this.useDurationOperations) {
                    JCTree.JCExpression method = this.m().Select(lhsTranslated, tree.operator);
                    return this.m().Apply(null, method, List.of(rhsTranslated));
                }
                return this.m().Binary(this.getBinaryOp(), lhsTranslated, rhsTranslated);
            }

            JCTree.JCExpression defaultFullExpression(JCTree.JCExpression lhsTranslated, JCTree.JCExpression rhsTranslated) {
                return this.useDurationOperations ? this.m().Assign(lhsTranslated, this.buildRHS(rhsTranslated)) : this.m().Assignop(tree.getOperatorTag(), lhsTranslated, rhsTranslated);
            }

            private int getBinaryOp() {
                switch (tree.getFXTag()) {
                    case PLUS_ASG: {
                        return 69;
                    }
                    case MINUS_ASG: {
                        return 70;
                    }
                    case MUL_ASG: {
                        return 71;
                    }
                    case DIV_ASG: {
                        return 72;
                    }
                }
                assert (false) : "unexpected assign op kind";
                return 69;
            }
        }.doit();
    }

    @Override
    public void visitSelect(JFXSelect tree) {
        if (this.substitute(tree.sym)) {
            return;
        }
        this.result = new SelectTranslator(tree).doit();
    }

    @Override
    public void visitIdent(JFXIdent tree) {
        JCTree.JCExpression convert;
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        if (this.substitute(tree.sym)) {
            return;
        }
        if (tree.name == this.names._this) {
            JCTree.JCExpression rcvr = this.make.at(diagPos).Ident(this.defs.receiverName);
            if (this.wrap == Wrapped.InLocation) {
                rcvr = this.makeConstantLocation(diagPos, tree.type, rcvr);
            }
            this.result = rcvr;
            return;
        }
        if (tree.name == this.names._super) {
            if (this.types.isCompoundClass(tree.type.tsym)) {
                this.result = this.make.at(diagPos).Ident(tree.type.tsym.name);
            } else {
                JCTree.JCFieldAccess superSelect = this.make.at(diagPos).Select((JCTree.JCExpression)this.make.at(diagPos).Ident(this.defs.receiverName), tree.name);
                this.result = superSelect;
            }
            return;
        }
        int kind = tree.sym.kind;
        if (kind == 2) {
            this.result = this.makeTypeTree(diagPos, this.types.erasure(tree.sym.type), false);
            return;
        }
        boolean isStatic = tree.sym.isStatic();
        if (isStatic) {
            convert = this.make.at(diagPos).Select(this.makeTypeTree(diagPos, tree.sym.owner.type, false), tree.name);
        } else if ((kind == 4 || kind == 16) && tree.sym.owner.kind == 2) {
            JCTree.JCExpression mRec = this.makeReceiver(diagPos, tree.sym, this.attrEnv.enclClass.sym);
            convert = this.make.at(diagPos).Select(mRec, tree.name);
        } else {
            convert = this.make.at(diagPos).Ident(tree.name);
        }
        if (tree.type instanceof FunctionType && tree.sym.type instanceof Type.MethodType) {
            Type.MethodType mtype = (Type.MethodType)tree.sym.type;
            JFXFunctionDefinition def = null;
            this.result = this.makeFunctionValue(convert, def, tree.pos(), mtype);
            return;
        }
        this.result = this.convertVariableReference(diagPos, convert, tree.sym, this.wrap == Wrapped.InLocation);
    }

    @Override
    public void visitSequenceExplicit(JFXSequenceExplicit tree) {
        ListBuffer<JCTree.JCStatement> stmts = ListBuffer.lb();
        Type elemType = this.elementType(tree.type);
        UseSequenceBuilder builder = this.useSequenceBuilder(tree.pos(), elemType);
        stmts.append(builder.makeBuilderVar());
        for (JFXExpression item : tree.getItems()) {
            stmts.append(builder.makeAdd(item));
        }
        this.result = this.makeBlockExpression(tree.pos(), stmts, builder.makeToSequence());
    }

    @Override
    public void visitSequenceRange(JFXSequenceRange tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JCTree.JCExpression meth = this.makeQualifiedTree(diagPos, tree.isExclusive() ? sequencesRangeExclusiveString : sequencesRangeString);
        ListBuffer args = ListBuffer.lb();
        List<JCTree.JCExpression> typeArgs = List.nil();
        args.append(this.translate(tree.getLower()));
        args.append(this.translate(tree.getUpper()));
        if (tree.getStepOrNull() != null) {
            args.append(this.translate(tree.getStepOrNull()));
        }
        this.result = this.make.at(diagPos).Apply(typeArgs, meth, args.toList());
    }

    @Override
    public void visitSequenceEmpty(JFXSequenceEmpty tree) {
        if (this.types.isSequence(tree.type)) {
            Type elemType = this.elementType(tree.type);
            this.result = this.makeEmptySequenceCreator(tree.pos(), elemType);
        } else {
            this.result = this.make.at(tree.pos).Literal(17, null);
        }
    }

    @Override
    public void visitSequenceIndexed(JFXSequenceIndexed tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JCTree.JCExpression seq = this.translate(tree.getSequence(), Wrapped.InNothing);
        JCTree.JCExpression index = this.makeTypeCast(diagPos, this.syms.intType, tree.getIndex().type, this.translate(tree.getIndex()));
        JCTree.JCFieldAccess select = this.make.at(diagPos).Select(seq, this.defs.getMethodName);
        List<JCTree.JCExpression> args = List.of(index);
        this.result = this.make.at(diagPos).Apply(null, select, args);
    }

    @Override
    public void visitSequenceSlice(JFXSequenceSlice tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JCTree.JCExpression seq = this.translate(tree.getSequence(), Wrapped.InLocation);
        JCTree.JCExpression firstIndex = this.translate(tree.getFirstIndex(), this.syms.intType);
        JCTree.JCExpression lastIndex = this.makeSliceLastIndex(tree);
        JCTree.JCFieldAccess select = this.make.at(diagPos).Select(seq, this.defs.getSliceMethodName);
        List<JCTree.JCExpression> args = List.of(firstIndex, lastIndex);
        this.result = this.make.at(diagPos).Apply(null, select, args);
    }

    @Override
    public void visitSequenceInsert(JFXSequenceInsert tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JCTree.JCExpression seqLoc = this.translate(tree.getSequence(), Wrapped.InLocation);
        JCTree.JCExpression elem = this.translate(tree.getElement());
        if (this.types.isArray(tree.getElement().type)) {
            elem = this.convertTranslated(elem, diagPos, tree.getElement().type, tree.getSequence().type);
        }
        if (tree.getPosition() == null) {
            this.result = this.callStatement(diagPos, seqLoc, "insert", (Object)elem);
        } else {
            String meth = tree.shouldInsertAfter() ? "insertAfter" : "insertBefore";
            this.result = this.callStatement(diagPos, seqLoc, meth, List.of(elem, this.translate(tree.getPosition())));
        }
    }

    @Override
    public void visitSequenceDelete(JFXSequenceDelete tree) {
        JFXExpression seq = tree.getSequence();
        if (tree.getElement() != null) {
            JCTree.JCExpression seqLoc = this.translate(seq, Wrapped.InLocation);
            this.result = this.callStatement(tree.pos(), seqLoc, "deleteValue", (Object)this.translate(tree.getElement()));
        } else if (seq.getFXTag() == JavafxTag.SEQUENCE_INDEXED) {
            JFXSequenceIndexed si = (JFXSequenceIndexed)seq;
            JFXExpression seqseq = si.getSequence();
            JCTree.JCExpression seqLoc = this.translate(seqseq, Wrapped.InLocation);
            JCTree.JCExpression index = this.translate(si.getIndex());
            this.result = this.callStatement(tree.pos(), seqLoc, "delete", (Object)index);
        } else if (seq.getFXTag() == JavafxTag.SEQUENCE_SLICE) {
            JFXSequenceSlice slice = (JFXSequenceSlice)seq;
            JFXExpression seqseq = slice.getSequence();
            JCTree.JCExpression seqLoc = this.translate(seqseq, Wrapped.InLocation);
            JCTree.JCExpression first = this.translate(slice.getFirstIndex());
            JCTree.JCExpression last = this.makeSliceLastIndex(slice);
            this.result = this.callStatement(tree.pos(), seqLoc, "deleteSlice", List.of(first, last));
        } else if (this.types.isSequence(seq.type)) {
            JCTree.JCExpression seqLoc = this.translate(seq, Wrapped.InLocation);
            this.result = this.callStatement(tree.pos(), seqLoc, "deleteAll");
        } else {
            this.result = this.make.at(tree.pos()).Exec(this.make.Assign(this.translate(seq), this.make.Literal(17, null)));
        }
    }

    JCTree.JCExpression makeSliceLastIndex(JFXSequenceSlice tree) {
        JCTree.JCExpression lastIndex = tree.getLastIndex() == null ? this.callExpression((JCDiagnostic.DiagnosticPosition)tree, this.translate(tree.getSequence()), this.defs.sizeMethodName) : this.translate(tree.getLastIndex(), this.syms.intType);
        int decr = (tree.getEndKind() == 1 ? 1 : 0) + (tree.getLastIndex() == null ? 1 : 0);
        if (decr > 0) {
            lastIndex = this.make.at(tree).Binary(70, lastIndex, this.make.Literal(4, decr));
        }
        return lastIndex;
    }

    JCTree.JCMethodDecl makeMainMethod(JCDiagnostic.DiagnosticPosition diagPos, Name className) {
        List<JCTree.JCStatement> mainStats;
        if (!this.attrEnv.toplevel.isRunnable) {
            List<JCTree.JCExpression> newClassArgs = List.of(this.make.at(diagPos).Literal(10, className.toString()));
            mainStats = List.of(this.make.at(diagPos).Throw(this.make.at(diagPos).NewClass(null, null, this.makeIdentifier(diagPos, noMainExceptionString), newClassArgs, null)));
        } else {
            List<JCTree.JCExpression> emptyExpressionList = List.nil();
            JCTree.JCIdent classIdent = this.make.at(diagPos).Ident(className);
            JCTree.JCFieldAccess classConstant = this.make.at(diagPos).Select((JCTree.JCExpression)classIdent, this.names._class);
            JCTree.JCExpression commandLineArgs = this.makeIdentifier(diagPos, "args");
            JCTree.JCExpression startIdent = this.makeQualifiedTree(diagPos, "com.sun.javafx.runtime.Entry.start");
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            args.append(classConstant);
            args.append(commandLineArgs);
            JCTree.JCMethodInvocation runCall = this.make.at(diagPos).Apply(emptyExpressionList, startIdent, args.toList());
            mainStats = List.of(this.make.at(diagPos).Exec(runCall));
        }
        List<JCTree.JCVariableDecl> paramList = List.nil();
        paramList = paramList.append(this.make.at(diagPos).VarDef(this.make.Modifiers(0L), Name.fromString(this.names, "args"), this.make.at(diagPos).TypeArray(this.make.Ident(Name.fromString(this.names, "String"))), null));
        JCTree.JCBlock body = this.make.Block(0L, mainStats);
        return this.make.at(diagPos).MethodDef(this.make.Modifiers(9L), Name.fromString(this.names, "main"), this.make.at(diagPos).TypeIdent(9), List.<JCTree.JCTypeParameter>nil(), paramList, this.makeThrows(diagPos), body, null);
    }

    TreeMaker make_at(JCDiagnostic.DiagnosticPosition pos) {
        return this.make.at(pos);
    }

    private Symbol.MethodSymbol lookupMethod(JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return this.rs.resolveInternalMethod(pos, this.attrEnv, qual, name, args, null);
    }

    private Symbol.MethodSymbol lookupConstructor(JCDiagnostic.DiagnosticPosition pos, Type qual, List<Type> args) {
        return this.rs.resolveInternalConstructor(pos, this.attrEnv, qual, args, null);
    }

    JCTree.JCExpression makeBox(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression translatedExpr, Type primitiveType) {
        JCTree.JCExpression box;
        this.make_at(translatedExpr.pos());
        Type boxedType = this.types.boxedClass((Type)primitiveType).type;
        if (this.target.boxWithConstructors()) {
            Symbol.MethodSymbol ctor = this.lookupConstructor(translatedExpr.pos(), boxedType, List.nil().prepend(primitiveType));
            box = this.make.Create(ctor, List.of(translatedExpr));
        } else {
            Symbol.MethodSymbol valueOfSym = this.lookupMethod(translatedExpr.pos(), this.names.valueOf, boxedType, List.nil().prepend(primitiveType));
            JCTree.JCFieldAccess meth = this.make.Select(this.makeTypeTree(diagPos, valueOfSym.owner.type), valueOfSym.name);
            TreeInfo.setSymbol(meth, valueOfSym);
            meth.type = valueOfSym.type;
            box = this.make.App(meth, List.of(translatedExpr));
        }
        return box;
    }

    public List<JCTree.JCExpression> makeThrows(JCDiagnostic.DiagnosticPosition diagPos) {
        return List.of(this.makeQualifiedTree(diagPos, methodThrowsString));
    }

    UseSequenceBuilder useSequenceBuilder(JCDiagnostic.DiagnosticPosition diagPos, Type elemType) {
        return new UseSequenceBuilder(diagPos, elemType, sequenceBuilderString){

            JCTree.JCStatement makeAdd(JFXExpression exprToAdd) {
                JCTree.JCExpression expr = JavafxToJava.this.translate(exprToAdd);
                Type exprType = exprToAdd.type;
                return this.makeAdd(expr, exprType);
            }

            JCTree.JCExpression makeConstructorArg() {
                return JavafxToJava.this.makeTypeInfo(this.diagPos, this.elemType);
            }
        };
    }

    UseSequenceBuilder useBoundSequenceBuilder(JCDiagnostic.DiagnosticPosition diagPos, Type elemType) {
        return new UseSequenceBuilder(diagPos, elemType, boundSequenceBuilderString){

            JCTree.JCStatement makeAdd(JFXExpression exprToAdd) {
                JCTree.JCExpression expr = JavafxToJava.this.toBound.translate(exprToAdd);
                Type exprType = exprToAdd.type;
                return this.makeAdd(expr, exprType);
            }

            JCTree.JCExpression makeConstructorArg() {
                return JavafxToJava.this.makeElementClassObject(this.diagPos, this.elemType);
            }
        };
    }

    JCTree.JCExpression castFromObject(JCTree.JCExpression arg, Type castType) {
        if (castType.isPrimitive()) {
            castType = this.types.boxedClass((Type)castType).type;
        }
        return this.make.TypeCast(this.makeTypeTree(arg.pos(), castType), arg);
    }

    @Override
    public void visitBinary(final JFXBinary tree) {
        this.result = new Translator(tree.pos(), this){

            private JCTree.JCExpression makeNullCheck(JCTree.JCExpression targ) {
                return this.makeEqEq(targ, this.makeNull());
            }

            private JCTree.JCExpression makePrimitiveNullCheck(Type argType, JCTree.JCExpression arg) {
                JavafxTypeMorpher.TypeMorphInfo tmi = JavafxToJava.this.typeMorpher.typeMorphInfo(argType);
                JCTree.JCExpression defaultValue = JavafxToJava.this.makeLit(this.diagPos, tmi.getRealType(), tmi.getDefaultValue());
                return this.makeEqEq(arg, defaultValue);
            }

            private JCTree.JCExpression makeObjectNullCheck(Type argType, JCTree.JCExpression arg) {
                JavafxTypeMorpher.TypeMorphInfo tmi = JavafxToJava.this.typeMorpher.typeMorphInfo(argType);
                if (tmi.getTypeKind() == 4 || tmi.getRealType() == this.syms.javafx_StringType) {
                    return this.callRuntime("com.sun.javafx.runtime.Checks.isNull", List.of(arg));
                }
                return this.makeNullCheck(arg);
            }

            private JCTree.JCExpression makeEqEq(JCTree.JCExpression arg1, JCTree.JCExpression arg2) {
                return this.makeBinary(60, arg1, arg2);
            }

            private JCTree.JCExpression makeBinary(int tag, JCTree.JCExpression arg1, JCTree.JCExpression arg2) {
                return JavafxToJava.this.make.at(this.diagPos).Binary(tag, arg1, arg2);
            }

            private JCTree.JCExpression makeNull() {
                return JavafxToJava.this.make.at(this.diagPos).Literal(17, null);
            }

            private JCTree.JCExpression callRuntime(String methNameString, List<JCTree.JCExpression> args) {
                JCTree.JCExpression meth = JavafxToJava.this.makeQualifiedTree(this.diagPos, methNameString);
                List<JCTree.JCExpression> typeArgs = List.nil();
                return this.m().Apply(typeArgs, meth, args);
            }

            private JCTree.JCExpression makeFullCheck(JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
                return this.callRuntime("com.sun.javafx.runtime.Checks.equals", List.of(lhs, rhs));
            }

            private JCTree.JCExpression translateEqualsEquals() {
                JCTree.JCExpression lhs = JavafxToJava.this.translate(tree.lhs);
                JCTree.JCExpression rhs = JavafxToJava.this.translate(tree.rhs);
                Type lhsType = tree.lhs.type;
                Type rhsType = tree.rhs.type;
                if (lhsType.getKind() == TypeKind.NULL) {
                    if (rhsType.getKind() == TypeKind.NULL) {
                        return JavafxToJava.this.make.at(this.diagPos).Literal(8, 1);
                    }
                    if (rhsType.isPrimitive()) {
                        return this.makePrimitiveNullCheck(rhsType, rhs);
                    }
                    return this.makeObjectNullCheck(rhsType, rhs);
                }
                if (lhsType.isPrimitive()) {
                    if (rhsType.getKind() == TypeKind.NULL) {
                        return this.makePrimitiveNullCheck(lhsType, lhs);
                    }
                    if (rhsType.isPrimitive()) {
                        return this.makeEqEq(lhs, rhs);
                    }
                    return this.makeFullCheck(rhs, lhs);
                }
                if (rhsType.getKind() == TypeKind.NULL) {
                    return this.makeObjectNullCheck(lhsType, lhs);
                }
                return this.makeFullCheck(lhs, rhs);
            }

            @Override
            public JCTree doit() {
                if (tree.getFXTag() == JavafxTag.EQ) {
                    return this.translateEqualsEquals();
                }
                if (tree.getFXTag() == JavafxTag.NE) {
                    return JavafxToJava.this.make.at(this.diagPos).Unary(48, this.translateEqualsEquals());
                }
                if ((this.types.isSameType(tree.lhs.type, this.syms.javafx_DurationType) || this.types.isSameType(tree.rhs.type, this.syms.javafx_DurationType)) && tree.operator == null) {
                    JFXExpression l = tree.lhs;
                    JFXExpression r = tree.rhs;
                    switch (tree.getFXTag()) {
                        case PLUS: {
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "add")), List.of(JavafxToJava.this.translate(r)));
                        }
                        case MINUS: {
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "sub")), List.of(JavafxToJava.this.translate(r)));
                        }
                        case DIV: {
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "div")), List.of(JavafxToJava.this.translate(r)));
                        }
                        case MUL: {
                            if (!this.types.isSameType(l.type, this.syms.javafx_DurationType)) {
                                r = l;
                                l = tree.rhs;
                            }
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "mul")), List.of(JavafxToJava.this.translate(r)));
                        }
                        case LT: {
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "lt")), List.of(JavafxToJava.this.translate(r)));
                        }
                        case LE: {
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "le")), List.of(JavafxToJava.this.translate(r)));
                        }
                        case GT: {
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "gt")), List.of(JavafxToJava.this.translate(r)));
                        }
                        case GE: {
                            return JavafxToJava.this.make.at(this.diagPos).Apply(null, JavafxToJava.this.make.at(this.diagPos).Select(JavafxToJava.this.translate(l), Name.fromString(JavafxToJava.this.names, "ge")), List.of(JavafxToJava.this.translate(r)));
                        }
                    }
                }
                JCTree.JCExpression lhs = JavafxToJava.this.translate(tree.lhs);
                JCTree.JCExpression rhs = JavafxToJava.this.translate(tree.rhs);
                return this.makeBinary(tree.getOperatorTag(), lhs, rhs);
            }
        }.doit();
    }

    @Override
    public void visitBreak(JFXBreak tree) {
        this.result = this.make.at(tree.pos).Break(tree.label);
    }

    @Override
    public void visitCatch(JFXCatch tree) {
        JCTree.JCVariableDecl param = this.translate(tree.param);
        JCTree.JCBlock body = this.translateBlockExpressionToBlock(tree.body);
        this.result = this.make.at(tree.pos).Catch(param, body);
    }

    @Override
    public void visitForExpression(JFXForExpression tree) {
        if (this.yield == Yield.ToExecStatement) {
            this.result = this.wrapWithInClause(tree, this.translateExpressionToStatement(tree.getBodyExpression()));
        } else {
            assert (tree.type != this.syms.voidType) : "should be handled above";
            JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
            ListBuffer<JCTree.JCStatement> stmts = ListBuffer.lb();
            assert (tree.type.getTypeArguments().size() == 1);
            Type elemType = this.elementType(tree.type);
            UseSequenceBuilder builder = this.useSequenceBuilder(diagPos, elemType);
            stmts.append(builder.makeBuilderVar());
            JCTree.JCStatement stmt = builder.makeAdd(tree.getBodyExpression());
            JCTree.JCExpression value = builder.makeToSequence();
            stmt = this.wrapWithInClause(tree, stmt);
            stmts.append(stmt);
            if (this.yield == Yield.ToExpression) {
                this.result = this.makeBlockExpression(diagPos, stmts, value);
            } else {
                stmts.append(this.make.at(tree).Return(value));
                this.result = this.make.at(diagPos).Block(0L, stmts.toList());
            }
        }
    }

    private JCTree.JCStatement wrapWithInClause(JFXForExpression tree, JCTree.JCStatement coreStmt) {
        JCTree.JCStatement stmt = coreStmt;
        for (int inx = tree.getInClauses().size() - 1; inx >= 0; --inx) {
            Name tmpIndexVarName;
            JFXForExpressionInClause clause = (JFXForExpressionInClause)tree.getInClauses().get(inx);
            if (clause.getWhereExpression() != null) {
                stmt = this.make.at(clause).If(this.translate(clause.getWhereExpression()), stmt, null);
            }
            JFXVar var = clause.getVar();
            Name tmpVarName = this.getSyntheticName(var.getName().toString());
            JCTree.JCVariableDecl finalVar = this.make.VarDef(this.make.Modifiers(16L), var.getName(), this.makeTypeTree(var, var.type), this.make.Ident(tmpVarName));
            if (clause.getIndexUsed()) {
                Name indexVarName = this.indexVarName(clause);
                tmpIndexVarName = this.getSyntheticName(indexVarName.toString());
                JCTree.JCVariableDecl finalIndexVar = this.make.VarDef(this.make.Modifiers(16L), indexVarName, this.makeTypeTree(var, this.syms.javafx_IntegerType), this.make.Unary(52, this.make.Ident(tmpIndexVarName)));
                stmt = this.make.Block(0L, List.of(finalIndexVar, finalVar, stmt));
            } else {
                tmpIndexVarName = null;
                stmt = this.make.Block(0L, List.of(finalVar, stmt));
            }
            JFXExpression diagPos = clause.seqExpr;
            if (this.types.isSequence(clause.seqExpr.type)) {
                JCTree.JCMethodInvocation seq = this.callExpression((JCDiagnostic.DiagnosticPosition)diagPos, this.makeQualifiedTree(diagPos, "com.sun.javafx.runtime.sequence.Sequences"), "forceNonNull", List.of(this.makeElementClassObject(diagPos, var.type), this.translate(clause.seqExpr)));
                stmt = this.make.at(clause).ForeachLoop(this.make.VarDef(this.make.Modifiers(0L), tmpVarName, this.makeTypeTree(var, var.type, true), null), seq, stmt);
            } else if (this.types.asSuper(clause.seqExpr.type, this.syms.iterableType.tsym) != null) {
                stmt = this.make.at(clause).ForeachLoop(this.make.VarDef(this.make.Modifiers(0L), tmpVarName, this.makeTypeTree(var, var.type, true), null), this.translate(clause.seqExpr), stmt);
            } else {
                if (!var.type.isPrimitive()) {
                    stmt = this.make.If(this.make.Binary(61, this.make.Ident(tmpVarName), this.make.Literal(17, null)), stmt, null);
                }
                stmt = this.make.at(diagPos).Block(0L, List.of(this.make.at(diagPos).VarDef(this.make.Modifiers(0L), tmpVarName, this.makeTypeTree(var, var.type, true), this.translate(clause.seqExpr)), stmt));
            }
            if (!clause.getIndexUsed()) continue;
            JCTree.JCVariableDecl tmpIndexVar = this.make.VarDef(this.make.Modifiers(0L), tmpIndexVarName, this.makeTypeTree(var, this.syms.javafx_IntegerType), this.make.Literal(0));
            stmt = this.make.Block(0L, List.of(tmpIndexVar, stmt));
        }
        return stmt;
    }

    @Override
    public void visitIndexof(JFXIndexof tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        assert (tree.clause.getIndexUsed()) : "assert that index used is set correctly";
        JCTree.JCIdent transIndex = this.make.at(diagPos).Ident(this.indexVarName(tree.fname));
        Symbol.VarSymbol vsym = tree.clause.getVar().sym;
        this.result = this.requiresLocation(vsym) ? this.getLocationValue(diagPos, transIndex, 3) : transIndex;
    }

    @Override
    public void visitIfExpression(JFXIfExpression tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JCTree.JCExpression cond = this.translate(tree.getCondition());
        JFXExpression trueSide = tree.getTrueExpression();
        JFXExpression falseSide = tree.getFalseExpression();
        if (this.yield == Yield.ToExpression) {
            JCTree.JCExpression translatedFalseSide;
            if (falseSide == null) {
                Type trueSideType = tree.getTrueExpression().type;
                switch (trueSideType.tag) {
                    case 8: {
                        translatedFalseSide = this.make.at(diagPos).Literal(8, 0);
                        break;
                    }
                    case 4: {
                        translatedFalseSide = this.make.at(diagPos).Literal(4, 0);
                        break;
                    }
                    case 7: {
                        translatedFalseSide = this.make.at(diagPos).Literal(7, 0.0);
                        break;
                    }
                    case 17: {
                        translatedFalseSide = this.make.at(diagPos).Literal(17, null);
                        break;
                    }
                    case 9: {
                        assert (false) : "should have been translated";
                        translatedFalseSide = this.make.at(diagPos).Literal(17, null);
                        break;
                    }
                    case 10: {
                        if (trueSideType == this.syms.stringType) {
                            translatedFalseSide = this.make.at(diagPos).Literal(10, "");
                            break;
                        }
                        translatedFalseSide = this.make.at(diagPos).Literal(17, null);
                        break;
                    }
                    default: {
                        assert (false) : "what is this type doing here? " + trueSideType;
                        translatedFalseSide = this.make.at(diagPos).Literal(17, null);
                        break;
                    }
                }
            } else {
                translatedFalseSide = this.translate(falseSide);
            }
            JCTree.JCExpression translatedTrueSide = this.convertTranslated(this.translate(trueSide), trueSide, trueSide.type, tree.type);
            translatedFalseSide = falseSide != null ? this.convertTranslated(translatedFalseSide, falseSide, falseSide.type, tree.type) : this.convertTranslated(translatedFalseSide, null, trueSide.type, tree.type);
            this.result = this.make.at(diagPos).Conditional(cond, translatedTrueSide, translatedFalseSide);
        } else {
            this.result = this.make.at(diagPos).If(cond, this.translateExpressionToYield(trueSide), falseSide == null ? null : this.translateExpressionToYield(falseSide));
        }
    }

    @Override
    public void visitContinue(JFXContinue tree) {
        this.result = this.make.at(tree.pos).Continue(tree.label);
    }

    @Override
    public void visitErroneous(JFXErroneous tree) {
        List errs = this.translateGeneric((List)tree.getErrorTrees());
        this.result = this.make.at(tree.pos).Erroneous(errs);
    }

    @Override
    public void visitReturn(JFXReturn tree) {
        JFXExpression exp = tree.getExpression();
        this.result = exp == null ? this.make.at(tree).Return(null) : this.translateExpression(exp, tree.type);
    }

    @Override
    public void visitParens(JFXParens tree) {
        if (this.yield == Yield.ToExpression) {
            JCTree.JCExpression expr = this.translate(tree.expr);
            this.result = this.make.at(tree.pos).Parens(expr);
        } else {
            this.result = this.translateExpressionToYield(tree.expr);
        }
    }

    @Override
    public void visitImport(JFXImport tree) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitInstanceOf(JFXInstanceOf tree) {
        JCTree.JCExpression clazz = this.makeTypeTree(tree, tree.clazz.type);
        JCTree.JCExpression expr = this.translate(tree.expr);
        if (tree.expr.type.isPrimitive()) {
            expr = this.makeBox(tree.expr.pos(), expr, tree.expr.type);
        }
        if (this.types.isSequence(tree.expr.type) && !this.types.isSequence(tree.clazz.type)) {
            expr = this.callExpression((JCDiagnostic.DiagnosticPosition)tree.expr, this.makeQualifiedTree(tree.expr, "com.sun.javafx.runtime.sequence.Sequences"), "getSingleValue", (Object)expr);
        }
        this.result = this.make.at(tree.pos).TypeTest(expr, clazz);
    }

    @Override
    public void visitTypeCast(JFXTypeCast tree) {
        this.result = this.makeTypeCast(tree.pos(), tree.clazz.type, tree.expr.type, this.translate(tree.expr));
    }

    @Override
    public void visitLiteral(JFXLiteral tree) {
        if (tree.typetag == 17 && this.types.isSequence(tree.type)) {
            Type elemType = this.elementType(tree.type);
            this.result = this.makeEmptySequenceCreator(tree.pos(), elemType);
        } else {
            this.result = this.make.at(tree.pos).Literal(tree.typetag, tree.value);
        }
    }

    @Override
    public void visitFunctionInvocation(final JFXFunctionInvocation tree) {
        this.result = new FunctionCallTranslator(tree, this){
            private Name funcName;
            {
                super(x0, x1);
                this.funcName = null;
            }

            protected JCTree doit() {
                boolean knownNonNull;
                JFXExpression toCheckOrNull;
                if (this.useInvoke) {
                    toCheckOrNull = this.meth;
                    this.funcName = this.defs.invokeName;
                    knownNonNull = false;
                } else if (this.selector == null) {
                    if (this.meth.getFXTag() == JavafxTag.IDENT) {
                        JFXIdent fr = this.fxm().Ident(JavafxToJava.this.functionName(this.msym, this.superToStatic, this.callBound));
                        fr.type = this.meth.type;
                        fr.sym = this.msym;
                        toCheckOrNull = fr;
                        this.funcName = null;
                        knownNonNull = true;
                    } else {
                        assert (false) : this.meth;
                        toCheckOrNull = this.meth;
                        this.funcName = null;
                        knownNonNull = true;
                    }
                } else {
                    toCheckOrNull = this.selector;
                    this.funcName = JavafxToJava.this.functionName(this.msym, this.superToStatic, this.callBound);
                    knownNonNull = this.selector.type.isPrimitive() || !this.selectorMutable;
                }
                return new NullCheckTranslator(this.diagPos, toCheckOrNull, this.returnType, knownNonNull){

                    JCTree.JCExpression translateToCheck(JFXExpression expr) {
                        JCTree.JCExpression trans;
                        if (renameToSuper) {
                            trans = this.m().Select(JavafxToJava.this.makeTypeTree(this.diagPos, ((JavafxToJava)JavafxToJava.this).currentClass.sym.type, false), JavafxToJava.this.names._super);
                        } else if (superToStatic) {
                            trans = JavafxToJava.this.makeTypeTree(this.diagPos, this.types.erasure(msym.owner.type), false);
                        } else if (selector != null && !useInvoke && msym != null && msym.isStatic()) {
                            trans = JavafxToJava.this.makeTypeTree(this.diagPos, this.types.erasure(msym.owner.type), false);
                        } else {
                            trans = JavafxToJava.this.translate(expr);
                            if (expr.type.isPrimitive()) {
                                trans = JavafxToJava.this.makeBox(this.diagPos, trans, expr.type);
                            }
                        }
                        return trans;
                    }

                    JCTree.JCExpression fullExpression(JCTree.JCExpression mungedToCheckTranslated) {
                        JCTree.JCExpression full;
                        JCTree.JCExpression tc = mungedToCheckTranslated;
                        if (funcName != null) {
                            tc = this.m().Select(tc, funcName);
                        }
                        JCTree.JCMethodInvocation app = this.determineArgs(tc);
                        JCTree.JCExpression jCExpression = full = callBound ? this.makeBoundCall(app) : app;
                        if (useInvoke && tree.type.tag != 9) {
                            full = JavafxToJava.this.castFromObject(full, tree.type);
                        }
                        if (JavafxToJava.this.wrap == Wrapped.InLocation && !callBound && msym != null) {
                            JavafxTypeMorpher.TypeMorphInfo returnTypeInfo = JavafxToJava.this.typeMorpher.typeMorphInfo(returnType);
                            full = JavafxToJava.this.makeUnboundLocation(this.diagPos, returnTypeInfo, full);
                        }
                        return full;
                    }
                }.doit();
            }

            JCTree.JCMethodInvocation determineArgs(JCTree.JCExpression transMeth) {
                ListBuffer targs = ListBuffer.lb();
                if (this.superToStatic) {
                    targs.append(JavafxToJava.this.make.Ident(this.defs.receiverName));
                }
                if (this.msym != null && (this.msym.flags() & 0xAL) == 2L && this.types.isCompoundClass(this.msym.owner) && transMeth instanceof JCTree.JCFieldAccess) {
                    JCTree.JCFieldAccess selectTr = (JCTree.JCFieldAccess)transMeth;
                    JCTree.JCExpression receiverType = JavafxToJava.this.makeTypeTree(this.diagPos, this.msym.owner.type, false);
                    transMeth = JavafxToJava.this.make.at(transMeth).Select(receiverType, JavafxToJava.this.functionName(this.msym, true, this.callBound));
                    targs.append(selectTr.getExpression());
                }
                if (this.callBound) {
                    List formal = this.formals;
                    for (JFXExpression arg : tree.args) {
                        switch (arg.getFXTag()) {
                            case APPLY: 
                            case IDENT: 
                            case SELECT: {
                                if (arg.type.equals(formal.head) || this.types.isSequence((Type)formal.head) || formal.head == this.syms.objectType) {
                                    targs.append(JavafxToJava.this.translate(arg, Wrapped.InLocation));
                                    break;
                                }
                            }
                            default: {
                                targs.append(JavafxToJava.this.makeUnboundLocation(arg.pos(), JavafxToJava.this.typeMorpher.typeMorphInfo((Type)formal.head), JavafxToJava.this.translate(arg, arg.type)));
                            }
                        }
                        formal = formal.tail;
                    }
                } else {
                    boolean handlingVarargs = false;
                    Type formal = null;
                    List t = this.formals;
                    List<JFXExpression> l = tree.args;
                    while (l.nonEmpty()) {
                        if (!handlingVarargs) {
                            formal = (Type)t.head;
                            t = t.tail;
                            if (this.usesVarArgs && t.isEmpty()) {
                                formal = this.types.elemtype(formal);
                                handlingVarargs = true;
                            }
                        }
                        JCTree.JCExpression targ = this.magicIsInitializedFunction ? JavafxToJava.this.translate((JFXExpression)l.head, Wrapped.InLocation) : JavafxToJava.this.translate((JFXExpression)l.head, formal);
                        targs.append(targ);
                        l = l.tail;
                    }
                }
                return this.m().Apply(JavafxToJava.this.translateExpressions(tree.typeargs), transMeth, targs.toList());
            }

            JCTree.JCExpression makeBoundCall(JCTree.JCExpression applyExpression) {
                JavafxTypeMorpher.TypeMorphInfo tmi = JavafxToJava.this.typeMorpher.typeMorphInfo(this.msym.getReturnType());
                return JavafxToJava.this.wrap == Wrapped.InLocation ? applyExpression : JavafxToJava.this.callExpression(this.diagPos, (JCTree.JCExpression)this.m().Parens(applyExpression), this.defs.locationGetMethodName[tmi.getTypeKind()]);
            }
        }.doit();
    }

    @Override
    public void visitModifiers(JFXModifiers tree) {
        this.result = this.make.at(tree.pos).Modifiers(tree.flags, List.<JCTree.JCAnnotation>nil());
    }

    @Override
    public void visitSkip(JFXSkip tree) {
        this.result = this.make.at(tree.pos).Skip();
    }

    @Override
    public void visitThrow(JFXThrow tree) {
        JCTree.JCExpression expr = this.translate(tree.expr);
        this.result = this.make.at(tree.pos).Throw(expr);
    }

    @Override
    public void visitTry(JFXTry tree) {
        JCTree.JCBlock body = this.translateBlockExpressionToBlock(tree.body);
        List<JCTree.JCCatch> catchers = this.translateCatchers(tree.catchers);
        JCTree.JCBlock finalizer = this.translateBlockExpressionToBlock(tree.finalizer);
        this.result = this.make.at(tree.pos).Try(body, catchers, finalizer);
    }

    @Override
    public void visitUnary(final JFXUnary tree) {
        this.result = new Translator(tree.pos(), this){
            private final JFXExpression expr;
            private final JCTree.JCExpression transExpr;
            {
                super(x0, x1);
                this.expr = tree.getExpression();
                this.transExpr = JavafxToJava.this.translate(this.expr);
            }

            private JCTree.JCExpression doIncDec(final int binaryOp, final boolean postfix) {
                return (JCTree.JCExpression)new AssignTranslator(this.diagPos, this.expr, this.fxm().Literal(1)){

                    JCTree.JCExpression buildRHS(JCTree.JCExpression rhsTranslated) {
                        return this.m().Binary(binaryOp, transExpr, rhsTranslated);
                    }

                    JCTree.JCExpression defaultFullExpression(JCTree.JCExpression lhsTranslated, JCTree.JCExpression rhsTranslated) {
                        return this.m().Unary(tree.getOperatorTag(), lhsTranslated);
                    }

                    protected JCTree.JCExpression postProcess(JCTree.JCExpression built) {
                        if (postfix) {
                            return this.m().Binary(binaryOp, built, this.m().Literal(-1));
                        }
                        return built;
                    }
                }.doit();
            }

            public JCTree doit() {
                switch (tree.getFXTag()) {
                    case SIZEOF: {
                        return JavafxToJava.this.callExpression(this.diagPos, JavafxToJava.this.makeQualifiedTree(this.diagPos, "com.sun.javafx.runtime.sequence.Sequences"), this.defs.sizeMethodName, (Object)this.transExpr);
                    }
                    case REVERSE: {
                        return JavafxToJava.this.callExpression(this.diagPos, JavafxToJava.this.makeQualifiedTree(this.diagPos, "com.sun.javafx.runtime.sequence.Sequences"), "reverse", (Object)this.transExpr);
                    }
                    case PREINC: {
                        return this.doIncDec(69, false);
                    }
                    case PREDEC: {
                        return this.doIncDec(70, false);
                    }
                    case POSTINC: {
                        return this.doIncDec(69, true);
                    }
                    case POSTDEC: {
                        return this.doIncDec(70, true);
                    }
                    case NEG: {
                        if (!this.types.isSameType(tree.type, this.syms.javafx_DurationType)) break;
                        return this.m().Apply(null, this.m().Select(JavafxToJava.this.translate(tree.arg), Name.fromString(JavafxToJava.this.names, "negate")), List.<JCTree.JCExpression>nil());
                    }
                }
                return this.m().Unary(tree.getOperatorTag(), this.transExpr);
            }
        }.doit();
    }

    @Override
    public void visitWhileLoop(JFXWhileLoop tree) {
        JCTree.JCStatement body = this.translateExpressionToStatement(tree.body);
        JCTree.JCExpression cond = this.translate(tree.cond);
        this.result = this.make.at(tree.pos).WhileLoop(cond, body);
    }

    @Override
    public void visitObjectLiteralPart(JFXObjectLiteralPart that) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitTypeAny(JFXTypeAny that) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitTypeClass(JFXTypeClass that) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitTypeFunctional(JFXTypeFunctional that) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitTypeUnknown(JFXTypeUnknown that) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitForExpressionInClause(JFXForExpressionInClause that) {
        assert (false) : "should be processed by parent tree";
    }

    private JCTree.JCBlock makeRunMethodBody(JFXBlock bexpr) {
        JCTree.JCBlock block;
        JCDiagnostic.DiagnosticPosition diagPos = bexpr.pos();
        JFXExpression value = bexpr.value;
        if (value == null || value.type == this.syms.voidType) {
            block = this.asBlock(this.translateExpressionToStatement(bexpr));
            block.stats = block.stats.append(this.make.Return(this.make.at(diagPos).Literal(17, null)));
        } else {
            block = this.asBlock(this.translateExpressionToReturn(bexpr));
            final Type valueType = value.type;
            if (valueType != null && valueType.isPrimitive()) {
                new TreeTranslator(){

                    public void visitReturn(JCTree.JCReturn tree) {
                        tree.expr = JavafxToJava.this.makeBox(tree.expr.pos(), tree.expr, valueType);
                        this.result = tree;
                    }

                    public void visitClassDef(JCTree.JCClassDecl tree) {
                        this.result = tree;
                    }
                }.translate(block);
            }
        }
        return block;
    }

    @Override
    protected String getSyntheticPrefix() {
        return "jfx$";
    }

    boolean requiresLocation(Symbol sym) {
        if (sym == null) {
            return false;
        }
        return this.typeMorpher.requiresLocation(sym);
    }

    boolean requiresLocation(JavafxTypeMorpher.VarMorphInfo vmi) {
        return this.requiresLocation(vmi.getSymbol());
    }

    JCTree.JCBlock translatedOnReplaceBody(JFXOnReplace onr) {
        return onr == null ? null : this.translateBlockExpressionToBlock(onr.getBody());
    }

    JCTree.JCExpression convertVariableReference(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression varRef, Symbol sym, boolean wantLocation) {
        JCTree.JCExpression expr = varRef;
        boolean staticReference = sym.isStatic();
        if (sym instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol vsym = (Symbol.VarSymbol)sym;
            if (sym.owner.kind == 2 && this.types.isJFXClass(sym.owner)) {
                if (staticReference) {
                    expr = this.switchName(diagPos, varRef, this.attributeFieldName(vsym));
                } else {
                    JCTree.JCExpression accessFunc = this.switchName(diagPos, varRef, this.attributeGetterName(vsym));
                    List<JCTree.JCExpression> emptyArgs = List.nil();
                    expr = this.make.at(diagPos).Apply(null, accessFunc, emptyArgs);
                }
            }
            JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(vsym);
            if (this.requiresLocation(vsym)) {
                if (!wantLocation) {
                    expr = this.getLocationValue(diagPos, expr, vmi.getTypeKind());
                }
            } else if (wantLocation) {
                expr = this.makeUnboundLocation(diagPos, vmi, expr);
            }
        }
        return expr;
    }

    private JCTree.JCExpression switchName(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression identOrSelect, Name name) {
        switch (identOrSelect.getTag()) {
            case 35: {
                return this.make.at(diagPos).Ident(name);
            }
            case 34: {
                return this.make.at(diagPos).Select(((JCTree.JCFieldAccess)identOrSelect).getExpression(), name);
            }
        }
        throw new AssertionError();
    }

    private JCTree.JCExpression makeReceiver(JCDiagnostic.DiagnosticPosition pos, Symbol treeSym, Symbol siteOwner) {
        JCTree.JCExpression ret = null;
        if (treeSym != null && siteOwner != null) {
            ret = this.make.Ident(this.defs.receiverName);
            ret.type = siteOwner.type;
            if (siteOwner != treeSym.owner) {
                Symbol siteCursor = siteOwner;
                boolean foundOwner = false;
                int numOfOuters = 0;
                block0: while (siteCursor.kind != 1) {
                    ListBuffer<Type> supertypes = ListBuffer.lb();
                    HashSet<Type> superSet = new HashSet<Type>();
                    if (siteCursor.type != null) {
                        supertypes.append(siteCursor.type);
                        superSet.add(siteCursor.type);
                    }
                    if (siteCursor.kind == 2) {
                        this.types.getSupertypes(siteCursor, supertypes, superSet);
                    }
                    for (Type supType : supertypes) {
                        if (!this.types.isSameType(supType, treeSym.owner.type)) continue;
                        foundOwner = true;
                        break block0;
                    }
                    if (siteCursor.kind == 2) {
                        ++numOfOuters;
                    }
                    siteCursor = siteCursor.owner;
                }
                if (foundOwner) {
                    siteCursor = siteOwner;
                    while (numOfOuters > 0) {
                        if (siteCursor.kind == 2) {
                            ret = this.callExpression(pos, ret, this.initBuilder.outerAccessorName);
                            ret.type = siteCursor.type;
                        }
                        if (siteCursor.kind == 2) {
                            --numOfOuters;
                        }
                        siteCursor = siteCursor.owner;
                    }
                }
            }
        }
        return ret;
    }

    private void fillClassesWithOuters(JFXScript tree) {
        class FillClassesWithOuters
        extends JavafxTreeScanner {
            JFXClassDeclaration currentClass;

            FillClassesWithOuters() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitClassDeclaration(JFXClassDeclaration tree) {
                JFXClassDeclaration prevClass = this.currentClass;
                try {
                    this.currentClass = tree;
                    super.visitClassDeclaration(tree);
                }
                finally {
                    this.currentClass = prevClass;
                }
            }

            public void visitIdent(JFXIdent tree) {
                super.visitIdent(tree);
                if (this.currentClass != null && tree.sym.kind != 2) {
                    this.addOutersForOuterAccess(tree.sym, this.currentClass.sym);
                }
            }

            public void visitInstanciate(JFXInstanciate tree) {
                super.visitInstanciate(tree);
                super.scan(tree.getArgs());
            }

            private void addOutersForOuterAccess(Symbol sym, Symbol currentClass) {
                if (sym != null && sym.owner != null && sym.owner.type != null && !sym.isStatic() && currentClass != null) {
                    Symbol outerSym = currentClass;
                    ListBuffer<Symbol.ClassSymbol> potentialOuters = new ListBuffer<Symbol.ClassSymbol>();
                    boolean foundOuterOwner = false;
                    while (outerSym != null) {
                        if (outerSym.kind == 2) {
                            Symbol.ClassSymbol outerCSym = (Symbol.ClassSymbol)outerSym;
                            if (JavafxToJava.this.types.isSuperType(sym.owner.type, outerCSym)) {
                                foundOuterOwner = true;
                                break;
                            }
                            potentialOuters.append(outerCSym);
                        } else if (sym.owner == outerSym) break;
                        outerSym = outerSym.owner;
                    }
                    if (foundOuterOwner) {
                        for (Symbol.ClassSymbol cs : potentialOuters) {
                            JavafxToJava.this.hasOuters.add(cs);
                        }
                    }
                }
            }
        }
        new FillClassesWithOuters().scan(tree);
    }

    @Override
    public void visitTimeLiteral(JFXTimeLiteral tree) {
        JFXFunctionInvocation duration = this.timeLiteralToDuration(tree);
        this.visitFunctionInvocation(duration);
    }

    @Override
    public void visitInterpolateValue(JFXInterpolateValue tree) {
        List<JFXTree> parts;
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXExpression clsname = this.fxmake.at(diagPos).Type(this.syms.javafx_KeyValueType);
        ((JFXSelect)clsname).sym = this.syms.javafx_KeyValueType.tsym;
        final Symbol targetSymbol = this.syms.javafx_KeyValueType.tsym.members().lookup((Name)this.defs.targetName).sym;
        JFXObjectLiteralPart targetLiteral = this.fxmake.at(tree.pos()).ObjectLiteralPart(this.defs.targetName, tree.attribute);
        targetLiteral.sym = targetSymbol;
        JFXObjectLiteralPart valueLiteral = this.fxmake.at(tree.pos()).ObjectLiteralPart(this.defs.valueName, tree.value, JavafxBindStatus.UNIDIBIND);
        valueLiteral.sym = this.syms.javafx_KeyValueType.tsym.members().lookup((Name)this.defs.valueName).sym;
        if (tree.interpolation == null) {
            parts = List.of(targetLiteral, valueLiteral);
        } else {
            JFXObjectLiteralPart interpolateLiteral = this.fxmake.at(tree.pos()).ObjectLiteralPart(this.defs.interpolateName, tree.interpolation, JavafxBindStatus.UNIDIBIND);
            interpolateLiteral.sym = this.syms.javafx_KeyValueType.tsym.members().lookup((Name)this.defs.interpolateName).sym;
            parts = List.of(targetLiteral, valueLiteral, interpolateLiteral);
        }
        JFXInstanciate inst = this.fxmake.at(diagPos).Instanciate(Tree.JavaFXKind.INSTANTIATE_OBJECT_LITERAL, clsname, null, parts);
        inst.type = clsname.type;
        this.result = new InstanciateTranslator(inst, this){

            protected void processLocalVar(JFXVar var) {
            }

            protected JCTree.JCStatement translateAttributeSet(JFXExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName) {
                if (targetSymbol == vsym) {
                    JCTree.JCExpression localAttr;
                    JCTree.JCExpression target = JavafxToJava.this.translate(init, Wrapped.InLocation);
                    target = JavafxToJava.this.callExpression(this.diagPos, this.makeExpression(this.syms.javafx_PointerType), "make", (Object)target);
                    JavafxTypeMorpher.VarMorphInfo vmi = JavafxToJava.this.typeMorpher.varMorphInfo(vsym);
                    if (vsym.owner.kind == 2) {
                        localAttr = JavafxToJava.this.makeAttributeAccess(this.diagPos, vsym, instanceName);
                    } else {
                        assert ((vsym.flags() & 0x200000000L) == 0L) : "Parameters are not initialized";
                        localAttr = JavafxToJava.this.make.at(this.diagPos).Ident(vsym);
                    }
                    return JavafxToJava.this.make.at(this.diagPos).Exec(JavafxToJava.this.callExpression(this.diagPos, localAttr, this.defs.locationSetMilieuMethodName[vmi.getTypeKind()][1], (Object)target));
                }
                return this.toJava.translateDefinitionalAssignmentToSet(this.diagPos, init, bindStatus, vsym, instanceName, 1);
            }
        }.doit();
    }

    @Override
    public void visitKeyFrameLiteral(JFXKeyFrameLiteral tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXExpression clsname = this.fxmake.at(diagPos).Type(this.syms.javafx_KeyFrameType);
        ((JFXSelect)clsname).sym = this.syms.javafx_KeyFrameType.tsym;
        Symbol timeSymbol = this.syms.javafx_KeyFrameType.tsym.members().lookup((Name)this.defs.timeName).sym;
        JFXObjectLiteralPart timeLiteral = this.fxmake.at(diagPos).ObjectLiteralPart(this.defs.timeName, tree.start);
        timeLiteral.sym = timeSymbol;
        JFXSequenceExplicit values = this.fxmake.at(diagPos).ExplicitSequence(tree.values);
        values.type = this.types.sequenceType(this.fxmake.at((JCDiagnostic.DiagnosticPosition)diagPos).Type((Type)this.syms.javafx_KeyValueType).type);
        JFXObjectLiteralPart valuesLiteral = this.fxmake.at(diagPos).ObjectLiteralPart(this.defs.valuesName, values);
        valuesLiteral.sym = this.syms.javafx_KeyFrameType.tsym.members().lookup((Name)this.defs.valuesName).sym;
        List<JFXTree> parts = List.of(timeLiteral, valuesLiteral);
        JFXInstanciate inst = this.fxmake.at(diagPos).Instanciate(Tree.JavaFXKind.INSTANTIATE_OBJECT_LITERAL, clsname, null, parts);
        inst.type = clsname.type;
        this.result = new InstanciateTranslator(inst, this){

            protected void processLocalVar(JFXVar var) {
            }

            protected JCTree.JCStatement translateAttributeSet(JFXExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName) {
                return this.toJava.translateDefinitionalAssignmentToSet(this.diagPos, init, bindStatus, vsym, instanceName, 1);
            }
        }.doit();
    }

    static abstract class FunctionCallTranslator
    extends Translator {
        protected final JFXExpression meth;
        protected final JFXExpression selector;
        protected final Symbol.MethodSymbol msym;
        protected final boolean renameToSuper;
        protected final boolean superToStatic;
        protected final List<Type> formals;
        protected final boolean usesVarArgs;
        protected final boolean useInvoke;
        protected final boolean selectorMutable;
        protected final boolean callBound;
        protected final boolean magicIsInitializedFunction;
        protected final Type returnType;

        FunctionCallTranslator(JFXFunctionInvocation tree, JavafxToJava toJava) {
            super(tree.pos(), toJava);
            this.meth = tree.meth;
            this.returnType = tree.type;
            JFXSelect fieldAccess = this.meth.getFXTag() == JavafxTag.SELECT ? (JFXSelect)this.meth : null;
            this.selector = fieldAccess != null ? fieldAccess.getExpression() : null;
            Symbol sym = toJava.expressionSymbol(this.meth);
            this.msym = sym instanceof Symbol.MethodSymbol ? (Symbol.MethodSymbol)sym : null;
            Name selectorIdName = this.selector != null && this.selector.getFXTag() == JavafxTag.IDENT ? ((JFXIdent)this.selector).getName() : null;
            boolean thisCall = selectorIdName == toJava.names._this;
            boolean superCall = selectorIdName == toJava.names._super;
            Symbol.ClassSymbol csym = toJava.attrEnv.enclClass.sym;
            boolean namedSuperCall = this.selector != null && this.msym != null && !this.msym.isStatic() && toJava.expressionSymbol(this.selector) instanceof Symbol.ClassSymbol && this.types.isSuperType(toJava.expressionSymbol((JFXExpression)this.selector).type, csym);
            this.renameToSuper = namedSuperCall && !this.types.isCompoundClass(csym);
            this.superToStatic = (superCall || namedSuperCall) && !this.renameToSuper;
            this.formals = this.meth.type.getParameterTypes();
            this.usesVarArgs = tree.args != null && this.msym != null && (this.msym.flags() & 0x400000000L) != 0L && (this.formals.size() != tree.args.size() || this.types.isConvertible(tree.args.last().type, this.types.elemtype(this.formals.last())));
            this.useInvoke = this.meth.type instanceof FunctionType;
            this.selectorMutable = this.msym != null && !sym.isStatic() && this.selector != null && !superCall && !namedSuperCall && !thisCall && !this.renameToSuper;
            this.callBound = this.msym != null && !this.useInvoke && (this.msym.flags() & 0x8000000000L) != 0L;
            this.magicIsInitializedFunction = this.msym != null && (this.msym.flags_field & 0x800000000000L) != 0L;
        }
    }

    abstract class UseSequenceBuilder {
        final JCDiagnostic.DiagnosticPosition diagPos;
        final Type elemType;
        final String seqBuilder;
        Name sbName;

        private UseSequenceBuilder(JCDiagnostic.DiagnosticPosition diagPos, Type elemType, String seqBuilder) {
            this.diagPos = diagPos;
            this.elemType = elemType;
            this.seqBuilder = seqBuilder;
        }

        JCTree.JCStatement makeBuilderVar() {
            JCTree.JCExpression builderTypeExpr = JavafxToJava.this.makeQualifiedTree(this.diagPos, this.seqBuilder);
            List<JCTree.JCExpression> btargs = List.of(JavafxToJava.this.makeTypeTree(this.diagPos, this.elemType));
            builderTypeExpr = JavafxToJava.this.make.at(this.diagPos).TypeApply(builderTypeExpr, btargs);
            this.sbName = JavafxToJava.this.getSyntheticName("sb");
            JCTree.JCNewClass newExpr = JavafxToJava.this.make.at(this.diagPos).NewClass(null, List.<JCTree.JCExpression>nil(), JavafxToJava.this.make.at(this.diagPos).TypeApply(JavafxToJava.this.makeQualifiedTree(this.diagPos, this.seqBuilder), List.of(JavafxToJava.this.makeTypeTree(this.diagPos, this.elemType))), List.of(this.makeConstructorArg()), null);
            return JavafxToJava.this.make.at(this.diagPos).VarDef(JavafxToJava.this.make.at(this.diagPos).Modifiers(0L), this.sbName, builderTypeExpr, newExpr);
        }

        JCTree.JCIdent makeBuilderVarAccess() {
            return JavafxToJava.this.make.Ident(this.sbName);
        }

        abstract JCTree.JCStatement makeAdd(JFXExpression var1);

        abstract JCTree.JCExpression makeConstructorArg();

        JCTree.JCStatement makeAdd(JCTree.JCExpression expr, Type exprType) {
            if (exprType != this.elemType) {
                if (JavafxToJava.this.types.isArray(exprType)) {
                    expr = JavafxToJava.this.convertTranslated(expr, this.diagPos, exprType, JavafxToJava.this.types.sequenceType(this.elemType));
                } else {
                    Type unboxedElemType = JavafxToJava.this.types.unboxedType(this.elemType);
                    if (unboxedElemType != Type.noType) {
                        Type unboxedExprType = JavafxToJava.this.types.unboxedType(exprType);
                        if (unboxedExprType != Type.noType) {
                            expr = JavafxToJava.this.make.at(this.diagPos).TypeCast(unboxedExprType, expr);
                            exprType = unboxedExprType;
                        }
                        if (exprType.tag == 4 && unboxedElemType.tag == 7) {
                            expr = JavafxToJava.this.make.at(this.diagPos).TypeCast(unboxedElemType, expr);
                        }
                    }
                }
            }
            JCTree.JCMethodInvocation addCall = JavafxToJava.this.make.Apply(List.<JCTree.JCExpression>nil(), JavafxToJava.this.make.at(this.diagPos).Select((JCTree.JCExpression)this.makeBuilderVarAccess(), Name.fromString(JavafxToJava.this.names, "add")), List.of(expr));
            return JavafxToJava.this.make.at(this.diagPos).Exec(addCall);
        }

        JCTree.JCExpression makeToSequence() {
            return JavafxToJava.this.make.Apply(List.<JCTree.JCExpression>nil(), JavafxToJava.this.make.at(this.diagPos).Select((JCTree.JCExpression)this.makeBuilderVarAccess(), Name.fromString(JavafxToJava.this.names, JavafxToJava.toSequenceString)), List.<JCTree.JCExpression>nil());
        }
    }

    class SelectTranslator
    extends NullCheckTranslator {
        protected final Symbol sym;
        protected final boolean isFunctionReference;
        protected final boolean staticReference;
        protected final Name name;

        protected SelectTranslator(JFXSelect tree) {
            super(tree.pos(), tree.getExpression(), tree.type, tree.sym.isStatic());
            this.sym = tree.sym;
            this.isFunctionReference = tree.type instanceof FunctionType && tree.sym.type instanceof Type.MethodType;
            this.staticReference = tree.sym.isStatic();
            this.name = tree.getIdentifier();
        }

        protected JCTree.JCExpression translateToCheck(JFXExpression expr) {
            JCTree.JCExpression translatedSelected = JavafxToJava.this.translate(expr, Wrapped.InNothing);
            if (this.staticReference) {
                translatedSelected = JavafxToJava.this.makeTypeTree(this.diagPos, this.types.erasure(this.sym.owner.type), false);
            }
            return translatedSelected;
        }

        protected JCTree.JCExpression fullExpression(JCTree.JCExpression mungedToCheckTranslated) {
            if (this.isFunctionReference) {
                Type.MethodType mtype = (Type.MethodType)this.sym.type;
                JCTree.JCExpression tc = this.staticReference ? mungedToCheckTranslated : this.addTempVar(this.toCheck.type, mungedToCheckTranslated);
                JCTree.JCFieldAccess translated = this.m().Select(tc, this.name);
                return JavafxToJava.this.makeFunctionValue(translated, null, this.diagPos, mtype);
            }
            JCTree.JCExpression tc = mungedToCheckTranslated;
            if (this.toCheck.type != null && this.toCheck.type.isPrimitive()) {
                tc = JavafxToJava.this.makeBox(this.diagPos, tc, this.toCheck.type);
            }
            JCTree.JCFieldAccess translated = JavafxToJava.this.make.at(this.diagPos).Select(tc, this.name);
            return JavafxToJava.this.convertVariableReference(this.diagPos, translated, this.sym, JavafxToJava.this.wrap == Wrapped.InLocation);
        }
    }

    abstract class AssignTranslator
    extends Translator {
        protected final JFXExpression lhs;
        protected final JFXExpression rhs;
        protected final Symbol sym;
        protected final JCTree.JCExpression rhsTranslated;

        AssignTranslator(JCDiagnostic.DiagnosticPosition diagPos, JFXExpression lhs, JFXExpression rhs) {
            super(diagPos, JavafxToJava.this);
            this.lhs = lhs;
            this.rhs = rhs;
            this.rhsTranslated = JavafxToJava.this.translate(rhs, lhs.type);
            this.sym = JavafxToJava.this.expressionSymbol(lhs);
        }

        abstract JCTree.JCExpression defaultFullExpression(JCTree.JCExpression var1, JCTree.JCExpression var2);

        abstract JCTree.JCExpression buildRHS(JCTree.JCExpression var1);

        protected JCTree.JCExpression postProcess(JCTree.JCExpression built) {
            return built;
        }

        private JCTree.JCExpression buildSetter(JCTree.JCExpression tc, JCTree.JCExpression rhsComplete) {
            Name setter = JavafxToJava.this.attributeSetterName(this.sym);
            JCTree.JCExpression toApply = tc == null ? this.m().Ident(setter) : this.m().Select(tc, setter);
            return this.m().Apply(null, toApply, List.of(rhsComplete));
        }

        protected JCTree doit() {
            boolean useSetters;
            if (this.lhs.getFXTag() == JavafxTag.SEQUENCE_INDEXED) {
                JFXSequenceIndexed si = (JFXSequenceIndexed)this.lhs;
                JCTree.JCExpression seq = JavafxToJava.this.translate(si.getSequence(), Wrapped.InLocation);
                JCTree.JCExpression index = JavafxToJava.this.translate(si.getIndex());
                JCTree.JCFieldAccess select = this.m().Select(seq, this.defs.setMethodName);
                List<JCTree.JCExpression> args = List.of(index, this.buildRHS(this.rhsTranslated));
                return this.postProcess(this.m().Apply(null, select, args));
            }
            if (JavafxToJava.this.requiresLocation(this.sym)) {
                JCTree.JCExpression lhsTranslated = JavafxToJava.this.translate(this.lhs, Wrapped.InLocation);
                JCTree.JCFieldAccess setSelect = this.m().Select(lhsTranslated, this.defs.locationSetMethodName[JavafxToJava.this.typeMorpher.typeMorphInfo(this.lhs.type).getTypeKind()]);
                List<JCTree.JCExpression> setArgs = List.of(this.buildRHS(this.rhsTranslated));
                return this.postProcess(this.m().Apply(null, setSelect, setArgs));
            }
            boolean bl = useSetters = this.sym.owner.kind == 2 && !this.sym.isStatic() && this.types.isJFXClass(this.sym.owner);
            if (this.lhs.getFXTag() == JavafxTag.SELECT) {
                final JFXSelect select = (JFXSelect)this.lhs;
                return new NullCheckTranslator(this.diagPos, select.getExpression(), this.lhs.type, false){
                    private final JCTree.JCExpression rhsTranslatedPreserved;
                    {
                        super(x0, x1, x2, x3);
                        this.rhsTranslatedPreserved = this.preserveSideEffects(AssignTranslator.this.lhs.type, AssignTranslator.this.rhs, AssignTranslator.this.rhsTranslated);
                    }

                    JCTree.JCExpression translateToCheck(JFXExpression expr) {
                        return JavafxToJava.this.translate(expr, Wrapped.InNothing);
                    }

                    JCTree.JCExpression fullExpression(JCTree.JCExpression mungedToCheckTranslated) {
                        if (useSetters) {
                            return AssignTranslator.this.postProcess(AssignTranslator.this.buildSetter(mungedToCheckTranslated, AssignTranslator.this.buildRHS(this.rhsTranslatedPreserved)));
                        }
                        JCTree.JCFieldAccess fa = this.m().Select(mungedToCheckTranslated, JavafxToJava.this.attributeFieldName(select.sym));
                        return AssignTranslator.this.defaultFullExpression(fa, this.rhsTranslatedPreserved);
                    }
                }.doit();
            }
            if (useSetters) {
                JCTree.JCExpression recv = JavafxToJava.this.makeReceiver(this.diagPos, this.sym, JavafxToJava.this.attrEnv.enclClass.sym);
                return this.postProcess(this.buildSetter(recv, this.buildRHS(this.rhsTranslated)));
            }
            return this.defaultFullExpression(JavafxToJava.this.translate(this.lhs), this.rhsTranslated);
        }
    }

    static abstract class StringExpressionTranslator
    extends Translator {
        private final JFXStringExpression tree;

        StringExpressionTranslator(JFXStringExpression tree, JavafxToJava toJava) {
            super(tree.pos(), toJava);
            this.tree = tree;
        }

        protected JCTree.JCExpression doit() {
            String formatMethod;
            StringBuffer sb = new StringBuffer();
            List<JFXExpression> parts = this.tree.getParts();
            ListBuffer<JCTree.JCExpression> values = new ListBuffer<JCTree.JCExpression>();
            JFXLiteral lit = (JFXLiteral)parts.head;
            sb.append((String)lit.value);
            parts = parts.tail;
            boolean containsExtendedFormat = false;
            while (parts.nonEmpty()) {
                JCTree.JCExpression texp;
                lit = (JFXLiteral)parts.head;
                String format = (String)lit.value;
                if (!containsExtendedFormat && format.length() > 0 && EXTENDED_FORMAT_PATTERN.matcher(format).find()) {
                    containsExtendedFormat = true;
                }
                parts = parts.tail;
                JFXExpression exp = (JFXExpression)parts.head;
                if (exp != null && this.types.isSameType(exp.type, this.syms.javafx_DurationType)) {
                    texp = this.m().Apply(null, this.m().Select(this.translateArg(exp), Name.fromString(this.toJava.names, "toDate")), List.<JCTree.JCExpression>nil());
                    sb.append(format.length() == 0 ? "%tQms" : format);
                } else {
                    texp = this.translateArg(exp);
                    sb.append(format.length() == 0 ? "%s" : format);
                }
                values.append(texp);
                parts = parts.tail;
                lit = (JFXLiteral)parts.head;
                String part = (String)lit.value;
                sb.append(part.replace("%", "%%"));
                parts = parts.tail;
            }
            JCTree.JCLiteral formatLiteral = this.m().Literal(10, sb.toString());
            values.prepend(formatLiteral);
            if (this.tree.translationKey != null) {
                formatMethod = "com.sun.javafx.runtime.util.StringLocalization.getLocalizedString";
                if (this.tree.translationKey.length() == 0) {
                    values.prepend(this.m().Literal(17, null));
                } else {
                    values.prepend(this.m().Literal(10, this.tree.translationKey));
                }
                String resourceName = this.toJava.attrEnv.enclClass.sym.flatname.toString().replace('.', '/').replaceAll("\\$.*", "");
                values.prepend(this.m().Literal(10, resourceName));
            } else {
                formatMethod = containsExtendedFormat ? "com.sun.javafx.runtime.util.FXFormatter.sprintf" : "java.lang.String.format";
            }
            JCTree.JCExpression formatter = this.toJava.makeQualifiedTree(this.diagPos, formatMethod);
            return this.m().Apply(null, formatter, values.toList());
        }

        protected abstract JCTree.JCExpression translateArg(JFXExpression var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class InstanciateTranslator
    extends Translator {
        protected final JFXInstanciate tree;
        protected ListBuffer<JCTree.JCStatement> stats = ListBuffer.lb();

        InstanciateTranslator(JFXInstanciate tree, JavafxToJava toJava) {
            super(tree.pos(), toJava);
            this.tree = tree;
        }

        protected abstract void processLocalVar(JFXVar var1);

        protected List<JCTree.JCExpression> translatedConstructorArgs() {
            if (this.tree.constructor != null && this.tree.constructor.type != null) {
                java.util.List ptypes = this.tree.constructor.type.asMethodType().getParameterTypes();
                return this.toJava.translate(this.tree.getArgs(), (List<Type>)ptypes);
            }
            return this.toJava.translateExpressions(this.tree.getArgs());
        }

        protected abstract JCTree.JCStatement translateAttributeSet(JFXExpression var1, JavafxBindStatus var2, Symbol.VarSymbol var3, Name var4);

        @Override
        protected JCTree.JCExpression doit() {
            JCTree.JCExpression instExpression;
            Type type;
            for (JFXVar var : this.tree.getLocalvars()) {
                this.processLocalVar(var);
            }
            if (this.tree.getClassBody() == null) {
                type = this.tree.type;
            } else {
                JFXClassDeclaration cdef = this.tree.getClassBody();
                this.stats.append(this.toJava.translateClassDef(cdef));
                type = cdef.type;
            }
            JCTree.JCExpression classTypeExpr = this.toJava.makeTypeTree(this.tree, type, false);
            Symbol sym = JavafxTreeInfo.symbol(this.tree.getIdentifier());
            List<JCTree.JCExpression> newClassArgs = this.translatedConstructorArgs();
            if (this.tree.getClassBody() != null || this.types.isJFXClass(sym)) {
                assert (newClassArgs.size() == 0) : "should not be args for JavaFX class constructors";
                newClassArgs = newClassArgs.append(this.m().Literal(8, 1));
            }
            if (this.tree.getClassBody() != null && this.tree.getClassBody().sym != null && this.toJava.hasOuters.contains(this.tree.getClassBody().sym) || sym != null && this.toJava.hasOuters.contains(sym)) {
                JCTree.JCIdent thisIdent = this.m().Ident(this.defs.receiverName);
                newClassArgs = newClassArgs.prepend(thisIdent);
            }
            JCTree.JCNewClass newClass = this.m().NewClass(null, null, classTypeExpr, newClassArgs, null);
            if (sym != null && sym.kind == 2 && sym instanceof Symbol.ClassSymbol && (this.types.isJFXClass((Symbol.ClassSymbol)sym) || this.tree.getClassBody() != null)) {
                JCTree.JCVariableDecl tmpVar = this.toJava.makeTmpVar(this.diagPos, "objlit", type, newClass);
                this.stats.append(tmpVar);
                if (this.tree.varDefinedByThis != null) {
                    this.toJava.substitutionMap.put(this.tree.varDefinedByThis, tmpVar.name);
                }
                for (JFXObjectLiteralPart olpart : this.tree.getParts()) {
                    this.diagPos = olpart.pos();
                    JavafxBindStatus bindStatus = olpart.getBindStatus();
                    JFXExpression init = olpart.getExpression();
                    Symbol.VarSymbol vsym = (Symbol.VarSymbol)olpart.sym;
                    if (this.types.isSequence(olpart.type)) {
                        JFXExpression olexpr = olpart.getExpression();
                        if (!this.types.isSequence(olexpr.type)) {
                            init = this.fxm().ExplicitSequence(List.of(olexpr));
                            Type.WildcardType tpType = new Type.WildcardType(olexpr.type, BoundKind.EXTENDS, olexpr.type.tsym);
                            init.type = new Type.ClassType(this.syms.javafx_SequenceType, List.of(tpType), this.syms.javafx_SequenceType.tsym);
                        }
                    }
                    this.stats.append(this.translateAttributeSet(init, bindStatus, vsym, tmpVar.name));
                }
                if (this.tree.varDefinedByThis != null) {
                    this.toJava.substitutionMap.remove(this.tree.varDefinedByThis);
                }
                this.diagPos = this.tree.pos();
                JCTree.JCIdent ident3 = this.m().Ident(tmpVar.name);
                JCTree.JCStatement applyExec = this.toJava.callStatement(this.diagPos, (JCTree.JCExpression)ident3, this.defs.initializeName);
                this.stats.append(applyExec);
                JCTree.JCIdent ident2 = this.m().Ident(tmpVar.name);
                instExpression = this.toJava.makeBlockExpression(this.diagPos, this.stats, (JCTree.JCExpression)ident2);
            } else {
                instExpression = newClass;
            }
            if (this.toJava.wrap == Wrapped.InLocation) {
                instExpression = this.toJava.makeConstantLocation(this.diagPos, this.tree.type, instExpression);
            }
            return instExpression;
        }
    }

    abstract class NullCheckTranslator
    extends Translator {
        protected final JFXExpression toCheck;
        protected final Type resultType;
        private final boolean needNullCheck;
        private boolean hasSideEffects;
        private boolean hse;
        private ListBuffer<JCTree.JCStatement> tmpVarList;

        NullCheckTranslator(JCDiagnostic.DiagnosticPosition diagPos, JFXExpression toCheck, Type resultType, boolean knownNonNull) {
            super(diagPos, JavafxToJava.this);
            this.toCheck = toCheck;
            this.resultType = resultType;
            this.needNullCheck = !knownNonNull && !toCheck.type.isPrimitive() && this.possiblyNull(toCheck);
            this.hasSideEffects = this.needNullCheck && this.computeHasSideEffects(toCheck);
            this.tmpVarList = ListBuffer.lb();
        }

        abstract JCTree.JCExpression fullExpression(JCTree.JCExpression var1);

        abstract JCTree.JCExpression translateToCheck(JFXExpression var1);

        protected JCTree.JCExpression preserveSideEffects(Type type, JFXExpression expr, JCTree.JCExpression trans) {
            if (this.needNullCheck && expr != null && this.computeHasSideEffects(expr)) {
                return this.addTempVar(type, trans);
            }
            return trans;
        }

        protected JCTree.JCExpression addTempVar(Type varType, JCTree.JCExpression trans) {
            JCTree.JCVariableDecl tmpVar = JavafxToJava.this.makeTmpVar(this.diagPos, "pse", varType, trans);
            this.tmpVarList.append(tmpVar);
            return this.m().Ident(tmpVar.name);
        }

        private boolean possiblyNull(JFXExpression expr) {
            if (expr == null) {
                return true;
            }
            switch (expr.getFXTag()) {
                case ASSIGN: {
                    return this.possiblyNull(((JFXAssign)expr).getExpression());
                }
                case APPLY: {
                    return true;
                }
                case BLOCK_EXPRESSION: {
                    return this.possiblyNull(((JFXBlock)expr).getValue());
                }
                case IDENT: {
                    return ((JFXIdent)expr).sym instanceof Symbol.VarSymbol;
                }
                case CONDEXPR: {
                    return this.possiblyNull(((JFXIfExpression)expr).getTrueExpression()) || this.possiblyNull(((JFXIfExpression)expr).getFalseExpression());
                }
                case LITERAL: {
                    return expr.getJavaFXKind() == Tree.JavaFXKind.NULL_LITERAL;
                }
                case PARENS: {
                    return this.possiblyNull(((JFXParens)expr).getExpression());
                }
                case SELECT: {
                    return ((JFXSelect)expr).sym instanceof Symbol.VarSymbol;
                }
                case TYPECAST: {
                    return this.possiblyNull(((JFXTypeCast)expr).getExpression());
                }
                case VAR_DEF: {
                    return this.possiblyNull(((JFXVar)expr).getInitializer());
                }
            }
            return false;
        }

        private boolean computeHasSideEffects(JFXExpression expr) {
            this.hse = false;
            new JavafxTreeScanner(){

                private void markSideEffects() {
                    NullCheckTranslator.this.hse = true;
                }

                public void visitBlockExpression(JFXBlock tree) {
                    this.markSideEffects();
                }

                public void visitUnary(JFXUnary tree) {
                    this.markSideEffects();
                }

                public void visitAssign(JFXAssign tree) {
                    this.markSideEffects();
                }

                public void visitAssignop(JFXAssignOp tree) {
                    this.markSideEffects();
                }

                public void visitInstanciate(JFXInstanciate tree) {
                    this.markSideEffects();
                }

                public void visitFunctionInvocation(JFXFunctionInvocation tree) {
                    this.markSideEffects();
                }

                public void visitSelect(JFXSelect tree) {
                    this.markSideEffects();
                }
            }.scan(expr);
            return this.hse;
        }

        protected JCTree doit() {
            JCTree.JCExpression mungedToCheckTranslated = this.translateToCheck(this.toCheck);
            JCTree.JCVariableDecl tmpVar = null;
            if (this.hasSideEffects) {
                tmpVar = JavafxToJava.this.makeTmpVar(this.diagPos, "toCheck", this.toCheck.type, mungedToCheckTranslated);
                this.tmpVarList.append(tmpVar);
                mungedToCheckTranslated = this.m().Ident(tmpVar.name);
            }
            JCTree.JCExpression full = this.fullExpression(mungedToCheckTranslated);
            if (!this.needNullCheck && this.tmpVarList.isEmpty()) {
                return full;
            }
            JCTree.JCExpression toTest = this.hasSideEffects ? this.m().Ident(tmpVar.name) : this.translateToCheck(this.toCheck);
            JCTree.JCBinary cond = this.m().Binary(61, toTest, JavafxToJava.this.make.Literal(17, null));
            if (this.resultType == this.syms.voidType) {
                JCTree.JCStatement stmt = this.m().Exec(full);
                if (this.needNullCheck) {
                    stmt = this.m().If(cond, stmt, null);
                }
                assert (JavafxToJava.this.yield == Yield.ToExecStatement) : "Yield from a void call should always be a statement";
                if (this.tmpVarList.nonEmpty()) {
                    return this.m().Block(0L, this.tmpVarList.toList().append(stmt));
                }
                return stmt;
            }
            if (this.needNullCheck) {
                JavafxTypeMorpher.TypeMorphInfo returnTypeInfo = JavafxToJava.this.typeMorpher.typeMorphInfo(this.resultType);
                JCTree.JCExpression defaultExpr = JavafxToJava.this.makeDefaultValue(this.diagPos, returnTypeInfo);
                if (JavafxToJava.this.wrap == Wrapped.InLocation) {
                    defaultExpr = JavafxToJava.this.makeUnboundLocation(this.diagPos, returnTypeInfo, defaultExpr);
                }
                full = this.m().Conditional(cond, full, defaultExpr);
            }
            if (this.tmpVarList.nonEmpty()) {
                full = JavafxToJava.this.makeBlockExpression(this.diagPos, this.tmpVarList.toList(), full);
            }
            return full;
        }
    }

    static abstract class Translator {
        protected JCDiagnostic.DiagnosticPosition diagPos;
        protected final JavafxToJava toJava;
        protected final JavafxDefs defs;
        protected final JavafxTypes types;
        protected final JavafxSymtab syms;

        Translator(JCDiagnostic.DiagnosticPosition diagPos, JavafxToJava toJava) {
            this.diagPos = diagPos;
            this.toJava = toJava;
            this.defs = toJava.defs;
            this.types = toJava.types;
            this.syms = toJava.syms;
        }

        protected abstract JCTree doit();

        protected TreeMaker m() {
            return this.toJava.make.at(this.diagPos);
        }

        protected JavafxTreeMaker fxm() {
            return this.toJava.fxmake.at(this.diagPos);
        }

        protected JCTree.JCExpression makeExpression(Type type) {
            return this.toJava.makeTypeTree(this.diagPos, type, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Yield {
        ToExpression,
        ToReturnStatement,
        ToExecStatement;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Wrapped {
        InLocation,
        InNothing;

    }
}

