/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.main;

import com.sun.javafx.api.JavafxTaskEvent;
import com.sun.javafx.api.JavafxTaskListener;
import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Messages;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javafx.antlr.JavafxSyntacticAnalysis;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxAnnotate;
import com.sun.tools.javafx.comp.JavafxAttr;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxCheck;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.comp.JavafxEnter;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.comp.JavafxOptimizationStatistics;
import com.sun.tools.javafx.comp.JavafxPrepForBackEnd;
import com.sun.tools.javafx.comp.JavafxToJava;
import com.sun.tools.javafx.comp.JavafxTodo;
import com.sun.tools.javafx.comp.JavafxVarUsageAnalysis;
import com.sun.tools.javafx.main.JavafxJavaCompiler;
import com.sun.tools.javafx.main.Main;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JavaPretty;
import com.sun.tools.javafx.tree.JavafxPretty;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import com.sun.tools.javafx.util.JavafxFileManager;
import com.sun.tools.javafx.util.PlatformPlugin;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxCompiler
implements ClassReader.SourceCompleter {
    private static final String javafxErrorsKey = "com.sun.tools.javafx.resources.javafxcompiler";
    protected static final Context.Key<JavafxCompiler> compilerKey = new Context.Key();
    private static final String versionRBName = "com.sun.tools.javafx.resources.version";
    private static ResourceBundle versionRB;
    private static CompilePolicy DEFAULT_COMPILE_POLICY;
    protected Options options;
    public Log log;
    protected JavafxTreeMaker make;
    protected ClassWriter writer;
    protected JavafxEnter enter;
    protected JavafxSymtab syms;
    protected Source source;
    protected Name.Table names;
    protected JavafxAttr attr;
    protected JavafxCheck chk;
    protected JavafxAnnotate annotate;
    protected JavafxPrepForBackEnd prepForBackEnd;
    protected JavafxOptimizationStatistics optStat;
    protected JavafxJavaCompiler javafxJavaCompiler;
    protected final Name completionFailureName;
    protected Types types;
    protected JavaFileManager fileManager;
    protected JavafxTaskListener taskListener;
    protected JavafxSyntacticAnalysis syntacticAnalysis;
    protected JavafxVarUsageAnalysis varUsageAnalysis;
    protected JavafxToJava jfxToJava;
    protected boolean implicitSourceFilesRead;
    protected Context context;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    boolean relax;
    public boolean printFlat;
    public String encoding;
    public boolean lineDebugInfo;
    protected boolean devVerbose;
    protected boolean processPcks;
    protected boolean explicitAnnotationProcessingRequested;
    protected CompilePolicy compilePolicy;
    protected ImplicitSourcePolicy implicitSourcePolicy;
    public boolean verboseCompilePolicy;
    public JavafxTodo todo;
    private Set<JavafxEnv<JavafxAttrContext>> deferredSugar;
    protected Set<JavaFileObject> inputFiles;
    public boolean keepComments;
    private boolean hasBeenUsed;
    private long start_msec;
    public long elapsed_msec;
    private boolean parseErrors;

    public static JavafxCompiler instance(Context context) {
        JavafxCompiler instance = context.get(compilerKey);
        if (instance == null) {
            instance = new JavafxCompiler(context);
        }
        return instance;
    }

    public static String version() {
        return JavafxCompiler.version("release");
    }

    public static String fullVersion() {
        return JavafxCompiler.version("full");
    }

    private static String version(String key) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException e) {
                return Main.getJavafxLocalizedString("compiler.misc.version.resource.missing", System.getProperty("java.version"));
            }
        }
        try {
            return versionRB.getString(key);
        }
        catch (MissingResourceException e) {
            return Main.getJavafxLocalizedString("compiler.misc.version.unknown", System.getProperty("java.version"));
        }
    }

    public JavafxCompiler(Context context) {
        block2: {
            this.explicitAnnotationProcessingRequested = false;
            this.deferredSugar = new HashSet<JavafxEnv<JavafxAttrContext>>();
            this.inputFiles = new HashSet<JavaFileObject>();
            this.keepComments = false;
            this.hasBeenUsed = false;
            this.start_msec = 0L;
            this.elapsed_msec = 0L;
            this.parseErrors = false;
            this.context = context;
            context.put(compilerKey, this);
            this.registerServices(context);
            JavafxClassReader.instance((Context)context).sourceCompleter = this;
            this.javafxJavaCompiler = JavafxJavaCompiler.instance(context);
            this.names = Name.Table.instance(context);
            this.options = Options.instance(context);
            this.log = Log.instance(context);
            this.make = JavafxTreeMaker.instance(context);
            this.writer = ClassWriter.instance(context);
            this.enter = JavafxEnter.instance(context);
            this.todo = JavafxTodo.instance(context);
            this.fileManager = context.get(JavaFileManager.class);
            this.syntacticAnalysis = JavafxSyntacticAnalysis.instance(context);
            this.varUsageAnalysis = JavafxVarUsageAnalysis.instance(context);
            this.jfxToJava = JavafxToJava.instance(context);
            this.prepForBackEnd = JavafxPrepForBackEnd.instance(context);
            Messages.instance(context).add(javafxErrorsKey);
            try {
                this.syms = (JavafxSymtab)JavafxSymtab.instance(context);
            }
            catch (Symbol.CompletionFailure ex) {
                this.log.error("cant.access", ex.sym, ex.errmsg);
                if (!(ex instanceof ClassReader.BadClassFile)) break block2;
                throw new Abort();
            }
        }
        this.source = Source.instance(context);
        this.attr = JavafxAttr.instance(context);
        this.chk = JavafxCheck.instance(context);
        this.annotate = JavafxAnnotate.instance(context);
        this.optStat = JavafxOptimizationStatistics.instance(context);
        this.types = Types.instance(context);
        this.taskListener = context.get(JavafxTaskListener.class);
        this.verbose = this.options.get("-verbose") != null;
        this.sourceOutput = this.options.get("-printsource") != null;
        this.stubOutput = this.options.get("-stubs") != null;
        this.relax = this.options.get("-relax") != null;
        this.printFlat = this.options.get("-printflat") != null;
        this.attrParseOnly = this.options.get("-attrparseonly") != null;
        this.encoding = this.options.get("-encoding");
        this.lineDebugInfo = this.options.get("-g:") == null || this.options.get("-g:lines") != null;
        this.devVerbose = this.options.get("dev") != null;
        this.processPcks = this.options.get("process.packages") != null;
        this.verboseCompilePolicy = this.options.get("verboseCompilePolicy") != null;
        this.compilePolicy = this.attrParseOnly ? CompilePolicy.ATTR_ONLY : CompilePolicy.decode(this.options.get("compilePolicy"));
        this.implicitSourcePolicy = ImplicitSourcePolicy.decode(this.options.get("-implicit"));
        this.completionFailureName = this.options.get("failcomplete") != null ? this.names.fromString(this.options.get("failcomplete")) : null;
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    protected final <T> List<T> stopIfError(ListBuffer<T> listBuffer) {
        if (this.errorCount() == 0) {
            return listBuffer.toList();
        }
        return List.nil();
    }

    protected final <T> List<T> stopIfError(List<T> list) {
        if (this.errorCount() == 0) {
            return list;
        }
        return List.nil();
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public CharSequence readSource(JavaFileObject filename) {
        try {
            this.inputFiles.add(filename);
            return filename.getCharContent(false);
        }
        catch (IOException e) {
            this.log.error("error.reading.file", filename, e.getLocalizedMessage());
            return null;
        }
    }

    protected JFXScript parse(JavaFileObject filename, CharSequence content) {
        long msec = JavafxCompiler.now();
        JFXScript tree = null;
        if (content != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", filename);
            }
            if (this.taskListener != null) {
                JavafxTaskEvent e = new JavafxTaskEvent(TaskEvent.Kind.PARSE, filename);
                this.taskListener.started(e);
            }
            int initialErrorCount = this.log.nerrors;
            tree = this.syntacticAnalysis.parse(content, filename.getName());
            this.parseErrors |= this.log.nerrors > initialErrorCount;
            if (tree != null && this.lineDebugInfo) {
                String hunk = ((Object)content).toString();
                tree.lineMap = Position.makeLineMap(hunk.toCharArray(), hunk.length(), false);
            }
        }
        if (this.verbose) {
            this.printVerbose("parsing.done", Long.toString(JavafxCompiler.elapsed(msec)));
        }
        if (tree == null) {
            tree = this.make.Script(null, List.<JFXTree>nil());
        }
        tree.sourcefile = filename;
        this.printJavafxSource(tree, content);
        if (content != null && this.taskListener != null) {
            JavafxTaskEvent e = new JavafxTaskEvent(TaskEvent.Kind.PARSE, tree);
            this.taskListener.finished(e);
        }
        return tree;
    }

    protected boolean keepComments() {
        return this.keepComments || this.sourceOutput || this.stubOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFXScript parse(JavaFileObject filename) {
        JavaFileObject prev = this.log.useSource(filename);
        try {
            JFXScript t = this.parse(filename, this.readSource(filename));
            if (t.endPositions != null) {
                this.log.setEndPosTable(filename, t.endPositions);
            }
            JFXScript jFXScript = t;
            return jFXScript;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printJavaSource(JavafxEnv<JavafxAttrContext> env) {
        String dump = this.options.get("dumpjava");
        if (dump != null) {
            try {
                String fn = env.toplevel.sourcefile.toString().replace(".fx", ".javadump");
                File outFile = new File(dump, new File(fn).getName());
                FileWriter fw = new FileWriter(outFile);
                BufferedWriter out = new BufferedWriter(fw);
                try {
                    new JavaPretty(out, true, this.context).printUnit(env.translatedToplevel, null);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException ex) {
                System.err.println("Exception thrown in JavaFX pretty printing: " + ex);
            }
        }
    }

    void printOptimizationStatistics(JavafxEnv<JavafxAttrContext> env) {
        String which = this.options.get("optstats");
        if (which != null) {
            this.optStat.printData(which);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printJavafxSource(JFXScript cu, CharSequence content) {
        String dump = this.options.get("dumpfx");
        BufferedWriter out = null;
        if (dump != null) {
            try {
                try {
                    String fn = cu.sourcefile.toString().replace(".fx", ".fxdump");
                    File outFile = new File(dump, new File(fn).getName());
                    FileWriter fw = new FileWriter(outFile);
                    out = new BufferedWriter(fw);
                    new JavafxPretty(out, true, content).printUnit(cu);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (IOException ex) {
                System.err.println("Exception thrown in JavaFX pretty printing: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol.ClassSymbol c) throws Symbol.CompletionFailure {
        JavafxTaskEvent e;
        JFXScript tree;
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure(c, "user-selected completion failure by class name");
        }
        JavaFileObject filename = c.classfile;
        JavaFileObject prev = this.log.useSource(filename);
        try {
            tree = this.parse(filename, filename.getCharContent(false));
        }
        catch (IOException e2) {
            this.log.error("error.reading.file", filename, e2);
            tree = this.make.Script(null, List.<JFXTree>nil());
        }
        finally {
            this.log.useSource(prev);
        }
        if (this.taskListener != null) {
            e = new JavafxTaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.started(e);
        }
        this.enter.complete(List.of(tree), c);
        if (this.taskListener != null) {
            e = new JavafxTaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.finished(e);
        }
        if (this.enter.getEnv(c) == null) {
            boolean isPkgInfo = tree.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            if (isPkgInfo) {
                if (this.enter.getEnv(tree.packge) == null) {
                    String msg = Log.getLocalizedString("file.does.not.contain.package", c.location());
                    throw new ClassReader.BadClassFile(c, filename, msg);
                }
            } else {
                throw new ClassReader.BadClassFile(c, filename, Log.getLocalizedString("file.doesnt.contain.class", c.fullname));
            }
        }
        this.implicitSourceFilesRead = true;
    }

    public void compile(List<JavaFileObject> sourceFileObject) throws Throwable {
        this.compile(sourceFileObject, List.<String>nil());
    }

    public void compile(List<JavaFileObject> sourceFileObjects, List<String> classnames) throws IOException {
        block4: {
            if (this.hasBeenUsed) {
                throw new AssertionError((Object)"attempt to reuse JavaCompiler");
            }
            this.hasBeenUsed = true;
            this.start_msec = JavafxCompiler.now();
            try {
                List<JFXScript> cus = this.stopIfError(this.parseFiles(sourceFileObjects));
                this.enterTrees(cus);
                this.compile2(null);
                if (this.attr != null) {
                    this.attr.clearCaches();
                }
                this.close();
            }
            catch (Abort ex) {
                if (!this.devVerbose) break block4;
                ex.printStackTrace();
            }
        }
    }

    public List<JavafxEnv<JavafxAttrContext>> jfxToJava(List<JavafxEnv<JavafxAttrContext>> envs) {
        ListBuffer<JavafxEnv<JavafxAttrContext>> results = ListBuffer.lb();
        List<JavafxEnv<JavafxAttrContext>> l = envs;
        while (l.nonEmpty()) {
            this.jfxToJava((JavafxEnv)l.head, results);
            l = l.tail;
        }
        return this.stopIfError(results);
    }

    public List<JavafxEnv<JavafxAttrContext>> jfxToJava(JavafxEnv<JavafxAttrContext> env) {
        ListBuffer<JavafxEnv<JavafxAttrContext>> results = ListBuffer.lb();
        this.jfxToJava(env, results);
        return this.stopIfError(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jfxToJava(JavafxEnv<JavafxAttrContext> env, ListBuffer<JavafxEnv<JavafxAttrContext>> results) {
        try {
            if (this.errorCount() > 0) {
                return;
            }
            if (this.relax || this.deferredSugar.contains(env)) {
                results.append(env);
                return;
            }
            if (this.verboseCompilePolicy) {
                Log.printLines(this.log.noticeWriter, "[flow " + env.enclClass.sym + "]");
            }
            JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                this.make.at(0);
                this.jfxToJava.toJava(env);
                if (this.errorCount() > 0) {
                    return;
                }
                results.append(env);
            }
            catch (RuntimeException ex) {
                if (env.where != null) {
                    this.log.note(env.where, "javafx.internal.error", new Object[0]);
                }
                throw ex;
            }
            finally {
                this.log.useSource(prev);
            }
        }
        finally {
            if (this.taskListener != null) {
                JavafxTaskEvent e = new JavafxTaskEvent(TaskEvent.Kind.ANALYZE, env.translatedToplevel, (TypeElement)env.enclClass.sym);
                this.taskListener.finished(e);
            }
        }
    }

    private void compile2(ListBuffer<JavaFileObject> results) throws IOException {
        block14: {
            try {
                switch (this.compilePolicy) {
                    case ATTR_ONLY: {
                        this.attribute(this.todo);
                        break;
                    }
                    case CHECK_ONLY: {
                        this.backEnd(this.prepForBackEnd(this.jfxToJava(this.varAnalysis(this.attribute(this.todo)))), results);
                        break;
                    }
                    case SIMPLE: {
                        this.backEnd(this.prepForBackEnd(this.jfxToJava(this.varAnalysis(this.attribute(this.todo)))), results);
                        break;
                    }
                    case BY_FILE: {
                        ListBuffer envbuff = ListBuffer.lb();
                        for (List<JavafxEnv<JavafxAttrContext>> list : this.groupByFile(this.jfxToJava(this.varAnalysis(this.attribute(this.todo)))).values()) {
                            envbuff.appendList(this.prepForBackEnd(list));
                        }
                        this.backEnd(envbuff.toList(), results);
                        break;
                    }
                    case BY_TODO: {
                        ListBuffer envbuff = ListBuffer.lb();
                        while (this.todo.nonEmpty()) {
                            envbuff.append(this.attribute((JavafxEnv)this.todo.next()));
                        }
                        this.backEnd(this.prepForBackEnd(this.jfxToJava(this.varAnalysis(this.stopIfError(envbuff)))), results);
                        break;
                    }
                    default: {
                        assert (false) : "unknown compile policy";
                        break;
                    }
                }
            }
            catch (Abort ex) {
                if (!this.devVerbose) break block14;
                ex.printStackTrace();
            }
        }
        if (this.verbose) {
            this.elapsed_msec = JavafxCompiler.elapsed(this.start_msec);
            this.printVerbose("total", Long.toString(this.elapsed_msec));
        }
        this.reportDeferredDiagnostics();
        if (!this.log.hasDiagnosticListener()) {
            this.printCount("error", this.errorCount());
            this.printCount("warn", this.warningCount());
        }
        ((JavafxTypes)this.types).clearCaches();
    }

    public void generate(List<JavafxEnv<JavafxAttrContext>> genlist, ListBuffer<JavaFileObject> results) throws IOException {
        this.todo.appendList(genlist);
        this.compile2(results);
    }

    private void backEnd(List<JavafxEnv<JavafxAttrContext>> envs, ListBuffer<JavaFileObject> results) throws IOException {
        ListBuffer<JCTree.JCCompilationUnit> javaTrees = ListBuffer.lb();
        for (JavafxEnv<JavafxAttrContext> env : envs) {
            javaTrees.append(env.translatedToplevel);
        }
        PlatformPlugin plugin = PlatformPlugin.instance(this.context);
        if (plugin != null) {
            plugin.process(javaTrees);
            if (Log.instance((Context)this.context).nerrors > 0) {
                return;
            }
        }
        this.javafxJavaCompiler.backEnd(javaTrees.toList(), results);
    }

    public List<JFXScript> parseFiles(List<JavaFileObject> fileObjects) throws IOException {
        if (this.errorCount() > 0) {
            return List.nil();
        }
        ListBuffer trees = ListBuffer.lb();
        for (JavaFileObject fileObject : fileObjects) {
            trees.append(this.parse(fileObject));
        }
        return trees.toList();
    }

    public List<JFXScript> enterTrees(List<JFXScript> roots) {
        JavafxTaskEvent e;
        if (this.taskListener != null) {
            for (JFXScript unit : roots) {
                e = new JavafxTaskEvent(TaskEvent.Kind.ENTER, unit);
                this.taskListener.started(e);
            }
        }
        this.enter.main(roots);
        if (this.taskListener != null) {
            for (JFXScript unit : roots) {
                e = new JavafxTaskEvent(TaskEvent.Kind.ENTER, unit);
                this.taskListener.finished(e);
            }
        }
        if (this.sourceOutput || this.stubOutput) {
            ListBuffer cdefs = ListBuffer.lb();
            for (JFXScript unit : roots) {
                List<JFXTree> defs = unit.defs;
                while (defs.nonEmpty()) {
                    if (defs.head instanceof JFXClassDeclaration) {
                        cdefs.append((JFXClassDeclaration)defs.head);
                    }
                    defs = defs.tail;
                }
            }
        }
        return roots;
    }

    public void errorCheck() throws IOException {
        this.backEnd(this.prepForBackEnd(this.jfxToJava(this.varAnalysis(this.attribute(this.todo)))), null);
    }

    public List<JavafxEnv<JavafxAttrContext>> attribute() {
        return this.attribute(this.todo);
    }

    public List<JavafxEnv<JavafxAttrContext>> attribute(ListBuffer<JavafxEnv<JavafxAttrContext>> envs) {
        ListBuffer results = ListBuffer.lb();
        while (envs.nonEmpty()) {
            results.append(this.attribute(envs.next()));
        }
        return results.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavafxEnv<JavafxAttrContext> attribute(JavafxEnv<JavafxAttrContext> env) {
        if (this.verboseCompilePolicy) {
            Log.printLines(this.log.noticeWriter, "[attribute " + env.enclClass.sym + "]");
        }
        if (this.verbose) {
            this.printVerbose("checking.attribution", env.enclClass.sym);
        }
        if (this.taskListener != null) {
            JavafxTaskEvent e = new JavafxTaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, (TypeElement)env.enclClass.sym);
            this.taskListener.started(e);
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            this.attr.attribClass(env.tree.pos(), env.tree instanceof JFXClassDeclaration ? (JFXClassDeclaration)env.tree : null, env.enclClass.sym);
        }
        finally {
            this.log.useSource(prev);
        }
        if (this.taskListener != null) {
            JavafxTaskEvent e = new JavafxTaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, (TypeElement)env.enclClass.sym);
            this.taskListener.finished(e);
        }
        return env;
    }

    public List<JavafxEnv<JavafxAttrContext>> varAnalysis(List<JavafxEnv<JavafxAttrContext>> envs) {
        List<JavafxEnv<JavafxAttrContext>> l = envs;
        while (l.nonEmpty()) {
            this.varAnalysis((JavafxEnv)l.head);
            l = l.tail;
        }
        return envs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavafxEnv<JavafxAttrContext> varAnalysis(JavafxEnv<JavafxAttrContext> env) {
        if (this.verboseCompilePolicy) {
            Log.printLines(this.log.noticeWriter, "[type-morph " + env.enclClass.sym + "]");
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            this.varUsageAnalysis.analyzeVarUse(env);
        }
        finally {
            this.log.useSource(prev);
        }
        return env;
    }

    public List<JavafxEnv<JavafxAttrContext>> prepForBackEnd(List<JavafxEnv<JavafxAttrContext>> envs) {
        List<JavafxEnv<JavafxAttrContext>> l = envs;
        while (l.nonEmpty()) {
            this.prepForBackEnd((JavafxEnv)l.head);
            l = l.tail;
        }
        return envs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavafxEnv<JavafxAttrContext> prepForBackEnd(JavafxEnv<JavafxAttrContext> env) {
        if (this.verboseCompilePolicy) {
            Log.printLines(this.log.noticeWriter, "[prep-for-back-end " + env.enclClass.sym + "]");
        }
        this.printJavaSource(env);
        this.printOptimizationStatistics(env);
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            this.prepForBackEnd.prep(env);
        }
        finally {
            this.log.useSource(prev);
        }
        return env;
    }

    Map<JFXScript, List<JavafxEnv<JavafxAttrContext>>> groupByFile(List<JavafxEnv<JavafxAttrContext>> list) {
        LinkedHashMap<JFXScript, List<JavafxEnv<JavafxAttrContext>>> map = new LinkedHashMap<JFXScript, List<JavafxEnv<JavafxAttrContext>>>();
        HashSet<JFXScript> fixupSet = new HashSet<JFXScript>();
        List<JavafxEnv<JavafxAttrContext>> l = list;
        while (l.nonEmpty()) {
            JavafxEnv env = (JavafxEnv)l.head;
            List<JavafxEnv> sublist = (List<JavafxEnv>)map.get(env.toplevel);
            if (sublist == null) {
                sublist = List.of(env);
            } else {
                sublist = sublist.prepend(env);
                fixupSet.add(env.toplevel);
            }
            map.put(env.toplevel, sublist);
            l = l.tail;
        }
        for (JFXScript tree : fixupSet) {
            map.put(tree, ((List)map.get(tree)).reverse());
        }
        return map;
    }

    public void reportDeferredDiagnostics() {
        this.chk.reportDeferredDiagnostics();
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean disposeNames) {
        this.make = null;
        this.writer = null;
        this.enter = null;
        if (this.todo != null) {
            this.todo.clear();
        }
        this.todo = null;
        this.syms = null;
        this.source = null;
        this.attr = null;
        this.chk = null;
        this.annotate = null;
        this.types = null;
        this.log.flush();
        try {
            this.fileManager.flush();
        }
        catch (IOException e) {
            throw new Abort(e);
        }
        finally {
            if (this.names != null && disposeNames) {
                this.names.dispose();
            }
            this.names = null;
        }
    }

    protected void printVerbose(String key, Object arg) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + key, arg));
    }

    protected void printCount(String kind, int count) {
        if (count != 0) {
            String text = count == 1 ? Log.getLocalizedString("count." + kind, String.valueOf(count)) : Log.getLocalizedString("count." + kind + ".plural", String.valueOf(count));
            Log.printLines(this.log.errWriter, text);
            this.log.errWriter.flush();
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static long elapsed(long then) {
        return JavafxCompiler.now() - then;
    }

    public void initRound(JavafxCompiler prev) {
        this.keepComments = prev.keepComments;
        this.start_msec = prev.start_msec;
        this.hasBeenUsed = true;
    }

    public static void enableLogging() {
        Logger logger = Logger.getLogger(com.sun.tools.javac.Main.class.getPackage().getName());
        logger.setLevel(Level.ALL);
        for (Handler h : logger.getParent().getHandlers()) {
            h.setLevel(Level.ALL);
        }
    }

    protected void registerServices(Context context) {
        if (context.get(JavaFileManager.class) == null) {
            JavafxFileManager.preRegister(context);
        }
        JavafxSymtab.preRegister(context);
        JavafxTypes.preRegister(context);
    }

    static {
        DEFAULT_COMPILE_POLICY = CompilePolicy.BY_TODO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImplicitSourcePolicy {
        NONE,
        CLASS,
        UNSET;


        static ImplicitSourcePolicy decode(String option) {
            if (option == null) {
                return UNSET;
            }
            if (option.equals("none")) {
                return NONE;
            }
            if (option.equals("class")) {
                return CLASS;
            }
            return UNSET;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompilePolicy {
        ATTR_ONLY,
        CHECK_ONLY,
        SIMPLE,
        BY_FILE,
        BY_TODO;


        static CompilePolicy decode(String option) {
            if (option == null) {
                return DEFAULT_COMPILE_POLICY;
            }
            if (option.equals("attr")) {
                return ATTR_ONLY;
            }
            if (option.equals("check")) {
                return CHECK_ONLY;
            }
            if (option.equals("simple")) {
                return SIMPLE;
            }
            if (option.equals("byfile")) {
                return BY_FILE;
            }
            if (option.equals("bytodo")) {
                return BY_TODO;
            }
            return DEFAULT_COMPILE_POLICY;
        }
    }
}

