/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.script;

import com.sun.tools.javafx.script.JavaFXScriptEngineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFXScriptEngineFactory
implements ScriptEngineFactory {
    private static long nextClassNum = 0L;
    private static List<String> names = new ArrayList<String>(1);
    private static List<String> extensions;
    private static List<String> mimeTypes;

    @Override
    public String getEngineName() {
        return "JavaFX Script Engine";
    }

    @Override
    public String getEngineVersion() {
        return "1.0";
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "javafx";
    }

    @Override
    public String getLanguageVersion() {
        return "1.0";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(obj);
        buf.append(".");
        buf.append(m);
        buf.append("(");
        if (args.length != 0) {
            int i;
            for (i = 0; i < args.length - 1; ++i) {
                buf.append(args[i] + ", ");
            }
            buf.append(args[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        buf.append("java.lang.System.out.print(\"");
        int len = toDisplay.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\");");
        return buf.toString();
    }

    @Override
    public String getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < statements.length; ++i) {
            sb.append(statements[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        JavaFXScriptEngineImpl engine = new JavaFXScriptEngineImpl();
        engine.setFactory(this);
        return engine;
    }

    static {
        names.add("fx");
        extensions = Collections.unmodifiableList(names);
        names.add("javafx");
        names = Collections.unmodifiableList(names);
        mimeTypes = new ArrayList<String>(0);
        mimeTypes.add("application/x-javafx-source");
        mimeTypes = Collections.unmodifiableList(mimeTypes);
    }
}

