/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.script;

import com.sun.javafx.api.JavaFXScriptEngine;
import com.sun.javafx.api.JavafxcTask;
import com.sun.javafx.api.tree.ExpressionTree;
import com.sun.javafx.api.tree.SourcePositions;
import com.sun.javafx.api.tree.UnitTree;
import com.sun.javafx.runtime.Entry;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javafx.api.JavafxcTool;
import com.sun.tools.javafx.api.JavafxcTrees;
import com.sun.tools.javafx.script.JavaFXScriptCompiler;
import com.sun.tools.javafx.script.JavaFXScriptEngineFactory;
import com.sun.tools.javafx.script.MemoryClassLoader;
import com.sun.tools.javafx.script.MemoryFileManager;
import com.sun.tools.javafx.script.ScriptContextManager;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXTree;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFXScriptEngineImpl
extends AbstractScriptEngine
implements JavaFXScriptEngine {
    private static final String SCRIPT_CONTEXT_NAME = "javafx$ctx";
    private JavaFXScriptCompiler compiler;
    private LinkedList<Class> scripts = new LinkedList();
    private ScriptEngineFactory factory;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private ClassLoader parentClassLoader = this.getClass().getClassLoader();
    private static final String SYSPROP_PREFIX = "com.sun.tools.javafx.script.";
    private static final String SOURCEPATH = "sourcepath";
    private static final String CLASSPATH = "classpath";
    private static Map<Class, Class> wrappers = new HashMap<Class, Class>();

    public JavaFXScriptEngineImpl() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            this.parentClassLoader = cl;
        }
        this.compiler = new JavaFXScriptCompiler(this.parentClassLoader);
    }

    public List<Diagnostic<? extends JavaFileObject>> getLastDiagnostics() {
        return this.diagnostics == null ? null : this.diagnostics.getDiagnostics();
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(script, null);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public CompiledScript compile(String script, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        Class clazz = this.parse(script, this.context, listener, true);
        this.scripts.addFirst(clazz);
        return new JavafxScriptCompiledScript(clazz);
    }

    @Override
    public CompiledScript compile(Reader script, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        return this.compile(this.readFully(script), listener);
    }

    @Override
    public Object eval(String script, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        return this.eval(script, this.getContext(), listener);
    }

    @Override
    public Object eval(Reader script, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        return this.eval(script, this.getContext(), listener);
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval(str, ctx, null);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    @Override
    public Object eval(String script, ScriptContext context, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        Class clazz = this.parse(script, context, listener, false);
        this.scripts.addFirst(clazz);
        return JavaFXScriptEngineImpl.evalClass(clazz, context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        return this.eval(this.readFully(reader), context, listener);
    }

    @Override
    public Object eval(String script, Bindings bindings, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        ScriptContext ctx = this.getContext();
        ctx.setBindings(bindings, 100);
        return this.eval(script, ctx, listener);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings, DiagnosticListener<JavaFileObject> listener) throws ScriptException {
        ScriptContext ctx = this.getContext();
        ctx.setBindings(bindings, 100);
        return this.eval(reader, ctx, listener);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            this.factory = new JavaFXScriptEngineFactory();
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private Class parse(String str, ScriptContext ctx, final DiagnosticListener<JavaFileObject> listener, boolean inferBindings) throws ScriptException {
        Iterable<Class> classes;
        String fileName = JavaFXScriptEngineImpl.getFileName(ctx);
        String sourcePath = JavaFXScriptEngineImpl.getSourcePath(ctx);
        String classPath = JavaFXScriptEngineImpl.getClassPath(ctx);
        String script = str;
        this.diagnostics = new DiagnosticCollector();
        DiagnosticListener<JavaFileObject> diagnosticListener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> rep) {
                if (listener != null) {
                    listener.report(rep);
                }
                JavaFXScriptEngineImpl.this.diagnostics.report(rep);
            }
        };
        DiagnosticCollector<JavaFileObject> firstCollector = new DiagnosticCollector<JavaFileObject>();
        Map<String, byte[]> classBytes = this.compiler.compile(fileName, script, ctx.getErrorWriter(), sourcePath, classPath, firstCollector, false);
        if (firstCollector.getDiagnostics().size() > 0) {
            boolean recompile = false;
            HashSet<String> attrs = new HashSet<String>();
            for (Diagnostic<JavaFileObject> d : firstCollector.getDiagnostics()) {
                Object[] args;
                if (!d.getCode().equals("compiler.err.cant.resolve.location") || (args = ((JCDiagnostic)d).getArgs()).length < 2 || !(args[1] instanceof String)) continue;
                attrs.add((String)args[1]);
                recompile = true;
            }
            if (recompile) {
                String binding = this.makeBindingStatement(ctx, attrs, inferBindings);
                int bindingInsert = 0;
                try {
                    UnitTree unit;
                    ExpressionTree pkg;
                    JavafxcTool tool = JavafxcTool.create();
                    MemoryFileManager manager = new MemoryFileManager(tool.getStandardFileManager(this.diagnostics, (Locale)null, (Charset)null), this.parentClassLoader);
                    ArrayList<JavaFileObject> compUnits = new ArrayList<JavaFileObject>(1);
                    compUnits.add(manager.makeStringSource(fileName, script));
                    JavafxcTask task = tool.getTask(null, manager, this.diagnostics, null, compUnits);
                    Iterable<? extends UnitTree> units = task.parse();
                    if (units.iterator().hasNext() && (pkg = (unit = units.iterator().next()).getPackageName()) != null) {
                        SourcePositions positions = JavafxcTrees.instance(task).getSourcePositions();
                        JFXTree firstDef = (JFXTree)((JFXScript)unit).defs.head;
                        bindingInsert = (int)positions.getStartPosition(unit, firstDef);
                    }
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                script = str.substring(0, bindingInsert) + binding + str.substring(bindingInsert);
                classBytes = this.compiler.compile(fileName, script, ctx.getErrorWriter(), sourcePath, classPath, diagnosticListener, true);
            } else {
                for (Diagnostic<JavaFileObject> d : firstCollector.getDiagnostics()) {
                    diagnosticListener.report(d);
                }
                JavaFXScriptCompiler.printDiagnostics(this.diagnostics, ctx.getErrorWriter());
            }
        }
        if (classBytes == null) {
            throw new ScriptException("compilation failed");
        }
        URL sourceURL = null;
        if (fileName != null) {
            try {
                sourceURL = new File(fileName).toURI().toURL();
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        MemoryClassLoader loader = new MemoryClassLoader(sourceURL, classBytes, classPath, this.parentClassLoader);
        try {
            classes = loader.loadAll();
        }
        catch (ClassNotFoundException exp) {
            throw new ScriptException(exp);
        }
        Class c = JavaFXScriptEngineImpl.findMainClass(classes);
        if (c == null) {
            throw new ScriptException("no main class found");
        }
        return c;
    }

    private static Class findMainClass(Iterable<Class> classes) {
        for (Class clazz : classes) {
            Method mainMethod;
            int modifiers = clazz.getModifiers();
            if (!Modifier.isPublic(modifiers) || (mainMethod = JavaFXScriptEngineImpl.findMainMethod(clazz)) == null) continue;
            return clazz;
        }
        for (Class clazz : classes) {
            Method mainMethod = JavaFXScriptEngineImpl.findMainMethod(clazz);
            if (mainMethod == null) continue;
            return clazz;
        }
        return null;
    }

    private static Method findMainMethod(Class clazz) {
        block3: {
            try {
                Method mainMethod = clazz.getMethod(Entry.entryMethodName(), Sequence.class);
                int modifiers = mainMethod.getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                    return mainMethod;
                }
            }
            catch (NoSuchMethodException nsme) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)nsme);
            }
        }
        return null;
    }

    private static String getFileName(ScriptContext ctx) {
        int scope = ctx.getAttributesScope("javax.script.filename");
        if (scope != -1) {
            return ctx.getAttribute("javax.script.filename", scope).toString();
        }
        return "___FX_SCRIPT___.fx";
    }

    private static String getScriptKey(ScriptContext ctx) {
        return "script-context";
    }

    private static String getSourcePath(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(SOURCEPATH);
        if (scope != -1) {
            return ctx.getAttribute(SOURCEPATH).toString();
        }
        return System.getProperty("com.sun.tools.javafx.script.sourcepath");
    }

    private static String getClassPath(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(CLASSPATH);
        if (scope != -1) {
            return ctx.getAttribute(CLASSPATH).toString();
        }
        String res = System.getProperty("com.sun.tools.javafx.script.classpath");
        if (res == null) {
            res = System.getProperty("java.class.path");
        }
        return res;
    }

    private static Object evalClass(Class clazz, ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        if (clazz == null) {
            return null;
        }
        String scriptKey = JavaFXScriptEngineImpl.getScriptKey(ctx);
        try {
            ScriptContextManager.putContext(scriptKey, ctx);
            Object result = null;
            Method mainMethod = JavaFXScriptEngineImpl.findMainMethod(clazz);
            if (mainMethod != null) {
                boolean isPublicClazz = Modifier.isPublic(clazz.getModifiers());
                if (!isPublicClazz) {
                    mainMethod.setAccessible(true);
                }
                Sequence args = TypeInfo.String.emptySequence;
                result = mainMethod.invoke(null, args);
            }
            Object object = result;
            return object;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            Throwable cause = exp.getCause();
            if (cause != null) {
                System.err.println("Cause:");
                cause.printStackTrace();
            }
            throw new ScriptException(exp);
        }
        finally {
            ScriptContextManager.removeContext(scriptKey);
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private String makeBindingStatement(ScriptContext ctx, Set<String> attrs, boolean inferBindings) {
        if (attrs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var ");
        sb.append(SCRIPT_CONTEXT_NAME);
        sb.append(":javax.script.ScriptContext = ");
        sb.append("com.sun.tools.javafx.script.ScriptContextManager.getContext(\"");
        sb.append(JavaFXScriptEngineImpl.getScriptKey(ctx));
        sb.append("\"); ");
        for (String attr : attrs) {
            Object value = ctx.getAttribute(attr);
            if (value == null && !inferBindings) continue;
            sb.append("var ");
            sb.append(attr);
            String type = null;
            if (value != null && (type = value.getClass().getCanonicalName()) != null) {
                sb.append(':');
                sb.append(type);
            }
            sb.append(" = ");
            sb.append(SCRIPT_CONTEXT_NAME);
            sb.append(".getAttribute(\"");
            sb.append(attr);
            sb.append("\")");
            if (value != null) {
                sb.append(" as ");
                sb.append(type);
            }
            sb.append("; ");
        }
        return sb.toString();
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new ScriptException("target object not specified");
        }
        if (name == null) {
            throw new ScriptException("method name not specified");
        }
        Method method = JavaFXScriptEngineImpl.findMethod(thiz.getClass(), name, args);
        if (method == null) {
            throw new ScriptException(new NoSuchMethodException());
        }
        try {
            method.setAccessible(true);
            return method.invoke(thiz, args);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new ScriptException("method name not specified");
        }
        for (Class script : this.scripts) {
            Method method = JavaFXScriptEngineImpl.findMethod(script, name, args);
            if (method == null) continue;
            try {
                Constructor cons = this.findDefaultConstructor(script);
                cons.setAccessible(true);
                Object instance = cons.newInstance(new Object[0]);
                method.setAccessible(true);
                return method.invoke(instance, args);
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
        throw new ScriptException(new NoSuchMethodException(name));
    }

    private static Method findMethod(Class clazz, String name, Object[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        try {
            return clazz.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equals(name)) continue;
                if (m.isVarArgs()) {
                    return m;
                }
                Class[] parameters = m.getParameterTypes();
                if (args.length != parameters.length || !JavaFXScriptEngineImpl.argsMatch(argTypes, parameters)) continue;
                return m;
            }
            return null;
        }
    }

    private Constructor findDefaultConstructor(Class script) throws NoSuchMethodException {
        Constructor<?>[] cs;
        for (Constructor<?> c : cs = script.getDeclaredConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return c;
        }
        throw new NoSuchMethodException("default constructor");
    }

    private static boolean argsMatch(Class[] argTypes, Class[] parameterTypes) {
        for (int i = 0; i < argTypes.length; ++i) {
            Class arg = argTypes[i];
            Class param = parameterTypes[i];
            if (param.isPrimitive()) {
                param = wrappers.get(param);
            }
            if (param != null && param.isAssignableFrom(arg)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clazz) {
        if (thiz == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(thiz, clazz);
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        final Object thiz = obj;
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                if (thiz == null) {
                    return JavaFXScriptEngineImpl.this.invokeFunction(m.getName(), args);
                }
                return JavaFXScriptEngineImpl.this.invokeMethod(thiz, m.getName(), args);
            }
        });
    }

    public Object invoke(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeFunction(name, args);
    }

    public Object invoke(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethod(thiz, name, args);
    }

    static {
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Short.TYPE, Short.class);
    }

    private class JavafxScriptCompiledScript
    extends CompiledScript {
        private Class clazz;

        JavafxScriptCompiledScript(Class clazz) {
            this.clazz = clazz;
        }

        public ScriptEngine getEngine() {
            return JavaFXScriptEngineImpl.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JavaFXScriptEngineImpl.evalClass(this.clazz, ctx);
        }

        public String getName() {
            return this.clazz.getName();
        }
    }
}

