/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryClassLoader
extends URLClassLoader {
    private Map<String, byte[]> classBytes;
    private URL source;

    public MemoryClassLoader(URL source, Map<String, byte[]> classBytes, String classPath, ClassLoader parent) {
        super(MemoryClassLoader.toURLs(classPath), parent);
        this.source = source;
        this.classBytes = classBytes;
    }

    public Class load(String className) throws ClassNotFoundException {
        return this.loadClass(className);
    }

    public Iterable<Class> loadAll() throws ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>(this.classBytes.size());
        for (String name : this.classBytes.keySet()) {
            classes.add(this.loadClass(name));
        }
        return classes;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        byte[] buf = this.classBytes.get(className);
        if (buf != null) {
            this.classBytes.put(className, null);
            return this.defineClass(className, buf, 0, buf.length);
        }
        return super.findClass(className);
    }

    @Override
    public URL findResource(String name) {
        if (name.endsWith(".class") && this.classBytes.containsKey(name = name.substring(0, name.length() - 6).replace('/', '.'))) {
            return this.source;
        }
        return super.findResource(name);
    }

    private static URL[] toURLs(String classPath) {
        if (classPath == null) {
            return new URL[0];
        }
        ArrayList<URL> list = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            File file = new File(token);
            if (file.exists()) {
                try {
                    list.add(file.toURI().toURL());
                }
                catch (MalformedURLException mue) {}
                continue;
            }
            try {
                list.add(new URL(token));
            }
            catch (MalformedURLException mue) {}
        }
        URL[] res = new URL[list.size()];
        list.toArray(res);
        return res;
    }
}

