/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.tree;

import com.sun.javafx.api.JavafxBindStatus;
import com.sun.javafx.api.tree.ForExpressionInClauseTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.tree.JFXAssign;
import com.sun.tools.javafx.tree.JFXAssignOp;
import com.sun.tools.javafx.tree.JFXBinary;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXBreak;
import com.sun.tools.javafx.tree.JFXCatch;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXContinue;
import com.sun.tools.javafx.tree.JFXErroneous;
import com.sun.tools.javafx.tree.JFXErroneousBlock;
import com.sun.tools.javafx.tree.JFXErroneousForExpressionInClause;
import com.sun.tools.javafx.tree.JFXErroneousVar;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXForExpression;
import com.sun.tools.javafx.tree.JFXForExpressionInClause;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXFunctionValue;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXIfExpression;
import com.sun.tools.javafx.tree.JFXImport;
import com.sun.tools.javafx.tree.JFXIndexof;
import com.sun.tools.javafx.tree.JFXInitDefinition;
import com.sun.tools.javafx.tree.JFXInstanceOf;
import com.sun.tools.javafx.tree.JFXInstanciate;
import com.sun.tools.javafx.tree.JFXInterpolateValue;
import com.sun.tools.javafx.tree.JFXKeyFrameLiteral;
import com.sun.tools.javafx.tree.JFXLiteral;
import com.sun.tools.javafx.tree.JFXModifiers;
import com.sun.tools.javafx.tree.JFXObjectLiteralPart;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXParens;
import com.sun.tools.javafx.tree.JFXPostInitDefinition;
import com.sun.tools.javafx.tree.JFXReturn;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXSequenceDelete;
import com.sun.tools.javafx.tree.JFXSequenceEmpty;
import com.sun.tools.javafx.tree.JFXSequenceExplicit;
import com.sun.tools.javafx.tree.JFXSequenceIndexed;
import com.sun.tools.javafx.tree.JFXSequenceInsert;
import com.sun.tools.javafx.tree.JFXSequenceRange;
import com.sun.tools.javafx.tree.JFXSequenceSlice;
import com.sun.tools.javafx.tree.JFXSkip;
import com.sun.tools.javafx.tree.JFXStringExpression;
import com.sun.tools.javafx.tree.JFXThrow;
import com.sun.tools.javafx.tree.JFXTimeLiteral;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXTry;
import com.sun.tools.javafx.tree.JFXType;
import com.sun.tools.javafx.tree.JFXTypeAny;
import com.sun.tools.javafx.tree.JFXTypeCast;
import com.sun.tools.javafx.tree.JFXTypeClass;
import com.sun.tools.javafx.tree.JFXTypeFunctional;
import com.sun.tools.javafx.tree.JFXTypeUnknown;
import com.sun.tools.javafx.tree.JFXUnary;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JFXVarScriptInit;
import com.sun.tools.javafx.tree.JFXWhileLoop;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import com.sun.tools.javafx.tree.JavafxTreeScanner;
import com.sun.tools.javafx.tree.JavafxVisitor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxPretty
implements JavafxVisitor {
    public static final int SCOPE_OUTER = 0;
    public static final int SCOPE_CLASS = 1;
    public static final int SCOPE_METHOD = 2;
    public static final int SCOPE_PARAMS = 3;
    protected int variableScope = 0;
    protected final boolean sourceOutput;
    Writer out;
    public int width = 4;
    int lmargin = 0;
    Map<JCTree, String> docComments = null;
    CharSequence sourceContent;
    String lineSep = System.getProperty("line.separator");
    protected int prec;

    public JavafxPretty(Writer out, boolean sourceOutput, CharSequence content) {
        this.out = out;
        this.sourceOutput = sourceOutput;
        this.sourceContent = content;
    }

    public JavafxPretty(Writer out, boolean sourceOutput) {
        this.out = out;
        this.sourceOutput = sourceOutput;
        this.sourceContent = null;
    }

    public void align() throws IOException {
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.write(" ");
        }
    }

    public void indent() {
        this.lmargin += this.width;
    }

    public void undent() {
        this.lmargin -= this.width;
    }

    void open(int contextPrec, int ownPrec) throws IOException {
        if (ownPrec < contextPrec) {
            this.out.write("(");
        }
    }

    void close(int contextPrec, int ownPrec) throws IOException {
        if (ownPrec < contextPrec) {
            this.out.write(")");
        }
    }

    public void print(Object s) throws IOException {
        this.out.write(Convert.escapeUnicode(s.toString()));
    }

    public void println() throws IOException {
        this.out.write(this.lineSep);
    }

    public void printExpr(JFXTree tree, int prec) throws IOException {
        int prevPrec = this.prec;
        try {
            this.prec = prec;
            if (tree == null || tree instanceof JFXErroneous) {
                this.print("/*missing*/");
            } else {
                tree.accept(this);
            }
        }
        catch (UncheckedIOException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        finally {
            this.prec = prevPrec;
        }
    }

    public void printExpr(JFXTree tree) throws IOException {
        this.printExpr(tree, 0);
    }

    public void printStat(JFXTree tree) throws IOException {
        this.printExpr(tree, -1);
    }

    public <T extends JFXTree> void printExprs(List<T> trees, String sep) throws IOException {
        if (trees.nonEmpty()) {
            this.printExpr((JFXTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                this.print(sep);
                this.printExpr((JFXTree)l.head);
                l = l.tail;
            }
        }
    }

    public <T extends JFXTree> void printExprs(List<T> trees) throws IOException {
        this.printExprs(trees, ", ");
    }

    public void printStats(List<? extends JFXTree> trees) throws IOException {
        List<JFXTree> l = trees;
        while (l.nonEmpty()) {
            this.align();
            this.printStat((JFXTree)l.head);
            this.println();
            l = l.tail;
        }
    }

    public void printFlags(long flags) throws IOException {
        if ((flags & 0x1000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(JavafxTreeInfo.flagNames(flags));
        if ((flags & 0xFFFL) != 0L) {
            this.print(" ");
        }
        if ((flags & 0x2000L) != 0L) {
            this.print("@");
        }
    }

    public void printDocComment(JFXTree tree) throws IOException {
        String dc;
        if (this.docComments != null && (dc = this.docComments.get(tree)) != null) {
            int pos = 0;
            int endpos = JavafxPretty.lineEndPos(dc, pos);
            while (pos < dc.length()) {
                this.align();
                this.print(dc.substring(pos, endpos));
                pos = endpos + 1;
                if (pos < dc.length()) {
                    this.println();
                }
                endpos = JavafxPretty.lineEndPos(dc, pos);
            }
            this.align();
        }
    }

    static int lineEndPos(String s, int start) {
        int pos = s.indexOf(10, start);
        if (pos < 0) {
            pos = s.length();
        }
        return pos;
    }

    public void printBlock(List<? extends JFXTree> stats) throws IOException {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(stats);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printUnit(JFXScript tree) throws IOException {
        this.docComments = tree.docComments;
        this.printDocComment(tree);
        if (tree.pid != null) {
            this.print("package ");
            this.printExpr(tree.pid);
            this.print(";");
            this.println();
        }
        boolean firstImport = true;
        List<JFXTree> l = tree.defs;
        while (l.nonEmpty()) {
            if (((JFXTree)l.head).getFXTag() == JavafxTag.IMPORT) {
                JFXImport imp = (JFXImport)l.head;
                if (firstImport) {
                    firstImport = false;
                    this.println();
                }
                this.printStat(imp);
            } else {
                this.printStat((JFXTree)l.head);
            }
            l = l.tail;
        }
    }

    boolean isUsed(final Symbol t, JFXTree cdef) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UsedVisitor
        extends JavafxTreeScanner {
            boolean result = false;

            UsedVisitor() {
            }

            @Override
            public void scan(JFXTree tree) {
                if (tree != null && !this.result) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitIdent(JFXIdent tree) {
                if (tree.sym == t) {
                    this.result = true;
                }
            }
        }
        UsedVisitor v = new UsedVisitor();
        v.scan(cdef);
        return v.result;
    }

    @Override
    public void visitScript(JFXScript tree) {
        try {
            this.printUnit(tree);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitImport(JFXImport tree) {
        try {
            this.print("import ");
            this.printExpr(tree.qualid);
            this.print(";");
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSkip(JFXSkip tree) {
        try {
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitWhileLoop(JFXWhileLoop tree) {
        try {
            this.print("while ");
            if (tree.cond.getFXTag() == JavafxTag.PARENS) {
                this.printExpr(tree.cond);
            } else {
                this.print("(");
                this.printExpr(tree.cond);
                this.print(")");
            }
            this.print(" ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTry(JFXTry tree) {
        try {
            this.print("try ");
            this.printStat(tree.body);
            List<JFXCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                this.printStat((JFXTree)l.head);
                l = l.tail;
            }
            if (tree.finalizer != null) {
                this.print(" finally ");
                this.printStat(tree.finalizer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitCatch(JFXCatch tree) {
        try {
            this.print(" catch (");
            this.printExpr(tree.param);
            this.print(") ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIfExpression(JFXIfExpression tree) {
        try {
            this.print(" if (");
            this.printExpr(tree.cond);
            this.print(") ");
            this.printExpr(tree.truepart);
            if (tree.falsepart != null) {
                this.print(" else ");
                this.printExpr(tree.falsepart);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBreak(JFXBreak tree) {
        try {
            this.print("break");
            if (tree.label != null) {
                this.print(" " + tree.label);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitContinue(JFXContinue tree) {
        try {
            this.print("continue");
            if (tree.label != null) {
                this.print(" " + tree.label);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitReturn(JFXReturn tree) {
        try {
            this.print("return");
            if (tree.expr != null) {
                this.print(" ");
                this.printExpr(tree.expr);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitThrow(JFXThrow tree) {
        try {
            this.print("throw ");
            this.printExpr(tree.expr);
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitFunctionInvocation(JFXFunctionInvocation tree) {
        try {
            if (!tree.typeargs.isEmpty()) {
                if (tree.meth.getFXTag() == JavafxTag.SELECT) {
                    JFXSelect left = (JFXSelect)tree.meth;
                    this.printExpr(left.selected);
                    this.print(".<");
                    this.printExprs(tree.typeargs);
                    this.print(">" + left.name);
                } else {
                    this.print("<");
                    this.printExprs(tree.typeargs);
                    this.print(">");
                    this.printExpr(tree.meth);
                }
            } else {
                this.printExpr(tree.meth);
            }
            this.print("(");
            this.printExprs(tree.args);
            this.print(")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitParens(JFXParens tree) {
        try {
            this.print("(");
            this.printExpr(tree.expr);
            this.print(")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitAssign(JFXAssign tree) {
        try {
            this.open(this.prec, 1);
            this.printExpr(tree.lhs, 2);
            this.print(" = ");
            this.printExpr(tree.rhs, 1);
            this.close(this.prec, 1);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String operatorName(JavafxTag tag) {
        switch (tag) {
            case NEG: {
                return "-";
            }
            case NOT: {
                return "not";
            }
            case PREINC: {
                return "++";
            }
            case PREDEC: {
                return "--";
            }
            case POSTINC: {
                return "++";
            }
            case POSTDEC: {
                return "--";
            }
            case NULLCHK: {
                return "<*nullchk*>";
            }
            case OR: {
                return "or";
            }
            case AND: {
                return "and";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case GE: {
                return ">=";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case PLUS_ASG: {
                return "+=";
            }
            case MINUS_ASG: {
                return "-=";
            }
            case MUL_ASG: {
                return "*=";
            }
            case DIV_ASG: {
                return "/=";
            }
            case REVERSE: {
                return "reverse";
            }
            case INDEXOF: {
                return "indexof";
            }
            case SIZEOF: {
                return "sizeof";
            }
        }
        throw new Error();
    }

    @Override
    public void visitAssignop(JFXAssignOp tree) {
        try {
            this.open(this.prec, 2);
            this.printExpr(tree.lhs, 3);
            this.print(" " + this.operatorName(tree.getFXTag()));
            this.printExpr(tree.rhs, 2);
            this.close(this.prec, 2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitUnary(JFXUnary tree) {
        try {
            if (tree.getFXTag() == JavafxTag.SIZEOF) {
                this.print("(sizeof ");
                this.printExpr(tree.arg);
                this.print(")");
            } else {
                int ownprec = JavafxTreeInfo.opPrec(tree.getFXTag());
                String opname = this.operatorName(tree.getFXTag());
                this.open(this.prec, ownprec);
                if (tree.getFXTag().ordinal() <= JavafxTag.PREDEC.ordinal()) {
                    this.print(opname);
                    this.printExpr(tree.arg, ownprec);
                } else {
                    this.printExpr(tree.arg, ownprec);
                    this.print(opname);
                }
                this.close(this.prec, ownprec);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBinary(JFXBinary tree) {
        try {
            int ownprec = JavafxTreeInfo.opPrec(tree.getFXTag());
            String opname = this.operatorName(tree.getFXTag());
            this.open(this.prec, ownprec);
            this.printExpr(tree.lhs, ownprec);
            this.print(" " + opname + " ");
            this.printExpr(tree.rhs, ownprec + 1);
            this.close(this.prec, ownprec);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeCast(JFXTypeCast tree) {
        try {
            this.printExpr(tree.expr, 9);
            this.print(" as ");
            this.printExpr(tree.clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitInstanceOf(JFXInstanceOf tree) {
        try {
            this.open(this.prec, 6);
            this.printExpr(tree.expr, 6);
            this.print(" instanceof ");
            this.printExpr(tree.clazz, 7);
            this.close(this.prec, 6);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSelect(JFXSelect tree) {
        try {
            this.printExpr(tree.selected, 10);
            this.print("." + tree.name);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIdent(JFXIdent tree) {
        try {
            this.print(tree.name);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitLiteral(JFXLiteral tree) {
        try {
            switch (tree.typetag) {
                case 4: {
                    this.print(tree.value.toString());
                    break;
                }
                case 5: {
                    this.print(tree.value + "L");
                    break;
                }
                case 6: {
                    this.print(tree.value + "F");
                    break;
                }
                case 7: {
                    this.print(tree.value.toString());
                    break;
                }
                case 2: {
                    this.print("'" + Convert.quote(String.valueOf((char)((Number)tree.value).intValue())) + "'");
                    break;
                }
                case 8: {
                    this.print(((Number)tree.value).intValue() == 1 ? "true" : "false");
                    break;
                }
                case 17: {
                    this.print("null");
                    break;
                }
                default: {
                    this.print("\"" + Convert.quote(tree.value.toString()) + "\"");
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitErroneous(JFXErroneous tree) {
        try {
            this.print("(ERROR)");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitModifiers(JFXModifiers mods) {
        try {
            this.printFlags(mods.flags);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void visitTree(JFXTree tree) {
        try {
            this.print("(UNKNOWN: " + tree + ")");
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String posAsString(int pos) {
        if (pos == -1 || this.sourceContent == null) {
            return "%?%";
        }
        int line = 1;
        int bp = 0;
        while (bp < this.sourceContent.length() && bp < pos) {
            switch (this.sourceContent.charAt(bp++)) {
                case '\r': {
                    if (bp < this.sourceContent.length() && this.sourceContent.charAt(bp) == '\n') {
                        ++bp;
                    }
                    ++line;
                    break;
                }
                case '\n': {
                    ++line;
                }
            }
        }
        return " %(" + pos + ")" + line + "% ";
    }

    private void printInterpolateValue(JFXInterpolateValue tree) {
        try {
            if (tree.getAttribute() != null) {
                this.print(tree.getAttribute());
                this.print("=>");
            }
            this.print(tree.getValue());
            this.printTween(tree);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitClassDeclaration(JFXClassDeclaration tree) {
        try {
            int oldScope = this.variableScope;
            this.variableScope = 1;
            this.println();
            this.align();
            this.printDocComment(tree);
            this.print("class ");
            Name n = tree.getName();
            this.print(n == null ? "<anonymous>" : n);
            this.print(" {");
            this.println();
            this.indent();
            for (JFXTree mem : tree.getMembers()) {
                this.align();
                this.printExpr(mem);
            }
            this.undent();
            this.println();
            this.print("}");
            this.println();
            this.align();
            this.variableScope = oldScope;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void visitFunctionValue(JavafxPretty pretty, JFXFunctionValue tree) {
        try {
            JFXBlock body;
            pretty.println();
            pretty.align();
            pretty.printDocComment(tree);
            pretty.print("function ");
            pretty.print("(");
            pretty.printExprs(tree.getParams());
            pretty.print(")");
            if (tree.getType() != null) {
                pretty.printExpr(tree.getType());
            }
            if ((body = tree.getBodyExpression()) != null) {
                if (body instanceof JFXErroneousBlock) {
                    pretty.print("<erroroneous>");
                } else {
                    pretty.printExpr(body);
                }
            }
            pretty.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitFunctionValue(JFXFunctionValue tree) {
        JavafxPretty.visitFunctionValue(this, tree);
    }

    public static void visitFunctionDefinition(JavafxPretty pretty, JFXFunctionDefinition tree) {
        try {
            JavafxPretty fxpretty = pretty;
            int oldScope = fxpretty.variableScope;
            pretty.println();
            pretty.align();
            pretty.printDocComment(tree);
            pretty.printExpr(tree.mods);
            pretty.print("function ");
            pretty.print(tree.name);
            pretty.print("(");
            fxpretty.variableScope = 3;
            pretty.printExprs(tree.getParams());
            fxpretty.variableScope = 2;
            pretty.print(")");
            pretty.printExpr(tree.operation.rettype);
            JFXBlock body = tree.getBodyExpression();
            if (body != null) {
                pretty.print(" ");
                pretty.printExpr(body);
            }
            pretty.println();
            fxpretty.variableScope = oldScope;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitFunctionDefinition(JFXFunctionDefinition tree) {
        JavafxPretty.visitFunctionDefinition(this, tree);
    }

    @Override
    public void visitInitDefinition(JFXInitDefinition tree) {
        try {
            this.println();
            this.align();
            this.printDocComment(tree);
            this.print("init ");
            this.print(tree.getBody());
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitPostInitDefinition(JFXPostInitDefinition tree) {
        try {
            this.println();
            this.align();
            this.printDocComment(tree);
            this.print("postinit ");
            this.print(tree.getBody());
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBlockExpression(JFXBlock tree) {
        JavafxPretty.visitBlockExpression(this, tree);
    }

    public static void visitBlockExpression(JavafxPretty pretty, JFXBlock tree) {
        try {
            pretty.printFlags(tree.flags);
            pretty.print("{");
            pretty.println();
            pretty.indent();
            pretty.printStats(tree.stats);
            if (tree.value != null) {
                pretty.align();
                pretty.printExpr(tree.value);
                pretty.println();
            }
            pretty.undent();
            pretty.align();
            pretty.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void printBind(JavafxBindStatus bindStatus) {
        try {
            if (bindStatus.isUnidiBind()) {
                this.print(" bind /*stays*/ ");
            }
            if (bindStatus.isBidiBind()) {
                this.print(" bind /*tie*/ ");
            }
            if (bindStatus.isLazy()) {
                this.print(" bind /*lazy*/ ");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSequenceEmpty(JFXSequenceEmpty that) {
        try {
            this.print("[]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSequenceRange(JFXSequenceRange that) {
        try {
            this.print("[");
            this.printExpr(that.getLower());
            this.print("..");
            this.printExpr(that.getUpper());
            if (that.getStepOrNull() != null) {
                this.print("step ");
                this.printExpr(that.getStepOrNull());
            }
            if (that.isExclusive()) {
                this.print(" exclusive");
            }
            this.print("]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSequenceExplicit(JFXSequenceExplicit that) {
        try {
            boolean first = true;
            this.print("[");
            for (JFXExpression expr : that.getItems()) {
                if (!first) {
                    this.print(", ");
                }
                first = false;
                this.printExpr(expr);
            }
            this.print("]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSequenceIndexed(JFXSequenceIndexed that) {
        try {
            this.printExpr(that.getSequence());
            this.print("[ ");
            this.printExpr(that.getIndex());
            this.print("]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSequenceSlice(JFXSequenceSlice that) {
        try {
            this.printExpr(that.getSequence());
            this.print("[ ");
            this.printExpr(that.getFirstIndex());
            this.print(" .. ");
            this.printExpr(that.getLastIndex());
            this.print("]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSequenceInsert(JFXSequenceInsert that) {
        try {
            this.print("insert ");
            this.printExpr(that.getElement());
            this.print(" into ");
            this.printExpr(that.getSequence());
            this.print("; ");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSequenceDelete(JFXSequenceDelete that) {
        try {
            this.print("delete ");
            this.printExpr(that.getSequence());
            if (that.getElement() != null) {
                this.print(" (");
                this.printExpr(that.getElement());
                this.print(")");
            }
            this.print("; ");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitStringExpression(JFXStringExpression tree) {
        try {
            int i;
            List<JFXExpression> parts = tree.getParts();
            for (i = 0; i < parts.length() - 1; i += 3) {
                this.printExpr(parts.get(i));
                this.print("{");
                JFXExpression format = parts.get(i + 1);
                if (format != null) {
                    this.printExpr(format);
                }
                this.printExpr(parts.get(i + 2));
                this.print("}");
            }
            this.printExpr(parts.get(i));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitInstanciate(JFXInstanciate tree) {
        try {
            JFXExpression id = tree.getIdentifier();
            if (tree.getArgs().nonEmpty()) {
                this.print("new ");
            }
            if (id != null) {
                this.printExpr(id);
            }
            if (tree.getArgs().nonEmpty()) {
                this.print("(");
                this.printExprs(tree.getArgs());
                this.print(")");
            } else {
                this.print(" {");
                if (tree.getParts().nonEmpty()) {
                    this.indent();
                    for (JFXObjectLiteralPart mem : tree.getParts()) {
                        this.println();
                        this.align();
                        this.printExpr(mem);
                    }
                    this.undent();
                    this.println();
                    this.align();
                }
                this.print("}");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitObjectLiteralPart(JFXObjectLiteralPart tree) {
        try {
            this.print(tree.getName());
            this.print(": ");
            this.printBind(tree.getBindStatus());
            this.printExpr(tree.getExpression());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeAny(JFXTypeAny tree) {
        try {
            this.print("* ");
            this.print(this.ary(tree));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void printTypeSpecifier(JFXType type) {
        try {
            if (type instanceof JFXTypeUnknown) {
                return;
            }
            this.print(": ");
            this.printExpr(type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeClass(JFXTypeClass tree) {
        try {
            this.print(tree.getClassName());
            this.print(this.ary(tree));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeFunctional(JFXTypeFunctional tree) {
        try {
            this.print("(");
            List<JFXType> params = tree.getParams();
            if (params.nonEmpty()) {
                this.printTypeSpecifier((JFXType)params.head);
                List l = params.tail;
                while (l.nonEmpty()) {
                    this.print(", ");
                    this.printTypeSpecifier((JFXType)l.head);
                    l = l.tail;
                }
            }
            this.print(")");
            this.printTypeSpecifier((JFXType)tree.getReturnType());
            this.print(this.ary(tree));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeUnknown(JFXTypeUnknown tree) {
        try {
            this.print(this.ary(tree));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    String ary(JFXType tree) {
        switch (tree.getCardinality()) {
            case ANY: {
                return "[]";
            }
            case SINGLETON: {
                return "";
            }
        }
        return "";
    }

    @Override
    public void visitVarScriptInit(JFXVarScriptInit tree) {
        try {
            this.print("variable initialization for ");
            this.print(tree.getVar());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitVar(JFXVar tree) {
        try {
            if (this.docComments != null && this.docComments.get(tree) != null) {
                this.println();
                this.align();
            }
            this.printDocComment(tree);
            this.printExpr(tree.mods);
            if (this.variableScope != 3) {
                if ((tree.getModifiers().flags & 0x20000000000L) != 0L) {
                    this.print("def ");
                } else {
                    this.print("var ");
                }
            }
            this.print(tree.getName());
            this.printTypeSpecifier(tree.getJFXType());
            if (this.variableScope != 3 && tree.getInitializer() != null) {
                this.print(" = ");
                this.printExpr(tree.getInitializer());
            }
            if (tree.getOnReplace() != null) {
                this.printExpr(tree.getOnReplace());
            }
            this.print(";");
            if (this.variableScope == 0 || this.variableScope == 1) {
                this.println();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitOverrideClassVar(JFXOverrideClassVar tree) {
        try {
            this.print("override attribute ");
            this.printExpr(tree.getId());
            if (tree.getInitializer() != null) {
                this.print(" = ");
                this.printExpr(tree.getInitializer());
            }
            this.print(" ");
            this.align();
            this.printExpr(tree.getOnReplace());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitOnReplace(JFXOnReplace tree) {
        try {
            this.print(" on replace");
            if (tree.getOldValue() != null) {
                this.print(" ");
                this.printExpr(tree.getOldValue());
            }
            if (tree.getFirstIndex() != null) {
                this.print("[");
                this.printExpr(tree.getFirstIndex());
                if (tree.getLastIndex() != null) {
                    this.print(" .. ");
                    this.printExpr(tree.getLastIndex());
                }
                this.print(" ]");
            }
            if (tree.getNewElements() != null) {
                this.print("= ");
                this.printExpr(tree.getNewElements());
            }
            this.print(" ");
            if (tree.getBody() != null) {
                this.printExpr(tree.getBody());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitForExpression(JFXForExpression tree) {
        try {
            boolean first = true;
            this.print("for (");
            for (ForExpressionInClauseTree cl : tree.getInClauses()) {
                if (cl == null || cl instanceof JFXErroneousForExpressionInClause) continue;
                JFXForExpressionInClause clause = (JFXForExpressionInClause)cl;
                if (first) {
                    first = false;
                } else {
                    this.print(", ");
                }
                JFXVar var = clause.getVar();
                if (var == null || var instanceof JFXErroneousVar) {
                    this.print("<missing>)");
                } else {
                    this.print(var.getName());
                }
                this.print(" in ");
                JFXExpression e1 = clause.getSequenceExpression();
                if (e1 == null || e1 instanceof JFXErroneous) {
                    this.print("<error>");
                } else {
                    this.printExpr(e1);
                }
                if (clause.getWhereExpression() == null) continue;
                this.print(" where ");
                this.printExpr(clause.getWhereExpression());
            }
            this.print(") ");
            JFXExpression body = tree.getBodyExpression();
            if (body == null || body instanceof JFXErroneous) {
                this.print(" {}\n");
            } else {
                this.printExpr(body);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIndexof(JFXIndexof that) {
        try {
            this.print("indexof ");
            this.print(that.fname);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitForExpressionInClause(JFXForExpressionInClause that) {
        try {
            if (that == null || that.var == null || that.var instanceof JFXErroneousVar) {
                this.print("<missing>");
            } else {
                this.print(that.var);
            }
            this.print(" in ");
            if (that == null || that.seqExpr == null || that.seqExpr instanceof JFXErroneous) {
                this.print("<missing expr>");
            } else {
                this.print(that.seqExpr);
            }
            if (that.whereExpr != null && !(that.whereExpr instanceof JFXErroneous)) {
                this.print(" where ");
                this.print(that.whereExpr);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toString(JFXTree tree) {
        StringWriter s = new StringWriter();
        try {
            new JavafxPretty(s, false).printExpr(tree);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return s.toString();
    }

    @Override
    public void visitTimeLiteral(JFXTimeLiteral tree) {
        try {
            Double d = ((Number)tree.value.value).doubleValue();
            d = d / (double)tree.duration.getMultiplier();
            this.print(d + tree.duration.getSuffix());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitInterpolateValue(JFXInterpolateValue tree) {
        this.printInterpolateValue(tree);
    }

    private void printTween(JFXInterpolateValue tree) throws IOException {
        JFXExpression tween = tree.getInterpolation();
        if (tween != null) {
            this.print(" tween ");
            this.print(tween);
        }
    }

    @Override
    public void visitKeyFrameLiteral(JFXKeyFrameLiteral tree) {
        try {
            this.print("at (");
            this.print(tree.getStartDuration());
            this.print(") {");
            this.println();
            this.indent();
            this.printStats(List.convert(JFXTree.class, tree.getInterpolationValues()));
            if (tree.getTrigger() != null) {
                this.align();
                this.print("trigger ");
                JavafxPretty.visitBlockExpression(this, (JFXBlock)tree.getTrigger());
            }
            this.undent();
            this.println();
            this.align();
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected static class UncheckedIOException
    extends RuntimeException {
        static final long serialVersionUID = -4032692679158424751L;

        public UncheckedIOException(IOException e) {
            super(e.getMessage(), e);
        }
    }
}

