/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.tree;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.tree.JFXAssign;
import com.sun.tools.javafx.tree.JFXAssignOp;
import com.sun.tools.javafx.tree.JFXBinary;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXBreak;
import com.sun.tools.javafx.tree.JFXCatch;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXContinue;
import com.sun.tools.javafx.tree.JFXErroneous;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXForExpression;
import com.sun.tools.javafx.tree.JFXForExpressionInClause;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXFunctionValue;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXIfExpression;
import com.sun.tools.javafx.tree.JFXImport;
import com.sun.tools.javafx.tree.JFXIndexof;
import com.sun.tools.javafx.tree.JFXInitDefinition;
import com.sun.tools.javafx.tree.JFXInstanceOf;
import com.sun.tools.javafx.tree.JFXInstanciate;
import com.sun.tools.javafx.tree.JFXInterpolateValue;
import com.sun.tools.javafx.tree.JFXKeyFrameLiteral;
import com.sun.tools.javafx.tree.JFXLiteral;
import com.sun.tools.javafx.tree.JFXModifiers;
import com.sun.tools.javafx.tree.JFXObjectLiteralPart;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXParens;
import com.sun.tools.javafx.tree.JFXPostInitDefinition;
import com.sun.tools.javafx.tree.JFXReturn;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXSequenceDelete;
import com.sun.tools.javafx.tree.JFXSequenceEmpty;
import com.sun.tools.javafx.tree.JFXSequenceExplicit;
import com.sun.tools.javafx.tree.JFXSequenceIndexed;
import com.sun.tools.javafx.tree.JFXSequenceInsert;
import com.sun.tools.javafx.tree.JFXSequenceRange;
import com.sun.tools.javafx.tree.JFXSequenceSlice;
import com.sun.tools.javafx.tree.JFXSkip;
import com.sun.tools.javafx.tree.JFXStringExpression;
import com.sun.tools.javafx.tree.JFXThrow;
import com.sun.tools.javafx.tree.JFXTimeLiteral;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXTry;
import com.sun.tools.javafx.tree.JFXType;
import com.sun.tools.javafx.tree.JFXTypeAny;
import com.sun.tools.javafx.tree.JFXTypeCast;
import com.sun.tools.javafx.tree.JFXTypeClass;
import com.sun.tools.javafx.tree.JFXTypeFunctional;
import com.sun.tools.javafx.tree.JFXTypeUnknown;
import com.sun.tools.javafx.tree.JFXUnary;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JFXVarScriptInit;
import com.sun.tools.javafx.tree.JFXWhileLoop;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import com.sun.tools.javafx.tree.JavafxVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxTreeCopier
implements JavafxVisitor {
    private JavafxTreeMaker maker;
    private JFXTree result;

    public JavafxTreeCopier(JavafxTreeMaker maker) {
        this.maker = maker;
    }

    public <T extends JFXTree> T copy(T tree) {
        if (tree == null) {
            return null;
        }
        tree.accept(this);
        return (T)this.result;
    }

    public <T extends JFXTree> List<T> copy(List<T> trees) {
        if (trees == null) {
            return null;
        }
        ListBuffer<JFXTree> lb = new ListBuffer<JFXTree>();
        for (JFXTree tree : trees) {
            lb.append(this.copy(tree));
        }
        return lb.toList();
    }

    @Override
    public void visitScript(JFXScript tree) {
        JFXExpression pid = this.copy(tree.pid);
        List<JFXTree> defs = this.copy(tree.defs);
        this.result = this.maker.at(tree.pos).Script(pid, defs);
    }

    @Override
    public void visitImport(JFXImport tree) {
        JFXExpression qualid = this.copy(tree.qualid);
        this.result = this.maker.at(tree.pos).Import(qualid);
    }

    @Override
    public void visitSkip(JFXSkip tree) {
        this.result = this.maker.at(tree.pos).Skip();
    }

    @Override
    public void visitWhileLoop(JFXWhileLoop tree) {
        JFXExpression cond = this.copy(tree.cond);
        JFXExpression body = this.copy(tree.body);
        this.result = this.maker.at(tree.pos).WhileLoop(cond, body);
    }

    @Override
    public void visitTry(JFXTry tree) {
        JFXBlock body = this.copy(tree.body);
        List<JFXCatch> catchers = this.copy(tree.catchers);
        JFXBlock finalizer = this.copy(tree.finalizer);
        this.result = this.maker.at(tree.pos).Try(body, catchers, finalizer);
    }

    @Override
    public void visitCatch(JFXCatch tree) {
        JFXVar param = this.copy(tree.param);
        JFXBlock body = this.copy(tree.body);
        this.result = this.maker.at(tree.pos).Catch(param, body);
    }

    @Override
    public void visitIfExpression(JFXIfExpression tree) {
        JFXExpression cond = this.copy(tree.cond);
        JFXExpression truepart = this.copy(tree.truepart);
        JFXExpression falsepart = this.copy(tree.falsepart);
        this.result = this.maker.at(tree.pos).Conditional(cond, truepart, falsepart);
    }

    @Override
    public void visitBreak(JFXBreak tree) {
        this.result = this.maker.at(tree.pos).Break(tree.label);
    }

    @Override
    public void visitContinue(JFXContinue tree) {
        this.result = this.maker.at(tree.pos).Continue(tree.label);
    }

    @Override
    public void visitReturn(JFXReturn tree) {
        JFXExpression expr = this.copy(tree.expr);
        this.result = this.maker.at(tree.pos).Return(expr);
    }

    @Override
    public void visitThrow(JFXThrow tree) {
        JFXExpression expr = this.copy(tree.expr);
        this.result = this.maker.at(tree.pos).Throw(expr);
    }

    @Override
    public void visitFunctionInvocation(JFXFunctionInvocation tree) {
        List<JFXExpression> typeargs = this.copy(tree.typeargs);
        JFXExpression fn = this.copy(tree.meth);
        List<JFXExpression> args = this.copy(tree.args);
        this.result = this.maker.at(tree.pos).Apply(typeargs, fn, args);
    }

    @Override
    public void visitParens(JFXParens tree) {
        JFXExpression expr = this.copy(tree.expr);
        this.result = this.maker.at(tree.pos).Parens(expr);
    }

    @Override
    public void visitAssign(JFXAssign tree) {
        JFXExpression lhs = this.copy(tree.lhs);
        JFXExpression rhs = this.copy(tree.rhs);
        this.result = this.maker.at(tree.pos).Assign(lhs, rhs);
    }

    @Override
    public void visitAssignop(JFXAssignOp tree) {
        JFXExpression lhs = this.copy(tree.lhs);
        JFXExpression rhs = this.copy(tree.rhs);
        JavafxTag tag = tree.getFXTag();
        this.result = this.maker.at(tree.pos).Assignop(tag, lhs, rhs);
    }

    @Override
    public void visitUnary(JFXUnary tree) {
        JFXExpression arg = this.copy(tree.arg);
        JavafxTag tag = tree.getFXTag();
        this.result = this.maker.at(tree.pos).Unary(tag, arg);
    }

    @Override
    public void visitBinary(JFXBinary tree) {
        JFXExpression lhs = this.copy(tree.lhs);
        JFXExpression rhs = this.copy(tree.rhs);
        JavafxTag tag = tree.getFXTag();
        this.result = this.maker.at(tree.pos).Binary(tag, lhs, rhs);
    }

    @Override
    public void visitTypeCast(JFXTypeCast tree) {
        JFXTree clazz = this.copy(tree.clazz);
        JFXExpression expr = this.copy(tree.expr);
        this.result = this.maker.at(tree.pos).TypeCast(clazz, expr);
    }

    @Override
    public void visitInstanceOf(JFXInstanceOf tree) {
        JFXExpression expr = this.copy(tree.expr);
        JFXTree clazz = this.copy(tree.clazz);
        this.result = this.maker.at(tree.pos).TypeTest(expr, clazz);
    }

    @Override
    public void visitSelect(JFXSelect tree) {
        JFXExpression selected = this.copy(tree.selected);
        this.result = this.maker.at(tree.pos).Select(selected, tree.name);
    }

    @Override
    public void visitIdent(JFXIdent tree) {
        this.result = this.maker.at(tree.pos).Ident(tree.name);
    }

    @Override
    public void visitLiteral(JFXLiteral tree) {
        this.result = this.maker.at(tree.pos).Literal(tree.typetag, tree.value);
    }

    @Override
    public void visitModifiers(JFXModifiers tree) {
        this.result = this.maker.at(tree.pos).Modifiers(tree.flags);
    }

    @Override
    public void visitErroneous(JFXErroneous tree) {
        List errs = this.copy((List)tree.getErrorTrees());
        this.result = this.maker.at(tree.pos).Erroneous(errs);
    }

    @Override
    public void visitClassDeclaration(JFXClassDeclaration tree) {
        JFXModifiers mods = this.copy(tree.mods);
        Name name = tree.getName();
        List<JFXExpression> supertypes = this.copy(tree.getSupertypes());
        List<JFXTree> defs = this.copy(tree.getMembers());
        this.result = this.maker.at(tree.pos).ClassDeclaration(mods, name, supertypes, defs);
    }

    @Override
    public void visitFunctionDefinition(JFXFunctionDefinition tree) {
        JFXModifiers mods = this.copy(tree.mods);
        Name name = tree.getName();
        JFXType restype = this.copy(tree.getJFXReturnType());
        List<JFXVar> params = this.copy(tree.getParams());
        JFXBlock bodyExpression = this.copy(tree.getBodyExpression());
        this.result = this.maker.at(tree.pos).FunctionDefinition(mods, name, restype, params, bodyExpression);
    }

    @Override
    public void visitInitDefinition(JFXInitDefinition tree) {
        JFXBlock body = tree.body;
        this.result = this.maker.at(tree.pos).InitDefinition(body);
    }

    @Override
    public void visitPostInitDefinition(JFXPostInitDefinition tree) {
        JFXBlock body = tree.body;
        this.result = this.maker.at(tree.pos).PostInitDefinition(body);
    }

    @Override
    public void visitStringExpression(JFXStringExpression tree) {
        List<JFXExpression> parts = this.copy(tree.parts);
        this.result = this.maker.at(tree.pos).StringExpression(parts, tree.translationKey);
    }

    @Override
    public void visitInstanciate(JFXInstanciate tree) {
        JFXExpression clazz = this.copy(tree.getIdentifier());
        JFXClassDeclaration def = this.copy(tree.getClassBody());
        List<JFXExpression> args = this.copy(tree.getArgs());
        List<JFXObjectLiteralPart> parts = this.copy(tree.getParts());
        List<JFXVar> localVars = this.copy(tree.getLocalvars());
        this.result = this.maker.at(tree.pos).Instanciate(tree.getJavaFXKind(), clazz, def, args, parts, localVars);
    }

    @Override
    public void visitObjectLiteralPart(JFXObjectLiteralPart tree) {
        JFXExpression expr = this.copy(tree.getExpression());
        this.result = this.maker.at(tree.pos).ObjectLiteralPart(tree.name, expr, null);
    }

    @Override
    public void visitTypeAny(JFXTypeAny tree) {
        this.result = this.maker.at(tree.pos).TypeAny(tree.getCardinality());
    }

    @Override
    public void visitTypeClass(JFXTypeClass tree) {
        JFXExpression clazz = this.copy(tree.getClassName());
        this.result = this.maker.at(tree.pos).TypeClass(clazz, tree.getCardinality());
    }

    @Override
    public void visitTypeFunctional(JFXTypeFunctional tree) {
        List<JFXType> params = this.copy(tree.getParams());
        JFXType restype = this.copy(tree.restype);
        this.result = this.maker.at(tree.pos).TypeFunctional(params, restype, tree.getCardinality());
    }

    @Override
    public void visitTypeUnknown(JFXTypeUnknown tree) {
        this.result = this.maker.at(tree.pos).TypeUnknown();
    }

    @Override
    public void visitVarScriptInit(JFXVarScriptInit tree) {
    }

    @Override
    public void visitVar(JFXVar tree) {
        Name name = tree.name;
        JFXType type = this.copy(tree.getJFXType());
        JFXModifiers mods = this.copy(tree.getModifiers());
        JFXExpression init = this.copy(tree.getInitializer());
        JFXOnReplace onReplace = this.copy(tree.getOnReplace());
        this.result = this.maker.at(tree.pos).Var(name, type, mods, init, tree.getBindStatus(), onReplace);
    }

    @Override
    public void visitOnReplace(JFXOnReplace tree) {
        JFXVar oldValue = this.copy(tree.getOldValue());
        JFXVar firstIndex = this.copy(tree.getFirstIndex());
        JFXVar lastIndex = this.copy(tree.getLastIndex());
        JFXVar newElements = this.copy(tree.getNewElements());
        JFXBlock body = this.copy(tree.getBody());
        this.result = this.maker.at(tree.pos).OnReplace(oldValue, firstIndex, lastIndex, tree.getEndKind(), newElements, body);
    }

    @Override
    public void visitBlockExpression(JFXBlock tree) {
        List<JFXExpression> stats = this.copy(tree.stats);
        JFXExpression value = this.copy(tree.value);
        this.result = this.maker.at(tree.pos).Block(tree.flags, stats, value);
    }

    @Override
    public void visitFunctionValue(JFXFunctionValue tree) {
        JFXType restype = this.copy(tree.rettype);
        List<JFXVar> params = this.copy(tree.getParams());
        JFXBlock bodyExpression = this.copy(tree.bodyExpression);
        this.result = this.maker.at(tree.pos).FunctionValue(restype, params, bodyExpression);
    }

    @Override
    public void visitSequenceEmpty(JFXSequenceEmpty tree) {
        this.result = this.maker.at(tree.pos).EmptySequence();
    }

    @Override
    public void visitSequenceRange(JFXSequenceRange tree) {
        JFXExpression lower = this.copy(tree.getLower());
        JFXExpression upper = this.copy(tree.getUpper());
        JFXExpression stepOrNull = this.copy(tree.getStepOrNull());
        this.result = this.maker.at(tree.pos).RangeSequence(lower, upper, stepOrNull, tree.isExclusive());
    }

    @Override
    public void visitSequenceExplicit(JFXSequenceExplicit tree) {
        List<JFXExpression> items = this.copy(tree.getItems());
        this.result = this.maker.at(tree.pos).ExplicitSequence(items);
    }

    @Override
    public void visitSequenceIndexed(JFXSequenceIndexed tree) {
        JFXExpression sequence = this.copy(tree.getSequence());
        JFXExpression index = this.copy(tree.getIndex());
        this.result = this.maker.at(tree.pos).SequenceIndexed(sequence, index);
    }

    @Override
    public void visitSequenceSlice(JFXSequenceSlice tree) {
        JFXExpression sequence = this.copy(tree.getSequence());
        JFXExpression firstIndex = this.copy(tree.getFirstIndex());
        JFXExpression lastIndex = this.copy(tree.getLastIndex());
        this.result = this.maker.at(tree.pos).SequenceSlice(sequence, firstIndex, lastIndex, tree.getEndKind());
    }

    @Override
    public void visitSequenceInsert(JFXSequenceInsert tree) {
        JFXExpression sequence = this.copy(tree.getSequence());
        JFXExpression element = this.copy(tree.getElement());
        JFXExpression position = this.copy(tree.getPosition());
        this.result = this.maker.at(tree.pos).SequenceInsert(sequence, element, position, tree.shouldInsertAfter());
    }

    @Override
    public void visitSequenceDelete(JFXSequenceDelete tree) {
        JFXExpression sequence = this.copy(tree.getSequence());
        JFXExpression element = this.copy(tree.getElement());
        this.result = this.maker.at(tree.pos).SequenceDelete(sequence, element);
    }

    @Override
    public void visitForExpression(JFXForExpression tree) {
        List<JFXForExpressionInClause> inClauses = this.copy(tree.inClauses);
        JFXExpression bodyExpr = this.copy(tree.bodyExpr);
        this.result = this.maker.at(tree.pos).ForExpression(inClauses, bodyExpr);
    }

    @Override
    public void visitForExpressionInClause(JFXForExpressionInClause tree) {
        JFXVar var = this.copy(tree.var);
        JFXExpression seqExpr = this.copy(tree.seqExpr);
        JFXExpression whereExpr = this.copy(tree.whereExpr);
        this.result = this.maker.at(tree.pos).InClause(var, seqExpr, whereExpr);
    }

    @Override
    public void visitIndexof(JFXIndexof tree) {
        this.result = this.maker.at(tree.pos).Indexof(tree.fname);
    }

    @Override
    public void visitTimeLiteral(JFXTimeLiteral tree) {
        JFXLiteral literal = this.copy(tree.value);
        this.result = this.maker.at(tree.pos).TimeLiteral(literal, tree.duration);
    }

    @Override
    public void visitOverrideClassVar(JFXOverrideClassVar tree) {
        JFXIdent expr = this.copy(tree.getId());
        JFXExpression initializer = this.copy(tree.getInitializer());
        JFXOnReplace onr = this.copy(tree.getOnReplace());
        this.result = this.maker.at(tree.pos).OverrideClassVar(expr, initializer, tree.getBindStatus(), onr);
    }

    @Override
    public void visitInterpolateValue(JFXInterpolateValue tree) {
        JFXExpression attr = this.copy(tree.attribute);
        JFXExpression value = this.copy(tree.value);
        JFXExpression interpolation = this.copy(tree.interpolation);
        this.result = this.maker.at(tree.pos).InterpolateValue(attr, value, interpolation);
    }

    @Override
    public void visitKeyFrameLiteral(JFXKeyFrameLiteral tree) {
        JFXExpression start = this.copy(tree.start);
        List<JFXExpression> values = this.copy(tree.values);
        JFXExpression trigger = this.copy(tree.trigger);
        this.result = this.maker.at(tree.pos).KeyFrameLiteral(start, values, trigger);
    }
}

