/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.tree;

import com.sun.javafx.api.tree.ForExpressionInClauseTree;
import com.sun.javafx.api.tree.Tree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javafx.tree.JFXAssign;
import com.sun.tools.javafx.tree.JFXAssignOp;
import com.sun.tools.javafx.tree.JFXBinary;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXBreak;
import com.sun.tools.javafx.tree.JFXCatch;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXContinue;
import com.sun.tools.javafx.tree.JFXErroneous;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXForExpression;
import com.sun.tools.javafx.tree.JFXForExpressionInClause;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXFunctionValue;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXIfExpression;
import com.sun.tools.javafx.tree.JFXImport;
import com.sun.tools.javafx.tree.JFXIndexof;
import com.sun.tools.javafx.tree.JFXInitDefinition;
import com.sun.tools.javafx.tree.JFXInstanceOf;
import com.sun.tools.javafx.tree.JFXInstanciate;
import com.sun.tools.javafx.tree.JFXInterpolateValue;
import com.sun.tools.javafx.tree.JFXKeyFrameLiteral;
import com.sun.tools.javafx.tree.JFXLiteral;
import com.sun.tools.javafx.tree.JFXModifiers;
import com.sun.tools.javafx.tree.JFXObjectLiteralPart;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXParens;
import com.sun.tools.javafx.tree.JFXPostInitDefinition;
import com.sun.tools.javafx.tree.JFXReturn;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXSequenceDelete;
import com.sun.tools.javafx.tree.JFXSequenceEmpty;
import com.sun.tools.javafx.tree.JFXSequenceExplicit;
import com.sun.tools.javafx.tree.JFXSequenceIndexed;
import com.sun.tools.javafx.tree.JFXSequenceInsert;
import com.sun.tools.javafx.tree.JFXSequenceRange;
import com.sun.tools.javafx.tree.JFXSequenceSlice;
import com.sun.tools.javafx.tree.JFXSkip;
import com.sun.tools.javafx.tree.JFXStringExpression;
import com.sun.tools.javafx.tree.JFXThrow;
import com.sun.tools.javafx.tree.JFXTimeLiteral;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXTry;
import com.sun.tools.javafx.tree.JFXType;
import com.sun.tools.javafx.tree.JFXTypeAny;
import com.sun.tools.javafx.tree.JFXTypeCast;
import com.sun.tools.javafx.tree.JFXTypeClass;
import com.sun.tools.javafx.tree.JFXTypeFunctional;
import com.sun.tools.javafx.tree.JFXTypeUnknown;
import com.sun.tools.javafx.tree.JFXUnary;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JFXVarScriptInit;
import com.sun.tools.javafx.tree.JFXWhileLoop;
import com.sun.tools.javafx.tree.JavafxVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxTreeScanner
implements JavafxVisitor {
    public void scan(JFXTree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    public void scan(List<? extends JFXTree> trees) {
        if (trees != null) {
            List<JFXTree> l = trees;
            while (l.nonEmpty()) {
                this.scan((JFXTree)l.head);
                l = l.tail;
            }
        }
    }

    public void scan(java.util.List<? extends Tree> trees) {
        if (trees != null) {
            for (Tree tree : trees) {
                this.scan((JFXTree)tree);
            }
        }
    }

    @Override
    public void visitScript(JFXScript tree) {
        this.scan(tree.pid);
        this.scan(tree.defs);
    }

    @Override
    public void visitImport(JFXImport tree) {
        this.scan(tree.qualid);
    }

    @Override
    public void visitSkip(JFXSkip tree) {
    }

    @Override
    public void visitWhileLoop(JFXWhileLoop tree) {
        this.scan(tree.cond);
        this.scan(tree.body);
    }

    @Override
    public void visitTry(JFXTry tree) {
        this.scan(tree.body);
        this.scan(tree.catchers);
        this.scan(tree.finalizer);
    }

    @Override
    public void visitCatch(JFXCatch tree) {
        this.scan(tree.param);
        this.scan(tree.body);
    }

    @Override
    public void visitIfExpression(JFXIfExpression tree) {
        this.scan(tree.cond);
        this.scan(tree.truepart);
        this.scan(tree.falsepart);
    }

    @Override
    public void visitBreak(JFXBreak tree) {
    }

    @Override
    public void visitContinue(JFXContinue tree) {
    }

    @Override
    public void visitReturn(JFXReturn tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitThrow(JFXThrow tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitFunctionInvocation(JFXFunctionInvocation tree) {
        this.scan(tree.meth);
        this.scan(tree.args);
    }

    @Override
    public void visitParens(JFXParens tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitAssign(JFXAssign tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitAssignop(JFXAssignOp tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitUnary(JFXUnary tree) {
        this.scan(tree.arg);
    }

    @Override
    public void visitBinary(JFXBinary tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitTypeCast(JFXTypeCast tree) {
        this.scan(tree.clazz);
        this.scan(tree.expr);
    }

    @Override
    public void visitInstanceOf(JFXInstanceOf tree) {
        this.scan(tree.expr);
        this.scan(tree.clazz);
    }

    @Override
    public void visitSelect(JFXSelect tree) {
        this.scan(tree.selected);
    }

    @Override
    public void visitIdent(JFXIdent tree) {
    }

    @Override
    public void visitLiteral(JFXLiteral tree) {
    }

    @Override
    public void visitModifiers(JFXModifiers tree) {
    }

    @Override
    public void visitErroneous(JFXErroneous tree) {
    }

    @Override
    public void visitClassDeclaration(JFXClassDeclaration tree) {
        this.scan(tree.mods);
        for (JFXTree member : tree.getMembers()) {
            this.scan(member);
        }
    }

    @Override
    public void visitFunctionValue(JFXFunctionValue tree) {
        for (JFXVar param : tree.getParams()) {
            this.scan(param);
        }
        this.scan(tree.getBodyExpression());
    }

    @Override
    public void visitFunctionDefinition(JFXFunctionDefinition tree) {
        this.scan(tree.getModifiers());
        this.scan(tree.getJFXReturnType());
        this.visitFunctionValue(tree.operation);
    }

    @Override
    public void visitInitDefinition(JFXInitDefinition that) {
        this.scan(that.getBody());
    }

    @Override
    public void visitPostInitDefinition(JFXPostInitDefinition that) {
        this.scan(that.getBody());
    }

    @Override
    public void visitSequenceEmpty(JFXSequenceEmpty that) {
    }

    @Override
    public void visitSequenceRange(JFXSequenceRange that) {
        this.scan(that.getLower());
        this.scan(that.getUpper());
        this.scan(that.getStepOrNull());
    }

    @Override
    public void visitSequenceExplicit(JFXSequenceExplicit that) {
        this.scan(that.getItems());
    }

    @Override
    public void visitSequenceIndexed(JFXSequenceIndexed that) {
        this.scan(that.getSequence());
        this.scan(that.getIndex());
    }

    @Override
    public void visitSequenceSlice(JFXSequenceSlice that) {
        this.scan(that.getSequence());
        this.scan(that.getFirstIndex());
        this.scan(that.getLastIndex());
    }

    @Override
    public void visitSequenceInsert(JFXSequenceInsert that) {
        this.scan(that.getSequence());
        this.scan(that.getElement());
    }

    @Override
    public void visitSequenceDelete(JFXSequenceDelete that) {
        this.scan(that.getSequence());
        this.scan(that.getElement());
    }

    @Override
    public void visitStringExpression(JFXStringExpression that) {
        List<JFXExpression> parts = that.getParts();
        parts = parts.tail;
        while (parts.nonEmpty()) {
            parts = parts.tail;
            this.scan((JFXTree)parts.head);
            parts = parts.tail;
            parts = parts.tail;
        }
    }

    @Override
    public void visitInstanciate(JFXInstanciate tree) {
        this.scan(tree.getIdentifier());
        this.scan(tree.getArgs());
        this.scan(tree.getParts());
        this.scan(tree.getLocalvars());
        this.scan(tree.getClassBody());
    }

    @Override
    public void visitObjectLiteralPart(JFXObjectLiteralPart tree) {
        this.scan(tree.getExpression());
    }

    @Override
    public void visitTypeAny(JFXTypeAny that) {
    }

    @Override
    public void visitTypeClass(JFXTypeClass that) {
    }

    @Override
    public void visitTypeFunctional(JFXTypeFunctional that) {
        for (JFXType param : (List)that.getParameters()) {
            this.scan(param);
        }
        this.scan((JFXType)that.getReturnType());
    }

    @Override
    public void visitTypeUnknown(JFXTypeUnknown that) {
    }

    @Override
    public void visitVarScriptInit(JFXVarScriptInit tree) {
    }

    @Override
    public void visitVar(JFXVar tree) {
        this.scan(tree.getJFXType());
        this.scan(tree.mods);
        this.scan(tree.init);
        this.scan(tree.getOnReplace());
    }

    @Override
    public void visitOverrideClassVar(JFXOverrideClassVar tree) {
        this.scan(tree.getId());
        this.scan(tree.getInitializer());
        this.scan(tree.getOnReplace());
    }

    @Override
    public void visitOnReplace(JFXOnReplace tree) {
        this.scan(tree.getFirstIndex());
        this.scan(tree.getOldValue());
        this.scan(tree.getBody());
        this.scan(tree.getLastIndex());
        this.scan(tree.getNewElements());
    }

    @Override
    public void visitForExpression(JFXForExpression that) {
        for (ForExpressionInClauseTree cl : that.getInClauses()) {
            JFXForExpressionInClause clause = (JFXForExpressionInClause)cl;
            this.scan(clause);
        }
        this.scan(that.getBodyExpression());
    }

    @Override
    public void visitForExpressionInClause(JFXForExpressionInClause that) {
        this.scan(that.getVar());
        this.scan(that.getSequenceExpression());
        this.scan(that.getWhereExpression());
    }

    @Override
    public void visitBlockExpression(JFXBlock that) {
        this.scan(that.stats);
        this.scan(that.value);
    }

    @Override
    public void visitIndexof(JFXIndexof that) {
    }

    public void visitTree(JFXTree that) {
        assert (false) : "Should not be here!!!";
    }

    @Override
    public void visitTimeLiteral(JFXTimeLiteral tree) {
    }

    @Override
    public void visitInterpolateValue(JFXInterpolateValue that) {
        this.scan(that.attribute);
        this.scan(that.value);
        if (that.interpolation != null) {
            this.scan(that.interpolation);
        }
    }

    @Override
    public void visitKeyFrameLiteral(JFXKeyFrameLiteral that) {
        this.scan(that.start);
        for (JFXExpression value : that.values) {
            this.scan(value);
        }
        if (that.trigger != null) {
            this.scan(that.trigger);
        }
    }
}

