/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import java.util.AbstractList;
import java.util.List;
import javafx.reflect.FXContext;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXMember;
import javafx.reflect.FXMemberFilter;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXType;
import javafx.reflect.FXVarMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FXClassType
extends FXType
implements FXMember {
    String name;
    FXContext context;
    protected int modifiers;
    protected static final int COMPOUND_CLASS = 1;
    protected static final int FX_CLASS = 2;
    public static final String SEQUENCE_CLASSNAME = "com.sun.javafx.runtime.sequence.Sequence";
    public static final String OBJECT_VARIABLE_CLASSNAME = "com.sun.javafx.runtime.location.ObjectVariable";
    public static final String SEQUENCE_VARIABLE_CLASSNAME = "com.sun.javafx.runtime.location.SequenceVariable";
    public static final String DOUBLE_VARIABLE_CLASSNAME = "com.sun.javafx.runtime.location.DoubleVariable";
    public static final String INT_VARIABLE_CLASSNAME = "com.sun.javafx.runtime.location.IntVariable";
    public static final String BOOLEAN_VARIABLE_CLASSNAME = "com.sun.javafx.runtime.location.BooleanVariable";
    public static final String FUNCTION_CLASSNAME_PREFIX = "com.sun.javafx.functions.Function";
    public static final String GETTER_PREFIX = "get$";
    public static final String SETTER_PREFIX = "set$";

    protected FXClassType(FXContext context, int modifiers) {
        this.context = context;
        this.modifiers = modifiers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "class " + this.getName();
    }

    public boolean equals(FXClassType other) {
        return this.context.equals(other.context) && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public abstract List<FXClassType> getSuperClasses(boolean var1);

    public boolean isCompoundClass() {
        return (this.modifiers & 1) != 0;
    }

    @Override
    public boolean isJfxType() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isAssignableFrom(FXClassType cls) {
        if (this.equals(cls)) {
            return true;
        }
        List<FXClassType> supers = cls.getSuperClasses(false);
        for (FXClassType s : supers) {
            if (!this.isAssignableFrom(s)) continue;
            return true;
        }
        return false;
    }

    public List<FXMember> getMembers(FXMemberFilter filter, boolean all) {
        SortedMemberArray<FXMember> result = new SortedMemberArray<FXMember>();
        if (all) {
            List<FXClassType> supers = this.getSuperClasses(all);
            for (FXClassType cl : supers) {
                cl.getMembers(filter, result);
            }
        } else {
            this.getMembers(filter, result);
        }
        return result;
    }

    public List<FXMember> getMembers(boolean all) {
        return this.getMembers(new FXMemberFilter(), all);
    }

    protected void getMembers(FXMemberFilter filter, SortedMemberArray<FXMember> result) {
        this.getVariables(filter, result);
        this.getFunctions(filter, result);
    }

    public List<FXFunctionMember> getFunctions(FXMemberFilter filter, boolean all) {
        SortedMemberArray<FXFunctionMember> result = new SortedMemberArray<FXFunctionMember>();
        if (all) {
            List<FXClassType> supers = this.getSuperClasses(all);
            for (FXClassType cl : supers) {
                cl.getFunctions(filter, result);
            }
        } else {
            this.getFunctions(filter, result);
        }
        return result;
    }

    public List<FXFunctionMember> getFunctions(boolean all) {
        return this.getFunctions(FXMemberFilter.acceptMethods(), all);
    }

    protected abstract void getFunctions(FXMemberFilter var1, SortedMemberArray<? super FXFunctionMember> var2);

    public List<FXVarMember> getVariables(FXMemberFilter filter, boolean all) {
        SortedMemberArray<FXVarMember> result = new SortedMemberArray<FXVarMember>();
        if (all) {
            List<FXClassType> supers = this.getSuperClasses(all);
            for (FXClassType cl : supers) {
                cl.getVariables(filter, result);
            }
        } else {
            this.getVariables(filter, result);
        }
        return result;
    }

    public List<FXVarMember> getVariables(boolean all) {
        return this.getVariables(FXMemberFilter.acceptAttributes(), all);
    }

    protected abstract void getVariables(FXMemberFilter var1, SortedMemberArray<? super FXVarMember> var2);

    public FXMember getMember(String name, FXType type) {
        throw new UnsupportedOperationException("getMember not implemented yet.");
    }

    public FXVarMember getVariable(String name) {
        FXMemberFilter filter = new FXMemberFilter();
        filter.setAttributesAccepted(true);
        filter.setRequiredName(name);
        List<FXVarMember> attrs = this.getVariables(filter, true);
        return attrs.isEmpty() ? null : attrs.get(0);
    }

    public abstract FXFunctionMember getFunction(String var1, FXType ... var2);

    public FXContext getReflectionContext() {
        return this.context;
    }

    public abstract FXObjectValue allocate();

    public FXObjectValue newInstance() {
        return this.allocate().initialize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SortedMemberArray<T extends FXMember>
    extends AbstractList<T> {
        FXMember[] buffer = new FXMember[4];
        int sz;

        protected SortedMemberArray() {
        }

        @Override
        public T get(int index) {
            if (index >= this.sz) {
                throw new IndexOutOfBoundsException();
            }
            return (T)this.buffer[index];
        }

        @Override
        public int size() {
            return this.sz;
        }

        boolean insert(T cl) {
            int i;
            String clname = cl.getName();
            for (i = 0; i < this.sz; ++i) {
                FXMember c = this.buffer[i];
                int cmp = c.getName().compareToIgnoreCase(clname);
                if (cmp == 0) {
                    cmp = c.getName().compareTo(clname);
                }
                if (cmp > 0) break;
                if (cmp < 0) continue;
                FXClassType clowner = cl.getDeclaringClass();
                FXClassType cowner = c.getDeclaringClass();
                boolean clAssignableFromC = clowner.isAssignableFrom(cowner);
                boolean cAssignableFromCl = cowner.isAssignableFrom(clowner);
                if (clAssignableFromC && !cAssignableFromCl) break;
                if (cAssignableFromCl && !clAssignableFromC) continue;
                String clownerName = clowner.getName();
                String cownerName = cowner.getName();
                cmp = cownerName.compareToIgnoreCase(clownerName);
                if (cmp == 0) {
                    cmp = cownerName.compareTo(clownerName);
                }
                if (cmp > 0) break;
                if (cmp < 0) continue;
                if (cl instanceof FXClassType) break;
                if (c instanceof FXClassType) continue;
                if (cl instanceof FXVarMember) break;
                if (c instanceof FXVarMember) continue;
                if (!(cl instanceof FXFunctionMember) || !(c instanceof FXFunctionMember)) break;
                String scl = ((FXFunctionMember)cl).getType().toString();
                String sc = ((FXFunctionMember)c).getType().toString();
                cmp = sc.compareToIgnoreCase(scl);
                if (cmp == 0) {
                    cmp = sc.compareTo(scl);
                }
                if (cmp >= 0) break;
            }
            if (this.sz == this.buffer.length) {
                FXMember[] tmp = new FXMember[2 * this.sz];
                System.arraycopy(this.buffer, 0, tmp, 0, this.sz);
                this.buffer = tmp;
            }
            System.arraycopy(this.buffer, i, this.buffer, i + 1, this.sz - i);
            this.buffer[i] = cl;
            ++this.sz;
            return true;
        }
    }
}

