/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXBooleanValue;
import javafx.reflect.FXClassType;
import javafx.reflect.FXIntegerValue;
import javafx.reflect.FXLocal;
import javafx.reflect.FXNumberValue;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceBuilder;
import javafx.reflect.FXSequenceValue;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;

public abstract class FXContext {
    public static final String INTERFACE_SUFFIX = "$Intf";
    public static final String FXOBJECT_NAME = "com.sun.javafx.runtime.FXObject";
    FXType anyType = this.findClass("java.lang.Object");

    public static FXContext getInstance() {
        return FXLocal.getContext();
    }

    protected FXContext() {
    }

    public abstract FXClassType findClass(String var1);

    public FXType getAnyType() {
        return this.anyType;
    }

    public FXPrimitiveType getBooleanType() {
        return FXPrimitiveType.booleanType;
    }

    public FXPrimitiveType getIntegerType() {
        return FXPrimitiveType.integerType;
    }

    public FXPrimitiveType getNumberType() {
        return FXPrimitiveType.numberType;
    }

    public FXPrimitiveType getVoidType() {
        return FXPrimitiveType.voidType;
    }

    public FXSequenceBuilder makeSequenceBuilder(FXType elementType) {
        return new FXSequenceBuilder(this, elementType);
    }

    public FXValue makeSequence(FXType elementType, FXValue ... values) {
        FXSequenceBuilder builder = this.makeSequenceBuilder(elementType);
        for (int i = 0; i < values.length; ++i) {
            builder.append(values[i]);
        }
        return builder.getSequence();
    }

    public FXValue makeSequenceValue(FXValue[] values, int nvalues, FXType elementType) {
        return new FXSequenceValue(values, nvalues, elementType);
    }

    public FXValue mirrorOf(boolean value) {
        return new FXBooleanValue(value, this.getBooleanType());
    }

    public FXValue mirrorOf(int value) {
        return new FXIntegerValue(value, this.getIntegerType());
    }

    public FXValue mirrorOf(double value) {
        return new FXNumberValue(value, this.getNumberType());
    }

    public abstract FXValue mirrorOf(String var1);
}

