/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javadoc.AnnotationValueImpl;
import com.sun.tools.javadoc.DocEnv;

public class AnnotationDescImpl
implements AnnotationDesc {
    private final DocEnv env;
    private final Attribute.Compound annotation;

    AnnotationDescImpl(DocEnv env, Attribute.Compound annotation) {
        this.env = env;
        this.annotation = annotation;
    }

    public AnnotationTypeDoc annotationType() {
        Symbol.ClassSymbol atsym = (Symbol.ClassSymbol)this.annotation.type.tsym;
        return (AnnotationTypeDoc)((Object)this.env.getClassDoc(atsym));
    }

    public AnnotationDesc.ElementValuePair[] elementValues() {
        List<Pair<Symbol.MethodSymbol, Attribute>> vals = this.annotation.values;
        AnnotationDesc.ElementValuePair[] res = new AnnotationDesc.ElementValuePair[vals.length()];
        int i = 0;
        for (Pair<Symbol.MethodSymbol, Attribute> val : vals) {
            res[i++] = new ElementValuePairImpl(this.env, (Symbol.MethodSymbol)val.fst, (Attribute)val.snd);
        }
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("@");
        sb.append(this.annotation.type.tsym);
        AnnotationDesc.ElementValuePair[] vals = this.elementValues();
        if (vals.length > 0) {
            sb.append('(');
            boolean first = true;
            for (AnnotationDesc.ElementValuePair val : vals) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                String name = val.element().name();
                if (vals.length == 1 && name.equals("value")) {
                    sb.append(val.value());
                    continue;
                }
                sb.append(val);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static class ElementValuePairImpl
    implements AnnotationDesc.ElementValuePair {
        private final DocEnv env;
        private final Symbol.MethodSymbol meth;
        private final Attribute value;

        ElementValuePairImpl(DocEnv env, Symbol.MethodSymbol meth, Attribute value) {
            this.env = env;
            this.meth = meth;
            this.value = value;
        }

        public AnnotationTypeElementDoc element() {
            return this.env.getAnnotationTypeElementDoc(this.meth);
        }

        public AnnotationValue value() {
            return new AnnotationValueImpl(this.env, this.value);
        }

        public String toString() {
            return this.meth.name + "=" + this.value();
        }
    }
}

