/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.javadoc.Comment;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.text.CollationKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DocImpl
implements Doc,
Comparable<Object> {
    protected final DocEnv env;
    private Comment comment;
    private CollationKey collationkey = null;
    protected String documentation;
    private Tag[] firstSentence;
    private Tag[] inlineTags;

    DocImpl(DocEnv env, String documentation) {
        this.documentation = documentation;
        this.env = env;
    }

    String documentation() {
        if (this.documentation == null) {
            this.documentation = "";
        }
        return this.documentation;
    }

    Comment comment() {
        if (this.comment == null) {
            this.comment = new Comment(this, this.documentation());
        }
        return this.comment;
    }

    @Override
    public String commentText() {
        return this.comment().commentText();
    }

    @Override
    public Tag[] tags() {
        return this.comment().tags();
    }

    @Override
    public Tag[] tags(String tagname) {
        return this.comment().tags(tagname);
    }

    @Override
    public SeeTag[] seeTags() {
        return this.comment().seeTags();
    }

    @Override
    public Tag[] inlineTags() {
        if (this.inlineTags == null) {
            this.inlineTags = Comment.getInlineTags(this, this.commentText());
        }
        return this.inlineTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag[] firstSentenceTags() {
        if (this.firstSentence == null) {
            this.inlineTags();
            try {
                this.env.setSilent(true);
                this.firstSentence = Comment.firstSentenceTags(this, this.commentText());
            }
            finally {
                this.env.setSilent(false);
            }
        }
        return this.firstSentence;
    }

    String readHTMLDocumentation(InputStream input, String filename) throws IOException {
        int endIdx;
        int filesize = input.available();
        byte[] filecontents = new byte[filesize];
        input.read(filecontents, 0, filesize);
        input.close();
        String encoding = this.env.getEncoding();
        String rawDoc = encoding != null ? new String(filecontents, encoding) : new String(filecontents);
        String upper = null;
        int bodyIdx = rawDoc.indexOf("<body");
        if (bodyIdx == -1 && (bodyIdx = rawDoc.indexOf("<BODY")) == -1 && (bodyIdx = (upper = rawDoc.toUpperCase()).indexOf("<BODY")) == -1) {
            this.env.error(SourcePositionImpl.make(filename, -1, null), "javadoc.Body_missing_from_html_file");
            return "";
        }
        if ((bodyIdx = rawDoc.indexOf(62, bodyIdx)) == -1) {
            this.env.error(SourcePositionImpl.make(filename, -1, null), "javadoc.Body_missing_from_html_file");
            return "";
        }
        if ((endIdx = rawDoc.indexOf("</body", ++bodyIdx)) == -1 && (endIdx = rawDoc.indexOf("</BODY", bodyIdx)) == -1) {
            if (upper == null) {
                upper = rawDoc.toUpperCase();
            }
            if ((endIdx = upper.indexOf("</BODY", bodyIdx)) == -1) {
                this.env.error(SourcePositionImpl.make(filename, -1, null), "javadoc.End_body_missing_from_html_file");
                return "";
            }
        }
        return rawDoc.substring(bodyIdx, endIdx);
    }

    @Override
    public String getRawCommentText() {
        return this.documentation();
    }

    @Override
    public void setRawCommentText(String rawDocumentation) {
        this.documentation = rawDocumentation;
        this.comment = null;
    }

    CollationKey key() {
        if (this.collationkey == null) {
            this.collationkey = this.generateKey();
        }
        return this.collationkey;
    }

    CollationKey generateKey() {
        String k = this.name();
        return this.env.doclocale.collator.getCollationKey(k);
    }

    public String toString() {
        return this.qualifiedName();
    }

    @Override
    public abstract String name();

    public abstract String qualifiedName();

    @Override
    public int compareTo(Object obj) {
        return this.key().compareTo(((DocImpl)obj).key());
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isEnumConstant() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isMethod() {
        return false;
    }

    @Override
    public boolean isAnnotationTypeElement() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isException() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public abstract boolean isIncluded();

    @Override
    public SourcePosition position() {
        return null;
    }
}

