/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafxdoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafxdoc.DocEnv;
import com.sun.tools.javafxdoc.MemberDocImpl;
import com.sun.tools.javafxdoc.SourcePositionImpl;
import com.sun.tools.javafxdoc.TypeMaker;

public class FieldDocImpl
extends MemberDocImpl
implements FieldDoc {
    protected final Symbol.VarSymbol sym;

    public FieldDocImpl(DocEnv env, Symbol.VarSymbol sym, String rawDocs, JFXVar tree, Position.LineMap lineMap) {
        super(env, sym, rawDocs, tree, lineMap);
        this.sym = sym;
    }

    public FieldDocImpl(DocEnv env, Symbol.VarSymbol sym) {
        this(env, sym, null, null, null);
    }

    protected Symbol.ClassSymbol getContainingClass() {
        return this.sym.enclClass();
    }

    public Type type() {
        this.sym.complete();
        return TypeMaker.getType(this.env, this.sym.type, false);
    }

    public com.sun.tools.javac.code.Type rawType() {
        this.sym.complete();
        return this.sym.type;
    }

    public Object constantValue() {
        Object result = this.sym.getConstValue();
        if (result != null && this.sym.type.tag == 8) {
            result = (Integer)result != 0;
        }
        return result;
    }

    public String constantValueExpression() {
        return FieldDocImpl.constantValueExpression(this.constantValue());
    }

    static String constantValueExpression(Object cb) {
        if (cb == null) {
            return null;
        }
        if (cb instanceof Character) {
            return FieldDocImpl.sourceForm(((Character)cb).charValue());
        }
        if (cb instanceof Byte) {
            return FieldDocImpl.sourceForm((Byte)cb);
        }
        if (cb instanceof String) {
            return FieldDocImpl.sourceForm((String)cb);
        }
        if (cb instanceof Double) {
            return FieldDocImpl.sourceForm((Double)cb, 'd');
        }
        if (cb instanceof Float) {
            return FieldDocImpl.sourceForm(((Float)cb).doubleValue(), 'f');
        }
        if (cb instanceof Long) {
            return cb + "L";
        }
        return cb.toString();
    }

    private static String sourceForm(double v, char suffix) {
        if (Double.isNaN(v)) {
            return "0" + suffix + "/0" + suffix;
        }
        if (v == Double.POSITIVE_INFINITY) {
            return "1" + suffix + "/0" + suffix;
        }
        if (v == Double.NEGATIVE_INFINITY) {
            return "-1" + suffix + "/0" + suffix;
        }
        return v + (suffix == 'f' || suffix == 'F' ? "" + suffix : "");
    }

    private static String sourceForm(char c) {
        StringBuffer buf = new StringBuffer(8);
        buf.append('\'');
        FieldDocImpl.sourceChar(c, buf);
        buf.append('\'');
        return buf.toString();
    }

    private static String sourceForm(byte c) {
        return "0x" + Integer.toString(c & 0xFF, 16);
    }

    private static String sourceForm(String s) {
        StringBuffer buf = new StringBuffer(s.length() + 5);
        buf.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            FieldDocImpl.sourceChar(c, buf);
        }
        buf.append('\"');
        return buf.toString();
    }

    private static void sourceChar(char c, StringBuffer buf) {
        switch (c) {
            case '\b': {
                buf.append("\\b");
                return;
            }
            case '\t': {
                buf.append("\\t");
                return;
            }
            case '\n': {
                buf.append("\\n");
                return;
            }
            case '\f': {
                buf.append("\\f");
                return;
            }
            case '\r': {
                buf.append("\\r");
                return;
            }
            case '\"': {
                buf.append("\\\"");
                return;
            }
            case '\'': {
                buf.append("\\'");
                return;
            }
            case '\\': {
                buf.append("\\\\");
                return;
            }
        }
        if (FieldDocImpl.isPrintableAscii(c)) {
            buf.append(c);
            return;
        }
        FieldDocImpl.unicodeEscape(c, buf);
    }

    private static void unicodeEscape(char c, StringBuffer buf) {
        String chars = "0123456789abcdef";
        buf.append("\\u");
        buf.append("0123456789abcdef".charAt(0xF & c >> 12));
        buf.append("0123456789abcdef".charAt(0xF & c >> 8));
        buf.append("0123456789abcdef".charAt(0xF & c >> 4));
        buf.append("0123456789abcdef".charAt(0xF & c >> 0));
    }

    private static boolean isPrintableAscii(char c) {
        return c >= ' ' && c <= '~';
    }

    public boolean isIncluded() {
        return this.containingClass().isIncluded() && this.env.shouldDocument(this.sym);
    }

    public boolean isField() {
        return !this.isEnumConstant();
    }

    public boolean isEnumConstant() {
        return (this.getFlags() & 0x4000L) != 0L && !this.env.legacyDoclet;
    }

    public boolean isTransient() {
        return (this.getFlags() & 0x80L) != 0L;
    }

    public boolean isVolatile() {
        return (this.getFlags() & 0x40L) != 0L;
    }

    public boolean isSynthetic() {
        return (this.getFlags() & 0x1000L) != 0L;
    }

    public boolean isPublicRead() {
        return (this.getFlags() & 0x40000000000L) != 0L;
    }

    public boolean isPublicInit() {
        return (this.getFlags() & 0x80000000000L) != 0L;
    }

    public boolean isDef() {
        return (this.getFlags() & 0x20000000000L) != 0L;
    }

    public SerialFieldTag[] serialFieldTags() {
        return this.comment().serialFieldTags();
    }

    public String name() {
        return this.sym.name.toString();
    }

    public String qualifiedName() {
        return this.sym.enclClass().getQualifiedName() + "." + this.name();
    }

    public SourcePosition position() {
        if (this.sym.enclClass().sourcefile == null) {
            return null;
        }
        return SourcePositionImpl.make(this.sym.enclClass().sourcefile.toString(), this.tree == null ? 0 : this.tree.pos, this.lineMap);
    }
}

