/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafxdoc;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messager
extends Log
implements DocErrorReporter {
    private final String programName;
    private ResourceBundle messageRB = null;
    static final PrintWriter defaultErrWriter = new PrintWriter(System.err);
    static final PrintWriter defaultWarnWriter = new PrintWriter(System.err);
    static final PrintWriter defaultNoticeWriter = new PrintWriter(System.out);

    public static Messager instance0(Context context) {
        Log instance = (Log)context.get(logKey);
        if (instance == null || !(instance instanceof Messager)) {
            throw new InternalError("no messager instance!");
        }
        return (Messager)instance;
    }

    public static void preRegister(final Context context, final String programName) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make() {
                return new Messager(context, programName);
            }
        });
    }

    public static void preRegister(final Context context, final String programName, final PrintWriter errWriter, final PrintWriter warnWriter, final PrintWriter noticeWriter) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make() {
                return new Messager(context, programName, errWriter, warnWriter, noticeWriter);
            }
        });
    }

    protected Messager(Context context, String programName) {
        this(context, programName, defaultErrWriter, defaultWarnWriter, defaultNoticeWriter);
    }

    protected Messager(Context context, String programName, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        super(context, errWriter, warnWriter, noticeWriter);
        this.programName = programName;
    }

    public void reset() {
        this.messageRB = null;
    }

    private String getString(String key) {
        ResourceBundle msgRB = this.messageRB;
        if (msgRB == null) {
            try {
                this.messageRB = msgRB = ResourceBundle.getBundle("com.sun.tools.javafxdoc.resources.javafxdoc");
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource for javafxdoc is missing");
            }
        }
        return msgRB.getString(key);
    }

    String getText(String key, Object ... args) {
        try {
            String message = this.getString(key);
            return MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            return "********** Resource for javafxdoc is broken. There is no " + key + " key in resource.";
        }
    }

    public void printError(String msg) {
        this.printError(null, msg);
    }

    public void printError(SourcePosition pos, String msg) {
        String prefix = pos == null ? this.programName : ((Object)pos).toString();
        this.errWriter.println(prefix + ": " + this.getText("javadoc.error", new Object[0]) + " - " + msg);
        this.errWriter.flush();
        this.prompt();
        ++this.nerrors;
    }

    public void printWarning(String msg) {
        this.printWarning(null, msg);
    }

    public void printWarning(SourcePosition pos, String msg) {
        String prefix = pos == null ? this.programName : ((Object)pos).toString();
        this.warnWriter.println(prefix + ": " + this.getText("javadoc.warning", new Object[0]) + " - " + msg);
        this.warnWriter.flush();
        ++this.nwarnings;
    }

    public void printNotice(String msg) {
        this.printNotice(null, msg);
    }

    public void printNotice(SourcePosition pos, String msg) {
        if (pos == null) {
            this.noticeWriter.println(msg);
        } else {
            this.noticeWriter.println(pos + ": " + msg);
        }
        this.noticeWriter.flush();
    }

    public void error(String key, Object ... arg1) {
        this.printError(this.getText(key, arg1));
    }

    public void error(SourcePosition pos, String key, Object ... args) {
        this.printError(pos, this.getText(key, args));
    }

    public void warning(SourcePosition pos, String key, Object ... args) {
        this.printWarning(pos, this.getText(key, args));
    }

    public void warning(String key, Object ... args) {
        this.printWarning(this.getText(key, args));
    }

    public void notice(String key, Object ... args) {
        this.printNotice(this.getText(key, args));
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public void exitNotice() {
        int nerrs = this.nerrors();
        int nwarn = this.nwarnings();
        if (nerrs > 0) {
            this.notice(nerrs > 1 ? "main.errors" : "main.error", "" + nerrs);
        }
        if (nwarn > 0) {
            this.notice(nwarn > 1 ? "main.warnings" : "main.warning", "" + nwarn);
        }
    }

    public void exit() {
        throw new ExitJavadoc();
    }

    public class ExitJavadoc
    extends Error {
        private static final long serialVersionUID = 0L;
    }
}

