/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafxdoc;

import com.sun.javadoc.LanguageVersion;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javafxdoc.DocletInvoker;
import com.sun.tools.javafxdoc.JavafxdocTool;
import com.sun.tools.javafxdoc.Messager;
import com.sun.tools.javafxdoc.ModifierFilter;
import com.sun.tools.javafxdoc.RootDocImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Start {
    private final Context context;
    private final String defaultDocletClassName;
    private static final String javafxdocName = "javafxdoc";
    private static final String standardDocletClassName = "com.sun.tools.xmldoclet.XMLDoclet";
    private ListBuffer<String[]> options = new ListBuffer();
    private ModifierFilter showAccess = null;
    private long defaultFilter = 0xC0000000005L;
    private Messager messager;
    String docLocale = "";
    boolean breakiterator = false;
    boolean quiet = false;
    String encoding = null;
    private DocletInvoker docletInvoker;
    private boolean rejectWarnings = false;

    Start(String programName, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter, String defaultDocletClassName) {
        this.context = new Context();
        this.messager = new Messager(this.context, programName, errWriter, warnWriter, noticeWriter);
        this.defaultDocletClassName = defaultDocletClassName;
    }

    Start(String programName, String defaultDocletClassName) {
        this.context = new Context();
        this.messager = new Messager(this.context, programName);
        this.defaultDocletClassName = defaultDocletClassName;
    }

    Start(String programName) {
        this(programName, standardDocletClassName);
    }

    Start() {
        this(javafxdocName);
    }

    private void usage() {
        this.messager.notice("main.usage", new Object[0]);
        if (this.docletInvoker != null) {
            this.docletInvoker.optionLength("-help");
        }
    }

    private void exit() {
        this.messager.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int begin(String[] argv) {
        boolean failed = false;
        try {
            failed = !this.parseAndExecute(argv);
        }
        catch (Messager.ExitJavadoc exc) {
        }
        catch (OutOfMemoryError ee) {
            this.messager.error("main.out.of.memory", new Object[0]);
            failed = true;
        }
        catch (Error ee) {
            ee.printStackTrace();
            this.messager.error("main.fatal.error", new Object[0]);
            failed = true;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            this.messager.error("main.fatal.exception", new Object[0]);
            failed = true;
        }
        finally {
            this.messager.exitNotice();
            this.messager.flush();
        }
        failed |= this.messager.nerrors() > 0;
        return (failed |= this.rejectWarnings && this.messager.nwarnings() > 0) ? 1 : 0;
    }

    private void addToList(ListBuffer<String> list, String str) {
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            list.append(current);
        }
    }

    private boolean parseAndExecute(String[] argv) throws IOException {
        boolean ok;
        JavafxdocTool comp;
        long tm = System.currentTimeMillis();
        ListBuffer<String> javaNames = new ListBuffer<String>();
        try {
            argv = CommandLine.parse(argv);
        }
        catch (FileNotFoundException e) {
            this.messager.error("main.cant.read", e.getMessage());
            this.exit();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.exit();
        }
        this.setDocletInvoker(argv);
        ListBuffer<String> subPackages = new ListBuffer<String>();
        ListBuffer<String> excludedPackages = new ListBuffer<String>();
        Options compOpts = Options.instance(this.context);
        boolean docClasses = false;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-subpackages")) {
                this.oneArg(argv, i++);
                this.addToList(subPackages, argv[i]);
                continue;
            }
            if (arg.equals("-exclude")) {
                this.oneArg(argv, i++);
                this.addToList(excludedPackages, argv[i]);
                continue;
            }
            if (arg.equals("-verbose")) {
                this.setOption(arg);
                compOpts.put("-verbose", "");
                continue;
            }
            if (arg.equals("-encoding")) {
                this.oneArg(argv, i++);
                this.encoding = argv[i];
                compOpts.put("-encoding", argv[i]);
                continue;
            }
            if (arg.equals("-breakiterator")) {
                this.breakiterator = true;
                this.setOption("-breakiterator");
                continue;
            }
            if (arg.equals("-quiet")) {
                this.quiet = true;
                this.setOption("-quiet");
                continue;
            }
            if (arg.equals("-help")) {
                this.usage();
                this.exit();
                continue;
            }
            if (arg.equals("-Xclasses")) {
                this.setOption(arg);
                docClasses = true;
                continue;
            }
            if (arg.equals("-Xwerror")) {
                this.setOption(arg);
                this.rejectWarnings = true;
                continue;
            }
            if (arg.equals("-private")) {
                this.setOption(arg);
                this.setFilter(0x300000000005L);
                continue;
            }
            if (arg.equals("-package")) {
                this.setOption(arg);
                this.setFilter(30786325577733L);
                continue;
            }
            if (arg.equals("-protected")) {
                this.setOption(arg);
                this.setFilter(0xC0000000005L);
                continue;
            }
            if (arg.equals("-public")) {
                this.setOption(arg);
                this.setFilter(0xC0000000001L);
                continue;
            }
            if (arg.equals("-source")) {
                this.oneArg(argv, i++);
                if (compOpts.get("-source") != null) {
                    this.usageError("main.option.already.seen", arg);
                }
                compOpts.put("-source", argv[i]);
                continue;
            }
            if (arg.equals("-prompt")) {
                compOpts.put("-prompt", "-prompt");
                this.messager.promptOnError = true;
                continue;
            }
            if (arg.equals("-sourcepath")) {
                this.oneArg(argv, i++);
                if (compOpts.get("-sourcepath") != null) {
                    this.usageError("main.option.already.seen", arg);
                }
                compOpts.put("-sourcepath", argv[i]);
                continue;
            }
            if (arg.equals("-classpath")) {
                this.oneArg(argv, i++);
                if (compOpts.get("-classpath") != null) {
                    this.usageError("main.option.already.seen", arg);
                }
                compOpts.put("-classpath", argv[i]);
                continue;
            }
            if (arg.equals("-sysclasspath")) {
                this.oneArg(argv, i++);
                if (compOpts.get("-bootclasspath") != null) {
                    this.usageError("main.option.already.seen", arg);
                }
                compOpts.put("-bootclasspath", argv[i]);
                continue;
            }
            if (arg.equals("-bootclasspath")) {
                this.oneArg(argv, i++);
                if (compOpts.get("-bootclasspath") != null) {
                    this.usageError("main.option.already.seen", arg);
                }
                compOpts.put("-bootclasspath", argv[i]);
                continue;
            }
            if (arg.equals("-extdirs")) {
                this.oneArg(argv, i++);
                if (compOpts.get("-extdirs") != null) {
                    this.usageError("main.option.already.seen", arg);
                }
                compOpts.put("-extdirs", argv[i]);
                continue;
            }
            if (arg.equals("-overview")) {
                this.oneArg(argv, i++);
                continue;
            }
            if (arg.equals("-doclet")) {
                ++i;
                continue;
            }
            if (arg.equals("-docletpath")) {
                ++i;
                continue;
            }
            if (arg.equals("-locale")) {
                if (i != 0) {
                    this.usageError("main.locale_first", new Object[0]);
                }
                this.oneArg(argv, i++);
                this.docLocale = argv[i];
                continue;
            }
            if (arg.startsWith("-XD")) {
                String s = arg.substring("-XD".length());
                int eq = s.indexOf(61);
                String key = eq < 0 ? s : s.substring(0, eq);
                String value = eq < 0 ? s : s.substring(eq + 1);
                compOpts.put(key, value);
                continue;
            }
            if (arg.startsWith("-")) {
                int optionLength = this.docletInvoker.optionLength(arg);
                if (optionLength < 0) {
                    this.exit();
                    continue;
                }
                if (optionLength == 0) {
                    this.usageError("main.invalid_flag", arg);
                    continue;
                }
                if (i + optionLength > argv.length) {
                    this.usageError("main.requires_argument", arg);
                }
                ListBuffer<String> args = new ListBuffer<String>();
                for (int j = 0; j < optionLength - 1; ++j) {
                    args.append(argv[++i]);
                }
                this.setOption(arg, args.toList());
                continue;
            }
            javaNames.append(arg);
        }
        if (javaNames.isEmpty() && subPackages.isEmpty()) {
            this.usageError("main.No_packages_or_classes_specified", new Object[0]);
        }
        if (!this.docletInvoker.validOptions(this.options.toList())) {
            this.exit();
        }
        if ((comp = JavafxdocTool.make0(this.context)) == null) {
            return false;
        }
        if (this.showAccess == null) {
            this.setFilter(this.defaultFilter);
        }
        LanguageVersion languageVersion = this.docletInvoker.languageVersion();
        RootDocImpl root = comp.getRootDocImpl(this.docLocale, this.encoding, this.showAccess, javaNames.toList(), this.options.toList(), this.breakiterator, subPackages.toList(), excludedPackages.toList(), docClasses, languageVersion == null || languageVersion == LanguageVersion.JAVA_1_1, this.quiet);
        boolean bl = ok = root != null;
        if (ok) {
            ok = this.docletInvoker.start(root);
        }
        if (compOpts.get("-verbose") != null) {
            tm = System.currentTimeMillis() - tm;
            this.messager.notice("main.done_in", Long.toString(tm));
        }
        return ok;
    }

    private void setDocletInvoker(String[] argv) {
        String docletClassName = null;
        String docletPath = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-doclet")) {
                this.oneArg(argv, i++);
                if (docletClassName != null) {
                    this.usageError("main.more_than_one_doclet_specified_0_and_1", docletClassName, argv[i]);
                }
                docletClassName = argv[i];
                continue;
            }
            if (!arg.equals("-docletpath")) continue;
            this.oneArg(argv, i++);
            docletPath = docletPath == null ? argv[i] : docletPath + File.pathSeparator + argv[i];
        }
        if (docletClassName == null) {
            docletClassName = this.defaultDocletClassName;
        }
        this.docletInvoker = new DocletInvoker(this.messager, docletClassName, docletPath);
    }

    private void setFilter(long filterBits) {
        if (this.showAccess != null) {
            this.messager.error("main.incompatible.access.flags", new Object[0]);
            this.usage();
            this.exit();
        }
        this.showAccess = new ModifierFilter(filterBits);
    }

    private void oneArg(String[] args, int index) {
        if (index + 1 < args.length) {
            this.setOption(args[index], args[index + 1]);
        } else {
            this.usageError("main.requires_argument", args[index]);
        }
    }

    private void usageError(String key, Object ... args) {
        this.messager.error(key, args);
        this.usage();
        this.exit();
    }

    private void setOption(String opt) {
        String[] option = new String[]{opt};
        this.options.append(option);
    }

    private void setOption(String opt, String argument) {
        String[] option = new String[]{opt, argument};
        this.options.append(option);
    }

    private void setOption(String opt, List<String> arguments) {
        String[] args = new String[arguments.length() + 1];
        int k = 0;
        args[k++] = opt;
        List<String> i = arguments;
        while (i.nonEmpty()) {
            args[k++] = (String)i.head;
            i = i.tail;
        }
        this.options = this.options.append(args);
    }
}

