/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafxdoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.javafxdoc.Comment;
import com.sun.tools.javafxdoc.DocEnv;
import com.sun.tools.javafxdoc.DocImpl;

class TagImpl
implements Tag {
    protected final String text;
    protected final String name;
    protected final DocImpl holder;
    private Tag[] firstSentence;
    private Tag[] inlineTags;

    TagImpl(DocImpl holder, String name, String text) {
        this.holder = holder;
        this.name = name;
        this.text = text;
    }

    public String name() {
        return this.name;
    }

    public Doc holder() {
        return this.holder;
    }

    public String kind() {
        return this.name;
    }

    public String text() {
        return this.text;
    }

    DocEnv docenv() {
        return this.holder.env;
    }

    String[] divideAtWhite() {
        String[] sa = new String[2];
        int len = this.text.length();
        sa[0] = this.text;
        sa[1] = "";
        block0: for (int inx = 0; inx < len; ++inx) {
            char ch = this.text.charAt(inx);
            if (!Character.isWhitespace(ch)) continue;
            sa[0] = this.text.substring(0, inx);
            while (inx < len) {
                ch = this.text.charAt(inx);
                if (!Character.isWhitespace(ch)) {
                    sa[1] = this.text.substring(inx, len);
                    break block0;
                }
                ++inx;
            }
            break;
        }
        return sa;
    }

    public String toString() {
        return this.name + ":" + this.text;
    }

    public Tag[] inlineTags() {
        if (this.inlineTags == null) {
            this.inlineTags = Comment.getInlineTags(this.holder, this.text);
        }
        return this.inlineTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] firstSentenceTags() {
        if (this.firstSentence == null) {
            this.inlineTags();
            try {
                this.docenv().setSilent(true);
                this.firstSentence = Comment.firstSentenceTags(this.holder, this.text);
            }
            finally {
                this.docenv().setSilent(false);
            }
        }
        return this.firstSentence;
    }

    public SourcePosition position() {
        return this.holder.position();
    }
}

