/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xmldoclet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Util {
    private static final String DOC_FILE_DIR_NAME = "doc-files";

    public static void copyDocFiles(String[] packages, String sourcePath, File docsdir) {
        String[] srcpaths;
        for (String srcpath : srcpaths = sourcePath.split(File.pathSeparator)) {
            for (String name : packages) {
                String srcdir = srcpath + File.separator + name;
                String destdir = docsdir + File.separator + name;
                Util.copyDocFiles(srcdir, destdir);
                srcdir = srcpath + File.separator + name.replace('.', File.separatorChar);
                Util.copyDocFiles(srcdir, destdir);
            }
        }
    }

    private static void copyDocFiles(String src, String dest) {
        File srcdir = new File(src + File.separator + DOC_FILE_DIR_NAME);
        if (!srcdir.exists() || !srcdir.isDirectory()) {
            return;
        }
        try {
            File destdir = new File(dest + File.separator + DOC_FILE_DIR_NAME);
            destdir.mkdirs();
            String[] files = srcdir.list();
            for (int i = 0; i < files.length; ++i) {
                File srcfile = new File(srcdir, files[i]);
                File destfile = new File(destdir, files[i]);
                if (!srcfile.isFile()) continue;
                Util.copyFile(srcfile, destfile);
            }
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File srcfile, File destfile) throws IOException {
        byte[] buf = new byte[512];
        int length = 0;
        FileInputStream input = new FileInputStream(srcfile);
        File destdir = destfile.getParentFile();
        destdir.mkdirs();
        FileOutputStream output = new FileOutputStream(destfile);
        try {
            while ((length = input.read(buf)) != -1) {
                output.write(buf, 0, length);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (SecurityException ex) {
        }
        finally {
            input.close();
            output.close();
        }
    }
}

