/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xmldoclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javafx.code.FunctionType;
import com.sun.tools.xmldoclet.Util;
import com.sun.tools.xslhtml.XHTMLProcessingUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDoclet {
    private PrintWriter out;
    private Transformer serializer;
    private TransformerHandler hd;
    private AttributesImpl attrs;
    private static String outFileName = null;
    private static List<String> xmlFiles = new ArrayList<String>();
    private static String sourcePath;
    private static File outDocsDir;
    private static boolean includeAuthorTags;
    private static boolean includeDeprecatedTags;
    private static boolean includeSinceTags;
    private static boolean includeVersionTags;
    private static boolean processXSLT;
    private static ResourceBundle messageRB;
    private static String xsltFileName;
    private static final boolean debug = false;
    private static final Map<String, String> params;
    static final Option[] options;

    public static boolean start(RootDoc root) {
        try {
            XMLDoclet doclet = new XMLDoclet();
            doclet.generateXML(root);
            if (processXSLT) {
                FileInputStream xsltStream = xsltFileName != null ? new FileInputStream(xsltFileName) : null;
                XHTMLProcessingUtils.process(xmlFiles, xsltStream, sourcePath, outDocsDir, params);
            } else {
                PackageDoc[] pkgs = doclet.packagesToProcess(root);
                String[] pkgNames = new String[pkgs.length];
                for (int index = 0; index < pkgs.length; ++index) {
                    pkgNames[index] = pkgs[index].name();
                }
                Util.copyDocFiles(pkgNames, sourcePath, new File(outFileName).getParentFile());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int optionLength(String option) {
        if (option.equals("-help")) {
            System.out.println(XMLDoclet.getString("help.header"));
            for (Option o : options) {
                System.out.println(o.help());
            }
            return 1;
        }
        for (Option o : options) {
            if (!o.name().equals(option)) continue;
            return o.length();
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        ArrayList<String> otherInputs = new ArrayList<String>();
        for (String[] option : options) {
            if (option[0].equals("-sourcepath")) {
                sourcePath = option[1];
                continue;
            }
            if (option[0].equals("-o")) {
                outFileName = option[1];
                continue;
            }
            if (option[0].equals("-i")) {
                otherInputs.add(option[1]);
                continue;
            }
            if (option[0].equals("-version")) {
                includeVersionTags = true;
                continue;
            }
            if (option[0].equals("-author")) {
                includeAuthorTags = true;
                continue;
            }
            if (option[0].equals("-nosince")) {
                includeSinceTags = false;
                continue;
            }
            if (option[0].equals("-nodeprecated")) {
                includeDeprecatedTags = false;
                continue;
            }
            if (option[0].equals("-nohtml")) {
                processXSLT = false;
                continue;
            }
            if (option[0].equals("-xsltfile")) {
                xsltFileName = option[1];
                continue;
            }
            if (option[0].equals("-mastercss")) {
                params.put("master-css", option[1]);
                continue;
            }
            if (option[0].equals("-extracss")) {
                params.put("extra-css", option[1]);
                continue;
            }
            if (option[0].equals("-extrajs")) {
                params.put("extra-js", option[1]);
                continue;
            }
            if (option[0].equals("-extrajs2")) {
                params.put("extra-js2", option[1]);
                continue;
            }
            if (option[0].equals("-d")) {
                outDocsDir = new File(option[1]);
                continue;
            }
            if (!option[0].startsWith("-xsl:")) continue;
            String s = option[1];
            int i = s.indexOf(61);
            if (i == -1) {
                return false;
            }
            String name = s.substring(0, i);
            String value = s.substring(i + 1);
            System.out.println("using a custom XSL parameter: '" + name + "'='" + value + "'");
            params.put(name, value);
        }
        if (outFileName == null) {
            try {
                File f = File.createTempFile("javadoc", ".xml");
                outFileName = f.getPath();
            }
            catch (IOException ex) {
                Logger.getLogger(XMLDoclet.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        xmlFiles.add(outFileName);
        xmlFiles.addAll(otherInputs);
        if (sourcePath == null) {
            HashSet<String> inputDirs = new HashSet<String>();
            for (String in : otherInputs) {
                inputDirs.add(new File(in).getParent());
            }
            StringBuilder buf = new StringBuilder();
            for (String in : inputDirs) {
                buf.append(in);
                buf.append(File.pathSeparatorChar);
            }
            sourcePath = buf.toString();
            if (sourcePath.length() == 0) {
                sourcePath = ".";
            }
        }
        return true;
    }

    private PackageDoc[] packagesToProcess(RootDoc root) {
        HashSet<PackageDoc> set = new HashSet<PackageDoc>(Arrays.asList(root.specifiedPackages()));
        ClassDoc[] classes = root.specifiedClasses();
        for (int i = 0; i < classes.length; ++i) {
            set.add(classes[i].containingPackage());
        }
        ArrayList<PackageDoc> results = new ArrayList<PackageDoc>(set);
        Collections.sort(results);
        return results.toArray(new PackageDoc[0]);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    void generateXML(RootDoc root) throws IOException, TransformerException, SAXException {
        this.initTransformer();
        this.attrs.clear();
        this.hd.startElement("", "", "javadoc", this.attrs);
        this.generateComment(root);
        for (PackageDoc pkg : this.packagesToProcess(root)) {
            this.generatePackage(pkg);
        }
        this.hd.endElement("", "", "javadoc");
        this.hd.endDocument();
    }

    private void generateExecutableMember(ExecutableMemberDoc exec, String kind) throws SAXException {
        if (!exec.isSynthetic()) {
            this.attrs.clear();
            this.attrs.addAttribute("", "", "name", "CDATA", exec.name());
            this.attrs.addAttribute("", "", "qualifiedName", "CDATA", exec.qualifiedName());
            if (exec instanceof MethodDoc) {
                this.attrs.addAttribute("", "", "varargs", "CDATA", Boolean.toString(exec.isVarArgs()));
            }
            this.hd.startElement("", "", kind, this.attrs);
            this.generateComment(exec);
            this.generateAnnotations(exec.annotations());
            this.generateModifiers(exec);
            this.generateTypeParameters(exec.typeParameters());
            this.generateParameters(exec.parameters(), exec);
            com.sun.javadoc.Type[] exceptions = exec.thrownExceptionTypes();
            if (exceptions.length > 0) {
                this.attrs.clear();
                this.hd.startElement("", "", "thrownExceptions", this.attrs);
                for (com.sun.javadoc.Type t : exceptions) {
                    this.generateTypeRef(t, "exception", null);
                }
                this.hd.endElement("", "", "thrownExceptions");
            }
            if (exec instanceof MethodDoc) {
                MethodDoc m = (MethodDoc)exec;
                this.generateTypeRef(m.returnType(), "returns", XMLDoclet.rawReturnType(m));
                MethodDoc overridden = m.overriddenMethod();
                if (overridden != null) {
                    String name = overridden.qualifiedName();
                    this.attrs.clear();
                    this.attrs.addAttribute("", "", "name", "CDATA", name);
                    this.hd.startElement("", "", "overrides", this.attrs);
                    this.hd.endElement("", "", "overrides");
                }
            }
            this.hd.endElement("", "", kind);
        }
    }

    private void generateField(FieldDoc field, String kind) throws SAXException {
        if (!field.isSynthetic()) {
            this.attrs.clear();
            this.attrs.addAttribute("", "", "name", "CDATA", field.name());
            this.attrs.addAttribute("", "", "qualifiedName", "CDATA", field.qualifiedName());
            this.attrs.addAttribute("", "", "enumConstant", "CDATA", Boolean.toString(field.isEnumConstant()));
            this.hd.startElement("", "", kind, this.attrs);
            this.generateComment(field);
            this.generateAnnotations(field.annotations());
            this.generateModifiers(field);
            this.generateTypeRef(field.type(), "type", XMLDoclet.rawType(field));
            String constantValue = field.constantValueExpression();
            if (constantValue != null) {
                this.attrs.clear();
                this.attrs.addAttribute("", "", "value", "CDATA", constantValue);
                this.hd.startElement("", "", "constant", this.attrs);
                this.hd.endElement("", "", "constant");
            }
            this.hd.endElement("", "", kind);
        }
    }

    private void generateFullHierarchy(ClassDoc cls) throws SAXException {
        this.attrs.clear();
        this.hd.startElement("", "", "hierarchy", this.attrs);
        List<com.sun.javadoc.Type> types = this.findInheritedTypes(cls);
        HashSet<com.sun.javadoc.Type> uniqueTypes = new HashSet<com.sun.javadoc.Type>();
        ListIterator<com.sun.javadoc.Type> it = types.listIterator();
        while (it.hasNext()) {
            com.sun.javadoc.Type type = it.next();
            if (uniqueTypes.contains(type)) {
                it.remove();
                continue;
            }
            uniqueTypes.add(type);
        }
        for (com.sun.javadoc.Type intf : types) {
            this.generateTypeRef(intf, "super", null);
        }
        this.hd.endElement("", "", "hierarchy");
    }

    private List<com.sun.javadoc.Type> findInheritedTypes(ClassDoc cls) {
        ArrayList<com.sun.javadoc.Type> types = new ArrayList<com.sun.javadoc.Type>();
        for (ClassDoc type : cls.interfaces()) {
            if (type == null) continue;
            types.add(type);
            ClassDoc cd = type.asClassDoc();
            types.addAll(this.findInheritedTypes(cd));
        }
        return types;
    }

    private void generatePackage(PackageDoc pkg) throws SAXException {
        if (pkg.allClasses().length == 0) {
            return;
        }
        this.attrs.clear();
        this.attrs.addAttribute("", "", "name", "CDATA", pkg.name());
        this.hd.startElement("", "", "package", this.attrs);
        this.generateComment(pkg);
        this.generateAnnotations(pkg.annotations());
        for (ClassDoc cls : pkg.allClasses()) {
            this.generateClass(cls);
        }
        this.hd.endElement("", "", "package");
    }

    private void generateClass(ClassDoc cls) throws SAXException {
        if (cls.simpleTypeName().equals("package-info")) {
            return;
        }
        boolean fxClass = XMLDoclet.isJFXClass(cls);
        String classType = cls.isAnnotationType() ? "annotation" : (cls.isEnum() ? "enum" : (cls.isInterface() ? "interface" : (cls.isAbstract() ? "abstractClass" : "class")));
        this.attrs.clear();
        this.attrs.addAttribute("", "", "name", "CDATA", cls.name());
        this.attrs.addAttribute("", "", "qualifiedName", "CDATA", cls.qualifiedName());
        this.attrs.addAttribute("", "", "packageName", "CDATA", cls.containingPackage().name());
        ClassDoc containingClass = cls.containingClass();
        if (containingClass != null) {
            this.attrs.addAttribute("", "", "outerClass", "CDATA", containingClass.qualifiedName());
        }
        this.attrs.addAttribute("", "", "language", "CDATA", fxClass ? "javafx" : "java");
        this.attrs.addAttribute("", "", "classType", "CDATA", classType);
        this.hd.startElement("", "", "class", this.attrs);
        this.generateComment(cls);
        this.generateModifiers(cls);
        if (!fxClass) {
            this.generateAnnotations(cls.annotations());
            this.generateTypeParameters(cls.typeParameters());
        }
        if (cls.superclass() != null && !cls.superclass().qualifiedName().equals("java.lang.Object")) {
            this.generateTypeRef(cls.superclass(), "superclass", null);
        }
        this.attrs.clear();
        this.hd.startElement("", "", "interfaces", this.attrs);
        for (ClassDoc classDoc : cls.interfaces()) {
            this.generateTypeRef(classDoc, "interface", null);
        }
        this.hd.endElement("", "", "interfaces");
        this.generateFullHierarchy(cls);
        if (!fxClass) {
            for (ProgramElementDoc programElementDoc : cls.constructors()) {
                this.generateExecutableMember((ExecutableMemberDoc)programElementDoc, "constructor");
            }
        }
        for (ProgramElementDoc programElementDoc : cls.methods()) {
            this.generateExecutableMember((ExecutableMemberDoc)programElementDoc, fxClass ? "function" : "method");
        }
        for (ProgramElementDoc programElementDoc : cls.fields()) {
            this.generateField((FieldDoc)programElementDoc, fxClass ? "attribute" : "field");
        }
        for (ProgramElementDoc programElementDoc : cls.enumConstants()) {
            this.generateField((FieldDoc)programElementDoc, fxClass ? "attribute" : "field");
        }
        this.hd.endElement("", "", "class");
    }

    private void generateModifiers(ProgramElementDoc element) throws SAXException {
        this.attrs.clear();
        boolean bound = this.isBoundFunction(element);
        String modifiersText = element.modifiers();
        this.attrs.addAttribute("", "", "text", "CDATA", modifiersText);
        this.hd.startElement("", "", "modifiers", this.attrs);
        this.attrs.clear();
        if (element.isPublic()) {
            this.hd.startElement("", "", "public", this.attrs);
            this.hd.endElement("", "", "public");
        } else if (element.isProtected()) {
            this.hd.startElement("", "", "protected", this.attrs);
            this.hd.endElement("", "", "protected");
        } else if (element.isPackagePrivate()) {
            this.hd.startElement("", "", "package", this.attrs);
            this.hd.endElement("", "", "package");
        } else if (element.isPrivate()) {
            this.hd.startElement("", "", "private", this.attrs);
            this.hd.endElement("", "", "private");
        } else {
            this.hd.startElement("", "", "script-private", this.attrs);
            this.hd.endElement("", "", "script-private");
        }
        if (element.isStatic()) {
            this.hd.startElement("", "", "static", this.attrs);
            this.hd.endElement("", "", "static");
        }
        if (element.isFinal()) {
            this.hd.startElement("", "", "final", this.attrs);
            this.hd.endElement("", "", "final");
        }
        if (this.isPublicRead(element)) {
            this.hd.startElement("", "", "public-read", this.attrs);
            this.hd.endElement("", "", "public-read");
        }
        if (this.isPublicInit(element)) {
            this.hd.startElement("", "", "public-init", this.attrs);
            this.hd.endElement("", "", "public-init");
        }
        if (this.isAbstract(element)) {
            this.hd.startElement("", "", "abstract", this.attrs);
            this.hd.endElement("", "", "abstract");
        }
        if (this.isDef(element)) {
            this.hd.startElement("", "", "read-only", this.attrs);
            this.hd.endElement("", "", "read-only");
        }
        if (bound) {
            this.hd.startElement("", "", "bound", this.attrs);
            this.hd.endElement("", "", "bound");
        }
        this.hd.endElement("", "", "modifiers");
    }

    private void generateParameters(Parameter[] parameters, ProgramElementDoc doc) throws SAXException {
        this.attrs.clear();
        this.hd.startElement("", "", "parameters", this.attrs);
        ArrayList<Tag> paramDocs = new ArrayList<Tag>();
        for (Tag t : doc.tags()) {
            if (!"@param".equals(t.kind())) continue;
            paramDocs.add(t);
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            this.attrs.clear();
            this.attrs.addAttribute("", "", "name", "CDATA", p.name());
            this.hd.startElement("", "", "parameter", this.attrs);
            this.generateTypeRef(p.type(), "type", XMLDoclet.rawType(p));
            this.generateAnnotations(p.annotations());
            this.attrs.clear();
            this.hd.startElement("", "", "docComment", this.attrs);
            if (paramDocs.size() > i) {
                Tag t = (Tag)paramDocs.get(i);
                Tag[] inlineTags = t.inlineTags();
                if (inlineTags.length <= 1) {
                    String text = t.text();
                    int n = (text = text.trim()).indexOf(" ");
                    if (n > 0) {
                        text = text.substring(n);
                    }
                    this.hd.characters(text.toCharArray(), 0, text.length());
                } else {
                    this.generateTags(inlineTags, "inlineTags");
                }
            }
            this.hd.endElement("", "", "docComment");
            this.hd.endElement("", "", "parameter");
        }
        this.hd.endElement("", "", "parameters");
    }

    private void generateTypeParameters(TypeVariable[] typeParameters) throws SAXException {
        if (typeParameters.length > 0) {
            this.attrs.clear();
            this.hd.startElement("", "", "typeParameters", this.attrs);
            for (TypeVariable tp : typeParameters) {
                this.attrs.clear();
                this.attrs.addAttribute("", "", "typeName", "CDATA", tp.typeName());
                this.attrs.addAttribute("", "", "simpleTypeName", "CDATA", tp.simpleTypeName());
                this.attrs.addAttribute("", "", "qualifiedTypeName", "CDATA", tp.qualifiedTypeName());
                this.hd.startElement("", "", "typeParameter", this.attrs);
                this.hd.endElement("", "", "typeParameter");
            }
            this.hd.endElement("", "", "typeParameters");
        }
    }

    private void generateTypeRef(com.sun.javadoc.Type type, String kind, Type rawType) throws SAXException {
        if (type != null) {
            boolean isFunctionType;
            this.attrs.clear();
            ClassDoc cd = type.asClassDoc();
            boolean isSequence = false;
            if (cd != null && (isSequence = XMLDoclet.isSequence(cd))) {
                if (rawType == null) {
                    throw new AssertionError((Object)"unknown sequence type");
                }
                type = XMLDoclet.sequenceType(cd, rawType);
                cd = type.asClassDoc();
            }
            String simpleName = (isFunctionType = rawType instanceof FunctionType) ? XMLDoclet.simpleFunctionalTypeName(cd, rawType) : type.simpleTypeName();
            this.attrs.addAttribute("", "", "typeName", "CDATA", type.typeName());
            this.attrs.addAttribute("", "", "simpleTypeName", "CDATA", simpleName);
            this.attrs.addAttribute("", "", "qualifiedTypeName", "CDATA", type.qualifiedTypeName());
            if (cd != null && !type.isPrimitive()) {
                this.attrs.addAttribute("", "", "packageName", "CDATA", cd.containingPackage().name());
            }
            this.attrs.addAttribute("", "", "dimension", "CDATA", type.dimension());
            this.attrs.addAttribute("", "", "toString", "CDATA", type.qualifiedTypeName() + type.dimension());
            this.attrs.addAttribute("", "", "sequence", "CDATA", Boolean.toString(isSequence));
            this.attrs.addAttribute("", "", "functionType", "CDATA", Boolean.toString(isFunctionType));
            this.hd.startElement("", "", kind, this.attrs);
            this.hd.endElement("", "", kind);
        }
    }

    private void generateComment(Doc doc) throws SAXException {
        String rawCommentText = doc.getRawCommentText();
        if (rawCommentText.length() > 0) {
            this.attrs.clear();
            this.hd.startElement("", "", "docComment", this.attrs);
            this.hd.startElement("", "", "rawCommentText", this.attrs);
            this.hd.characters(rawCommentText.toCharArray(), 0, rawCommentText.length());
            this.hd.endElement("", "", "rawCommentText");
            String commentText = doc.commentText();
            this.hd.startElement("", "", "commentText", this.attrs);
            this.hd.characters(commentText.toCharArray(), 0, commentText.length());
            this.hd.endElement("", "", "commentText");
            this.generateTags(doc.tags(), "tags");
            Tag[] firstSentenceTags = doc.firstSentenceTags();
            this.generateTags(firstSentenceTags, "firstSentenceTags");
            this.generateTags(doc.seeTags(), "seeTags");
            Tag[] inlineTags = this.getInlineTags(doc);
            this.generateTags(inlineTags, "inlineTags");
            boolean multipleSentences = false;
            if (inlineTags.length != firstSentenceTags.length) {
                multipleSentences = true;
            } else {
                for (int i = 0; i < firstSentenceTags.length; ++i) {
                    if (firstSentenceTags[i].text().equals(inlineTags[i].text())) continue;
                    multipleSentences = true;
                }
            }
            this.attrs.clear();
            this.attrs.addAttribute("", "", "multipleSentences", "CDATA", Boolean.toString(multipleSentences));
            this.hd.startElement("", "", "extraNotes", this.attrs);
            this.hd.endElement("", "", "extraNotes");
            this.hd.endElement("", "", "docComment");
        }
    }

    private void generateTags(Tag[] tags, String tagKind) throws SAXException, SAXException {
        if (tags.length == 0) {
            return;
        }
        this.attrs.clear();
        this.hd.startElement("", "", tagKind, this.attrs);
        for (Tag t : tags) {
            String kind = t.kind();
            if (kind.startsWith("@")) {
                kind = kind.substring(1);
            }
            if (kind.equals("@author") && !includeAuthorTags || kind.equals("@deprecated") && !includeDeprecatedTags || kind.equals("@since") && !includeSinceTags || kind.equals("@version") && !includeVersionTags) continue;
            if (!kind.matches("\\w+")) {
                System.out.println("possible invalid tag kind: " + kind);
                kind = "invalidtag";
            }
            this.attrs.clear();
            this.attrs.addAttribute("", "", "name", "CDATA", t.name());
            if ("@see".equals(t.name()) || "@link".equals(t.name())) {
                SeeTag see;
                String href = t.text();
                if (t instanceof SeeTag && (see = (SeeTag)t).referencedClass() != null) {
                    href = "../" + see.referencedClass().containingPackage().name() + "/" + see.referencedClassName() + ".html";
                    MemberDoc referencedMember = see.referencedMember();
                    if (referencedMember != null) {
                        if (referencedMember instanceof ExecutableMemberDoc) {
                            ExecutableMemberDoc execMember = (ExecutableMemberDoc)referencedMember;
                            href = href + "#" + execMember.name() + execMember.signature();
                        } else {
                            href = href + "#" + see.referencedMemberName();
                        }
                    }
                }
                this.attrs.addAttribute("", "", "href", "CDATA", href);
                String label = t.text();
                if (label.startsWith("#")) {
                    label = label.substring(1);
                }
                this.attrs.addAttribute("", "", "label", "CDATA", label);
            }
            this.hd.startElement("", "", kind, this.attrs);
            Tag[] inlineTags = t.inlineTags();
            if (inlineTags.length <= 1) {
                String text = t.text();
                this.hd.characters(text.toCharArray(), 0, text.length());
            } else {
                this.generateTags(inlineTags, "inlineTags");
            }
            this.hd.endElement("", "", kind);
        }
        this.hd.endElement("", "", tagKind);
    }

    private Tag[] getInlineTags(Doc doc) throws SAXException, SAXException {
        ArrayList<Tag> list = new ArrayList<Tag>();
        Tag[] inlineTags = doc.inlineTags();
        if (inlineTags.length > 0 && doc.isMethod()) {
            list.addAll(Arrays.asList(inlineTags));
            boolean changed = false;
            for (int i = 0; i < list.size(); ++i) {
                Tag t = (Tag)list.get(i);
                if (!t.kind().matches("@inheritDoc")) continue;
                Doc inherited = this.getInheritedDoc(doc);
                if (inherited == null) break;
                list.remove(i);
                list.addAll(i, Arrays.asList(this.getInlineTags(inherited)));
                changed = true;
                break;
            }
            if (changed) {
                inlineTags = list.toArray(new Tag[0]);
            }
        }
        return inlineTags;
    }

    private void generateAnnotations(AnnotationDesc[] annotations) throws SAXException {
        if (annotations.length > 0) {
            this.attrs.clear();
            this.hd.startElement("", "", "annotations", this.attrs);
            for (AnnotationDesc desc : annotations) {
                AnnotationTypeElementDoc[] elements;
                this.attrs.clear();
                this.hd.startElement("", "", "annotationType", this.attrs);
                AnnotationTypeDoc type = desc.annotationType();
                this.attrs.addAttribute("", "", "simpleName", "CDATA", type.simpleTypeName());
                this.attrs.addAttribute("", "", "qualifiedName", "CDATA", type.qualifiedTypeName());
                this.attrs.addAttribute("", "", "dimension", "CDATA", type.dimension());
                this.hd.startElement("", "", type.typeName(), this.attrs);
                for (AnnotationTypeElementDoc element : elements = type.elements()) {
                    if (element.isSynthetic()) continue;
                    this.attrs.clear();
                    this.attrs.addAttribute("", "", "name", "CDATA", element.name());
                    this.attrs.addAttribute("", "", "qualifiedName", "CDATA", element.qualifiedName());
                    this.attrs.addAttribute("", "", "commentText", "CDATA", element.commentText());
                    AnnotationValue defValue = element.defaultValue();
                    if (defValue != null) {
                        this.attrs.addAttribute("", "", "defaultValue", "CDATA", ((Object)defValue).toString());
                    }
                    this.hd.startElement("", "", "element", this.attrs);
                    this.hd.endElement("", "", "element");
                }
                this.hd.endElement("", "", type.typeName());
                this.hd.endElement("", "", "annotationType");
            }
            this.hd.endElement("", "", "annotations");
        }
    }

    private Doc getInheritedDoc(Doc doc) {
        if (doc instanceof MethodDoc) {
            return this.getOverriddenMethod((MethodDoc)doc);
        }
        return null;
    }

    private MethodDoc getOverriddenMethod(MethodDoc doc) {
        ClassDoc cls = doc.containingClass();
        ClassDoc scls = cls.superclass();
        MethodDoc meth = this.findDeclaredMethod(scls, doc);
        if (meth == null && XMLDoclet.isJFXClass(cls)) {
            ClassDoc intf;
            ClassDoc[] arr$ = cls.interfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (meth = this.findDeclaredMethod(intf = arr$[i$], doc)) == null; ++i$) {
            }
        }
        return meth;
    }

    private MethodDoc findDeclaredMethod(ClassDoc scls, MethodDoc doc) {
        MethodDoc[] meths;
        for (MethodDoc md : meths = scls.methods()) {
            if (!md.name().equals(doc.name()) || !md.signature().equals(doc.signature())) continue;
            return md;
        }
        return null;
    }

    private void initTransformer() throws IOException, SAXException, TransformerException {
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        tf.setAttribute("indent-number", new Integer(3));
        this.hd = tf.newTransformerHandler();
        this.serializer = this.hd.getTransformer();
        this.serializer.setOutputProperty("method", "xml");
        this.serializer.setOutputProperty("version", "1.0");
        this.serializer.setOutputProperty("encoding", "ISO-8859-1");
        this.serializer.setOutputProperty("indent", "yes");
        File f = new File(outFileName);
        f.getParentFile().mkdirs();
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        StreamResult streamResult = new StreamResult(this.out);
        this.attrs = new AttributesImpl();
        this.hd.setResult(streamResult);
        this.hd.startDocument();
    }

    static String getString(String key) {
        ResourceBundle msgRB = messageRB;
        if (msgRB == null) {
            try {
                messageRB = msgRB = ResourceBundle.getBundle("com.sun.tools.xmldoclet.resources.xmldoclet");
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource for javafxdoc is missing");
            }
        }
        return msgRB.getString(key);
    }

    private static boolean isJFXClass(ClassDoc clsDoc) {
        return XMLDoclet.probe(clsDoc, "isJFXClass");
    }

    private static boolean isSequence(ClassDoc clsDoc) {
        return XMLDoclet.probe(clsDoc, "isSequence");
    }

    private static boolean probe(ClassDoc clsDoc, String method) {
        try {
            Class<?> cls = clsDoc.getClass();
            Method m = cls.getDeclaredMethod(method, new Class[0]);
            Object result = m.invoke((Object)clsDoc, new Object[0]);
            return (Boolean)result;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Type rawType(FieldDoc field) {
        return XMLDoclet.rawType(field, "rawType");
    }

    private static Type rawType(Parameter param) {
        return XMLDoclet.rawType(param, "rawType");
    }

    private static Type rawReturnType(MethodDoc method) {
        return XMLDoclet.rawType(method, "rawReturnType");
    }

    private static Type rawType(Object o, String method) {
        try {
            Class<?> cls = o.getClass();
            Method m = cls.getDeclaredMethod(method, new Class[0]);
            Object result = m.invoke(o, new Object[0]);
            return (Type)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean getBooleanFlag(ProgramElementDoc doc, String flagMethod) {
        try {
            Class<?> cls = doc.getClass();
            Method m = cls.getMethod(flagMethod, new Class[0]);
            return (Boolean)m.invoke((Object)doc, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isBoundFunction(ProgramElementDoc doc) {
        if (!(doc instanceof ExecutableMemberDoc)) {
            return false;
        }
        return this.getBooleanFlag(doc, "isBound");
    }

    private boolean isScriptPrivate(ProgramElementDoc doc) {
        return this.getBooleanFlag(doc, "isScriptPrivate");
    }

    private boolean isPublicInit(ProgramElementDoc doc) {
        if (!(doc instanceof FieldDoc)) {
            return false;
        }
        return this.getBooleanFlag(doc, "isPublicInit");
    }

    private boolean isPublicRead(ProgramElementDoc doc) {
        if (!(doc instanceof FieldDoc)) {
            return false;
        }
        return this.getBooleanFlag(doc, "isPublicRead");
    }

    private boolean isDef(ProgramElementDoc doc) {
        if (!(doc instanceof FieldDoc)) {
            return false;
        }
        return this.getBooleanFlag(doc, "isDef");
    }

    private boolean isAbstract(ProgramElementDoc doc) {
        return this.getBooleanFlag(doc, "isAbstract");
    }

    private static com.sun.javadoc.Type sequenceType(ClassDoc cd, Type rawType) {
        try {
            Class<?> cls = cd.getClass();
            Method m = cls.getDeclaredMethod("sequenceType", Type.class);
            final com.sun.javadoc.Type result = (com.sun.javadoc.Type)m.invoke((Object)cd, rawType);
            return new com.sun.javadoc.Type(){

                public String typeName() {
                    return result.typeName();
                }

                public String qualifiedTypeName() {
                    return result.qualifiedTypeName();
                }

                public String simpleTypeName() {
                    return result.simpleTypeName();
                }

                public String dimension() {
                    return "[]";
                }

                public boolean isPrimitive() {
                    return result.isPrimitive();
                }

                public ClassDoc asClassDoc() {
                    return result.asClassDoc();
                }

                public ParameterizedType asParameterizedType() {
                    return null;
                }

                public TypeVariable asTypeVariable() {
                    return null;
                }

                public WildcardType asWildcardType() {
                    return null;
                }

                public AnnotationTypeDoc asAnnotationTypeDoc() {
                    return null;
                }
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String simpleFunctionalTypeName(ClassDoc cd, Type rawType) {
        try {
            Class<?> cls = cd.getClass();
            Method m = cls.getDeclaredMethod("simpleFunctionalTypeName", Type.class);
            Object result = m.invoke((Object)cd, rawType);
            return (String)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        outDocsDir = new File("fxdocs");
        includeAuthorTags = false;
        includeDeprecatedTags = true;
        includeSinceTags = true;
        includeVersionTags = false;
        processXSLT = true;
        messageRB = null;
        xsltFileName = null;
        params = new HashMap<String, String>();
        options = new Option[]{new Option("-o", XMLDoclet.getString("out.file.option"), XMLDoclet.getString("out.file.description")), new Option("-version", XMLDoclet.getString("version.description")), new Option("-author", XMLDoclet.getString("author.description")), new Option("-nosince", XMLDoclet.getString("nosince.description")), new Option("-nodeprecated", XMLDoclet.getString("nodeprecated.description")), new Option("-nohtml", XMLDoclet.getString("nohtml.description")), new Option("-xsltfile", XMLDoclet.getString("out.file.option"), XMLDoclet.getString("xsltfile.description")), new Option("-mastercss", XMLDoclet.getString("out.file.option"), XMLDoclet.getString("xsltfile.description")), new Option("-extracss", XMLDoclet.getString("out.file.option"), XMLDoclet.getString("xsltfile.description")), new Option("-extrajs", XMLDoclet.getString("out.file.option"), XMLDoclet.getString("xsltfile.description")), new Option("-extrajs2", XMLDoclet.getString("out.file.option"), XMLDoclet.getString("xsltfile.description")), new Option("-xsl:", XMLDoclet.getString("xslproperty.description"), "name=value"), new Option("-d", XMLDoclet.getString("out.dir.option"), XMLDoclet.getString("out.dir.description")), new Option("-i", XMLDoclet.getString("in.file.option"), XMLDoclet.getString("in.file.description"))};
    }

    static class Option {
        String[] fields;
        String help;
        private static final int DESCRIPTION_COLUMN = Integer.valueOf(XMLDoclet.getString("help.description.column"));

        Option(String field, String help) {
            this.fields = new String[]{field};
            this.help = help;
        }

        Option(String field, String param, String help) {
            this.fields = new String[]{field, param};
            this.help = help;
        }

        int length() {
            return this.fields.length;
        }

        String name() {
            return this.fields[0];
        }

        String description() {
            return this.fields.length == 1 ? this.fields[0] : this.fields[0] + ' ' + this.fields[1];
        }

        String help() {
            StringBuffer sb = new StringBuffer(this.description());
            while (sb.length() < DESCRIPTION_COLUMN) {
                sb.append(' ');
            }
            sb.append(this.help);
            return sb.toString();
        }
    }
}

