/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xslhtml;

import com.sun.tools.javafx.script.JavaFXScriptEngineFactory;
import com.sun.tools.xmldoclet.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLProcessingUtils {
    private static ResourceBundle messageRB = null;
    private static Logger logger = Logger.getLogger(XHTMLProcessingUtils.class.getName());
    private static boolean SDK_THEME = true;
    private static final String PARAMETER_PROFILES_ENABLED = "profiles-enabled";
    private static final String PARAMETER_TARGET_PROFILE = "target-profile";

    public static void process(List<String> xmlInputs, InputStream xsltStream, String sourcePath, File docsdir, Map<String, String> parameters) throws Exception {
        if (xmlInputs == null || xmlInputs.size() == 0) {
            throw new IllegalArgumentException("no XML input file(s)");
        }
        System.out.println(XHTMLProcessingUtils.getString("transforming.to.html"));
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        if (xsltStream == null) {
            xsltStream = SDK_THEME ? XHTMLProcessingUtils.class.getResourceAsStream("resources/sdk.xsl") : XHTMLProcessingUtils.class.getResourceAsStream("resources/javadoc.xsl");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
                this.pe(Level.WARNING, "warning: ", exception);
            }

            public void error(SAXParseException exception) throws SAXException {
                this.pe(Level.SEVERE, "error: ", exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                this.pe(Level.SEVERE, "fatal error", exception);
            }

            private void pe(Level level, String string, SAXParseException exception) {
                XHTMLProcessingUtils.p(level, string + " line: " + exception.getLineNumber() + " column: " + exception.getColumnNumber() + " " + exception.getLocalizedMessage());
            }
        });
        if (!docsdir.exists()) {
            docsdir.mkdir();
        }
        XHTMLProcessingUtils.p(Level.INFO, XHTMLProcessingUtils.getString("copying"));
        XHTMLProcessingUtils.copyResource(docsdir, "empty.html");
        XHTMLProcessingUtils.copyResource(docsdir, "general.css");
        XHTMLProcessingUtils.copyResource(docsdir, "sdk.css");
        XHTMLProcessingUtils.copyResource(docsdir, "mootools-1.2.1-yui.js");
        XHTMLProcessingUtils.copyResource(docsdir, "sdk.js");
        XHTMLProcessingUtils.copyResource(docsdir, "sessvars.js");
        File images = new File(docsdir, "images");
        images.mkdir();
        XHTMLProcessingUtils.copy(XHTMLProcessingUtils.class.getResource("resources/quote-background-1.gif"), new File(images, "quote-background-1.gif"));
        XHTMLProcessingUtils.copyResource(images, "JFX_arrow_down.png");
        XHTMLProcessingUtils.copyResource(images, "JFX_arrow_right.png");
        XHTMLProcessingUtils.copyResource(images, "JFX_arrow_up.png");
        XHTMLProcessingUtils.copyResource(images, "JFX_highlight_dot.png");
        XHTMLProcessingUtils.p(Level.INFO, XHTMLProcessingUtils.getString("transforming"));
        StreamSource xslt = new StreamSource(xsltStream);
        TransformerFactory transFact = TransformerFactory.newInstance();
        transFact.setURIResolver(new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                XHTMLProcessingUtils.p(Level.INFO, "Trying to resolve: " + href + " " + base);
                URL url = XHTMLProcessingUtils.class.getResource("resources/" + href);
                XHTMLProcessingUtils.p(Level.INFO, "Resolved " + href + ":" + base + " to " + url);
                try {
                    return new StreamSource(url.openStream());
                }
                catch (IOException ex) {
                    Logger.getLogger(XHTMLProcessingUtils.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
        });
        Transformer trans = transFact.newTransformer(xslt);
        if (SDK_THEME) {
            trans.setParameter("inline-classlist", "true");
            trans.setParameter("inline-descriptions", "true");
        }
        for (String key : parameters.keySet()) {
            System.out.println("using key: " + key + " " + parameters.get(key));
            trans.setParameter(key, parameters.get(key));
        }
        trans.setErrorListener(new MainErrorListener());
        Document packages_doc = builder.newDocument();
        Element package_list_elem = packages_doc.createElement("packageList");
        packages_doc.appendChild(package_list_elem);
        Document unified = builder.newDocument();
        Element javadocElement = unified.createElement("javadoc");
        unified.appendChild(javadocElement);
        XHTMLProcessingUtils.mergeDocuments(xmlInputs, builder, unified, javadocElement);
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList packages = (NodeList)xpath.evaluate("/javadoc/package", unified, XPathConstants.NODESET);
        XHTMLProcessingUtils.p(Level.INFO, MessageFormat.format(XHTMLProcessingUtils.getString("creating.packages"), packages.getLength()));
        String[] pkgNames = new String[packages.getLength()];
        for (int i = 0; i < packages.getLength(); ++i) {
            Element pkg = (Element)packages.item(i);
            String name = pkg.getAttribute("name");
            Element package_elem = packages_doc.createElement("package");
            package_elem.setAttribute("name", name);
            package_list_elem.appendChild(package_elem);
            XHTMLProcessingUtils.copyDocComment(pkg, package_elem);
            Element first_line = packages_doc.createElement("first-line-comment");
            first_line.appendChild(packages_doc.createTextNode("first line comment"));
            package_elem.appendChild(first_line);
            XHTMLProcessingUtils.processPackage(name, pkg, xpath, docsdir, trans, package_elem);
            pkgNames[i] = name;
        }
        trans.setParameter("root-path", "./");
        package_list_elem.setAttribute("mode", "overview-summary");
        trans.transform(new DOMSource(packages_doc), new StreamResult(new File(docsdir, "index.html")));
        Transformer indexTrans = transFact.newTransformer(new StreamSource(XHTMLProcessingUtils.class.getResourceAsStream("resources/master-index.xsl")));
        indexTrans.setParameter("root-path", "./");
        indexTrans.transform(new DOMSource(unified), new StreamResult(new File(docsdir, "master-index.html")));
        Util.copyDocFiles(pkgNames, sourcePath, docsdir);
        XHTMLProcessingUtils.p(Level.INFO, XHTMLProcessingUtils.getString("finished"));
    }

    private static void mergeDocuments(List<String> xmlInputs, DocumentBuilder builder, Document unified, Element javadocElement) throws DOMException, SAXException, XPathExpressionException, IOException {
        HashMap<String, Element> packageMap = new HashMap<String, Element>();
        for (String xmlInputPath : xmlInputs) {
            File file = new File(xmlInputPath);
            XHTMLProcessingUtils.p(Level.INFO, MessageFormat.format(XHTMLProcessingUtils.getString("reading.doc"), file.getAbsolutePath()));
            XHTMLProcessingUtils.p(Level.FINE, "exists: " + file.exists());
            Document doc = builder.parse(file);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList packages = (NodeList)xpath.evaluate("/javadoc/package", doc, XPathConstants.NODESET);
            XHTMLProcessingUtils.p(Level.INFO, "found " + packages.getLength() + " packages");
            for (int i = 0; i < packages.getLength(); ++i) {
                Element copy = (Element)unified.importNode(packages.item(i), true);
                String pkgName = copy.getAttribute("name");
                if (!packageMap.containsKey(pkgName)) {
                    packageMap.put(pkgName, copy);
                    continue;
                }
                Element pkg = (Element)packageMap.get(pkgName);
                NodeList classes = copy.getChildNodes();
                ArrayList<Node> classesList = new ArrayList<Node>();
                for (int j = 0; j < classes.getLength(); ++j) {
                    classesList.add(classes.item(j));
                }
                for (Node cls : classesList) {
                    pkg.appendChild(cls);
                }
            }
        }
        for (String pkgName : packageMap.keySet()) {
            Element pkg = (Element)packageMap.get(pkgName);
            javadocElement.appendChild(pkg);
        }
    }

    private static void processPackage(String packageName, Element pkg, XPath xpath, File docsdir, Transformer trans, Element package_elem) throws TransformerException, XPathExpressionException, IOException, FileNotFoundException, ParserConfigurationException {
        File packageDir = new File(docsdir, packageName);
        packageDir.mkdir();
        NodeList classesNodeList = (NodeList)xpath.evaluate("*[name() = 'class' or name() = 'abstractClass' or name() = 'interface']", pkg, XPathConstants.NODESET);
        List<Element> classes = XHTMLProcessingUtils.sort(classesNodeList);
        XHTMLProcessingUtils.p(Level.INFO, MessageFormat.format(XHTMLProcessingUtils.getString("creating.classes"), classes.size(), packageName));
        Document classes_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element class_list = classes_doc.createElement("classList");
        class_list.setAttribute("packageName", packageName);
        classes_doc.appendChild(class_list);
        for (Element clazz : classes) {
            XHTMLProcessingUtils.processClass(clazz, class_list, xpath, trans, packageDir);
            Element clazz_elem = (Element)package_elem.getOwnerDocument().importNode(clazz, true);
            package_elem.appendChild(clazz_elem);
        }
        class_list.setAttribute("mode", "overview-frame");
        trans.setParameter("root-path", "../");
        trans.transform(new DOMSource(classes_doc), new StreamResult(new File(packageDir, "package-frame.html")));
        class_list.setAttribute("mode", "overview-summary");
        trans.setParameter("root-path", "../");
        trans.transform(new DOMSource(classes_doc), new StreamResult(new File(packageDir, "package-summary.html")));
    }

    private static void processClass(Element clazz, Element class_list, XPath xpath, Transformer trans, File packageDir) throws TransformerException, IOException, XPathExpressionException {
        String qualifiedName = clazz.getAttribute("qualifiedName");
        String name = clazz.getAttribute("name");
        String profile = (String)xpath.evaluate("docComment/tags/profile/text()", clazz, XPathConstants.STRING);
        if ("true".equals(trans.getParameter(PARAMETER_PROFILES_ENABLED))) {
            Object target_profile = trans.getParameter(PARAMETER_TARGET_PROFILE);
            if (profile == null || !profile.equals(target_profile)) {
                return;
            }
        }
        Document doc = class_list.getOwnerDocument();
        Element class_elem = doc.createElement("class");
        class_list.appendChild(class_elem);
        class_elem.setAttribute("name", name);
        class_elem.setAttribute("qualifiedName", qualifiedName);
        Element first_line = doc.createElement("first-line-comment");
        first_line.appendChild(doc.createTextNode("first line comment"));
        class_elem.appendChild(first_line);
        XHTMLProcessingUtils.copyClassDoc(clazz, class_elem);
        XHTMLProcessingUtils.processInlineExamples(clazz, class_elem, packageDir);
        File xhtmlFile = new File(packageDir, qualifiedName + ".html");
        StreamResult xhtmlResult = new StreamResult(xhtmlFile);
        DOMSource xmlSource = new DOMSource(clazz.getOwnerDocument());
        trans.setParameter("target-class", qualifiedName);
        trans.setParameter("root-path", "../");
        trans.transform(xmlSource, xhtmlResult);
    }

    private static void copyClassDoc(Element clazz, Element class_elem) {
        NodeList tags;
        Element docComment = (Element)clazz.getElementsByTagName("docComment").item(0);
        if (docComment == null) {
            return;
        }
        NodeList firstSent = docComment.getElementsByTagName("firstSentenceTags");
        if (firstSent.getLength() > 0) {
            class_elem.appendChild(class_elem.getOwnerDocument().importNode(firstSent.item(0), true));
        }
        if ((tags = docComment.getElementsByTagName("tags")).getLength() > 0) {
            for (int i = 0; i < tags.getLength(); ++i) {
                Node tag = tags.item(i);
                class_elem.appendChild(class_elem.getOwnerDocument().importNode(tag, true));
            }
        }
    }

    private static void copyDocComment(Element pkg, Element package_elem) {
        Element docComment = XHTMLProcessingUtils.getFirstChildNamed(pkg, "docComment");
        if (docComment != null) {
            Node copy = package_elem.getOwnerDocument().importNode(docComment, true);
            package_elem.appendChild(copy);
        }
    }

    private static Element getFirstChildNamed(Element elem, String childName) {
        NodeList children = elem.getChildNodes();
        int length = children.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(childName)) continue;
            return (Element)node;
        }
        return null;
    }

    private static List<Element> sort(NodeList classesNodeList) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        for (int i = 0; i < classesNodeList.getLength(); ++i) {
            nodes.add((Element)classesNodeList.item(i));
        }
        Collections.sort(nodes, new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return o1.getAttribute("qualifiedName").compareTo(o2.getAttribute("qualifiedName"));
            }
        });
        return nodes;
    }

    private static void copy(URL url, File file) throws FileNotFoundException, IOException {
        int n;
        XHTMLProcessingUtils.p(Level.FINE, "copying from: " + url);
        XHTMLProcessingUtils.p(Level.FINE, "copying to: " + file.getAbsolutePath());
        InputStream in = url.openStream();
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
        }
    }

    private static void copyResource(File docsdir, String string) throws FileNotFoundException, IOException {
        XHTMLProcessingUtils.copy(XHTMLProcessingUtils.class.getResource("resources/" + string), new File(docsdir, string));
    }

    static String getString(String key) {
        ResourceBundle msgRB = messageRB;
        if (msgRB == null) {
            try {
                messageRB = msgRB = ResourceBundle.getBundle("com.sun.tools.xslhtml.resources.xslhtml");
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource for javafxdoc is missing");
            }
        }
        return msgRB.getString(key);
    }

    private static void p(Level level, String string) {
        if (level.intValue() >= logger.getLevel().intValue()) {
            System.err.println(string);
        }
    }

    private static void p(Level level, String string, Throwable t) {
        if (level.intValue() >= logger.getLevel().intValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append(string);
            if (t != null) {
                sb.append(System.getProperty("line.separator"));
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            System.err.println(sb.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> inputs = new ArrayList<String>();
        inputs.add("javadoc.xml");
        XHTMLProcessingUtils.process(inputs, null, ".", new File("fxdocs_test"), new HashMap<String, String>());
    }

    private static void processInlineExamples(Element clazz, Element class_elem, File packageDir) {
        NodeList highlights;
        NodeList examples = clazz.getElementsByTagName("example");
        if (examples != null & examples.getLength() > 0) {
            for (int i = 0; i < examples.getLength(); ++i) {
                Element example = (Element)examples.item(i);
                XHTMLProcessingUtils.processExampleCode(example, packageDir, clazz, i, true);
            }
        }
        if ((highlights = clazz.getElementsByTagName("highlight")) != null && highlights.getLength() > 0) {
            for (int i = 0; i < highlights.getLength(); ++i) {
                Element highlight = (Element)highlights.item(i);
                XHTMLProcessingUtils.processExampleCode(highlight, packageDir, clazz, i, false);
            }
        }
    }

    private static void processExampleCode(Element example, File packageDir, Element clazz, int i, boolean renderScreenshot) throws DOMException {
        try {
            String script = example.getTextContent();
            StringBuffer out = new StringBuffer();
            out.append("<p>the code:</p>");
            out.append("<pre class='example-code'><code>");
            String styledScript = XHTMLProcessingUtils.highlight(script);
            out.append(styledScript);
            out.append("</code></pre>");
            if (renderScreenshot) {
                try {
                    File imgFile = new File(packageDir, clazz.getAttribute("name") + i + ".png");
                    XHTMLProcessingUtils.renderScriptToImage(imgFile, script);
                    out.append("<p>produces:</p>");
                    out.append("<p>");
                    out.append("<img class='example-screenshot' src='" + imgFile.getName() + "'/>");
                    out.append("</p>");
                }
                catch (Throwable ex) {
                    System.out.println("error processing code: " + clazz.getAttribute("name"));
                    System.out.println("error processing: " + example.getTextContent());
                    ex.printStackTrace();
                }
            }
            example.setTextContent(out.toString());
        }
        catch (Exception ex) {
            System.out.println("error processing code: " + clazz.getAttribute("name"));
            System.out.println("error processing: " + example.getTextContent());
            ex.printStackTrace();
        }
    }

    private static String highlight(String text) {
        text = text.replaceAll("/\\*", "<i class='comment'>/*");
        text = text.replaceAll("\\*/", "*/</i>");
        text = text.replaceAll("(import|package)", "<b>$1</b>");
        text = text.replaceAll("(var)", "<b class='keyword'>$1</b>");
        text = text.replaceAll("(\\w\\w*):", "<b>$1</b>:");
        text = text.replaceAll("(\\d+)", "<span class='number-literal'>$1</span>");
        text = text.replaceAll("(\".*\")", "<span class='string-literal'>$1</span>");
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderScriptToImage(File imgFile, String script) throws ScriptException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException, ClassNotFoundException {
        JavaFXScriptEngineFactory factory = new JavaFXScriptEngineFactory();
        ScriptEngine scrEng = factory.getScriptEngine();
        PrintWriter pw = new PrintWriter(System.err);
        scrEng.getContext().setErrorWriter(pw);
        try {
            Object ret = scrEng.eval(script);
            Class<?> fxclass = ret.getClass();
            Rectangle2D bounds = null;
            Method paintMethod = null;
            Object drawObject = null;
            try {
                Method component_method = fxclass.getMethod("getJComponent", new Class[0]);
                JComponent component = (JComponent)component_method.invoke(ret, new Object[0]);
                component.validate();
                component.setSize(component.getPreferredSize());
                bounds = component.getBounds();
                drawObject = component;
                paintMethod = drawObject.getClass().getMethod("paint", Graphics.class);
            }
            catch (NoSuchMethodException ex) {
                Method method = fxclass.getMethod("impl_getFXNode", new Class[0]);
                drawObject = method.invoke(ret, new Object[0]);
                Method getBounds = drawObject.getClass().getMethod("getBounds", new Class[0]);
                bounds = (Rectangle2D)getBounds.invoke(drawObject, new Object[0]);
                paintMethod = drawObject.getClass().getMethod("render", Graphics2D.class);
            }
            BufferedImage img = new BufferedImage((int)bounds.getWidth(), (int)bounds.getHeight(), 2);
            Graphics2D g2 = img.createGraphics();
            g2.setPaint(Color.WHITE);
            g2.fillRect(0, 0, img.getWidth(), img.getHeight());
            g2.translate(-bounds.getX(), -bounds.getY());
            paintMethod.invoke(drawObject, g2);
            g2.dispose();
            ImageIO.write((RenderedImage)img, "png", imgFile);
        }
        catch (ScriptException ex) {
            pw.println(ex.getMessage());
            pw.println(" at: line = " + ex.getLineNumber() + " column = " + ex.getColumnNumber());
            pw.println("file = " + ex.getFileName());
            pw.println("exception = " + ex.toString());
            pw.println(ex.getMessage());
            ex.printStackTrace(pw);
            pw.println("cause = " + ex.getCause());
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    static {
        logger.setLevel(Level.ALL);
    }

    private static class MainErrorListener
    implements ErrorListener {
        public void warning(TransformerException exception) throws TransformerException {
            XHTMLProcessingUtils.p(Level.WARNING, "warning: " + exception);
        }

        public void error(TransformerException exception) throws TransformerException {
            Throwable thr = exception;
            while (true) {
                XHTMLProcessingUtils.p(Level.SEVERE, "error: " + exception.getMessageAndLocation(), ((Throwable)thr).getCause());
                if (((Throwable)thr).getCause() == null) break;
                thr = ((Throwable)thr).getCause();
            }
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            XHTMLProcessingUtils.p(Level.SEVERE, "fatal error: " + exception.getMessageAndLocation(), exception);
        }
    }
}

