/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.api;

import com.sun.javafx.api.JavaFXScriptEngine;
import com.sun.javafx.api.JavafxCompiler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.logging.Logger;

public class ToolProvider {
    private static Logger logger = Logger.getLogger("com.sun.javafx");

    private ToolProvider() {
    }

    public static JavafxCompiler getJavafxCompiler() {
        try {
            URL[] urls = new URL[]{ToolProvider.getPath("com.sun.tools.javafx.api.JavafxcTool"), ToolProvider.getPath("com.sun.tools.javac.util.Context")};
            ClassLoader cl = ToolProvider.createPrivilegedClassLoader(urls);
            Class<?> cls = Class.forName("com.sun.tools.javafx.api.JavafxcTool", false, cl);
            return (JavafxCompiler)cls.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static JavaFXScriptEngine getJavaFXScriptEngine() {
        try {
            URL[] urls = new URL[]{ToolProvider.getPath("com.sun.tools.javafx.script.JavaFXScriptEngineImpl"), ToolProvider.getPath("com.sun.tools.javac.util.Context")};
            ClassLoader cl = ToolProvider.createPrivilegedClassLoader(urls);
            Class<?> cls = Class.forName("com.sun.tools.javafx.script.JavaFXScriptEngineImpl", false, cl);
            return (JavaFXScriptEngine)cls.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static ClassLoader createPrivilegedClassLoader(final URL[] urls) throws PrivilegedActionException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader parent = JavafxCompiler.class.getClassLoader();
                return new URLClassLoader(urls, parent);
            }
        });
    }

    private static URL getPath(String className) throws MalformedURLException {
        File f;
        String classFile = className.replace('.', '/') + ".class";
        ClassLoader cl = ToolProvider.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        URL classURL = cl.getResource(classFile);
        String path = classURL.getPath();
        assert (path.endsWith(classFile));
        if ((path = path.substring(0, path.indexOf(classFile) - 1)).endsWith("!")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((f = new File(path)).exists()) {
            return f.toURI().toURL();
        }
        return new URL(path);
    }
}

