/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.functions.Function0;
import com.sun.javafx.runtime.FXExit;
import com.sun.javafx.runtime.NamedArgumentProvider;
import com.sun.javafx.runtime.RuntimeProvider;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.scenario.animation.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.lang.FX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    private static RuntimeProvider provider;
    private static String[] commandLineArgs;
    private static NamedArgumentProvider namedArgProvider;

    public static void start(Class<?> app, String[] commandLineArgs) throws Throwable {
        block9: {
            if (commandLineArgs != null) {
                Entry.setNamedArgumentProvider(NamedArgumentProviderDefault.getInstance(commandLineArgs));
                if (namedArgProvider == null) {
                    Entry.commandLineArgs = (String[])commandLineArgs.clone();
                }
            }
            final Method main = app.getMethod(Entry.entryMethodName(), Sequence.class);
            Sequence<String> args = Sequences.make(TypeInfo.String, commandLineArgs);
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        main.setAccessible(true);
                        provider = Entry.runtimeProviderLocator();
                        return null;
                    }
                });
                if (provider != null && provider.usesRuntimeLibrary(app)) {
                    provider.run(main, commandLineArgs);
                    break block9;
                }
                try {
                    main.invoke(null, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (AccessControlException ex) {
                try {
                    main.invoke(null, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        }
    }

    public static void deferAction(final Function0<Void> function) {
        Entry.deferAction(new Runnable(){

            public void run() {
                function.invoke();
            }
        });
    }

    public static void deferAction(Runnable function) {
        if (provider == null) {
            provider = Entry.runtimeProviderLocator();
        }
        assert (provider != null);
        provider.deferAction(function);
    }

    public static void exit() {
        if (provider == null) {
            provider = Entry.runtimeProviderLocator();
        }
        assert (provider != null);
        provider.exit();
    }

    public static void setNamedArgumentProvider(NamedArgumentProvider provider) {
        namedArgProvider = provider;
    }

    public static Sequence<String> getArguments() {
        return Sequences.make(TypeInfo.String, commandLineArgs);
    }

    private static Object getArgument(int argument) {
        String[] args = commandLineArgs;
        if (args == null) {
            return null;
        }
        if (argument < 0 || argument >= args.length) {
            return null;
        }
        return args[argument];
    }

    public static Object getArgument(String key) {
        NamedArgumentProvider provider = namedArgProvider;
        Object val = null;
        if (provider != null) {
            val = provider.get(key);
        }
        if (val == null) {
            try {
                return Entry.getArgument(Integer.parseInt(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    private static RuntimeProvider runtimeProviderLocator() {
        Iterator iterator;
        boolean usingServiceLoader;
        String loadMethodName;
        Class loaderClass;
        try {
            loaderClass = Class.forName("java.util.ServiceLoader");
            loadMethodName = "load";
            usingServiceLoader = true;
        }
        catch (ClassNotFoundException cnfe) {
            final Class[] cls = new Class[1];
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        cls[0] = Class.forName("sun.misc.Service");
                    }
                    catch (ClassNotFoundException cnfe2) {
                        cls[0] = null;
                    }
                    return null;
                }
            });
            loaderClass = cls[0];
            loadMethodName = "providers";
            usingServiceLoader = false;
        }
        if (loaderClass == null) {
            throw new AssertionError((Object)"Failed discovering ServiceLoader");
        }
        try {
            Method loadMethod = loaderClass.getMethod(loadMethodName, Class.class, ClassLoader.class);
            ClassLoader cl = Entry.class.getClassLoader();
            Object result = loadMethod.invoke(null, RuntimeProvider.class, cl);
            if (usingServiceLoader) {
                Method m = loaderClass.getMethod("iterator", new Class[0]);
                result = m.invoke(result, new Object[0]);
            }
            iterator = (Iterator)result;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        try {
            return iterator.hasNext() ? (RuntimeProvider)iterator.next() : new NoRuntimeDefault();
        }
        catch (Error e) {
            if (e.getClass().getSimpleName().equals("ServiceConfigurationError")) {
                return new NoRuntimeDefault();
            }
            throw e;
        }
    }

    public static String entryMethodName() {
        return "javafx$run$";
    }

    private static class NamedArgumentProviderDefault
    implements NamedArgumentProvider {
        private static final char DELIMITER = '=';
        private Properties namedArguments;

        private NamedArgumentProviderDefault(Properties namedArguments) {
            this.namedArguments = namedArguments;
        }

        public Object get(String name) {
            return this.namedArguments.getProperty(name);
        }

        static NamedArgumentProvider getInstance(String[] commandline) {
            Properties namedArguments = new Properties();
            for (String arg : commandline) {
                int index = arg.indexOf(61);
                if (index <= 0) {
                    return null;
                }
                namedArguments.setProperty(arg.substring(0, index), arg.substring(index + 1));
            }
            return new NamedArgumentProviderDefault(namedArguments);
        }
    }

    private static class NoRuntimeDefault
    extends Thread
    implements RuntimeProvider {
        private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();

        private NoRuntimeDefault() {
        }

        public boolean usesRuntimeLibrary(Class application) {
            return true;
        }

        public Object run(final Method entryPoint, final String ... args) throws Throwable {
            this.taskQueue.add(new Runnable(){

                public void run() {
                    try {
                        NoRuntimeDefault.this.main(entryPoint, args);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
            this.start();
            return null;
        }

        public void run() {
            try {
                Runnable task;
                while ((task = this.taskQueue.poll()) != null || Util.hasActiveAnimation()) {
                    if (task != null) {
                        task.run();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                        break;
                    }
                }
                FX.exit();
            }
            catch (FXExit fxExit) {
                return;
            }
        }

        private Object main(Method entryPoint, String ... args) throws Throwable {
            try {
                return entryPoint.invoke(null, Sequences.make(TypeInfo.String, args));
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof FXExit) {
                    return null;
                }
                throw cause;
            }
        }

        public void deferAction(Runnable r) {
            this.taskQueue.add(r);
        }

        public void exit() {
            try {
                System.exit(0);
            }
            catch (Throwable ignored) {
                throw new FXExit();
            }
        }
    }
}

