/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo<T> {
    public final T defaultValue;
    public final Sequence<T> emptySequence;
    public static final TypeInfo<Long> Long = new TypeInfo<Long>(0L);
    public static final TypeInfo<Integer> Integer = new TypeInfo<Integer>(0);
    public static final TypeInfo<Boolean> Boolean = new TypeInfo<Boolean>(false);
    public static final TypeInfo<Double> Double = new TypeInfo<Double>(0.0);
    public static final TypeInfo<Float> Float = new TypeInfo<Float>(java.lang.Float.valueOf(0.0f));
    public static final TypeInfo<String> String = new TypeInfo<String>("");
    public static final TypeInfo<Object> Object = new TypeInfo<Object>(null);
    private static final Map<Class<?>, TypeInfo<?>> map = new HashMap();

    private TypeInfo(T defaultValue) {
        this.defaultValue = defaultValue;
        this.emptySequence = new AbstractSequence<T>(this){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public T get(int position) {
                return TypeInfo.this.defaultValue;
            }
        };
    }

    public static <T> TypeInfo<T> getTypeInfo() {
        return Object;
    }

    public static <T> TypeInfo<T> getTypeInfo(Class<T> clazz) {
        TypeInfo<Object> ti = map.get(clazz);
        if (ti == null) {
            ti = TypeInfo.getTypeInfo();
        }
        return ti;
    }

    public static <T> TypeInfo<T> makeTypeInfo(T defaultValue) {
        return new TypeInfo<T>(defaultValue);
    }

    public static <T> TypeInfo<T> makeAndRegisterTypeInfo(Class clazz, T defaultValue) {
        TypeInfo<T> ti = new TypeInfo<T>(defaultValue);
        map.put(clazz, ti);
        return ti;
    }

    public static <T> TypeInfo<T> makeAndRegisterTypeInfo(T defaultValue) {
        return TypeInfo.makeAndRegisterTypeInfo(defaultValue.getClass(), defaultValue);
    }

    static {
        map.put(Integer.class, Integer);
        map.put(Long.class, Long);
        map.put(Boolean.class, Boolean);
        map.put(Double.class, Double);
        map.put(Float.class, Float);
        map.put(String.class, String);
    }
}

