/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.location.ChangeListener;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.WeakLocation;
import com.sun.javafx.runtime.location.WeakMeLocation;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocation
implements Location {
    private static final byte INUSE_NOT = 0;
    private static final byte INUSE_UNINFLATED = 1;
    private static final byte INUSE_INFLATED = 2;
    private boolean isValid;
    protected byte state;
    private byte inUse;
    private static final Map<Location, IterationData> iterationData = new HashMap<Location, IterationData>();
    private ChangeListener listeners;
    private WeakLocation dependentLocations;
    private WeakMeLocation weakMeHead;
    private static Linkable.HeadAccessor<ChangeListener, AbstractLocation> changeListenerList = new Linkable.HeadAccessor<ChangeListener, AbstractLocation>(){

        @Override
        public ChangeListener getHead(AbstractLocation host) {
            return host.listeners;
        }

        @Override
        public void setHead(AbstractLocation host, ChangeListener newHead) {
            host.listeners = newHead;
        }
    };
    private static Linkable.HeadAccessor<WeakLocation, AbstractLocation> dependentLocationList = new Linkable.HeadAccessor<WeakLocation, AbstractLocation>(){

        @Override
        public WeakLocation getHead(AbstractLocation host) {
            return host.dependentLocations;
        }

        @Override
        public void setHead(AbstractLocation host, WeakLocation newHead) {
            host.dependentLocations = newHead;
        }
    };
    private static Linkable.MutativeIterationClosure<ChangeListener, AbstractLocation> CALL_LISTENER_CLOSURE = new Linkable.MutativeIterationClosure<ChangeListener, AbstractLocation>(){

        @Override
        public boolean action(ChangeListener element) {
            try {
                return element.onChange();
            }
            catch (RuntimeException e) {
                ErrorHandler.triggerException(e);
                return true;
            }
        }
    };
    private static Linkable.MutativeIterationClosure<WeakLocation, AbstractLocation> INVALIDATE_DEPENDENCY_CLOSURE = new Linkable.MutativeIterationClosure<WeakLocation, AbstractLocation>(){

        @Override
        public boolean action(WeakLocation element) {
            Location loc = (Location)element.get();
            if (loc == null) {
                return false;
            }
            loc.invalidate();
            return element.get() != null;
        }
    };
    private static final Linkable.MutativeIterationClosure<WeakLocation, AbstractLocation> PURGE_LISTENER_CLOSURE = new Linkable.MutativeIterationClosure<WeakLocation, AbstractLocation>(){

        @Override
        public boolean action(WeakLocation element) {
            return element.get() != null;
        }
    };

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    protected void setValid() {
        this.isValid = true;
    }

    @Override
    public void invalidate() {
        boolean wasValid = this.isValid;
        this.isValid = false;
        if (wasValid) {
            this.invalidateDependencies();
        }
    }

    @Override
    public boolean hasDependencies() {
        return this.dependentLocations != null || this.listeners != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateDependencies() {
        if (this.listeners != null) {
            AbstractLinkable.iterate(changeListenerList, this, CALL_LISTENER_CLOSURE);
        }
        if (this.dependentLocations != null) {
            this.beginUpdate();
            try {
                AbstractLinkable.iterate(dependentLocationList, this, INVALIDATE_DEPENDENCY_CLOSURE);
            }
            finally {
                this.endUpdate();
            }
        }
    }

    void purgeDeadDependencies() {
        AbstractLinkable.iterate(dependentLocationList, this, PURGE_LISTENER_CLOSURE);
    }

    @Override
    public void addDependentLocation(WeakLocation weakLocation) {
        if (!this.inUse()) {
            WeakLocation.purgeDeadLocations(this);
            assert (AbstractLinkable.isUnused(weakLocation));
            AbstractLinkable.addAtEnd(dependentLocationList, this, weakLocation);
        } else {
            this.getInflated().addDependency(weakLocation);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        assert (AbstractLinkable.isUnused(listener));
        AbstractLinkable.addAtEnd(changeListenerList, this, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            AbstractLinkable.remove(changeListenerList, this, listener);
        }
    }

    @Override
    public void addDependency(Location ... dependencies) {
        if (dependencies.length > 0) {
            for (Location dep : dependencies) {
                this.addDependency(dep);
            }
        }
    }

    @Override
    public void addDependency(Location location) {
        location.addDependentLocation(new WeakLocation(this));
    }

    @Override
    public void addDynamicDependency(Location location) {
        WeakMeLocation newWeakMe = new WeakMeLocation(this);
        newWeakMe.nextWeakMe = this.weakMeHead;
        this.weakMeHead = newWeakMe;
        location.addDependentLocation(newWeakMe);
    }

    @Override
    public void clearDynamicDependencies() {
        WeakMeLocation wh = this.weakMeHead;
        while (wh != null) {
            wh.clear();
            wh = wh.nextWeakMe;
        }
        WeakLocation.purgeDeadLocations(null);
        this.weakMeHead = null;
    }

    public <T extends Location> T addDynamicDependent(T dep) {
        this.addDynamicDependency(dep);
        return dep;
    }

    public <T extends Location> T addStaticDependent(T dep) {
        this.addDependency((Location)dep);
        return dep;
    }

    @Override
    public ChangeListener getListeners() {
        return this.listeners;
    }

    @Override
    public void update() {
    }

    int getListenerCount() {
        this.purgeDeadDependencies();
        return AbstractLinkable.size(this.listeners) + AbstractLinkable.size(this.dependentLocations);
    }

    private IterationData inflateIterationData(int count) {
        this.inUse = (byte)2;
        IterationData id = new IterationData(count);
        iterationData.put(this, id);
        return id;
    }

    private void beginUpdate() {
        switch (this.inUse) {
            case 0: {
                this.inUse = 1;
                break;
            }
            case 1: {
                this.inflateIterationData(2);
                break;
            }
            case 2: {
                IterationData id = iterationData.get(this);
                ++id.iterationDepth;
            }
        }
    }

    private boolean inUse() {
        return this.inUse != 0;
    }

    private IterationData getInflated() {
        switch (this.inUse) {
            case 1: {
                return this.inflateIterationData(1);
            }
            case 2: {
                return iterationData.get(this);
            }
        }
        assert (false) : "Not inflated";
        return null;
    }

    private void endUpdate() {
        switch (this.inUse) {
            case 0: {
                assert (false);
                break;
            }
            case 1: {
                this.inUse = 0;
                break;
            }
            case 2: {
                IterationData id = iterationData.get(this);
                --id.iterationDepth;
                if (id.iterationDepth != 0) break;
                this.inUse = 0;
                iterationData.remove(this);
                id.apply(this);
            }
        }
    }

    private static class IterationData {
        public int iterationDepth;
        public List<WeakLocation> deferredDependencies;

        public IterationData(int iterationDepth) {
            this.iterationDepth = iterationDepth;
        }

        public void addDependency(WeakLocation loc) {
            if (this.deferredDependencies == null) {
                this.deferredDependencies = new LinkedList<WeakLocation>();
            }
            this.deferredDependencies.add(loc);
        }

        public void apply(AbstractLocation target) {
            if (this.deferredDependencies != null && this.deferredDependencies.size() > 0) {
                WeakLocation.purgeDeadLocations(target);
                for (WeakLocation loc : this.deferredDependencies) {
                    AbstractLinkable.addAtEnd(dependentLocationList, target, loc);
                }
            }
        }
    }
}

