/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.BindingException;
import com.sun.javafx.runtime.location.AbstractBindingExpression;
import com.sun.javafx.runtime.location.AbstractLocation;
import com.sun.javafx.runtime.location.BindableLocation;
import com.sun.javafx.runtime.location.Bindings;
import com.sun.javafx.runtime.location.DeferredInitializer;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVariable<T_VALUE, T_LOCATION extends ObjectLocation<T_VALUE>, T_BINDING extends AbstractBindingExpression, T_LISTENER extends Linkable<T_LISTENER, AbstractVariable>>
extends AbstractLocation
implements ObjectLocation<T_VALUE>,
BindableLocation<T_VALUE, T_BINDING, T_LISTENER> {
    protected static final byte STATE_INITIAL = 0;
    protected static final byte STATE_UNBOUND_DEFAULT = 1;
    protected static final byte STATE_UNBOUND = 2;
    protected static final byte STATE_UNI_BOUND = 3;
    protected static final byte STATE_UNI_BOUND_LAZY = 4;
    protected static final byte STATE_BIDI_BOUND = 5;
    protected T_BINDING binding;
    protected DeferredInitializer deferredLiteral;
    protected T_LISTENER replaceListeners;
    private static final Linkable.HeadAccessor<Linkable, AbstractVariable> LISTENER_LIST = new Linkable.HeadAccessor<Linkable, AbstractVariable>(){

        @Override
        public Linkable getHead(AbstractVariable host) {
            return host.replaceListeners;
        }

        @Override
        public void setHead(AbstractVariable host, Linkable newHead) {
            host.replaceListeners = newHead;
        }
    };

    protected AbstractVariable() {
    }

    protected AbstractVariable(byte state) {
        this.state = state;
    }

    protected void resetState(byte newState) {
        if (this.isValid()) {
            super.invalidate();
        }
        this.state = newState;
    }

    @Override
    public boolean isInitialized() {
        return this.state != 0 && this.state != 1;
    }

    protected boolean isBound() {
        return this.state >= 3;
    }

    protected void ensureBindable() {
        if (this.isBound()) {
            throw new BindingException("Cannot rebind variable");
        }
    }

    @Override
    public void bijectiveBind(ObjectLocation<T_VALUE> other) {
        this.ensureBindable();
        this.resetState((byte)5);
        Bindings.bijectiveBind(this, other);
    }

    @Override
    public void bijectiveBindFromLiteral(final ObjectLocation<T_VALUE> other) {
        this.deferredLiteral = new DeferredInitializer(){

            public void apply() {
                AbstractVariable.this.bijectiveBind(other);
            }
        };
    }

    protected abstract T_BINDING makeBindingExpression(T_LOCATION var1);

    public void bind(T_LOCATION otherLocation) {
        this.bind(false, this.makeBindingExpression(otherLocation), new Location[]{otherLocation});
    }

    public void bindFromLiteral(T_LOCATION otherLocation) {
        this.deferredLiteral = new DeferredInitializer((ObjectLocation)otherLocation){
            final /* synthetic */ ObjectLocation val$otherLocation;
            {
                this.val$otherLocation = objectLocation;
            }

            public void apply() {
                AbstractVariable.this.bind(this.val$otherLocation);
            }
        };
    }

    @Override
    public void bind(boolean lazy, T_BINDING binding, Location ... dependencies) {
        this.ensureBindable();
        this.resetState(lazy ? (byte)4 : 3);
        this.binding = binding;
        ((AbstractBindingExpression)binding).setLocation(this);
        this.addDependency(dependencies);
        if (!lazy) {
            this.update();
        }
    }

    @Override
    public void bindFromLiteral(final boolean lazy, T_BINDING binding, Location ... dependencies) {
        this.deferredLiteral = new DeferredInitializer((AbstractBindingExpression)binding, dependencies){
            final /* synthetic */ AbstractBindingExpression val$binding;
            final /* synthetic */ Location[] val$dependencies;
            {
                this.val$binding = abstractBindingExpression;
                this.val$dependencies = locationArray;
            }

            public void apply() {
                AbstractVariable.this.bind(lazy, this.val$binding, this.val$dependencies);
            }
        };
    }

    @Override
    public T_VALUE setFromLiteral(final T_VALUE value) {
        this.deferredLiteral = new DeferredInitializer(){

            public void apply() {
                AbstractVariable.this.set(value);
            }
        };
        return value;
    }

    protected boolean isUnidirectionallyBound() {
        return this.state == 3 || this.state == 4;
    }

    protected boolean isLazilyBound() {
        return this.state == 4;
    }

    public boolean needDefault() {
        if (this.deferredLiteral != null) {
            this.deferredLiteral.apply();
            this.deferredLiteral = null;
            return false;
        }
        return !this.isInitialized();
    }

    public void initialize() {
        assert (this.deferredLiteral == null);
        this.deferredLiteral = null;
        if (this.isUnidirectionallyBound() && !this.isLazilyBound()) {
            this.update();
        }
    }

    @Override
    public void invalidate() {
        if (this.isUnidirectionallyBound()) {
            super.invalidate();
            if (!this.isLazilyBound()) {
                this.update();
            }
        } else {
            throw new BindingException("Cannot invalidate non-bound variable");
        }
    }

    @Override
    public boolean isMutable() {
        return !this.isUnidirectionallyBound();
    }

    @Override
    public void addChangeListener(T_LISTENER listener) {
        assert (AbstractLinkable.isUnused(listener));
        AbstractLinkable.addAtEnd(LISTENER_LIST, this, listener);
    }

    @Override
    public void removeChangeListener(T_LISTENER listener) {
        AbstractLinkable.remove(LISTENER_LIST, this, listener);
    }

    @Override
    public boolean hasDependencies() {
        return this.replaceListeners != null || super.hasDependencies();
    }

    protected boolean preReplace(boolean changed) {
        boolean shouldFire = changed;
        switch (this.state) {
            case 2: {
                break;
            }
            case 0: {
                this.state = (byte)2;
                shouldFire = true;
                break;
            }
            case 1: {
                this.state = (byte)2;
                break;
            }
            default: {
                shouldFire = shouldFire || !this.isValid();
            }
        }
        return shouldFire;
    }
}

