/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.BindingException;
import com.sun.javafx.runtime.CircularBindingException;
import com.sun.javafx.runtime.location.Bijection;
import com.sun.javafx.runtime.location.ChangeListener;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.ObjectVariable;
import com.sun.javafx.runtime.location.StaticViewLocation;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bindings {
    public static <T> Bijection<T, T> identityBinding() {
        return new Bijection<T, T>(){

            @Override
            public T mapForwards(T a) {
                return a;
            }

            @Override
            public T mapBackwards(T b) {
                return b;
            }
        };
    }

    public static <T, U> void bijectiveBind(ObjectLocation<T> a, ObjectLocation<U> b, Bijection<T, U> mapper) {
        new BijectiveBinding<T, U>(a, b, mapper);
    }

    public static <T> void bijectiveBind(ObjectLocation<T> a, ObjectLocation<T> b) {
        Bijection<T, T> id = Bindings.identityBinding();
        Bindings.bijectiveBind(a, b, id);
    }

    public static <T> ObjectLocation<T> makeBijectiveBind(ObjectLocation<T> other) {
        ObjectVariable me = ObjectVariable.make();
        Bindings.bijectiveBind(me, other);
        return me;
    }

    static Collection<Location> getPeerLocations(Location location) {
        List<Location> newLocs = BijectiveBinding.getDirectPeers(location);
        if (newLocs.size() == 0) {
            return newLocs;
        }
        HashSet<Location> knownLocs = new HashSet<Location>();
        LinkedList<Location> toExplore = new LinkedList<Location>(newLocs);
        while (toExplore.size() > 0) {
            Location loc = toExplore.removeFirst();
            while (loc instanceof StaticViewLocation) {
                loc = ((StaticViewLocation)((Object)loc)).getUnderlyingLocation();
            }
            if (knownLocs.contains(loc) || loc == location) continue;
            knownLocs.add(loc);
            toExplore.addAll(BijectiveBinding.getDirectPeers(loc));
        }
        return knownLocs;
    }

    static boolean isPeerLocation(Location a, Location b) {
        Collection<Location> aPeers = Bindings.getPeerLocations(a);
        while (b instanceof StaticViewLocation) {
            b = ((StaticViewLocation)((Object)b)).getUnderlyingLocation();
        }
        return aPeers != null && aPeers.contains(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BijectiveBinding<T, U> {
        private final WeakReference<ObjectLocation<T>> aRef;
        private final WeakReference<ObjectLocation<U>> bRef;
        private final Bijection<T, U> mapper;
        private T lastA;
        private U lastB;

        public BijectiveBinding(ObjectLocation<T> a, ObjectLocation<U> b, Bijection<T, U> mapper) {
            if (!a.isMutable() || !b.isMutable()) {
                throw new BindingException("Both components of bijective bind must be mutable");
            }
            if (Bindings.isPeerLocation(a, b)) {
                throw new CircularBindingException("Binding circularity detected");
            }
            this.aRef = new WeakReference<ObjectLocation<ObjectLocation<T>>>(a);
            this.bRef = new WeakReference<ObjectLocation<U>>(b);
            this.mapper = mapper;
            a.set(mapper.mapBackwards(b.get()));
            a.addChangeListener(new BijectiveChangeListener(){

                public boolean onChange() {
                    ObjectLocation a = (ObjectLocation)BijectiveBinding.this.aRef.get();
                    ObjectLocation b = (ObjectLocation)BijectiveBinding.this.bRef.get();
                    if (a == null || b == null) {
                        return false;
                    }
                    Object newA = a.get();
                    if (newA == null && BijectiveBinding.this.lastA == null || newA != null && newA.equals(BijectiveBinding.this.lastA)) {
                        return true;
                    }
                    Object newB = BijectiveBinding.this.mapper.mapForwards(newA);
                    BijectiveBinding.this.lastA = newA;
                    BijectiveBinding.this.lastB = newB;
                    b.set(newB);
                    return true;
                }

                public BijectiveBinding getBijectiveBinding() {
                    return BijectiveBinding.this;
                }
            });
            b.addChangeListener(new BijectiveChangeListener(){

                public boolean onChange() {
                    ObjectLocation a = (ObjectLocation)BijectiveBinding.this.aRef.get();
                    ObjectLocation b = (ObjectLocation)BijectiveBinding.this.bRef.get();
                    if (a == null || b == null) {
                        return false;
                    }
                    Object newB = b.get();
                    if (newB == null && BijectiveBinding.this.lastB == null || newB != null && newB.equals(BijectiveBinding.this.lastB)) {
                        return true;
                    }
                    Object newA = BijectiveBinding.this.mapper.mapBackwards(newB);
                    BijectiveBinding.this.lastA = newA;
                    BijectiveBinding.this.lastB = newB;
                    a.set(newA);
                    return true;
                }

                public BijectiveBinding getBijectiveBinding() {
                    return BijectiveBinding.this;
                }
            });
        }

        public static List<Location> getDirectPeers(Location loc) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class DirectPeerClosure
            implements Linkable.IterationClosure<ChangeListener> {
                List<Location> list = null;
                final /* synthetic */ Location val$loc;

                DirectPeerClosure(Location location) {
                    this.val$loc = location;
                }

                @Override
                public void action(ChangeListener element) {
                    if (element instanceof BijectiveChangeListener) {
                        BijectiveBinding bb = ((BijectiveChangeListener)element).getBijectiveBinding();
                        ObjectLocation a = (ObjectLocation)bb.aRef.get();
                        ObjectLocation b = (ObjectLocation)bb.bRef.get();
                        if (a != null && a != this.val$loc) {
                            if (this.list == null) {
                                this.list = new ArrayList<Location>();
                            }
                            this.list.add(a);
                        }
                        if (b != null && b != this.val$loc) {
                            if (this.list == null) {
                                this.list = new ArrayList<Location>();
                            }
                            this.list.add(b);
                        }
                    }
                }
            }
            DirectPeerClosure closure = new DirectPeerClosure(loc);
            AbstractLinkable.iterate(loc.getListeners(), closure);
            if (closure.list != null) {
                return closure.list;
            }
            return Collections.emptyList();
        }

        private static abstract class BijectiveChangeListener
        extends ChangeListener {
            private BijectiveChangeListener() {
            }

            public abstract BijectiveBinding getBijectiveBinding();
        }
    }
}

