/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.location.AbstractVariable;
import com.sun.javafx.runtime.location.BooleanBindingExpression;
import com.sun.javafx.runtime.location.BooleanChangeListener;
import com.sun.javafx.runtime.location.BooleanLocation;
import com.sun.javafx.runtime.location.DeferredInitializer;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectChangeListener;
import com.sun.javafx.runtime.location.ObjectVariable;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanVariable
extends AbstractVariable<Boolean, BooleanLocation, BooleanBindingExpression, BooleanChangeListener>
implements BooleanLocation {
    public static final boolean DEFAULT = false;
    protected boolean $value = false;

    public static BooleanVariable make() {
        return new BooleanVariable();
    }

    public static BooleanVariable make(boolean value) {
        return new BooleanVariable(value);
    }

    public static BooleanVariable make(boolean lazy, BooleanBindingExpression binding, Location ... dependencies) {
        return new BooleanVariable(lazy, binding, dependencies);
    }

    public static BooleanVariable make(BooleanBindingExpression binding, Location ... dependencies) {
        return new BooleanVariable(false, binding, dependencies);
    }

    public static BooleanVariable makeBijective(ObjectVariable<Boolean> other) {
        BooleanVariable me = BooleanVariable.make();
        me.bijectiveBind(other);
        return me;
    }

    protected BooleanVariable() {
    }

    protected BooleanVariable(boolean value) {
        super((byte)2);
        this.$value = value;
        this.setValid();
    }

    protected BooleanVariable(boolean lazy, BooleanBindingExpression binding, Location ... dependencies) {
        this();
        this.bind(lazy, binding, new Location[0]);
        this.addDependency(dependencies);
    }

    protected boolean replaceValue(boolean newValue) {
        boolean oldValue = this.$value;
        if (this.preReplace(oldValue != newValue)) {
            boolean invalidateDependencies = this.isValid() || this.state == 2;
            this.$value = newValue;
            this.setValid();
            this.notifyListeners(oldValue, newValue, invalidateDependencies);
        } else {
            this.setValid();
        }
        return newValue;
    }

    @Override
    public boolean getAsBoolean() {
        if (this.isUnidirectionallyBound() && !this.isValid()) {
            this.update();
        }
        return this.$value;
    }

    @Override
    protected BooleanBindingExpression makeBindingExpression(final BooleanLocation otherLocation) {
        return new BooleanBindingExpression(){

            public boolean computeValue() {
                return otherLocation.getAsBoolean();
            }
        };
    }

    @Override
    public boolean setAsBoolean(boolean value) {
        if (this.isUnidirectionallyBound() && this.$value != value) {
            throw new AssignToBoundException("Cannot assign to bound variable");
        }
        return this.replaceValue(value);
    }

    @Override
    public boolean setAsBooleanFromLiteral(final boolean value) {
        this.deferredLiteral = new DeferredInitializer(){

            public void apply() {
                BooleanVariable.this.setAsBoolean(value);
            }
        };
        return value;
    }

    @Override
    public void setDefault() {
        if (this.state == 0) {
            this.$value = false;
            this.state = 1;
            this.notifyListeners(false, false, true);
        } else {
            this.setAsBoolean(false);
        }
    }

    @Override
    public Boolean set(Boolean value) {
        if (value == null) {
            ErrorHandler.nullToPrimitiveCoercion("Boolean");
            this.setDefault();
        } else {
            this.setAsBoolean(value);
        }
        return value;
    }

    @Override
    public void update() {
        block3: {
            try {
                if (this.isUnidirectionallyBound() && !this.isValid()) {
                    this.replaceValue(((BooleanBindingExpression)this.binding).computeValue());
                }
            }
            catch (RuntimeException e) {
                ErrorHandler.bindException(e);
                if (!this.isInitialized()) break block3;
                this.replaceValue(false);
            }
        }
    }

    @Override
    public Boolean get() {
        return this.getAsBoolean();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void addChangeListener(final ObjectChangeListener<Boolean> listener) {
        this.addChangeListener(new BooleanChangeListener(){

            public void onChange(boolean oldValue, boolean newValue) {
                listener.onChange(oldValue, newValue);
            }
        });
    }

    private void notifyListeners(final boolean oldValue, final boolean newValue, boolean invalidateDependencies) {
        if (invalidateDependencies) {
            this.invalidateDependencies();
        }
        if (this.replaceListeners != null) {
            AbstractLinkable.iterate(this.replaceListeners, new Linkable.IterationClosure<BooleanChangeListener>(){

                @Override
                public void action(BooleanChangeListener listener) {
                    try {
                        listener.onChange(oldValue, newValue);
                    }
                    catch (RuntimeException e) {
                        ErrorHandler.triggerException(e);
                    }
                }
            });
        }
    }
}

