/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.functions.Function0;
import com.sun.javafx.functions.Function1;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.location.BooleanBindingExpression;
import com.sun.javafx.runtime.location.BooleanConstant;
import com.sun.javafx.runtime.location.BooleanLocation;
import com.sun.javafx.runtime.location.BooleanVariable;
import com.sun.javafx.runtime.location.DoubleConstant;
import com.sun.javafx.runtime.location.DoubleLocation;
import com.sun.javafx.runtime.location.GeneratedBoundOperators;
import com.sun.javafx.runtime.location.IndirectBooleanExpression;
import com.sun.javafx.runtime.location.IndirectDoubleExpression;
import com.sun.javafx.runtime.location.IndirectIntExpression;
import com.sun.javafx.runtime.location.IndirectObjectExpression;
import com.sun.javafx.runtime.location.IndirectSequenceExpression;
import com.sun.javafx.runtime.location.IntConstant;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectConstant;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.SequenceConstant;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BoundOperators
extends GeneratedBoundOperators {
    private BoundOperators() {
    }

    public static <T, V> BooleanLocation eq_oo(final ObjectLocation<T> a, final ObjectLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Object aVal = a.get();
                Object bVal = b.get();
                if (aVal == null) {
                    return bVal == null;
                }
                return aVal.equals(bVal);
            }
        }, a, b);
    }

    public static <T, V> BooleanLocation ne_oo(final ObjectLocation<T> a, final ObjectLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Object aVal = a.get();
                Object bVal = b.get();
                if (aVal == null) {
                    return bVal != null;
                }
                return !aVal.equals(bVal);
            }
        }, a, b);
    }

    public static <T, V> BooleanLocation eq_ss(final SequenceLocation<T> a, final SequenceLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Sequence aVal = a.getAsSequence();
                Sequence bVal = b.getAsSequence();
                if (aVal == null) {
                    return bVal == null || bVal.isEmpty();
                }
                return aVal.equals(bVal);
            }
        }, a, b);
    }

    public static <T, V> BooleanLocation eq_so(final SequenceLocation<T> a, final ObjectLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Sequence aVal = a.getAsSequence();
                Object bVal = b.get();
                if (bVal == null) {
                    return aVal == null || aVal.isEmpty();
                }
                return aVal.size() == 1 && aVal.get(0).equals(bVal);
            }
        }, a, b);
    }

    public static <T, V> BooleanLocation eq_os(final ObjectLocation<T> a, final SequenceLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Object aVal = a.get();
                Sequence bVal = b.getAsSequence();
                if (aVal == null) {
                    return bVal == null || bVal.isEmpty();
                }
                return bVal.size() == 1 && bVal.get(0).equals(aVal);
            }
        }, a, b);
    }

    public static <T, V> BooleanLocation ne_ss(final SequenceLocation<T> a, final SequenceLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Sequence aVal = a.getAsSequence();
                Sequence bVal = b.getAsSequence();
                if (aVal == null) {
                    return bVal != null && !bVal.isEmpty();
                }
                return !aVal.equals(bVal);
            }
        }, a, b);
    }

    public static <T, V> BooleanLocation ne_so(final SequenceLocation<T> a, final ObjectLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Sequence aVal = a.getAsSequence();
                Object bVal = b.get();
                if (bVal == null) {
                    return aVal != null && !aVal.isEmpty();
                }
                return aVal.size() != 1 || !aVal.get(0).equals(bVal);
            }
        }, a, b);
    }

    public static <T, V> BooleanLocation ne_os(final ObjectLocation<T> a, final SequenceLocation<V> b) {
        return BooleanVariable.make(new BooleanBindingExpression(){

            public boolean computeValue() {
                Object aVal = a.get();
                Sequence bVal = b.getAsSequence();
                if (aVal == null) {
                    return bVal != null && !bVal.isEmpty();
                }
                return bVal.size() != 1 || !bVal.get(0).equals(aVal);
            }
        }, a, b);
    }

    public static IntLocation makeBoundIf(boolean lazy, final BooleanLocation conditional, final Function0<IntLocation> thenBranch, final Function0<IntLocation> elseBranch) {
        return new IndirectIntExpression(lazy, new Location[]{conditional}){

            public IntLocation computeLocation() {
                return (Boolean)conditional.get() != false ? (IntLocation)thenBranch.invoke() : (IntLocation)elseBranch.invoke();
            }
        };
    }

    public static DoubleLocation makeBoundIf(boolean lazy, final BooleanLocation conditional, final Function0<DoubleLocation> thenBranch, final Function0<DoubleLocation> elseBranch) {
        return new IndirectDoubleExpression(lazy, new Location[]{conditional}){

            public DoubleLocation computeLocation() {
                return (Boolean)conditional.get() != false ? (DoubleLocation)thenBranch.invoke() : (DoubleLocation)elseBranch.invoke();
            }
        };
    }

    public static BooleanLocation makeBoundIf(boolean lazy, final BooleanLocation conditional, final Function0<BooleanLocation> thenBranch, final Function0<BooleanLocation> elseBranch) {
        return new IndirectBooleanExpression(lazy, new Location[]{conditional}){

            public BooleanLocation computeLocation() {
                return (Boolean)conditional.get() != false ? (BooleanLocation)thenBranch.invoke() : (BooleanLocation)elseBranch.invoke();
            }
        };
    }

    public static <T> ObjectLocation<T> makeBoundIf(boolean lazy, final BooleanLocation conditional, final Function0<ObjectLocation<T>> thenBranch, final Function0<ObjectLocation<T>> elseBranch) {
        return new IndirectObjectExpression<T>(lazy, new Location[]{conditional}){

            @Override
            public ObjectLocation<T> computeLocation() {
                return (Boolean)conditional.get() != false ? (ObjectLocation)thenBranch.invoke() : (ObjectLocation)elseBranch.invoke();
            }
        };
    }

    public static <T> SequenceLocation<T> makeBoundIf(Class<T> clazz, boolean lazy, final BooleanLocation conditional, final Function0<SequenceLocation<T>> thenBranch, final Function0<SequenceLocation<T>> elseBranch) {
        return new IndirectSequenceExpression<T>(clazz, lazy, new Location[]{conditional}){

            @Override
            public SequenceLocation<T> computeLocation() {
                return (Boolean)conditional.get() != false ? (SequenceLocation)thenBranch.invoke() : (SequenceLocation)elseBranch.invoke();
            }
        };
    }

    public static <T> IntLocation makeBoundSelect(boolean lazy, final ObjectLocation<T> receiver, final Function1<IntLocation, T> selector) {
        return new IndirectIntExpression(lazy, new Location[]{receiver}){

            public IntLocation computeLocation() {
                Object selectorValue = receiver.get();
                return selectorValue == null ? IntConstant.make(0) : (IntLocation)selector.invoke(selectorValue);
            }

            public int setAsInt(int value) {
                return ((IntLocation)this.helper.get()).setAsInt(value);
            }

            public void setDefault() {
                ((IntLocation)this.helper.get()).setDefault();
            }

            public Integer set(Integer value) {
                return ((IntLocation)this.helper.get()).set(value);
            }
        };
    }

    public static <T> DoubleLocation makeBoundSelect(boolean lazy, final ObjectLocation<T> receiver, final Function1<DoubleLocation, T> selector) {
        return new IndirectDoubleExpression(lazy, new Location[]{receiver}){

            public DoubleLocation computeLocation() {
                Object selectorValue = receiver.get();
                return selectorValue == null ? DoubleConstant.make(0.0) : (DoubleLocation)selector.invoke(selectorValue);
            }

            public double setAsDouble(double value) {
                return ((DoubleLocation)this.helper.get()).setAsDouble(value);
            }

            public void setDefault() {
                ((DoubleLocation)this.helper.get()).setDefault();
            }

            public Double set(Double value) {
                return ((DoubleLocation)this.helper.get()).set(value);
            }
        };
    }

    public static <T> BooleanLocation makeBoundSelect(boolean lazy, final ObjectLocation<T> receiver, final Function1<BooleanLocation, T> selector) {
        return new IndirectBooleanExpression(lazy, new Location[]{receiver}){

            public BooleanLocation computeLocation() {
                Object selectorValue = receiver.get();
                return selectorValue == null ? BooleanConstant.make(false) : (BooleanLocation)selector.invoke(selectorValue);
            }

            public boolean setAsBoolean(boolean value) {
                return ((BooleanLocation)this.helper.get()).setAsBoolean(value);
            }

            public void setDefault() {
                ((BooleanLocation)this.helper.get()).setDefault();
            }

            public Boolean set(Boolean value) {
                return ((BooleanLocation)this.helper.get()).set(value);
            }
        };
    }

    public static <T, U> ObjectLocation<U> makeBoundSelect(final Class clazz, boolean lazy, final ObjectLocation<T> receiver, final Function1<ObjectLocation<U>, T> selector) {
        return new IndirectObjectExpression<U>(lazy, new Location[]{receiver}){

            @Override
            public ObjectLocation<U> computeLocation() {
                Object selectorValue = receiver.get();
                return selectorValue == null ? ObjectConstant.make(Util.defaultValue(clazz)) : (ObjectLocation)selector.invoke(selectorValue);
            }

            @Override
            public void setDefault() {
                ((ObjectLocation)this.helper.get()).setDefault();
            }

            @Override
            public U set(U value) {
                return ((ObjectLocation)this.helper.get()).set(value);
            }
        };
    }

    public static <T, U> SequenceLocation<U> makeBoundSelect(Class<U> clazz, boolean lazy, final ObjectLocation<T> receiver, final Function1<SequenceLocation<U>, T> selector) {
        final SequenceLocation<U> defaultValue = SequenceConstant.make(clazz, Sequences.emptySequence(clazz));
        return new IndirectSequenceExpression<U>(clazz, lazy, new Location[]{receiver}){

            @Override
            public SequenceLocation<U> computeLocation() {
                Object selectorValue = receiver.get();
                return selectorValue == null ? defaultValue : (SequenceLocation)selector.invoke(selectorValue);
            }

            @Override
            public void setDefault() {
                ((SequenceLocation)this.helper.get()).setDefault();
            }

            @Override
            public Sequence<U> setAsSequence(Sequence<? extends U> value) {
                return ((SequenceLocation)this.helper.get()).setAsSequence(value);
            }

            @Override
            public Sequence<U> set(Sequence<U> value) {
                return ((SequenceLocation)this.helper.get()).set(value);
            }

            @Override
            public U set(int position, U newValue) {
                return ((SequenceLocation)this.helper.get()).set(position, newValue);
            }

            @Override
            public Sequence<? extends U> replaceSlice(int startPos, int endPos, Sequence<? extends U> newValues) {
                return ((SequenceLocation)this.helper.get()).replaceSlice(startPos, endPos, newValues);
            }

            @Override
            public void delete(int position) {
                ((SequenceLocation)this.helper.get()).delete(position);
            }

            @Override
            public void deleteSlice(int startPos, int endPos) {
                ((SequenceLocation)this.helper.get()).deleteSlice(startPos, endPos);
            }

            @Override
            public void delete(SequencePredicate<U> tSequencePredicate) {
                ((SequenceLocation)this.helper.get()).delete(tSequencePredicate);
            }

            @Override
            public void deleteAll() {
                ((SequenceLocation)this.helper.get()).deleteAll();
            }

            @Override
            public void deleteValue(U targetValue) {
                ((SequenceLocation)this.helper.get()).deleteValue(targetValue);
            }

            @Override
            public void insert(U value) {
                ((SequenceLocation)this.helper.get()).insert(value);
            }

            @Override
            public void insert(Sequence<? extends U> values) {
                ((SequenceLocation)this.helper.get()).insert(values);
            }

            @Override
            public void insertFirst(U value) {
                ((SequenceLocation)this.helper.get()).insertFirst(value);
            }

            @Override
            public void insertFirst(Sequence<? extends U> values) {
                ((SequenceLocation)this.helper.get()).insertFirst(values);
            }

            @Override
            public void insertBefore(U value, int position) {
                ((SequenceLocation)this.helper.get()).insertBefore(value, position);
            }

            @Override
            public void insertBefore(U value, SequencePredicate<U> tSequencePredicate) {
                ((SequenceLocation)this.helper.get()).insertBefore(value, tSequencePredicate);
            }

            @Override
            public void insertBefore(Sequence<? extends U> values, int position) {
                ((SequenceLocation)this.helper.get()).insertBefore(values, position);
            }

            @Override
            public void insertBefore(Sequence<? extends U> values, SequencePredicate<U> tSequencePredicate) {
                ((SequenceLocation)this.helper.get()).insertBefore(values, tSequencePredicate);
            }

            @Override
            public void insertAfter(U value, int position) {
                ((SequenceLocation)this.helper.get()).insertAfter(value, position);
            }

            @Override
            public void insertAfter(U value, SequencePredicate<U> tSequencePredicate) {
                ((SequenceLocation)this.helper.get()).insertAfter(value, tSequencePredicate);
            }

            @Override
            public void insertAfter(Sequence<? extends U> values, int position) {
                ((SequenceLocation)this.helper.get()).insertAfter(values, position);
            }

            @Override
            public void insertAfter(Sequence<? extends U> values, SequencePredicate<U> tSequencePredicate) {
                ((SequenceLocation)this.helper.get()).insertAfter(values, tSequencePredicate);
            }
        };
    }
}

