/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.location.AbstractVariable;
import com.sun.javafx.runtime.location.DeferredInitializer;
import com.sun.javafx.runtime.location.DoubleBindingExpression;
import com.sun.javafx.runtime.location.DoubleChangeListener;
import com.sun.javafx.runtime.location.DoubleLocation;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectChangeListener;
import com.sun.javafx.runtime.location.ObjectVariable;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleVariable
extends AbstractVariable<Double, DoubleLocation, DoubleBindingExpression, DoubleChangeListener>
implements DoubleLocation {
    public static final double DEFAULT = 0.0;
    protected double $value = 0.0;

    public static DoubleVariable make() {
        return new DoubleVariable();
    }

    public static DoubleVariable make(double value) {
        return new DoubleVariable(value);
    }

    public static DoubleVariable make(boolean lazy, DoubleBindingExpression binding, Location ... dependencies) {
        return new DoubleVariable(lazy, binding, dependencies);
    }

    public static DoubleVariable make(DoubleBindingExpression binding, Location ... dependencies) {
        return new DoubleVariable(false, binding, dependencies);
    }

    public static DoubleVariable makeBijective(ObjectVariable<Double> other) {
        DoubleVariable me = DoubleVariable.make();
        me.bijectiveBind(other);
        return me;
    }

    protected DoubleVariable() {
    }

    protected DoubleVariable(double value) {
        super((byte)2);
        this.$value = value;
        this.setValid();
    }

    protected DoubleVariable(boolean lazy, DoubleBindingExpression binding, Location ... dependencies) {
        this();
        this.bind(lazy, binding, new Location[0]);
        this.addDependency(dependencies);
    }

    @Override
    public double getAsDouble() {
        if (this.isUnidirectionallyBound() && !this.isValid()) {
            this.update();
        }
        return this.$value;
    }

    @Override
    public Double get() {
        return this.getAsDouble();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    protected double replaceValue(double newValue) {
        double oldValue = this.$value;
        if (this.preReplace(oldValue != newValue)) {
            boolean invalidateDependencies = this.isValid() || this.state == 2;
            this.$value = newValue;
            this.setValid();
            this.notifyListeners(oldValue, newValue, invalidateDependencies);
        } else {
            this.setValid();
        }
        return newValue;
    }

    @Override
    protected DoubleBindingExpression makeBindingExpression(final DoubleLocation otherLocation) {
        return new DoubleBindingExpression(){

            public double computeValue() {
                return otherLocation.getAsDouble();
            }
        };
    }

    @Override
    public double setAsDouble(double value) {
        if (this.isUnidirectionallyBound() && this.$value != value) {
            throw new AssignToBoundException("Cannot assign to bound variable");
        }
        return this.replaceValue(value);
    }

    @Override
    public double setAsDoubleFromLiteral(final double value) {
        this.deferredLiteral = new DeferredInitializer(){

            public void apply() {
                DoubleVariable.this.setAsDouble(value);
            }
        };
        return value;
    }

    @Override
    public void setDefault() {
        if (this.state == 0) {
            this.$value = 0.0;
            this.state = 1;
            this.notifyListeners(0.0, 0.0, true);
        } else {
            this.setAsDouble(0.0);
        }
    }

    @Override
    public Double set(Double value) {
        if (value == null) {
            ErrorHandler.nullToPrimitiveCoercion("Double");
            this.setDefault();
        } else {
            this.setAsDouble(value);
        }
        return value;
    }

    @Override
    public void update() {
        block3: {
            try {
                if (this.isUnidirectionallyBound() && !this.isValid()) {
                    this.replaceValue(((DoubleBindingExpression)this.binding).computeValue());
                }
            }
            catch (RuntimeException e) {
                ErrorHandler.bindException(e);
                if (!this.isInitialized()) break block3;
                this.replaceValue(0.0);
            }
        }
    }

    @Override
    public void addChangeListener(final ObjectChangeListener<Double> listener) {
        this.addChangeListener(new DoubleChangeListener(){

            public void onChange(double oldValue, double newValue) {
                listener.onChange(oldValue, newValue);
            }
        });
    }

    private void notifyListeners(final double oldValue, final double newValue, boolean invalidateDependencies) {
        if (invalidateDependencies) {
            this.invalidateDependencies();
        }
        if (this.replaceListeners != null) {
            AbstractLinkable.iterate(this.replaceListeners, new Linkable.IterationClosure<DoubleChangeListener>(){

                @Override
                public void action(DoubleChangeListener listener) {
                    try {
                        listener.onChange(oldValue, newValue);
                    }
                    catch (RuntimeException e) {
                        ErrorHandler.triggerException(e);
                    }
                }
            });
        }
    }
}

