/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.location.AbstractVariable;
import com.sun.javafx.runtime.location.ChangeListener;
import com.sun.javafx.runtime.location.DeferredInitializer;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectChangeListener;
import com.sun.javafx.runtime.location.SequenceBindingExpression;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequenceMutator;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceVariable<T>
extends AbstractVariable<Sequence<T>, SequenceLocation<T>, SequenceBindingExpression<T>, SequenceChangeListener<T>>
implements SequenceLocation<T> {
    private final Class<T> clazz;
    private final SequenceMutator.Listener<T> mutationListener;
    private Sequence<T> $value;
    private BoundLocationInfo boundLocation;

    public static <T> SequenceVariable<T> make(Class clazz) {
        return new SequenceVariable<T>(clazz);
    }

    public static <T> SequenceVariable<T> make(Class clazz, Sequence<? extends T> value) {
        return new SequenceVariable<T>(clazz, value);
    }

    public static <T> SequenceVariable<T> make(Class clazz, boolean lazy, SequenceBindingExpression<T> binding, Location ... dependencies) {
        return new SequenceVariable<T>(clazz, lazy, binding, dependencies);
    }

    public static <T> SequenceVariable<T> make(Class clazz, SequenceBindingExpression<T> binding, Location ... dependencies) {
        return new SequenceVariable<T>(clazz, false, binding, dependencies);
    }

    public static <T> SequenceVariable<T> makeBijective(Class clazz, SequenceVariable<T> other) {
        SequenceVariable<T> me = SequenceVariable.make(clazz);
        me.bijectiveBind(other);
        return me;
    }

    protected SequenceVariable(Class clazz) {
        this.clazz = clazz;
        this.$value = Sequences.emptySequence(this.clazz);
        this.mutationListener = new SequenceMutator.Listener<T>(){

            @Override
            public void onReplaceSlice(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                SequenceVariable.this.replaceSlice(startPos, endPos, newElements, newValue);
            }

            @Override
            public void onReplaceElement(int startPos, int endPos, T newElement, Sequence<T> oldValue, Sequence<T> newValue) {
                SequenceVariable.this.replaceElement(startPos, endPos, newElement, newValue);
            }
        };
    }

    protected SequenceVariable(Class clazz, Sequence<? extends T> value) {
        this(clazz);
        if (value == null) {
            value = Sequences.emptySequence(this.clazz);
        }
        super.replaceValue(Sequences.upcast(value));
    }

    protected SequenceVariable(Class clazz, boolean lazy, SequenceBindingExpression<T> binding, Location ... dependencies) {
        this(clazz);
        this.bind(lazy, binding, new Location[0]);
        this.addDependency(dependencies);
    }

    private void ensureValid() {
        if (this.isUnidirectionallyBound() && !this.isValid()) {
            this.update();
        }
    }

    private Sequence<T> replaceValue(Sequence<T> newValue) {
        assert (this.boundLocation == null);
        if (newValue == null) {
            newValue = Sequences.emptySequence(this.clazz);
        }
        return this.replaceSlice(0, Sequences.size(this.$value) - 1, newValue, newValue);
    }

    private Sequence<T> replaceSlice(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> newValue) {
        assert (this.boundLocation == null);
        Sequence<T> oldValue = this.$value;
        if (!this.hasDependencies()) {
            this.preReplace(true);
            this.$value = newValue;
            this.setValid();
        } else if (this.preReplace(!Sequences.sliceEqual(oldValue, startPos, endPos, newElements))) {
            boolean invalidateDependencies = this.isValid() || this.state == 2;
            this.$value = newValue;
            this.setValid();
            this.notifyListeners(startPos, endPos, newElements, oldValue, newValue, invalidateDependencies);
        } else {
            this.setValid();
        }
        return this.$value;
    }

    private Sequence<T> replaceElement(int startPos, int endPos, T newElement, Sequence<T> newValue) {
        assert (this.boundLocation == null);
        Sequence<T> oldValue = this.$value;
        if (!this.hasDependencies()) {
            this.preReplace(true);
            this.$value = newValue;
            this.setValid();
        } else if (this.preReplace(startPos != endPos || !newElement.equals(oldValue.get(startPos)))) {
            boolean invalidateDependencies = this.isValid() || this.state == 2;
            this.$value = newValue;
            this.setValid();
            Sequence<T> newElements = Sequences.singleton(oldValue.getElementType(), newElement);
            this.notifyListeners(startPos, endPos, newElements, oldValue, newValue, invalidateDependencies);
        } else {
            this.setValid();
        }
        return this.$value;
    }

    @Override
    public Class<T> getElementType() {
        return this.clazz;
    }

    @Override
    public Sequence<T> get() {
        return this.getAsSequence();
    }

    @Override
    public T get(int position) {
        return this.getAsSequence().get(position);
    }

    @Override
    public Sequence<T> getAsSequence() {
        this.ensureValid();
        return this.$value;
    }

    @Override
    public Sequence<T> getSlice(int startPos, int endPos) {
        return this.getAsSequence().getSlice(startPos, endPos);
    }

    @Override
    public boolean isNull() {
        return Sequences.size(this.getAsSequence()) == 0;
    }

    @Override
    protected SequenceBindingExpression<T> makeBindingExpression(final SequenceLocation<T> otherLocation) {
        return new SequenceBindingExpression<T>(){

            @Override
            public Sequence<T> computeValue() {
                return otherLocation.getAsSequence();
            }
        };
    }

    @Override
    public void addChangeListener(final ObjectChangeListener<Sequence<T>> listener) {
        this.addChangeListener(new SequenceChangeListener<T>(){

            @Override
            public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                listener.onChange(oldValue, newValue);
            }
        });
    }

    protected void notifyListeners(final int startPos, final int endPos, final Sequence<? extends T> newElements, final Sequence<T> oldValue, final Sequence<T> newValue, boolean invalidateDependencies) {
        if (invalidateDependencies) {
            this.invalidateDependencies();
        }
        if (this.replaceListeners != null) {
            AbstractLinkable.iterate(this.replaceListeners, new Linkable.IterationClosure<SequenceChangeListener<T>>(){

                @Override
                public void action(SequenceChangeListener<T> listener) {
                    try {
                        listener.onChange(startPos, endPos, newElements, oldValue, newValue);
                    }
                    catch (RuntimeException e) {
                        ErrorHandler.triggerException(e);
                    }
                }
            });
        }
    }

    @Override
    public void bind(SequenceLocation<T> otherLocation) {
        this.ensureBindable();
        Sequence<T> oldValue = this.$value;
        this.$value = (Sequence)otherLocation.get();
        this.boundLocation = new BoundLocationInfo(otherLocation);
        this.boundLocation.bind();
        this.notifyListeners(0, Sequences.size(oldValue) - 1, this.$value, oldValue, this.$value, true);
    }

    protected void rebind(SequenceLocation<T> otherLocation) {
        if (this.boundLocation != null) {
            this.boundLocation.unbind();
        }
        this.boundLocation = null;
        this.bind(otherLocation);
    }

    @Override
    protected boolean isUnidirectionallyBound() {
        return super.isUnidirectionallyBound() || this.boundLocation != null;
    }

    public String toString() {
        return this.getAsSequence().toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getAsSequence().iterator();
    }

    @Override
    public void update() {
        block3: {
            try {
                if (this.isUnidirectionallyBound() && !this.isValid() && this.boundLocation == null) {
                    this.replaceValue(Sequences.upcast(((SequenceBindingExpression)this.binding).computeValue()));
                }
            }
            catch (RuntimeException e) {
                ErrorHandler.bindException(e);
                if (!this.isInitialized()) break block3;
                this.replaceValue(Sequences.emptySequence(this.clazz));
            }
        }
    }

    private void ensureNotBound() {
        if (this.isUnidirectionallyBound()) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
    }

    @Override
    public Sequence<T> set(Sequence<T> value) {
        return this.setAsSequence(value);
    }

    @Override
    public void setDefault() {
        Sequence<T> empty = Sequences.emptySequence(this.clazz);
        if (this.state == 0) {
            this.$value = empty;
            this.state = 1;
        } else {
            this.setAsSequence(empty);
        }
    }

    @Override
    public Sequence<T> setAsSequence(Sequence<? extends T> newValue) {
        this.ensureNotBound();
        Sequence<T> oldValue = this.$value;
        this.state = (byte)2;
        Sequence<Object> result = !Sequences.isEqual(oldValue, newValue) || this.state == 2 && !this.isValid() ? SequenceMutator.replaceSlice(oldValue, this.mutationListener, 0, Sequences.size(oldValue) - 1, newValue) : oldValue;
        return result;
    }

    @Override
    public Sequence<T> setAsSequenceFromLiteral(final Sequence<? extends T> value) {
        this.deferredLiteral = new DeferredInitializer(){

            public void apply() {
                SequenceVariable.this.setAsSequence(value);
            }
        };
        return Sequences.upcast(value);
    }

    @Override
    public T set(int position, T newValue) {
        this.ensureNotBound();
        SequenceMutator.set(this.$value, this.mutationListener, position, newValue);
        return newValue;
    }

    @Override
    public Sequence<? extends T> replaceSlice(int startPos, int endPos, Sequence<? extends T> newValues) {
        this.ensureNotBound();
        SequenceMutator.replaceSlice(this.$value, this.mutationListener, startPos, endPos, newValues);
        return newValues;
    }

    @Override
    public void delete(int position) {
        this.ensureNotBound();
        SequenceMutator.delete(this.$value, this.mutationListener, position);
    }

    @Override
    public void deleteSlice(int startPos, int endPos) {
        this.replaceSlice(startPos, endPos, null);
    }

    @Override
    public void delete(SequencePredicate<T> sequencePredicate) {
        this.ensureNotBound();
        SequenceMutator.delete(this.$value, this.mutationListener, sequencePredicate);
    }

    @Override
    public void deleteAll() {
        this.ensureNotBound();
        this.setAsSequence(Sequences.emptySequence(this.clazz));
    }

    @Override
    public void deleteValue(final T targetValue) {
        this.ensureNotBound();
        this.delete(new SequencePredicate<T>(){

            @Override
            public boolean matches(Sequence<? extends T> sequence, int index, T value) {
                if (value == null) {
                    return targetValue == null;
                }
                return value.equals(targetValue);
            }
        });
    }

    @Override
    public void insert(T value) {
        this.ensureNotBound();
        SequenceMutator.insert(this.$value, this.mutationListener, value);
    }

    @Override
    public void insert(Sequence<? extends T> values) {
        this.ensureNotBound();
        SequenceMutator.insert(this.$value, this.mutationListener, values);
    }

    @Override
    public void insertFirst(T value) {
        this.ensureNotBound();
        SequenceMutator.insertFirst(this.$value, this.mutationListener, value);
    }

    @Override
    public void insertFirst(Sequence<? extends T> values) {
        this.ensureNotBound();
        SequenceMutator.insertFirst(this.$value, this.mutationListener, values);
    }

    @Override
    public void insertBefore(T value, int position) {
        this.ensureNotBound();
        SequenceMutator.insertBefore(this.$value, this.mutationListener, value, position);
    }

    @Override
    public void insertBefore(T value, SequencePredicate<T> sequencePredicate) {
        this.ensureNotBound();
        SequenceMutator.insertBefore(this.$value, this.mutationListener, value, sequencePredicate);
    }

    @Override
    public void insertBefore(Sequence<? extends T> values, int position) {
        this.ensureNotBound();
        SequenceMutator.insertBefore(this.$value, this.mutationListener, values, position);
    }

    @Override
    public void insertBefore(Sequence<? extends T> values, SequencePredicate<T> sequencePredicate) {
        this.ensureNotBound();
        SequenceMutator.insertBefore(this.$value, this.mutationListener, values, sequencePredicate);
    }

    @Override
    public void insertAfter(T value, int position) {
        this.ensureNotBound();
        SequenceMutator.insertAfter(this.$value, this.mutationListener, value, position);
    }

    @Override
    public void insertAfter(T value, SequencePredicate<T> sequencePredicate) {
        this.ensureNotBound();
        SequenceMutator.insertAfter(this.$value, this.mutationListener, value, sequencePredicate);
    }

    @Override
    public void insertAfter(Sequence<? extends T> values, int position) {
        this.ensureNotBound();
        SequenceMutator.insertAfter(this.$value, this.mutationListener, values, position);
    }

    @Override
    public void insertAfter(Sequence<? extends T> values, SequencePredicate<T> sequencePredicate) {
        this.ensureNotBound();
        SequenceMutator.insertAfter(this.$value, this.mutationListener, values, sequencePredicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BoundLocationInfo {
        public final SequenceLocation<T> otherLocation;
        public ChangeListener changeListener;
        public SequenceChangeListener<T> sequenceChangeListener;

        BoundLocationInfo(SequenceLocation<T> otherLocation) {
            this.otherLocation = otherLocation;
        }

        void bind() {
            this.changeListener = new ChangeListener(){

                public boolean onChange() {
                    SequenceVariable.this.invalidateDependencies();
                    return true;
                }
            };
            this.sequenceChangeListener = new SequenceChangeListener<T>(){

                @Override
                public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                    SequenceVariable.this.$value = newValue;
                    SequenceVariable.this.notifyListeners(startPos, endPos, newElements, oldValue, newValue, false);
                }
            };
            this.otherLocation.addChangeListener(this.changeListener);
            this.otherLocation.addChangeListener(this.sequenceChangeListener);
        }

        void unbind() {
            this.otherLocation.removeChangeListener(this.changeListener);
            this.otherLocation.removeChangeListener(this.sequenceChangeListener);
            this.changeListener = null;
            this.sequenceChangeListener = null;
        }
    }
}

