/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.location.AbstractLocation;
import com.sun.javafx.runtime.location.ObjectChangeListener;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBoundSequence<T>
extends AbstractLocation
implements SequenceLocation<T> {
    private final Class<T> clazz;
    private List<SequenceChangeListener<T>> changeListeners;
    private Sequence<T> value;

    protected AbstractBoundSequence(Class<T> clazz) {
        this.clazz = clazz;
        this.value = Sequences.emptySequence(clazz);
    }

    protected void setInitialValue(Sequence<T> initialValue) {
        if (this.isValid()) {
            throw new IllegalStateException("Cannot call setInitialValue more than once");
        }
        Sequence<T> oldValue = this.value;
        Sequence<T> newValue = initialValue;
        if (newValue == null) {
            newValue = Sequences.emptySequence(this.clazz);
        }
        this.value = newValue;
        this.setValid();
        if (!Sequences.isEqual(oldValue, newValue)) {
            this.invalidateDependencies();
            this.notifyListeners(0, Sequences.size(oldValue) - 1, newValue, oldValue, newValue);
        }
    }

    protected void updateSlice(int startPos, int endPos, Sequence<? extends T> newValues) {
        Sequence<T> oldValue = this.value;
        this.value = Sequences.replaceSlice(oldValue, startPos, endPos, newValues);
        this.invalidateDependencies();
        this.notifyListeners(startPos, endPos, newValues, oldValue, this.value);
    }

    protected void updateSlice(int startPos, int endPos, Sequence<? extends T> newValues, Sequence<T> newSequence) {
        Sequence<T> oldValue = this.value;
        this.value = newSequence;
        this.invalidateDependencies();
        this.notifyListeners(startPos, endPos, newValues, oldValue, newSequence);
    }

    protected Sequence<T> getRawValue() {
        return this.value;
    }

    protected Class<T> getClazz() {
        return this.clazz;
    }

    @Override
    public Sequence<T> get() {
        return this.getAsSequence();
    }

    @Override
    public T get(int position) {
        return this.getAsSequence().get(position);
    }

    @Override
    public Sequence<T> getAsSequence() {
        assert (this.isValid());
        return this.value;
    }

    @Override
    public Class<T> getElementType() {
        return this.clazz;
    }

    @Override
    public Sequence<T> getSlice(int startPos, int endPos) {
        return this.getAsSequence().getSlice(startPos, endPos);
    }

    @Override
    public boolean isNull() {
        return Sequences.size(this.getAsSequence()) == 0;
    }

    @Override
    public void addChangeListener(final ObjectChangeListener<Sequence<T>> listener) {
        this.addChangeListener(new SequenceChangeListener<T>(){

            @Override
            public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                listener.onChange(oldValue, newValue);
            }
        });
    }

    @Override
    public void addChangeListener(SequenceChangeListener<T> listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList<SequenceChangeListener<T>>();
        }
        this.changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(SequenceChangeListener<T> listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    private void notifyListeners(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
        if (this.changeListeners != null) {
            for (SequenceChangeListener<? extends T> sequenceChangeListener : this.changeListeners) {
                sequenceChangeListener.onChange(startPos, endPos, newElements, oldValue, newValue);
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.getAsSequence().iterator();
    }

    public String toString() {
        return this.getAsSequence().toString();
    }

    @Override
    public void invalidate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefault() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int position, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<T> set(Sequence<T> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<T> setFromLiteral(Sequence<T> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<T> setAsSequence(Sequence<? extends T> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<T> setAsSequenceFromLiteral(Sequence<? extends T> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<? extends T> replaceSlice(int startPos, int endPos, Sequence<? extends T> newValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteSlice(int startPos, int endPos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteValue(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(SequencePredicate<T> sequencePredicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(Sequence<? extends T> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertFirst(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertFirst(Sequence<? extends T> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertBefore(T value, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertBefore(T value, SequencePredicate<T> sequencePredicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertBefore(Sequence<? extends T> values, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertBefore(Sequence<? extends T> values, SequencePredicate<T> sequencePredicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertAfter(T value, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertAfter(T value, SequencePredicate<T> sequencePredicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertAfter(Sequence<? extends T> values, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertAfter(Sequence<? extends T> values, SequencePredicate<T> sequencePredicate) {
        throw new UnsupportedOperationException();
    }
}

