/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.BitSet;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence<T>
implements Sequence<T>,
Formattable {
    protected final TypeInfo<T> ti;

    protected AbstractSequence(TypeInfo<T> ti) {
        this.ti = ti;
    }

    @Override
    public abstract int size();

    @Override
    public abstract T get(int var1);

    @Override
    public Sequence<T> getSlice(int startPos, int endPos) {
        return Sequences.subsequence(this, startPos, endPos + 1);
    }

    @Override
    public BitSet getBits(SequencePredicate<? super T> predicate) {
        int length = this.size();
        BitSet bits = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            if (!predicate.matches(this, i, this.get(i))) continue;
            bits.set(i);
        }
        return bits;
    }

    @Override
    public TypeInfo<T> getElementType() {
        return this.ti;
    }

    @Override
    public T getDefaultValue() {
        return this.ti.defaultValue;
    }

    @Override
    public Sequence<T> getEmptySequence() {
        return this.ti.emptySequence;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.get(i + sourceOffset);
        }
    }

    @Override
    public Sequence<T> get(SequencePredicate<? super T> predicate) {
        return Sequences.filter(this, this.getBits(predicate));
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int next = 0;
            private final int length = AbstractSequence.this.size();

            @Override
            public boolean hasNext() {
                return this.next < this.length;
            }

            @Override
            public T next() {
                if (this.next >= this.length) {
                    throw new NoSuchElementException();
                }
                return AbstractSequence.this.get(this.next++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof Sequence && Sequences.isEqual(this, (Sequence)obj);
    }

    public int hashCode() {
        int hash = 0;
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            T val = this.get(i);
            hash = 31 * hash + (val != null ? val.hashCode() : 0);
        }
        return hash;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[ ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.get(i));
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            formatter.format("%s", this.get(i));
        }
    }
}

