/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArraySequence<T>
extends AbstractSequence<T>
implements Sequence<T> {
    private final T[] array;

    public ArraySequence(TypeInfo<T> ti, T ... values) {
        this(ti, values, false);
    }

    public ArraySequence(TypeInfo<T> ti, T[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = Util.newObjectArray(values.length);
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.checkForNulls();
    }

    public ArraySequence(TypeInfo<T> ti, T[] values, int size) {
        super(ti);
        this.array = Util.newObjectArray(size);
        System.arraycopy(values, 0, this.array, 0, size);
        this.checkForNulls();
    }

    public ArraySequence(TypeInfo<T> ti, List<? extends T> values) {
        super(ti);
        this.array = values.toArray();
        this.checkForNulls();
    }

    /*
     * WARNING - void declaration
     */
    public ArraySequence(TypeInfo<T> ti, Sequence<? extends T> ... sequences) {
        super(ti);
        void var7_11;
        int size = 0;
        for (Sequence<T> sequence : sequences) {
            size += sequence.size();
        }
        this.array = Util.newObjectArray(size);
        int next = 0;
        Sequence<? extends T>[] arr$ = sequences;
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_11 < len$) {
            Sequence<T> sequence = arr$[var7_11];
            int l = sequence.size();
            sequence.toArray(0, l, this.array, next);
            next += l;
            ++var7_11;
        }
    }

    private void checkForNulls() {
        for (T v : this.array) {
            if (v != null) continue;
            throw new IllegalArgumentException("cannot create sequence with null values");
        }
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public T get(int position) {
        if (position < 0 || position >= this.array.length) {
            return this.getDefaultValue();
        }
        return this.array[position];
    }

    @Override
    public BitSet getBits(SequencePredicate<? super T> predicate) {
        BitSet bits = new BitSet(this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            if (!predicate.matches(this, i, this.array[i])) continue;
            bits.set(i);
        }
        return bits;
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < ArraySequence.this.array.length;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return ArraySequence.this.array[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

