/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundCompositeSequence<T>
extends AbstractBoundSequence<T>
implements SequenceLocation<T> {
    private Info<T>[] infos;

    public BoundCompositeSequence(Class<T> clazz, SequenceLocation<? extends T> ... locations) {
        this(clazz, locations, locations.length);
    }

    public BoundCompositeSequence(Class<T> clazz, SequenceLocation<? extends T>[] locations, int size) {
        super(clazz);
        this.infos = this.newInfoArray(size);
        for (int i = 0; i < size; ++i) {
            this.infos[i] = new Info<T>(locations[i]);
        }
        this.setInitialValue(this.computeValue());
        this.addTriggers();
    }

    private Info<T>[] newInfoArray(int len) {
        return new Info[len];
    }

    private Sequence<T> computeValue() {
        Sequence<T>[] sequences = Util.newSequenceArray(this.infos.length);
        int offset = 0;
        for (int i = 0; i < this.infos.length; ++i) {
            sequences[i] = ((Info)this.infos[i]).location.getAsSequence();
            ((Info)this.infos[i]).startPosition = offset;
            ((Info)this.infos[i]).size = sequences[i].size();
            offset += sequences[i].size();
        }
        return Sequences.concatenate(TypeInfo.getTypeInfo(this.getClazz()), sequences);
    }

    private void addTriggers() {
        for (int i = 0; i < this.infos.length; ++i) {
            this.infos[i].addListener(new MyListener(i));
        }
    }

    public void replaceSlice(int startPos, int endPos, SequenceLocation<? extends T>[] newValues) {
        int i;
        int affectedEnd;
        int affectedStart;
        Info<T>[] newInfos = this.newInfoArray(newValues.length);
        Sequence<T>[] sequences = Util.newSequenceArray(newValues.length);
        if (startPos < this.infos.length) {
            affectedStart = ((Info)this.infos[startPos]).startPosition;
            affectedEnd = endPos >= 0 ? ((Info)this.infos[endPos]).startPosition + ((Info)this.infos[endPos]).size - 1 : affectedStart - 1;
        } else {
            affectedStart = this.getRawValue().size();
            affectedEnd = affectedStart - 1;
        }
        int offset = affectedStart;
        for (int i2 = 0; i2 < newInfos.length; ++i2) {
            newInfos[i2] = new Info<T>(newValues[i2]);
            sequences[i2] = ((Info)newInfos[i2]).location.getAsSequence();
            ((Info)newInfos[i2]).startPosition = offset;
            ((Info)newInfos[i2]).size = sequences[i2].size();
            offset += sequences[i2].size();
            newInfos[i2].addListener(new MyListener(i2 + startPos));
        }
        Sequence newSlice = Sequences.concatenate(TypeInfo.getTypeInfo(this.getClazz()), sequences);
        int deltaElements = newSlice.size() - (affectedEnd - affectedStart + 1);
        int deltaLocations = newValues.length - (endPos - startPos + 1);
        for (i = endPos + 1; i < this.infos.length; ++i) {
            ((Info)this.infos[i]).startPosition += deltaElements;
            ((Info)this.infos[i]).listener.setIndex(i + deltaLocations);
        }
        for (i = startPos; i <= endPos; ++i) {
            this.infos[i].removeListener();
        }
        this.infos = this.replaceSlice(this.infos, startPos, endPos, newInfos);
        this.updateSlice(affectedStart, affectedEnd, newSlice);
    }

    private Info<T>[] replaceSlice(Info<T>[] array, int startPos, int endPos, Info<T>[] newElements) {
        int insertedCount = newElements.length;
        int deletedCount = endPos - startPos + 1;
        int netAdded = insertedCount - deletedCount;
        if (netAdded == 0) {
            System.arraycopy(newElements, 0, array, startPos, insertedCount);
            return array;
        }
        Info[] temp = new Info[array.length + netAdded];
        System.arraycopy(array, 0, temp, 0, startPos);
        System.arraycopy(newElements, 0, temp, startPos, insertedCount);
        System.arraycopy(array, endPos + 1, temp, startPos + insertedCount, array.length - (endPos + 1));
        return temp;
    }

    public void validate() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListener<V extends T>
    extends IndexListener<V> {
        private int index;

        private MyListener(int index) {
            this.index = index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public void onChange(int startPos, int endPos, Sequence<? extends V> newElements, Sequence<V> oldValue, Sequence<V> newValue) {
            int actualStart = BoundCompositeSequence.this.infos[this.index].startPosition + startPos;
            int actualEnd = BoundCompositeSequence.this.infos[this.index].startPosition + endPos;
            BoundCompositeSequence.this.infos[this.index].size = newValue.size();
            int delta = Sequences.size(newElements) - (endPos - startPos + 1);
            if (delta != 0) {
                for (int i = this.index + 1; i < BoundCompositeSequence.this.infos.length; ++i) {
                    BoundCompositeSequence.this.infos[i].startPosition += delta;
                }
            }
            BoundCompositeSequence.this.updateSlice(actualStart, actualEnd, newElements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IndexListener<T>
    extends SequenceChangeListener<T> {
        private IndexListener() {
        }

        public abstract void setIndex(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Info<T> {
        private final SequenceLocation<? extends T> location;
        private int startPosition;
        private int size;
        private IndexListener listener;

        public Info(SequenceLocation<? extends T> location) {
            this.location = location;
        }

        public void addListener(IndexListener<T> listener) {
            this.listener = listener;
            this.location.addChangeListener(this.listener);
        }

        public void removeListener() {
            this.location.removeChangeListener(this.listener);
            this.listener = null;
        }
    }
}

