/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.location.IntChangeListener;
import com.sun.javafx.runtime.location.IntConstant;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundIntRangeSequence
extends AbstractBoundSequence<Integer>
implements SequenceLocation<Integer> {
    private final IntLocation lowerLoc;
    private final IntLocation upperLoc;
    private final IntLocation stepLoc;
    private final boolean exclusive;
    private int lower;
    private int upper;
    private int size;
    private int step;

    public BoundIntRangeSequence(IntLocation lowerLoc, IntLocation upperLoc) {
        this(lowerLoc, upperLoc, IntConstant.make(1), false);
    }

    public BoundIntRangeSequence(IntLocation lowerLoc, IntLocation upperLoc, IntLocation stepLoc) {
        this(lowerLoc, upperLoc, stepLoc, false);
    }

    public BoundIntRangeSequence(IntLocation lowerLoc, IntLocation upperLoc, boolean exclusive) {
        this(lowerLoc, upperLoc, IntConstant.make(1), exclusive);
    }

    public BoundIntRangeSequence(IntLocation lowerLoc, IntLocation upperLoc, IntLocation stepLoc, boolean exclusive) {
        super(Integer.class);
        this.lowerLoc = lowerLoc;
        this.upperLoc = upperLoc;
        this.stepLoc = stepLoc;
        this.exclusive = exclusive;
        this.setInitialValue(this.computeValue());
        this.addTriggers();
    }

    private Sequence<Integer> computeValue() {
        this.computeBounds((Integer)this.lowerLoc.get(), (Integer)this.upperLoc.get(), (Integer)this.stepLoc.get());
        return this.computeFull(this.lower, this.upper, this.step);
    }

    private Sequence<Integer> computeFull(int lower, int upper, int step) {
        return this.exclusive ? Sequences.rangeExclusive(lower, upper, step) : Sequences.range(lower, upper, step);
    }

    private void computeBounds(int newLower, int newUpper, int newStep) {
        this.lower = newLower;
        this.upper = newUpper;
        this.step = newStep;
        if (Math.abs((long)newLower - (long)newUpper) + (long)(this.exclusive ? 0 : 1) / (long)this.step > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range sequence too big");
        }
        if (this.lower == this.upper) {
            this.size = this.exclusive ? 0 : 1;
        } else {
            this.size = Math.max(0, (this.upper - this.lower) / this.step + 1);
            if (this.exclusive) {
                boolean tooBig;
                boolean bl = this.step > 0 ? this.lower + (this.size - 1) * this.step >= this.upper : (tooBig = this.lower + (this.size - 1) * this.step <= this.upper);
                if (tooBig && this.size > 0) {
                    --this.size;
                }
            }
        }
    }

    private void addTriggers() {
        this.lowerLoc.addChangeListener(new IntChangeListener(){

            public void onChange(int oldValue, int newValue) {
                assert (oldValue != newValue);
                int oldSize = BoundIntRangeSequence.this.size;
                BoundIntRangeSequence.this.computeBounds(newValue, BoundIntRangeSequence.this.upper, BoundIntRangeSequence.this.step);
                if (oldSize == 0) {
                    BoundIntRangeSequence.this.updateSlice(0, -1, BoundIntRangeSequence.this.computeFull(BoundIntRangeSequence.this.lower, BoundIntRangeSequence.this.upper, BoundIntRangeSequence.this.step));
                } else if (oldSize < BoundIntRangeSequence.this.size) {
                    if ((newValue - oldValue) % BoundIntRangeSequence.this.step == 0) {
                        BoundIntRangeSequence.this.updateSlice(0, -1, Sequences.rangeExclusive(BoundIntRangeSequence.this.lower, oldValue, BoundIntRangeSequence.this.step));
                    } else {
                        Sequence newElements = BoundIntRangeSequence.this.computeFull(BoundIntRangeSequence.this.lower, BoundIntRangeSequence.this.upper, BoundIntRangeSequence.this.step);
                        BoundIntRangeSequence.this.updateSlice(0, newElements.isEmpty() ? 0 : BoundIntRangeSequence.this.size - 1, newElements, newElements);
                    }
                } else if (oldSize >= BoundIntRangeSequence.this.size) {
                    if ((newValue - oldValue) % BoundIntRangeSequence.this.step == 0) {
                        BoundIntRangeSequence.this.updateSlice(0, oldSize - BoundIntRangeSequence.this.size - 1, TypeInfo.Integer.emptySequence);
                    } else {
                        Sequence newElements = BoundIntRangeSequence.this.computeFull(BoundIntRangeSequence.this.lower, BoundIntRangeSequence.this.upper, BoundIntRangeSequence.this.step);
                        BoundIntRangeSequence.this.updateSlice(0, newElements.isEmpty() ? 0 : BoundIntRangeSequence.this.size - 1, newElements, newElements);
                    }
                }
            }
        });
        this.upperLoc.addChangeListener(new IntChangeListener(){

            public void onChange(int oldValue, int newValue) {
                assert (oldValue != newValue);
                int oldSize = BoundIntRangeSequence.this.size;
                BoundIntRangeSequence.this.computeBounds(BoundIntRangeSequence.this.lower, newValue, BoundIntRangeSequence.this.step);
                if (BoundIntRangeSequence.this.size == oldSize) {
                    return;
                }
                if (oldSize == 0) {
                    BoundIntRangeSequence.this.updateSlice(0, -1, BoundIntRangeSequence.this.computeFull(BoundIntRangeSequence.this.lower, BoundIntRangeSequence.this.upper, BoundIntRangeSequence.this.step));
                } else if (oldSize < BoundIntRangeSequence.this.size) {
                    int startPos = BoundIntRangeSequence.this.lower + oldSize * BoundIntRangeSequence.this.step;
                    BoundIntRangeSequence.this.updateSlice(oldSize, oldSize - 1, BoundIntRangeSequence.this.computeFull(startPos, BoundIntRangeSequence.this.upper, BoundIntRangeSequence.this.step));
                } else if (oldSize > BoundIntRangeSequence.this.size) {
                    BoundIntRangeSequence.this.updateSlice(BoundIntRangeSequence.this.size, oldSize - 1, TypeInfo.Integer.emptySequence);
                }
            }
        });
        this.stepLoc.addChangeListener(new IntChangeListener(){

            public void onChange(int oldValue, int newValue) {
                assert (oldValue != newValue);
                int oldSize = BoundIntRangeSequence.this.size;
                BoundIntRangeSequence.this.computeBounds(BoundIntRangeSequence.this.lower, BoundIntRangeSequence.this.upper, newValue);
                Sequence newSeq = BoundIntRangeSequence.this.computeFull(BoundIntRangeSequence.this.lower, BoundIntRangeSequence.this.upper, BoundIntRangeSequence.this.step);
                BoundIntRangeSequence.this.updateSlice(0, oldSize - 1, newSeq, newSeq);
            }
        });
    }
}

