/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.location.DoubleChangeListener;
import com.sun.javafx.runtime.location.DoubleConstant;
import com.sun.javafx.runtime.location.DoubleLocation;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundNumberRangeSequence
extends AbstractBoundSequence<Double>
implements SequenceLocation<Double> {
    private final DoubleLocation lowerLoc;
    private final DoubleLocation upperLoc;
    private final DoubleLocation stepLoc;
    private final boolean exclusive;
    private double lower;
    private double upper;
    private double step;
    private int size;

    public BoundNumberRangeSequence(DoubleLocation lowerLoc, DoubleLocation upperLoc) {
        this(lowerLoc, upperLoc, DoubleConstant.make(1.0), false);
    }

    public BoundNumberRangeSequence(DoubleLocation lowerLoc, DoubleLocation upperLoc, DoubleLocation stepLoc) {
        this(lowerLoc, upperLoc, stepLoc, false);
    }

    public BoundNumberRangeSequence(DoubleLocation lowerLoc, DoubleLocation upperLoc, boolean exclusive) {
        this(lowerLoc, upperLoc, DoubleConstant.make(1.0), exclusive);
    }

    public BoundNumberRangeSequence(DoubleLocation lowerLoc, DoubleLocation upperLoc, DoubleLocation stepLoc, boolean exclusive) {
        super(Double.class);
        this.lowerLoc = lowerLoc;
        this.upperLoc = upperLoc;
        this.stepLoc = stepLoc;
        this.exclusive = exclusive;
        this.setInitialValue(this.computeValue());
        this.addTriggers();
    }

    private Sequence<Double> computeValue() {
        this.computeBounds((Double)this.lowerLoc.get(), (Double)this.upperLoc.get(), (Double)this.stepLoc.get());
        return this.computeFull(this.lower, this.upper, this.step);
    }

    private Sequence<Double> computeFull(double lower, double upper, double step) {
        return this.exclusive ? Sequences.rangeExclusive(lower, upper, step) : Sequences.range(lower, upper, step);
    }

    private void computeBounds(double newLower, double newUpper, double newStep) {
        this.lower = newLower;
        this.upper = newUpper;
        this.step = newStep;
        if (this.lower == this.upper) {
            this.size = this.exclusive ? 0 : 1;
        } else {
            long size = Math.max(0L, (long)((this.upper - this.lower) / this.step) + 1L);
            if (this.exclusive) {
                boolean tooBig;
                boolean bl = this.step > 0.0 ? this.lower + (double)(size - 1L) * this.step >= this.upper : (tooBig = this.lower + (double)(size - 1L) * this.step <= this.upper);
                if (tooBig && size > 0L) {
                    --size;
                }
            }
            if (size > Integer.MAX_VALUE || size < 0L) {
                throw new IllegalArgumentException("Range sequence too big");
            }
            this.size = (int)size;
        }
    }

    private void addTriggers() {
        this.lowerLoc.addChangeListener(new DoubleChangeListener(){

            public void onChange(double oldValue, double newValue) {
                assert (oldValue != newValue);
                int oldSize = BoundNumberRangeSequence.this.size;
                BoundNumberRangeSequence.this.computeBounds(newValue, BoundNumberRangeSequence.this.upper, BoundNumberRangeSequence.this.step);
                if (oldSize == 0) {
                    BoundNumberRangeSequence.this.updateSlice(0, -1, BoundNumberRangeSequence.this.computeFull(BoundNumberRangeSequence.this.lower, BoundNumberRangeSequence.this.upper, BoundNumberRangeSequence.this.step));
                } else if (oldSize < BoundNumberRangeSequence.this.size) {
                    if ((newValue - oldValue) % BoundNumberRangeSequence.this.step == 0.0) {
                        BoundNumberRangeSequence.this.updateSlice(0, -1, Sequences.rangeExclusive(BoundNumberRangeSequence.this.lower, oldValue, BoundNumberRangeSequence.this.step));
                    } else {
                        Sequence newElements = BoundNumberRangeSequence.this.computeFull(BoundNumberRangeSequence.this.lower, BoundNumberRangeSequence.this.upper, BoundNumberRangeSequence.this.step);
                        BoundNumberRangeSequence.this.updateSlice(0, newElements.isEmpty() ? 0 : BoundNumberRangeSequence.this.size - 1, newElements, newElements);
                    }
                } else if (oldSize >= BoundNumberRangeSequence.this.size) {
                    if ((newValue - oldValue) % BoundNumberRangeSequence.this.step == 0.0) {
                        BoundNumberRangeSequence.this.updateSlice(0, oldSize - BoundNumberRangeSequence.this.size - 1, TypeInfo.Double.emptySequence);
                    } else {
                        Sequence newElements = BoundNumberRangeSequence.this.computeFull(BoundNumberRangeSequence.this.lower, BoundNumberRangeSequence.this.upper, BoundNumberRangeSequence.this.step);
                        BoundNumberRangeSequence.this.updateSlice(0, newElements.isEmpty() ? 0 : BoundNumberRangeSequence.this.size - 1, newElements, newElements);
                    }
                }
            }
        });
        this.upperLoc.addChangeListener(new DoubleChangeListener(){

            public void onChange(double oldValue, double newValue) {
                assert (oldValue != newValue);
                int oldSize = BoundNumberRangeSequence.this.size;
                BoundNumberRangeSequence.this.computeBounds(BoundNumberRangeSequence.this.lower, newValue, BoundNumberRangeSequence.this.step);
                if (BoundNumberRangeSequence.this.size == oldSize) {
                    return;
                }
                if (oldSize == 0) {
                    BoundNumberRangeSequence.this.updateSlice(0, -1, BoundNumberRangeSequence.this.computeFull(BoundNumberRangeSequence.this.lower, BoundNumberRangeSequence.this.upper, BoundNumberRangeSequence.this.step));
                } else if (oldSize < BoundNumberRangeSequence.this.size) {
                    BoundNumberRangeSequence.this.updateSlice(oldSize, oldSize - 1, BoundNumberRangeSequence.this.computeFull(BoundNumberRangeSequence.this.lower + (double)oldSize * BoundNumberRangeSequence.this.step, BoundNumberRangeSequence.this.upper, BoundNumberRangeSequence.this.step));
                } else if (oldSize > BoundNumberRangeSequence.this.size) {
                    BoundNumberRangeSequence.this.updateSlice(BoundNumberRangeSequence.this.size, oldSize - 1, TypeInfo.Double.emptySequence);
                }
            }
        });
        this.stepLoc.addChangeListener(new DoubleChangeListener(){

            public void onChange(double oldValue, double newValue) {
                assert (oldValue != newValue);
                int oldSize = BoundNumberRangeSequence.this.size;
                BoundNumberRangeSequence.this.computeBounds(BoundNumberRangeSequence.this.lower, BoundNumberRangeSequence.this.upper, newValue);
                Sequence newSeq = BoundNumberRangeSequence.this.computeFull(BoundNumberRangeSequence.this.lower, BoundNumberRangeSequence.this.upper, BoundNumberRangeSequence.this.step);
                BoundNumberRangeSequence.this.updateSlice(0, oldSize - 1, newSeq, newSeq);
            }
        });
    }
}

