/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BoundReverseSequence<T>
extends AbstractBoundSequence<T>
implements SequenceLocation<T> {
    private final SequenceLocation<T> location;

    BoundReverseSequence(SequenceLocation<T> location) {
        super(location.getElementType());
        this.location = location;
        this.setInitialValue(this.computeValue());
        this.addTriggers();
    }

    private Sequence<T> computeValue() {
        return Sequences.reverse(this.location.getAsSequence());
    }

    private void addTriggers() {
        this.location.addChangeListener(new SequenceChangeListener<T>(){

            @Override
            public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                int sliceSize = endPos - startPos;
                int actualStart = oldValue.size() - startPos - (sliceSize + 1);
                int actualEnd = actualStart + sliceSize;
                Sequence reverseElements = newElements == null ? null : Sequences.reverse(newElements);
                BoundReverseSequence.this.updateSlice(actualStart, actualEnd, reverseElements);
            }
        });
    }
}

