/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.BoundSequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundSequenceBuilder<T> {
    private static final int DEFAULT_SIZE = 8;
    private final Class<T> clazz;
    private SequenceLocation<? extends T>[] array;
    private int size;

    public BoundSequenceBuilder(Class<T> clazz) {
        this(clazz, 8);
    }

    public BoundSequenceBuilder(Class<T> clazz, int initialSize) {
        this.clazz = clazz;
        this.array = Util.newSequenceLocationArray(Util.powerOfTwo(1, initialSize));
    }

    private void ensureSize(int newSize) {
        if (this.array.length < newSize) {
            int newCapacity = Util.powerOfTwo(this.array.length, newSize);
            SequenceLocation<T>[] newArray = Util.newSequenceLocationArray(newCapacity);
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public int size() {
        return this.size;
    }

    public void add(SequenceLocation<? extends T> seq) {
        this.ensureSize(this.size + 1);
        this.array[this.size++] = seq;
    }

    public void add(ObjectLocation<? extends T> singleton) {
        this.add(BoundSequences.singleton(this.clazz, singleton));
    }

    public void clear() {
        this.array = (SequenceLocation[])Util.newObjectArray(Util.powerOfTwo(1, 8));
        this.size = 0;
    }

    public SequenceLocation<T> toSequence() {
        return BoundSequences.concatenate(this.clazz, this.array, this.size);
    }
}

