/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.ObjectBindingExpression;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.ObjectVariable;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BoundSequenceElement<T>
extends ObjectVariable<T>
implements ObjectLocation<T> {
    private final SequenceLocation<T> seq;
    private final IntLocation index;
    private int lastIndex;

    public BoundSequenceElement(SequenceLocation<T> seq, IntLocation index) {
        this.seq = seq;
        this.index = index;
        this.lastIndex = (Integer)index.get();
        this.bind(false, new ObjectBindingExpression<T>(){

            @Override
            public T computeValue() {
                BoundSequenceElement.this.lastIndex = (Integer)BoundSequenceElement.this.index.get();
                return BoundSequenceElement.this.seq.getAsSequence().get(BoundSequenceElement.this.lastIndex);
            }
        }, index);
        seq.addChangeListener(new MySequenceListener());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MySequenceListener
    extends SequenceChangeListener<T> {
        private MySequenceListener() {
        }

        @Override
        public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
            int deltaSize = endPos - startPos + 1 - Sequences.size(newElements);
            if (deltaSize != 0) {
                if (startPos <= BoundSequenceElement.this.lastIndex) {
                    BoundSequenceElement.this.invalidate();
                }
            } else if (startPos <= BoundSequenceElement.this.lastIndex && BoundSequenceElement.this.lastIndex <= endPos) {
                BoundSequenceElement.this.invalidate();
            }
        }
    }
}

