/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.location.BooleanLocation;
import com.sun.javafx.runtime.location.BooleanVariable;
import com.sun.javafx.runtime.location.DoubleLocation;
import com.sun.javafx.runtime.location.DoubleVariable;
import com.sun.javafx.runtime.location.IntBindingExpression;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.IntVariable;
import com.sun.javafx.runtime.location.Locations;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.ObjectVariable;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundComprehension;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.BoundCompositeSequence;
import com.sun.javafx.runtime.sequence.BoundIntRangeSequence;
import com.sun.javafx.runtime.sequence.BoundNumberRangeSequence;
import com.sun.javafx.runtime.sequence.BoundReverseSequence;
import com.sun.javafx.runtime.sequence.BoundSequenceElement;
import com.sun.javafx.runtime.sequence.BoundSequenceSlice;
import com.sun.javafx.runtime.sequence.BoundSingletonSequence;
import com.sun.javafx.runtime.sequence.BoundUpcastSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.javafx.runtime.sequence.SimpleBoundComprehension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BoundSequences {
    public static <T> SequenceLocation<T> concatenate(Class<T> clazz, SequenceLocation<? extends T> ... locations) {
        return new BoundCompositeSequence<T>(clazz, locations);
    }

    public static <T> SequenceLocation<T> concatenate(Class<T> clazz, SequenceLocation<? extends T>[] locations, int size) {
        return new BoundCompositeSequence<T>(clazz, locations, size);
    }

    public static <T, V extends T> SequenceLocation<T> upcast(Class<T> clazz, SequenceLocation<V> location) {
        Class<V> vClass = location.getElementType();
        if (clazz == vClass) {
            return location;
        }
        return new BoundUpcastSequence<T, V>(clazz, location);
    }

    public static <T> SequenceLocation<T> reverse(SequenceLocation<T> sequence) {
        return new BoundReverseSequence<T>(sequence);
    }

    public static <T, V extends T> SequenceLocation<T> singleton(Class<T> clazz, ObjectLocation<V> location) {
        return new BoundSingletonSequence<T, V>(clazz, location);
    }

    public static <T> SequenceLocation<Integer> singleton(IntLocation location) {
        return new BoundSingletonSequence<Integer, Integer>(Integer.class, location);
    }

    public static <T> SequenceLocation<T> empty(final Class<T> clazz) {
        return new AbstractBoundSequence<T>(clazz){
            {
                super(x0);
                this.setInitialValue(Sequences.emptySequence(clazz));
            }
        };
    }

    public static <T> ObjectLocation<T> element(SequenceLocation<T> sequence, IntLocation index) {
        return new BoundSequenceElement<T>(sequence, index);
    }

    public static IntLocation element(SequenceLocation<Integer> sequence, IntLocation index) {
        return Locations.asIntLocation(new BoundSequenceElement<Integer>(sequence, index));
    }

    public static DoubleLocation element(SequenceLocation<Double> sequence, IntLocation index) {
        return Locations.asDoubleLocation(new BoundSequenceElement<Double>(sequence, index));
    }

    public static BooleanLocation element(SequenceLocation<Boolean> sequence, IntLocation index) {
        return Locations.asBooleanLocation(new BoundSequenceElement<Boolean>(sequence, index));
    }

    public static <T> IntLocation sizeof(final SequenceLocation<T> sequence) {
        return IntVariable.make(new IntBindingExpression(){

            public int computeValue() {
                return Sequences.size((Sequence)sequence.get());
            }
        }, sequence);
    }

    public static <T> IntLocation sizeof(final ObjectLocation<T> item) {
        return IntVariable.make(new IntBindingExpression(){

            public int computeValue() {
                return item.get() == null ? 0 : 1;
            }
        }, item);
    }

    public static SequenceLocation<Integer> range(IntLocation a, IntLocation b) {
        return new BoundIntRangeSequence(a, b);
    }

    public static SequenceLocation<Integer> range(IntLocation a, IntLocation b, IntLocation step) {
        return new BoundIntRangeSequence(a, b, step);
    }

    public static SequenceLocation<Integer> range(IntLocation a, IntLocation b, boolean exclusive) {
        return new BoundIntRangeSequence(a, b, exclusive);
    }

    public static SequenceLocation<Integer> range(IntLocation a, IntLocation b, IntLocation step, boolean exclusive) {
        return new BoundIntRangeSequence(a, b, step, exclusive);
    }

    public static SequenceLocation<Double> range(DoubleLocation a, DoubleLocation b) {
        return new BoundNumberRangeSequence(a, b);
    }

    public static SequenceLocation<Double> range(DoubleLocation a, DoubleLocation b, DoubleLocation step) {
        return new BoundNumberRangeSequence(a, b, step);
    }

    public static SequenceLocation<Double> range(DoubleLocation a, DoubleLocation b, boolean exclusive) {
        return new BoundNumberRangeSequence(a, b, exclusive);
    }

    public static SequenceLocation<Double> range(DoubleLocation a, DoubleLocation b, DoubleLocation step, boolean exclusive) {
        return new BoundNumberRangeSequence(a, b, step, exclusive);
    }

    public static <T> SequenceLocation<T> slice(Class<T> clazz, SequenceLocation<T> sequence, IntLocation a, IntLocation b) {
        return new BoundSequenceSlice<T>(clazz, sequence, a, b, false);
    }

    public static <T> SequenceLocation<T> sliceExclusive(Class<T> clazz, SequenceLocation<T> sequence, IntLocation a, IntLocation b) {
        return new BoundSequenceSlice<T>(clazz, sequence, a, b, true);
    }

    public static <T, V> SequenceLocation<V> makeSimpleBoundComprehension(Class<V> clazz, SequenceLocation<T> seq, boolean useIndex, final ObjectSimpleBoundComprehensionCallback<T, V> callback) {
        return new SimpleBoundComprehension<T, V>(clazz, seq, useIndex){

            @Override
            protected V computeElement$(T element, int index) {
                return callback.computeElement$(element, index);
            }
        };
    }

    public static <V> SequenceLocation<V> makeSimpleBoundComprehension(Class<V> clazz, SequenceLocation<Integer> seq, boolean useIndex, final IntSimpleBoundComprehensionCallback<V> callback) {
        return new SimpleBoundComprehension<Integer, V>(clazz, seq, useIndex){

            @Override
            protected V computeElement$(Integer element, int index) {
                return callback.computeElement$(element, index);
            }
        };
    }

    public static <V> SequenceLocation<V> makeSimpleBoundComprehension(Class<V> clazz, SequenceLocation<Double> seq, boolean useIndex, final DoubleSimpleBoundComprehensionCallback<V> callback) {
        return new SimpleBoundComprehension<Double, V>(clazz, seq, useIndex){

            @Override
            protected V computeElement$(Double element, int index) {
                return callback.computeElement$(element, index);
            }
        };
    }

    public static <V> SequenceLocation<V> makeSimpleBoundComprehension(Class<V> clazz, SequenceLocation<Boolean> seq, boolean useIndex, final BooleanSimpleBoundComprehensionCallback<V> callback) {
        return new SimpleBoundComprehension<Boolean, V>(clazz, seq, useIndex){

            @Override
            protected V computeElement$(Boolean element, int index) {
                return callback.computeElement$(element, index);
            }
        };
    }

    public static <T, V> SequenceLocation<V> makeBoundComprehension(Class<V> clazz, SequenceLocation<T> sequenceLocation, boolean useIndex, final ObjectBoundComprehensionCallback<T, V> callback) {
        return new AbstractBoundComprehension<T, ObjectLocation<T>, V>(clazz, sequenceLocation, useIndex){

            @Override
            protected ObjectLocation<T> makeInductionLocation(T value) {
                return ObjectVariable.make(value);
            }

            @Override
            protected SequenceLocation<V> computeElements$(ObjectLocation<T> elementLocation, IntLocation indexLocation) {
                return callback.computeElements$(elementLocation, indexLocation);
            }
        };
    }

    public static <V> SequenceLocation<V> makeBoundComprehension(Class<V> clazz, SequenceLocation<Integer> sequenceLocation, boolean useIndex, final IntBoundComprehensionCallback<V> callback) {
        return new AbstractBoundComprehension<Integer, IntLocation, V>(clazz, sequenceLocation, useIndex){

            @Override
            protected IntLocation makeInductionLocation(Integer value) {
                return IntVariable.make(value);
            }

            @Override
            protected SequenceLocation<V> computeElements$(IntLocation elementLocation, IntLocation indexLocation) {
                return callback.computeElements$(elementLocation, indexLocation);
            }
        };
    }

    public static <V> SequenceLocation<V> makeBoundComprehension(Class<V> clazz, SequenceLocation<Double> sequenceLocation, boolean useIndex, final DoubleBoundComprehensionCallback<V> callback) {
        return new AbstractBoundComprehension<Double, DoubleLocation, V>(clazz, sequenceLocation, useIndex){

            @Override
            protected DoubleLocation makeInductionLocation(Double value) {
                return DoubleVariable.make(value);
            }

            @Override
            protected SequenceLocation<V> computeElements$(DoubleLocation elementLocation, IntLocation indexLocation) {
                return callback.computeElements$(elementLocation, indexLocation);
            }
        };
    }

    public static <V> SequenceLocation<V> makeBoundComprehension(Class<V> clazz, SequenceLocation<Boolean> sequenceLocation, boolean useIndex, final BooleanBoundComprehensionCallback<V> callback) {
        return new AbstractBoundComprehension<Boolean, BooleanLocation, V>(clazz, sequenceLocation, useIndex){

            @Override
            protected BooleanLocation makeInductionLocation(Boolean value) {
                return BooleanVariable.make(value);
            }

            @Override
            protected SequenceLocation<V> computeElements$(BooleanLocation elementLocation, IntLocation indexLocation) {
                return callback.computeElements$(elementLocation, indexLocation);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BooleanBoundComprehensionCallback<T> {
        public SequenceLocation<T> computeElements$(BooleanLocation var1, IntLocation var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleBoundComprehensionCallback<T> {
        public SequenceLocation<T> computeElements$(DoubleLocation var1, IntLocation var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IntBoundComprehensionCallback<T> {
        public SequenceLocation<T> computeElements$(IntLocation var1, IntLocation var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectBoundComprehensionCallback<T, V> {
        public SequenceLocation<V> computeElements$(ObjectLocation<T> var1, IntLocation var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BooleanSimpleBoundComprehensionCallback<V> {
        public V computeElement$(boolean var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleSimpleBoundComprehensionCallback<V> {
        public V computeElement$(double var1, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IntSimpleBoundComprehensionCallback<V> {
        public V computeElement$(int var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectSimpleBoundComprehensionCallback<T, V> {
        public V computeElement$(T var1, int var2);
    }
}

