/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianProduct<T>
extends AbstractSequence<T>
implements Sequence<T> {
    private final Sequence<?>[] sequences;
    private final Mapper<T> mapper;
    private final int size;
    private final int[] sizes;

    public CartesianProduct(TypeInfo<T> ti, Mapper<T> mapper, Sequence<?> ... sequences) {
        super(ti);
        this.sequences = sequences;
        this.mapper = mapper;
        if (sequences.length == 0) {
            this.size = 0;
        } else {
            int depth = 1;
            for (Sequence<?> seq : sequences) {
                depth *= seq.size();
            }
            this.size = depth;
        }
        this.sizes = new int[sequences.length];
        for (int i = 0; i < sequences.length; ++i) {
            int cur = 1;
            for (int j = i + 1; j < sequences.length; ++j) {
                cur *= sequences[j].size();
            }
            this.sizes[i] = cur;
        }
    }

    @Override
    public int getDepth() {
        int depth = 0;
        for (Sequence<?> seq : this.sequences) {
            depth = Math.max(depth, seq.getDepth());
        }
        return depth + 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int position) {
        int[] indices = new int[this.sequences.length];
        Object[] values = new Object[this.sequences.length];
        int last = this.sequences.length - 1;
        for (int i = 0; i < last; ++i) {
            indices[i] = position / this.sizes[i];
            values[i] = this.sequences[i].get(indices[i]);
            position -= indices[i] * this.sizes[i];
        }
        indices[last] = position;
        values[last] = this.sequences[last].get(indices[last]);
        return this.mapper.map(indices, values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mapper<T> {
        public T map(int[] var1, Object[] var2);
    }
}

