/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.sequence.DerivedSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterSequence<T>
extends DerivedSequence<T>
implements Sequence<T> {
    private final int[] indices;

    public FilterSequence(Sequence<T> sequence, BitSet bits) {
        super(sequence.getElementType(), sequence, bits.cardinality(), sequence.getDepth() + 1);
        this.indices = new int[this.size];
        int i = bits.nextSetBit(0);
        int next = 0;
        while (i >= 0) {
            this.indices[next++] = i;
            i = bits.nextSetBit(i + 1);
        }
    }

    @Override
    public T get(int position) {
        if (position < 0 || position >= this.indices.length) {
            return this.getDefaultValue();
        }
        return this.sequence.get(this.indices[position]);
    }
}

