/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.sequence.DerivedSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplacementSequence<T>
extends DerivedSequence<T>
implements Sequence<T> {
    private final int newIndex;
    private final T newValue;

    public ReplacementSequence(Sequence<T> sequence, int newIndex, T newValue) {
        super(sequence.getElementType(), sequence);
        this.newIndex = newIndex;
        this.newValue = newValue;
    }

    @Override
    public T get(int position) {
        return position == this.newIndex ? this.newValue : this.sequence.get(position);
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.sequence.toArray(sourceOffset, length, dest, destOffset);
        int position = destOffset + this.newIndex - sourceOffset;
        if (position >= 0 && position < length) {
            dest[position] = this.newValue;
        }
    }
}

