/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceBuilder<T> {
    private static final int DEFAULT_SIZE = 16;
    private final TypeInfo<T> ti;
    private T[] array;
    private int size;

    public SequenceBuilder(TypeInfo<T> ti) {
        this(ti, 16);
    }

    public SequenceBuilder(TypeInfo<T> ti, int initialSize) {
        this.ti = ti;
        this.array = Util.newObjectArray(initialSize);
    }

    private void ensureSize(int newSize) {
        if (this.array.length < newSize) {
            int newCapacity = Util.powerOfTwo(this.array.length, newSize);
            T[] newArray = Util.newObjectArray(newCapacity);
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public void add(T element) {
        if (element != null) {
            this.ensureSize(this.size + 1);
            this.array[this.size++] = element;
        }
    }

    public void add(Sequence<? extends T> elements) {
        int length = elements.size();
        this.ensureSize(this.size + length);
        elements.toArray(0, length, this.array, this.size);
        this.size += length;
    }

    public int size() {
        return this.size;
    }

    public T get(int n) {
        if (n < 0 || n >= this.size) {
            return null;
        }
        return this.array[n];
    }

    public void clear() {
        this.array = Util.newObjectArray(Util.powerOfTwo(1, 16));
        this.size = 0;
    }

    public Sequence<T> toSequence() {
        if (this.array.length == this.size) {
            T[] arrayRef = this.array;
            this.array = null;
            return Sequences.makeViaHandoff(this.ti, arrayRef);
        }
        return Sequences.make(this.ti, this.array, this.size);
    }
}

